import { FAQGroupService, FAQService } from './faq.service';
import { BaseCRUDController } from '../../controllers/base.controller';
import { FAQGroupEntity, FAQEntity } from './faq.entity';
import { CreateFAQDto, CreateFAQGroupDto, SearchFAQGroupQueryDto, SearchFAQQueryDto, UpdateFAQDto, UpdateFAQGroupDto } from './faq.dto';
import { IDDto } from '../../dtos/base.dto';
import { IAuthParam } from '../authentication/authentication.interface';
import { RoutePath } from '../../classes/route-path.class';
export declare const FAQRoutePath: RoutePath;
export declare const FAQGroupRoutePath: RoutePath;
export declare class FAQGroupController extends BaseCRUDController<FAQGroupEntity, SearchFAQGroupQueryDto> {
    readonly service: FAQGroupService;
    constructor(service: FAQGroupService);
    create(body: CreateFAQGroupDto, auth: IAuthParam): string | Promise<FAQGroupEntity>;
    updateByID(param: IDDto, body: UpdateFAQGroupDto, auth: IAuthParam): string | Promise<FAQGroupEntity>;
    search(query: SearchFAQGroupQueryDto): Promise<string | import("../..").ISearchResponse<FAQGroupEntity>>;
}
export declare class FAQController extends BaseCRUDController<FAQEntity, SearchFAQQueryDto> {
    readonly service: FAQService;
    constructor(service: FAQService);
    create(body: CreateFAQDto, auth: IAuthParam): string | Promise<FAQEntity>;
    updateByID(param: IDDto, body: UpdateFAQDto, auth: IAuthParam): string | Promise<FAQEntity>;
    search(query: SearchFAQQueryDto): Promise<string | import("../..").ISearchResponse<FAQEntity>>;
}
