"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CronController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const cron_dto_1 = require("./cron.dto");
const cron_service_1 = require("./cron.service");
const cron_enum_1 = require("./cron.enum");
const base_controller_1 = require("../../controllers/base.controller");
const utility_service_1 = require("../../services/utility.service");
let CronController = class CronController extends base_controller_1.BaseController {
    constructor(service) {
        super(service);
        this.service = service;
        this.subject = `Cron`;
    }
    async getCronTypes() {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: Object.values(cron_enum_1.ECronType),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async search(query) {
        return super.search(query);
    }
};
exports.CronController = CronController;
__decorate([
    (0, common_1.Get)('cronTypes'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], CronController.prototype, "getCronTypes", null);
__decorate([
    (0, common_1.Get)('search'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [cron_dto_1.CronSearchQueryDTO]),
    __metadata("design:returntype", Promise)
], CronController.prototype, "search", null);
exports.CronController = CronController = __decorate([
    (0, swagger_1.ApiTags)(cron_service_1.CronService.tag),
    (0, common_1.Controller)(cron_service_1.CronService.path),
    __metadata("design:paramtypes", [cron_service_1.CronService])
], CronController);
//# sourceMappingURL=cron.controller.js.map