"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthenticationController = void 0;
const common_1 = require("@nestjs/common");
const authentication_service_1 = require("./authentication.service");
const authentication_dto_1 = require("./authentication.dto");
const swagger_1 = require("@nestjs/swagger");
const authentication_guard_1 = require("./authentication.guard");
const utility_service_1 = require("../../services/utility.service");
const base_dto_1 = require("../../dtos/base.dto");
let AuthenticationController = class AuthenticationController {
    constructor(service) {
        this.service = service;
    }
    // @UseGuards(AuthenticationGuard)
    async logout(body) {
        return utility_service_1.UtilityClass.handleSuccess({
            data: await this.service.logout(body),
        });
    }
    async systemLogout(body) {
        return utility_service_1.UtilityClass.handleSuccess({
            data: await this.service.forceLogout(body),
        });
    }
    async login(body) {
        return utility_service_1.UtilityClass.handleSuccess({ data: await this.service.login(body) });
    }
    async register(body) {
        return utility_service_1.UtilityClass.handleSuccess({
            data: await this.service.register(body),
        });
    }
    async requestPasswordReset(body) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.requestPasswordReset(body),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async verifyResetPasswordToken(body) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.verifyResetPasswordToken(body),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async resetPassword(body) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.resetPassword(body),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async toggle(body, param) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.toggleStatus(param.id, body),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async passwordChange(body, auth) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.changePassword(body, auth),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
};
exports.AuthenticationController = AuthenticationController;
__decorate([
    (0, common_1.Post)('logout'),
    (0, swagger_1.ApiBearerAuth)()
    // @UseGuards(AuthenticationGuard)
    ,
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [authentication_dto_1.LogoutDTO]),
    __metadata("design:returntype", Promise)
], AuthenticationController.prototype, "logout", null);
__decorate([
    (0, common_1.Post)('logout/force'),
    (0, swagger_1.ApiBearerAuth)(),
    (0, common_1.UseGuards)(authentication_guard_1.AuthenticationGuard),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [authentication_dto_1.SystemLogoutDTO]),
    __metadata("design:returntype", Promise)
], AuthenticationController.prototype, "systemLogout", null);
__decorate([
    (0, common_1.Post)('login'),
    (0, authentication_guard_1.PublicAuth)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [authentication_dto_1.LoginDTO]),
    __metadata("design:returntype", Promise)
], AuthenticationController.prototype, "login", null);
__decorate([
    (0, common_1.Post)('register'),
    (0, authentication_guard_1.PublicAuth)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [authentication_dto_1.RegisterDTO]),
    __metadata("design:returntype", Promise)
], AuthenticationController.prototype, "register", null);
__decorate([
    (0, common_1.Post)('reset/request'),
    (0, authentication_guard_1.PublicAuth)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [authentication_dto_1.RequestPasswordResetDTO]),
    __metadata("design:returntype", Promise)
], AuthenticationController.prototype, "requestPasswordReset", null);
__decorate([
    (0, common_1.Post)('reset/verify'),
    (0, authentication_guard_1.PublicAuth)(),
    (0, swagger_1.ApiResponse)({ type: authentication_dto_1.VerifyResetPasswordTokenResponseDTO }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [authentication_dto_1.VerifyResetPasswordTokenDTO]),
    __metadata("design:returntype", Promise)
], AuthenticationController.prototype, "verifyResetPasswordToken", null);
__decorate([
    (0, common_1.Post)('reset'),
    (0, authentication_guard_1.PublicAuth)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [authentication_dto_1.ResetPasswordDTO]),
    __metadata("design:returntype", Promise)
], AuthenticationController.prototype, "resetPassword", null);
__decorate([
    (0, common_1.Put)('toggle'),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [authentication_dto_1.ToggleAuthDTO, base_dto_1.IDDto]),
    __metadata("design:returntype", Promise)
], AuthenticationController.prototype, "toggle", null);
__decorate([
    (0, common_1.Post)('password/change'),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, authentication_guard_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [authentication_dto_1.ChangePasswordDTO, Object]),
    __metadata("design:returntype", Promise)
], AuthenticationController.prototype, "passwordChange", null);
exports.AuthenticationController = AuthenticationController = __decorate([
    (0, swagger_1.ApiTags)(authentication_service_1.AuthenticationService.tag),
    (0, common_1.Controller)(authentication_service_1.AuthenticationService.path),
    __metadata("design:paramtypes", [authentication_service_1.AuthenticationService])
], AuthenticationController);
//# sourceMappingURL=authentication.controller.js.map