"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiKeyHistoryService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const base_service_1 = require("../../services/base.service");
const api_key_history_entity_1 = require("./api-key-history.entity");
const base_enum_1 = require("../../enums/base.enum");
const utility_service_1 = require("../../services/utility.service");
/**
 * API Key History Service
 *
 * This service handles all API key history related operations including:
 * - Creating new API key history records
 * - Searching and retrieving API key history data
 * - Managing API key history lifecycle
 *
 * @example
 * ```typescript
 * // Inject the service
 * constructor(private apiKeyHistoryService: ApiKeyHistoryService) {}
 *
 * // Create a new history record
 * const history = await this.apiKeyHistoryService.createHistory({
 *   orgID: 'client-id',
 *   creatorId: 'user-id'
 * });
 *
 * // Search history records
 * const results = await this.apiKeyHistoryService.search({
 *   orgID: 'client-id',
 *   page: 1,
 *   limit: 10
 * });
 * ```
 */
let ApiKeyHistoryService = class ApiKeyHistoryService extends base_service_1.BaseService {
    /**
     * Creates a new instance of ApiKeyHistoryService
     * @param repo - The TypeORM repository for API key history entities
     */
    constructor(repo) {
        super(repo, base_enum_1.ETableName.api_key_history);
        this.repo = repo;
    }
    async _postCreateFunction(requestData, savedData) {
        await this.repo.update({
            ref: { refCat: savedData.ref.refCat, refNo: savedData.ref.refNo },
            active: true,
            id: (0, typeorm_2.Not)(savedData.id),
        }, { active: false });
    }
    _create(data, config) {
        return super._create(data, config);
    }
    /**
     * Searches for API key history records with advanced filtering and pagination
     * @param query - The search query parameters
     * @param auth - Authentication parameters for filtering by organization
     * @returns Promise<ISearchResponse<ApiKeyHistoryEntity>> - Search results with pagination
     *
     * @example
     * ```typescript
     * const results = await this.search({
     *   orgID: 'client-id',
     *   page: 1,
     *   limit: 10,
     *   sortBy: 'createdAt',
     *   sortOrder: 'DESC'
     * }, auth);
     * ```
     */
    async search(query, auth) {
        // const formattedQuery = await this.baseWhereExtractor(query, auth);
        // const { refCat, refNo, ...restQuery } = formattedQuery;
        const { refCat, refNo, ...restQuery } = query;
        return await utility_service_1.UtilityClass.search(this.repo, { ...restQuery, ref: { refCat, refNo } }, {
            baseSelect: {
                creator: { id: true, firstname: true, lastname: true, email: true },
            },
            baseRelations: { creator: true },
        });
    }
};
exports.ApiKeyHistoryService = ApiKeyHistoryService;
ApiKeyHistoryService.path = 'api_key_history';
exports.ApiKeyHistoryService = ApiKeyHistoryService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(api_key_history_entity_1.ApiKeyHistoryEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], ApiKeyHistoryService);
//# sourceMappingURL=api-key-history.service.js.map