import { Repository } from 'typeorm';
import { BaseService } from '../../services/base.service';
import { ApiKeyHistoryEntity } from './api-key-history.entity';
import { CreateApiKeyHistoryDto, SearchApiKeyHistoryDto } from './api-key-history.dto';
import { ISearchResponse } from '../../interfaces/search.interface';
import { IAuthParam } from '../authentication/authentication.interface';
import { ICreateConfig } from '../../interfaces/index.interface';
/**
 * API Key History Service
 *
 * This service handles all API key history related operations including:
 * - Creating new API key history records
 * - Searching and retrieving API key history data
 * - Managing API key history lifecycle
 *
 * @example
 * ```typescript
 * // Inject the service
 * constructor(private apiKeyHistoryService: ApiKeyHistoryService) {}
 *
 * // Create a new history record
 * const history = await this.apiKeyHistoryService.createHistory({
 *   orgID: 'client-id',
 *   creatorId: 'user-id'
 * });
 *
 * // Search history records
 * const results = await this.apiKeyHistoryService.search({
 *   orgID: 'client-id',
 *   page: 1,
 *   limit: 10
 * });
 * ```
 */
export declare class ApiKeyHistoryService extends BaseService<ApiKeyHistoryEntity> {
    readonly repo: Repository<ApiKeyHistoryEntity>;
    static path: string;
    /**
     * Creates a new instance of ApiKeyHistoryService
     * @param repo - The TypeORM repository for API key history entities
     */
    constructor(repo: Repository<ApiKeyHistoryEntity>);
    protected _postCreateFunction(requestData: Partial<ApiKeyHistoryEntity>, savedData: ApiKeyHistoryEntity): Promise<void>;
    _create(data: CreateApiKeyHistoryDto, config?: ICreateConfig): Promise<ApiKeyHistoryEntity>;
    /**
     * Searches for API key history records with advanced filtering and pagination
     * @param query - The search query parameters
     * @param auth - Authentication parameters for filtering by organization
     * @returns Promise<ISearchResponse<ApiKeyHistoryEntity>> - Search results with pagination
     *
     * @example
     * ```typescript
     * const results = await this.search({
     *   orgID: 'client-id',
     *   page: 1,
     *   limit: 10,
     *   sortBy: 'createdAt',
     *   sortOrder: 'DESC'
     * }, auth);
     * ```
     */
    search(query: SearchApiKeyHistoryDto, auth?: IAuthParam): Promise<ISearchResponse<ApiKeyHistoryEntity>>;
}
