"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiKeyHistoryModule = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const api_key_history_entity_1 = require("./api-key-history.entity");
const api_key_history_service_1 = require("./api-key-history.service");
const base_module_1 = require("../base.module");
/**
 * API Key History Module
 *
 * This module handles all API key history related functionality including:
 * - Tracking API key generation and regeneration events
 * - Searching and retrieving API key history records
 * - Managing API key history data
 *
 * @example
 * ```typescript
 * // Import the module in your app.module.ts
 * import { ApiKeyHistoryModule } from './modules/api-key-history/api-key-history.module';
 *
 * @Module({
 *   imports: [ApiKeyHistoryModule],
 * })
 * export class AppModule {}
 * ```
 */
let ApiKeyHistoryModule = class ApiKeyHistoryModule extends base_module_1.BaseModule {
};
exports.ApiKeyHistoryModule = ApiKeyHistoryModule;
ApiKeyHistoryModule.entities = [api_key_history_entity_1.ApiKeyHistoryEntity];
ApiKeyHistoryModule.services = [api_key_history_service_1.ApiKeyHistoryService];
exports.ApiKeyHistoryModule = ApiKeyHistoryModule = __decorate([
    (0, common_1.Global)(),
    (0, common_1.Module)({
        imports: [typeorm_1.TypeOrmModule.forFeature(ApiKeyHistoryModule.entities)],
        controllers: [],
        providers: ApiKeyHistoryModule.services,
        exports: ApiKeyHistoryModule.services,
    })
], ApiKeyHistoryModule);
//# sourceMappingURL=api-key-history.module.js.map