import { ApiKeyHistoryEntity } from './api-key-history.entity';
import { ApiKeyHistoryService } from './api-key-history.service';
import { BaseModule } from '../base.module';
/**
 * API Key History Module
 *
 * This module handles all API key history related functionality including:
 * - Tracking API key generation and regeneration events
 * - Searching and retrieving API key history records
 * - Managing API key history data
 *
 * @example
 * ```typescript
 * // Import the module in your app.module.ts
 * import { ApiKeyHistoryModule } from './modules/api-key-history/api-key-history.module';
 *
 * @Module({
 *   imports: [ApiKeyHistoryModule],
 * })
 * export class AppModule {}
 * ```
 */
export declare class ApiKeyHistoryModule extends BaseModule {
    static entities: (typeof ApiKeyHistoryEntity)[];
    static services: (typeof ApiKeyHistoryService)[];
}
