"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiKeyHistoryEntity = void 0;
const typeorm_1 = require("typeorm");
const base_entity_1 = require("../../entities/base.entity");
const base_enum_1 = require("../../enums/base.enum");
/**
 * API Key History Entity
 *
 * This entity represents the history of API key operations including:
 * - API key generation events
 * - API key regeneration events
 * - Tracking of who created the API key and when
 *
 * @example
 * ```typescript
 * // Create a new API key history record
 * const history = new ApiKeyHistoryEntity();
 * history.orgID = 'client-id';
 * history.creatorId = 'user-id';
 * await history.save();
 * ```
 */
let ApiKeyHistoryEntity = class ApiKeyHistoryEntity extends base_entity_1.BaseEntity {
};
exports.ApiKeyHistoryEntity = ApiKeyHistoryEntity;
__decorate([
    (0, typeorm_1.Column)({ nullable: true, type: 'nvarchar', length: 500 }),
    __metadata("design:type", String)
], ApiKeyHistoryEntity.prototype, "apiKey", void 0);
__decorate([
    (0, typeorm_1.Column)(() => base_entity_1.RefEntity, { prefix: false }),
    __metadata("design:type", Object)
], ApiKeyHistoryEntity.prototype, "ref", void 0);
exports.ApiKeyHistoryEntity = ApiKeyHistoryEntity = __decorate([
    (0, typeorm_1.Entity)(base_enum_1.ETableName.api_key_history),
    (0, typeorm_1.Unique)(['ref.refCat', 'ref.refNo'])
], ApiKeyHistoryEntity);
//# sourceMappingURL=api-key-history.entity.js.map