import { Relation } from 'typeorm';
import { BaseEntity, RefEntity } from '../../entities/base.entity';
/**
 * API Key History Entity
 *
 * This entity represents the history of API key operations including:
 * - API key generation events
 * - API key regeneration events
 * - Tracking of who created the API key and when
 *
 * @example
 * ```typescript
 * // Create a new API key history record
 * const history = new ApiKeyHistoryEntity();
 * history.orgID = 'client-id';
 * history.creatorId = 'user-id';
 * await history.save();
 * ```
 */
export declare class ApiKeyHistoryEntity extends BaseEntity {
    apiKey?: string;
    ref: Relation<RefEntity>;
}
