"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SearchApiKeyHistoryDto = exports.ApiKeyHistoryResponseDto = exports.CreateApiKeyHistoryDto = void 0;
const class_validator_1 = require("class-validator");
const swagger_1 = require("@nestjs/swagger");
const base_dto_1 = require("../../dtos/base.dto");
const search_dto_1 = require("../../dtos/search.dto");
/**
 * Data Transfer Object for creating API key history records
 *
 * This DTO defines the structure for creating new API key history entries,
 * tracking when and by whom API keys were generated or regenerated.
 *
 * @example
 * ```typescript
 * const createDto: CreateApiKeyHistoryDto = {
 *   orgID: 'client-123',
 *   creatorId: 'user-456'
 * };
 * ```
 */
class CreateApiKeyHistoryDto extends (0, swagger_1.IntersectionType)(base_dto_1.BaseDto, base_dto_1.SaveRefDtoExtender) {
}
exports.CreateApiKeyHistoryDto = CreateApiKeyHistoryDto;
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], CreateApiKeyHistoryDto.prototype, "apiKey", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({
        description: 'ID of the user who created the API key',
        example: '550e8400-e29b-41d4-a716-446655440001',
    }),
    (0, class_validator_1.IsUUID)(),
    __metadata("design:type", String)
], CreateApiKeyHistoryDto.prototype, "creatorId", void 0);
/**
 * Data Transfer Object for API key history responses
 *
 * This DTO defines the structure for API key history responses,
 * including all the fields returned when querying API key history records.
 *
 * @example
 * ```typescript
 * const response: ApiKeyHistoryResponseDto = {
 *   id: 'history-123',
 *   orgID: 'client-123',
 *   creatorId: 'user-456',
 *   createdAt: '2024-01-15T10:30:00Z'
 * };
 * ```
 */
class ApiKeyHistoryResponseDto extends CreateApiKeyHistoryDto {
}
exports.ApiKeyHistoryResponseDto = ApiKeyHistoryResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Unique identifier of the API key history record',
        example: '550e8400-e29b-41d4-a716-446655440002',
    }),
    __metadata("design:type", String)
], ApiKeyHistoryResponseDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Timestamp when the API key was created',
        example: '2024-01-15T10:30:00Z',
    }),
    __metadata("design:type", String)
], ApiKeyHistoryResponseDto.prototype, "createdAt", void 0);
/**
 * Data Transfer Object for searching API key history records
 *
 * This DTO extends the search query functionality with API key history specific fields,
 * allowing for filtering and searching through API key history records.
 *
 * @example
 * ```typescript
 * const searchDto: SearchApiKeyHistoryDto = {
 *   orgID: 'client-123',
 *   page: 1,
 *   limit: 10,
 *   sortBy: 'createdAt',
 *   sortOrder: 'DESC'
 * };
 * ```
 */
class SearchApiKeyHistoryDto extends (0, swagger_1.IntersectionType)((search_dto_1.SearchQueryDto), (0, swagger_1.PartialType)((0, swagger_1.OmitType)(CreateApiKeyHistoryDto, ['ref'])), base_dto_1.SearchByRefQueryDto) {
}
exports.SearchApiKeyHistoryDto = SearchApiKeyHistoryDto;
//# sourceMappingURL=api-key-history.dto.js.map