import { ApiKeyHistoryEntity } from './api-key-history.entity';
import { BaseDto, SaveRefDtoExtender, SearchByRefQueryDto } from '../../dtos/base.dto';
import { SearchQueryDto } from '../../dtos/search.dto';
declare const CreateApiKeyHistoryDto_base: import("@nestjs/common").Type<BaseDto<unknown> & SaveRefDtoExtender>;
/**
 * Data Transfer Object for creating API key history records
 *
 * This DTO defines the structure for creating new API key history entries,
 * tracking when and by whom API keys were generated or regenerated.
 *
 * @example
 * ```typescript
 * const createDto: CreateApiKeyHistoryDto = {
 *   orgID: 'client-123',
 *   creatorId: 'user-456'
 * };
 * ```
 */
export declare class CreateApiKeyHistoryDto extends CreateApiKeyHistoryDto_base implements ApiKeyHistoryEntity {
    apiKey?: string;
    /**
     * Creator ID - The ID of the user who created/regenerated the API key
     * @example "550e8400-e29b-41d4-a716-446655440001"
     */
    creatorId: string;
}
/**
 * Data Transfer Object for API key history responses
 *
 * This DTO defines the structure for API key history responses,
 * including all the fields returned when querying API key history records.
 *
 * @example
 * ```typescript
 * const response: ApiKeyHistoryResponseDto = {
 *   id: 'history-123',
 *   orgID: 'client-123',
 *   creatorId: 'user-456',
 *   createdAt: '2024-01-15T10:30:00Z'
 * };
 * ```
 */
export declare class ApiKeyHistoryResponseDto extends CreateApiKeyHistoryDto implements ApiKeyHistoryEntity {
    /**
     * Unique identifier of the API key history record
     * @example "550e8400-e29b-41d4-a716-446655440002"
     */
    id: string;
    /**
     * Timestamp when the API key was created/regenerated
     * @example "2024-01-15T10:30:00Z"
     */
    createdAt: string;
}
declare const SearchApiKeyHistoryDto_base: import("@nestjs/common").Type<SearchByRefQueryDto & Partial<Omit<CreateApiKeyHistoryDto, "ref">> & SearchQueryDto<CreateApiKeyHistoryDto>>;
/**
 * Data Transfer Object for searching API key history records
 *
 * This DTO extends the search query functionality with API key history specific fields,
 * allowing for filtering and searching through API key history records.
 *
 * @example
 * ```typescript
 * const searchDto: SearchApiKeyHistoryDto = {
 *   orgID: 'client-123',
 *   page: 1,
 *   limit: 10,
 *   sortBy: 'createdAt',
 *   sortOrder: 'DESC'
 * };
 * ```
 */
export declare class SearchApiKeyHistoryDto extends SearchApiKeyHistoryDto_base {
}
export {};
