"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileContentEntity = exports.FileEntity = void 0;
const typeorm_1 = require("typeorm");
const base_entity_1 = require("./base.entity");
const base_enum_1 = require("../enums/base.enum");
const file_enum_1 = require("../enums/file.enum");
const utility_service_1 = require("../services/utility.service");
let FileEntity = class FileEntity extends base_entity_1.BaseEntity {
};
exports.FileEntity = FileEntity;
__decorate([
    (0, typeorm_1.Column)({ type: 'text' }),
    __metadata("design:type", String)
], FileEntity.prototype, "refCat", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'text' }),
    __metadata("design:type", String)
], FileEntity.prototype, "refNo", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'text', nullable: true }),
    __metadata("design:type", String)
], FileEntity.prototype, "path", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'text', nullable: true }),
    __metadata("design:type", String)
], FileEntity.prototype, "description", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'text' }),
    __metadata("design:type", String)
], FileEntity.prototype, "title", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'double' }),
    __metadata("design:type", Number)
], FileEntity.prototype, "fileSize", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'double', default: 0 }),
    __metadata("design:type", Number)
], FileEntity.prototype, "likes", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'double', default: 0 }),
    __metadata("design:type", Number)
], FileEntity.prototype, "dislikes", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'nvarchar', length: 100, nullable: true }),
    __metadata("design:type", String)
], FileEntity.prototype, "fileType", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'nvarchar', length: 20 }),
    __metadata("design:type", String)
], FileEntity.prototype, "fileExtension", void 0);
__decorate([
    (0, typeorm_1.Column)({
        type: 'enum',
        enum: file_enum_1.EFileSizeUnit,
        default: file_enum_1.EFileSizeUnit.bytes,
    }),
    __metadata("design:type", String)
], FileEntity.prototype, "fileSizeUnit", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true, type: 'text' }),
    __metadata("design:type", String)
], FileEntity.prototype, "link", void 0);
__decorate([
    (0, typeorm_1.OneToOne)(() => FileContentEntity, (i) => i.meta, { cascade: true }),
    (0, typeorm_1.JoinColumn)(),
    __metadata("design:type", Object)
], FileEntity.prototype, "content", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], FileEntity.prototype, "contentId", void 0);
exports.FileEntity = FileEntity = __decorate([
    (0, typeorm_1.Entity)(base_enum_1.ETableName.file)
], FileEntity);
let FileContentEntity = class FileContentEntity {
};
exports.FileContentEntity = FileContentEntity;
__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)('uuid'),
    __metadata("design:type", String)
], FileContentEntity.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.OneToOne)(() => FileEntity, (i) => i.content),
    __metadata("design:type", Object)
], FileContentEntity.prototype, "meta", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'longblob', nullable: true }),
    __metadata("design:type", String)
], FileContentEntity.prototype, "dataURI", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'timestamp', ...utility_service_1.UtilityClass.columnTimestamp }),
    (0, typeorm_1.CreateDateColumn)(),
    __metadata("design:type", String)
], FileContentEntity.prototype, "createdAt", void 0);
__decorate([
    (0, typeorm_1.DeleteDateColumn)(),
    __metadata("design:type", Date)
], FileContentEntity.prototype, "deletedAt", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'timestamp', ...utility_service_1.UtilityClass.columnTimestamp }),
    (0, typeorm_1.UpdateDateColumn)(),
    __metadata("design:type", String)
], FileContentEntity.prototype, "updatedAt", void 0);
exports.FileContentEntity = FileContentEntity = __decorate([
    (0, typeorm_1.Entity)(base_enum_1.ETableName.fileContent)
], FileContentEntity);
//# sourceMappingURL=file.entity.js.map