import { Relation } from 'typeorm';
import { BaseEntity } from './base.entity';
export declare class FileEntity extends BaseEntity {
    refCat: string;
    refNo: string;
    path?: string;
    description?: string;
    title: string;
    fileSize: number;
    likes?: number;
    dislikes?: number;
    fileType?: string;
    fileExtension: string;
    fileSizeUnit: string;
    blob?: Blob;
    link?: string;
    content?: Relation<FileContentEntity>;
    contentId?: string;
}
export declare class FileContentEntity {
    id: string;
    meta?: Relation<FileEntity>;
    dataURI?: string;
    createdAt?: string;
    deletedAt?: Date;
    updatedAt?: string;
}
