"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileToken = exports.FileSearchDto = exports.FileActionDto = exports.FileUploadJSONDto = exports.FileUploadJSONMiniDto = exports.FileUploadDto = exports.FileUpdateDto = exports.GetFileByRefDto = void 0;
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
const base_dto_1 = require("./base.dto");
const utility_service_1 = require("../services/utility.service");
const search_dto_1 = require("./search.dto");
const base_sample_1 = require("../samples/base.sample");
const file_entity_1 = require("../entities/file.entity");
const class_transformer_1 = require("class-transformer");
class GetFileByRefDto {
}
exports.GetFileByRefDto = GetFileByRefDto;
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)({ type: 'string', required: false }),
    __metadata("design:type", String)
], GetFileByRefDto.prototype, "refCat", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)({ type: 'string', required: false }),
    __metadata("design:type", String)
], GetFileByRefDto.prototype, "refNo", void 0);
class FileUpdateDto extends (0, swagger_1.IntersectionType)(GetFileByRefDto, base_dto_1.BaseDto) {
}
exports.FileUpdateDto = FileUpdateDto;
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    (0, swagger_1.ApiProperty)({ type: 'string', required: false }),
    __metadata("design:type", String)
], FileUpdateDto.prototype, "description", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    (0, swagger_1.ApiProperty)({ type: 'string' }),
    __metadata("design:type", String)
], FileUpdateDto.prototype, "title", void 0);
class FileUploadDto extends FileUpdateDto {
}
exports.FileUploadDto = FileUploadDto;
__decorate([
    (0, class_validator_1.Allow)(),
    (0, swagger_1.ApiProperty)({ type: 'string', format: 'binary' }),
    __metadata("design:type", File)
], FileUploadDto.prototype, "file", void 0);
class FileUploadJSONMiniDto {
}
exports.FileUploadJSONMiniDto = FileUploadJSONMiniDto;
__decorate([
    (0, class_validator_1.IsDataURI)(),
    (0, swagger_1.ApiProperty)({ type: 'string', example: base_sample_1.Sample.dataURI }),
    (0, class_transformer_1.Expose)(),
    __metadata("design:type", String)
], FileUploadJSONMiniDto.prototype, "dataURI", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)({ type: 'string', example: '.jpeg' }),
    (0, class_validator_1.ValidateIf)((i) => !!i.dataURI),
    (0, class_transformer_1.Expose)(),
    __metadata("design:type", String)
], FileUploadJSONMiniDto.prototype, "fileExtension", void 0);
class FileUploadJSONDto extends (0, swagger_1.IntersectionType)(FileUploadJSONMiniDto, FileUpdateDto) {
}
exports.FileUploadJSONDto = FileUploadJSONDto;
class FileActionDto extends base_dto_1.BaseDto {
}
exports.FileActionDto = FileActionDto;
__decorate([
    (0, class_validator_1.IsUUID)(),
    (0, swagger_1.ApiProperty)({ type: 'string', example: utility_service_1.UtilityClass.generateUUID }),
    __metadata("design:type", String)
], FileActionDto.prototype, "fileID", void 0);
class FileSearchDto extends (0, swagger_1.IntersectionType)(search_dto_1.SearchQueryDto, (0, swagger_1.PartialType)(GetFileByRefDto)) {
}
exports.FileSearchDto = FileSearchDto;
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    (0, swagger_1.ApiProperty)({ type: 'string', required: false }),
    __metadata("design:type", String)
], FileSearchDto.prototype, "description", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    (0, swagger_1.ApiProperty)({ type: 'string', required: false }),
    __metadata("design:type", String)
], FileSearchDto.prototype, "title", void 0);
class _FileToken extends (0, swagger_1.PickType)(file_entity_1.FileEntity, [
    'fileExtension',
    'fileType',
    'title',
    'contentId',
    'path',
    'id',
]) {
}
class FileToken {
}
exports.FileToken = FileToken;
__decorate([
    (0, class_transformer_1.Expose)(),
    __metadata("design:type", String)
], FileToken.prototype, "title", void 0);
__decorate([
    (0, class_transformer_1.Expose)(),
    __metadata("design:type", String)
], FileToken.prototype, "fileExtension", void 0);
__decorate([
    (0, class_transformer_1.Expose)(),
    __metadata("design:type", String)
], FileToken.prototype, "fileType", void 0);
__decorate([
    (0, class_transformer_1.Expose)(),
    __metadata("design:type", String)
], FileToken.prototype, "contentId", void 0);
__decorate([
    (0, class_transformer_1.Expose)(),
    __metadata("design:type", String)
], FileToken.prototype, "path", void 0);
__decorate([
    (0, class_transformer_1.Expose)(),
    __metadata("design:type", String)
], FileToken.prototype, "id", void 0);
__decorate([
    (0, class_transformer_1.Expose)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], FileToken.prototype, "fileID", void 0);
//# sourceMappingURL=file.dto.js.map