import { BaseEntity, RefEntity } from '../entities/base.entity';
import { AuthEntity } from '../modules/authentication/authentication.entity';
export declare class BaseDto<T = any> implements Partial<BaseEntity> {
    creatorId?: string;
    updaterId?: string;
    orgID?: string;
    updater?: AuthEntity;
    creator?: AuthEntity;
    constructor(obj?: T);
}
export declare class BatchDeleteDto {
    ids: string[];
}
export declare class IDDto {
    id: string;
}
export declare class ToggleActiveDTO {
    active: boolean;
}
export declare class ToggleBulkActiveDTO extends ToggleActiveDTO {
    ids: string[];
}
declare class SetOrderItem {
    id: string;
    order: number;
}
export declare class SetOrderDTO {
    items: SetOrderItem[];
}
export declare class ValueLabelDto<T = any> {
    value: T;
    label: string;
}
export declare class SaveRefDto implements RefEntity {
    refCat: string;
    refNo: string;
    slug?: string;
}
declare const SearchByRefQueryDto_base: import("@nestjs/common").Type<Partial<SaveRefDto>>;
export declare class SearchByRefQueryDto extends SearchByRefQueryDto_base implements RefEntity {
}
export declare class SaveRefDtoExtenderOptional {
    ref?: SearchByRefQueryDto;
}
export declare class SaveRefDtoExtender {
    ref: SaveRefDto;
}
export {};
