"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ToNumber = void 0;
const class_transformer_1 = require("class-transformer");
const ToNumber = () => {
    const toPlain = (0, class_transformer_1.Transform)(({ value }) => {
        return value;
    }, {
        toPlainOnly: true,
    });
    const toClass = (target, key) => {
        return (0, class_transformer_1.Transform)(({ obj }) => {
            return valueToNumber(obj[key]);
        }, {
            toClassOnly: true,
        })(target, key);
    };
    return function (target, key) {
        toPlain(target, key);
        toClass(target, key);
    };
};
exports.ToNumber = ToNumber;
const valueToNumber = (value) => {
    if (typeof value === 'number')
        return value;
    else if (value == null)
        return value;
    else if (!Number.isNaN(+value))
        return +value;
    return undefined;
};
//# sourceMappingURL=to-number.decorator.js.map