"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ToBoolean = void 0;
const class_transformer_1 = require("class-transformer");
const ToBoolean = () => {
    const toPlain = (0, class_transformer_1.Transform)(({ value }) => {
        return value;
    }, {
        toPlainOnly: true,
    });
    const toClass = (target, key) => {
        return (0, class_transformer_1.Transform)(({ obj }) => {
            return valueToBoolean(obj[key]);
        }, {
            toClassOnly: true,
        })(target, key);
    };
    return function (target, key) {
        toPlain(target, key);
        toClass(target, key);
    };
};
exports.ToBoolean = ToBoolean;
const valueToBoolean = (value) => {
    if (typeof value === 'boolean')
        return value;
    const valLower = value?.toLowerCase();
    if (valLower == 'true' || valLower == '1')
        return true;
    if (valLower == 'false' || valLower == '0')
        return false;
    return undefined;
};
//# sourceMappingURL=to-boolean.decorator.js.map