"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ToArray = void 0;
const class_transformer_1 = require("class-transformer");
const ToArray = () => {
    const toPlain = (0, class_transformer_1.Transform)(({ value }) => {
        return value;
    }, {
        toPlainOnly: true,
    });
    const toClass = (target, key, options) => {
        return (0, class_transformer_1.Transform)(({ obj }) => {
            return valueToTarget(obj[key], options);
        }, {
            toClassOnly: true,
        })(target, key);
    };
    return function (target, key, options) {
        toPlain(target, key);
        toClass(target, key, options);
    };
};
exports.ToArray = ToArray;
const valueToTarget = (value, options) => {
    return value == null
        ? options?.nullToArray
            ? []
            : value
        : Array.isArray(value)
            ? value
            : [value];
};
//# sourceMappingURL=to-array.decorator.js.map