"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UtilityController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const utility_service_1 = require("../services/utility.service");
const authentication_guard_1 = require("../modules/authentication/authentication.guard");
const axios_1 = require("@nestjs/axios");
const rxjs_1 = require("rxjs");
class SwaggerJSON {
}
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Call this function in the console ui.getConfigs().spec.paths',
        type: 'string',
    }),
    __metadata("design:type", Object)
], SwaggerJSON.prototype, "test", void 0);
function jsonPathsParser(body) {
    const _endpointsConfig = {};
    for (const path of Object.keys(body).sort()) {
        const element = body[path];
        const pathChunks = path.split('/').filter((x) => x);
        const groupName = pathChunks.shift()?.toCamelCase();
        const endpointName = pathChunks.join('_');
        // debugger;
        if (!groupName)
            continue;
        _endpointsConfig[groupName] = _endpointsConfig[groupName] || {};
        for (const method of Object.keys(element).sort()) {
            _endpointsConfig[groupName][utility_service_1.UtilityClass.strConcatenator(endpointName
                ?.toCamelCase()
                ?.replaceAll('-', '_')
                ?.replaceAll('{', '')
                ?.replaceAll('}', '') || undefined, method, '_')] = path.replace('/', '').replaceAll('{', ':').replaceAll('}', '');
        }
    }
    const endpointsConfig = {};
    for (const path of Object.keys(_endpointsConfig).sort()) {
        endpointsConfig[path] = _endpointsConfig[path];
        endpointsConfig[path]['_base'] = Object.values(_endpointsConfig[path])?.[0]?.split('/')[0];
    }
    const endpointsFunctions = {};
    endpointsFunctions['_all'] = { _all: '' };
    for (const key in endpointsConfig) {
        const paths = endpointsConfig[key];
        endpointsFunctions[key] = {};
        endpointsFunctions[key]['_all'] = '';
        for (const pathName in paths) {
            endpointsFunctions[key][pathName] =
                `${pathName} = <T=any>(query?: any) => {
      return  lastValueFrom(this.apiS.${pathName
                    .split('_')
                    .lastItem()}<T>(EP.${key}.${pathName}, query));
    };`;
            endpointsFunctions[key]['_all'] += endpointsFunctions[key][pathName];
            endpointsFunctions['_all']['_all'] +=
                `${key}_` + endpointsFunctions[key][pathName];
        }
    }
    return {
        endpointsConfig: endpointsConfig,
        endpointsFunctions: endpointsFunctions,
    };
}
let UtilityController = class UtilityController {
    constructor(http) {
        this.http = http;
    }
    swaggerToClientConfig(body) {
        return jsonPathsParser(body);
    }
    getSwaggerToClientConfig() {
        if (!utility_service_1.UtilityClass.swaggerUILink)
            utility_service_1.UtilityClass.throwError({
                message: `UtilityClass.swaggerUILink has not been set`,
            });
        const jsonRoute = utility_service_1.UtilityClass.swaggerUILink + `-json`;
        console.log('jsonRoute', jsonRoute);
        return this.http
            .get(jsonRoute)
            .pipe((0, rxjs_1.map)((response) => jsonPathsParser(response.data.paths)));
    }
};
exports.UtilityController = UtilityController;
__decorate([
    (0, common_1.Post)('swaggerToClientConfig'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [SwaggerJSON]),
    __metadata("design:returntype", void 0)
], UtilityController.prototype, "swaggerToClientConfig", null);
__decorate([
    (0, common_1.Get)('swaggerToClientConfig'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], UtilityController.prototype, "getSwaggerToClientConfig", null);
exports.UtilityController = UtilityController = __decorate([
    (0, authentication_guard_1.PublicAuth)(),
    (0, swagger_1.ApiTags)('Utility'),
    (0, common_1.Controller)(''),
    __metadata("design:paramtypes", [axios_1.HttpService])
], UtilityController);
//# sourceMappingURL=utility.controller.js.map