import { FileService as fileService } from '../services/file.service';
import { FileActionDto, FileSearchDto, FileUpdateDto, FileUploadDto, FileUploadJSONDto, GetFileByRefDto } from '../dtos/file.dto';
import { IFileDownloadResponse, IFileID } from '../interfaces/file.interface';
import { BatchDeleteDto, IDDto } from '../dtos/base.dto';
import { Response } from 'express';
import { IToken } from '../interfaces/base.interface';
import { IAuthParam } from '../modules/authentication/authentication.interface';
export declare class FileController {
    protected readonly fileService: fileService;
    constructor(fileService: fileService);
    upload(file: Express.Multer.File, meta: FileUploadDto, auth?: IAuthParam): Promise<string | import("..").FileEntity>;
    uploadJSON(body: FileUploadJSONDto, auth?: IAuthParam): Promise<string | import("..").FileEntity>;
    like(params: FileActionDto, auth?: IAuthParam): Promise<string | import("..").FileEntity>;
    dislike(params: FileActionDto, auth?: IAuthParam): Promise<string | import("..").FileEntity>;
    search(query: FileSearchDto): Promise<import("..").ISearchResponse<import("..").FileEntity>>;
    getFileByRef(query: GetFileByRefDto): Promise<string | import("..").FileEntity>;
    getFileByID(query: IDDto): Promise<string | import("..").FileEntity>;
    unlike(params: FileActionDto, auth?: IAuthParam): Promise<string | import("..").FileEntity>;
    deleteBatch(params: BatchDeleteDto): Promise<unknown>;
    delete(params: IFileID): Promise<unknown>;
    restoreBatch(params: BatchDeleteDto): Promise<unknown>;
    restore(params: IFileID): Promise<unknown>;
    update(body: FileUpdateDto, params: IFileID): Promise<string | void>;
    parseFileLinkResponse(data: IFileDownloadResponse, response: Response): Promise<void>;
    getFile(params: IFileID, response: Response): Promise<void>;
    getFileWithToken(params: IToken, response: Response): Promise<void>;
}
