"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseCRUDController = exports.BaseCRUController = exports.BaseController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const search_dto_1 = require("../dtos/search.dto");
const utility_service_1 = require("../services/utility.service");
const base_dto_1 = require("../dtos/base.dto");
const authentication_guard_1 = require("../modules/authentication/authentication.guard");
const analytics_dto_1 = require("../dtos/analytics.dto");
const base_enum_1 = require("../enums/base.enum");
class BaseController {
    constructor(service) {
        this.service = service;
        this.subject = `Item`;
        this.idParam = `id`;
    }
    checkControllerBlock(blockType) {
        if (this.service.blockController?.[blockType])
            utility_service_1.UtilityClass.throwError({ message: `Blocked`, statusCode: 403 });
    }
    async analytics(params) {
        try {
            this.checkControllerBlock(base_enum_1.EControllerBlock.read);
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.getAnalytics(params),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async getByID(params, auth) {
        try {
            this.checkControllerBlock(base_enum_1.EControllerBlock.read);
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.getById(params.id, auth),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async search(query, auth, searchFunction = (query, auth) => this.service.search(query, auth)) {
        this.checkControllerBlock(base_enum_1.EControllerBlock.read);
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: searchFunction(query, auth),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async setOrder(body) {
        try {
            this.checkControllerBlock(base_enum_1.EControllerBlock.arrange);
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.arrangeItems(body),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async toggleAllActive(body) {
        try {
            this.checkControllerBlock(base_enum_1.EControllerBlock.toggle);
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.toggleAllActive(body),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async toggleBulkActive(body) {
        try {
            this.checkControllerBlock(base_enum_1.EControllerBlock.toggle);
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.toggleBulkActive(body),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async toggleActive(body, param) {
        try {
            this.checkControllerBlock(base_enum_1.EControllerBlock.toggle);
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.toggleActive(param.id, body),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
}
exports.BaseController = BaseController;
BaseController.toggleBulkPath = `toggle/bulk`;
__decorate([
    (0, common_1.Get)('analytics'),
    (0, swagger_1.ApiOperation)({ summary: 'Get analytics data' }),
    (0, swagger_1.ApiResponse)({ type: [analytics_dto_1.Chart] }),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [analytics_dto_1.ChartQueryDto]),
    __metadata("design:returntype", Promise)
], BaseController.prototype, "analytics", null);
__decorate([
    (0, common_1.Get)('getByID/:id'),
    (0, swagger_1.ApiOperation)({ summary: 'Get item by ID' }),
    (0, swagger_1.ApiParam)({
        name: 'id',
        required: true,
    }),
    __param(0, (0, common_1.Param)()),
    __param(1, (0, authentication_guard_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], BaseController.prototype, "getByID", null);
__decorate([
    (0, common_1.Get)('search'),
    (0, swagger_1.ApiOperation)({ summary: 'Search items' }),
    (0, swagger_1.ApiResponse)({ type: search_dto_1.SearchResponseDto }),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, authentication_guard_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, Object]),
    __metadata("design:returntype", Promise)
], BaseController.prototype, "search", null);
__decorate([
    (0, swagger_1.ApiBearerAuth)(),
    (0, common_1.Patch)('arrange'),
    (0, swagger_1.ApiOperation)({ summary: 'Arrange items order' }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [base_dto_1.SetOrderDTO]),
    __metadata("design:returntype", Promise)
], BaseController.prototype, "setOrder", null);
__decorate([
    (0, swagger_1.ApiBearerAuth)(),
    (0, common_1.Put)(`toggle/all`),
    (0, swagger_1.ApiOperation)({ summary: 'Toggle active status for all items' }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [base_dto_1.ToggleActiveDTO]),
    __metadata("design:returntype", Promise)
], BaseController.prototype, "toggleAllActive", null);
__decorate([
    (0, swagger_1.ApiBearerAuth)(),
    (0, common_1.Put)(BaseController.toggleBulkPath),
    (0, swagger_1.ApiOperation)({ summary: 'Toggle active status for multiple items' }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [base_dto_1.ToggleBulkActiveDTO]),
    __metadata("design:returntype", Promise)
], BaseController.prototype, "toggleBulkActive", null);
__decorate([
    (0, swagger_1.ApiBearerAuth)(),
    (0, common_1.Put)('toggle/:id'),
    (0, swagger_1.ApiOperation)({ summary: 'Toggle active status for a single item' }),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [base_dto_1.ToggleActiveDTO, base_dto_1.IDDto]),
    __metadata("design:returntype", Promise)
], BaseController.prototype, "toggleActive", null);
class BaseCRUController extends BaseController {
    create(body, auth, createFunction = (data) => this.service._create(data, { auth })) {
        try {
            this.checkControllerBlock(base_enum_1.EControllerBlock.create);
            utility_service_1.UtilityClass.patchCreator(body, auth);
            return utility_service_1.UtilityClass.handleSuccess({
                data: createFunction(body),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    updateByID(param, body, auth, updateFunction = (id, data) => this.service._updateByID(id, data, { auth })) {
        try {
            this.checkControllerBlock(base_enum_1.EControllerBlock.update);
            utility_service_1.UtilityClass.patchUpdater(body, auth);
            return utility_service_1.UtilityClass.handleSuccess({
                data: updateFunction(param.id, body),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    update(updateFunction, ...params) {
        try {
            this.checkControllerBlock(base_enum_1.EControllerBlock.update);
            return utility_service_1.UtilityClass.handleSuccess({
                data: updateFunction(params),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
}
exports.BaseCRUController = BaseCRUController;
__decorate([
    (0, swagger_1.ApiBearerAuth)(),
    (0, common_1.Post)(),
    (0, swagger_1.ApiOperation)({ summary: 'Create new item' }),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, authentication_guard_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, typeof (_a = typeof TAuthParam !== "undefined" && TAuthParam) === "function" ? _a : Object, Function]),
    __metadata("design:returntype", void 0)
], BaseCRUController.prototype, "create", null);
__decorate([
    (0, swagger_1.ApiOperation)({ summary: 'Update item by ID' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [base_dto_1.IDDto, typeof (_b = typeof TUpdateDto !== "undefined" && TUpdateDto) === "function" ? _b : Object, typeof (_c = typeof TAuthParam !== "undefined" && TAuthParam) === "function" ? _c : Object, Function]),
    __metadata("design:returntype", void 0)
], BaseCRUController.prototype, "updateByID", null);
__decorate([
    (0, swagger_1.ApiBearerAuth)(),
    (0, swagger_1.ApiOperation)({ summary: 'Update item with custom function' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [typeof (_d = typeof TUpdateFunction !== "undefined" && TUpdateFunction) === "function" ? _d : Object, typeof (_e = typeof TUpdateFunction !== "undefined" && TUpdateFunction) === "function" ? _e : Object]),
    __metadata("design:returntype", void 0)
], BaseCRUController.prototype, "update", null);
class BaseCRUDController extends BaseCRUController {
    deleteByID(param, auth, deleteFunction = (id) => this.service._deleteByID(id, auth)) {
        try {
            this.checkControllerBlock(base_enum_1.EControllerBlock.delete);
            return utility_service_1.UtilityClass.handleSuccess({
                data: deleteFunction(param.id, auth),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    deleteByIDs(body, auth, deleteFunction = (ids) => this.service._deleteByIDs(ids, auth)) {
        try {
            this.checkControllerBlock(base_enum_1.EControllerBlock.delete);
            return utility_service_1.UtilityClass.handleSuccess({
                data: deleteFunction(body.ids, auth),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    restoreByID(param, restoreFunction = (id) => this.service._restoreByID(id)) {
        try {
            this.checkControllerBlock(base_enum_1.EControllerBlock.restore);
            return utility_service_1.UtilityClass.handleSuccess({
                data: restoreFunction(param.id),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    restoreByIDs(body, restoreFunction = (ids) => this.service._restoreByIDs(ids)) {
        try {
            this.checkControllerBlock(base_enum_1.EControllerBlock.restore);
            return utility_service_1.UtilityClass.handleSuccess({
                data: restoreFunction(body.ids),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
}
exports.BaseCRUDController = BaseCRUDController;
__decorate([
    (0, swagger_1.ApiBearerAuth)(),
    (0, common_1.Delete)(':id'),
    (0, swagger_1.ApiOperation)({ summary: 'Delete item by ID' }),
    __param(0, (0, common_1.Param)()),
    __param(1, (0, authentication_guard_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [base_dto_1.IDDto, Object, Function]),
    __metadata("design:returntype", void 0)
], BaseCRUDController.prototype, "deleteByID", null);
__decorate([
    (0, swagger_1.ApiBearerAuth)(),
    (0, common_1.Delete)(''),
    (0, swagger_1.ApiOperation)({ summary: 'Delete multiple items by IDs' }),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, authentication_guard_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [base_dto_1.BatchDeleteDto, Object, Function]),
    __metadata("design:returntype", void 0)
], BaseCRUDController.prototype, "deleteByIDs", null);
__decorate([
    (0, swagger_1.ApiBearerAuth)(),
    (0, common_1.Patch)('restore/:id'),
    (0, swagger_1.ApiOperation)({ summary: 'Restore deleted item by ID' }),
    __param(0, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [base_dto_1.IDDto, Function]),
    __metadata("design:returntype", void 0)
], BaseCRUDController.prototype, "restoreByID", null);
__decorate([
    (0, swagger_1.ApiBearerAuth)(),
    (0, common_1.Patch)('restore'),
    (0, swagger_1.ApiOperation)({ summary: 'Restore multiple deleted items by IDs' }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [base_dto_1.BatchDeleteDto, Function]),
    __metadata("design:returntype", void 0)
], BaseCRUDController.prototype, "restoreByIDs", null);
//# sourceMappingURL=base.controller.js.map