"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RoutePath = void 0;
class RoutePath {
    constructor(path, param2, param3) {
        let parent;
        if (typeof param2 == 'string') {
            this._tag = param2.toUpperCase();
            parent = param3;
        }
        else {
            parent = param2;
        }
        this.path = ((parent?.path || '') + '/' + path).replaceAll('//', '/');
    }
    get tag() {
        return (this._tag ||
            this.path
                .replaceAll('/', ' ')
                .replaceAll('_', ' ')
                .replaceAll('-', ' ')
                .toUpperCase());
    }
}
exports.RoutePath = RoutePath;
//# sourceMappingURL=route-path.class.js.map