"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SandboxedCodeExecutor = void 0;
const common_1 = require("@nestjs/common");
const exceptions_1 = require("@nestjs/core/errors/exceptions");
const injector_1 = require("@nestjs/core/injector");
const injector_2 = require("@nestjs/core/injector/injector");
const serialized_graph_1 = require("@nestjs/core/inspector/serialized-graph");
const metadata_scanner_1 = require("@nestjs/core/metadata-scanner");
const sandboxjs_1 = __importDefault(require("@nyariv/sandboxjs"));
const stream_1 = require("stream");
const util_1 = require("util");
let SandboxedCodeExecutor = class SandboxedCodeExecutor {
    constructor(serializedGraph, modulesContainer, metadataScanner) {
        this.serializedGraph = serializedGraph;
        this.modulesContainer = modulesContainer;
        this.metadataScanner = metadataScanner;
        this.injector = new injector_2.Injector();
    }
    execute(code, res) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const responseStream = new stream_1.PassThrough();
            responseStream.pipe(res);
            const pipeToResponse = (data) => {
                if (typeof data === 'string') {
                    responseStream.write(data + '\n');
                    return;
                }
                responseStream.write((0, util_1.inspect)(data, false, 3) + '\n');
            };
            try {
                yield this.runInNewContext(`${code}`, {
                    $: (_a = this.generatedTokensMap) !== null && _a !== void 0 ? _a : this.generateTokensMap(),
                    get: (id) => {
                        const [instanceWrapper] = this.getInstanceWrapperAndCollectionByNodeId(id);
                        if (!instanceWrapper.isDependencyTreeStatic()) {
                            throw new exceptions_1.InvalidClassScopeException(id);
                        }
                        return instanceWrapper.instance;
                    },
                    resolve: (id, contextId) => __awaiter(this, void 0, void 0, function* () {
                        const [instanceWrapper, collection] = this.getInstanceWrapperAndCollectionByNodeId(id);
                        if (instanceWrapper.isDependencyTreeStatic() &&
                            !instanceWrapper.isTransient) {
                            return instanceWrapper.instance;
                        }
                        const ctorHost = instanceWrapper.instance || {
                            constructor: instanceWrapper.metatype,
                        };
                        const instance = yield this.injector.loadPerContext(ctorHost, instanceWrapper.host, collection, contextId, instanceWrapper);
                        if (!instance) {
                            throw new exceptions_1.UnknownElementException();
                        }
                        return instance;
                    }),
                    console: {
                        log: (input) => {
                            pipeToResponse(input);
                            console.log(input);
                        },
                        error: (input) => {
                            pipeToResponse(input);
                            console.error(input);
                        },
                        warn: (input) => {
                            pipeToResponse(input);
                            console.warn(input);
                        },
                        table: function (input) {
                            pipeToResponse(`<DEVTOOLS_table_start>${JSON.stringify(input)}<DEVTOOLS_table_end>`);
                            console.table(input);
                        },
                    },
                    table: (input) => pipeToResponse(`<DEVTOOLS_table_start>${JSON.stringify(input)}<DEVTOOLS_table_end>`),
                    methods: (id) => {
                        const [instanceWrapper] = this.getInstanceWrapperAndCollectionByNodeId(id);
                        const proto = Object.getPrototypeOf(instanceWrapper === null || instanceWrapper === void 0 ? void 0 : instanceWrapper.instance);
                        const methods = new Set(this.metadataScanner.getAllFilteredMethodNames(proto));
                        return methods;
                    },
                });
            }
            catch (err) {
                console.error(err);
                pipeToResponse(err);
            }
            setTimeout(() => responseStream.end(), 250);
        });
    }
    generateTokensMap() {
        const nodes = JSON.parse(this.serializedGraph.toString()).nodes;
        const tokensMap = Object.values(nodes)
            .filter((node) => node.metadata.type !== 'module')
            .map((node) => {
            const key = node.label
                .toString()
                .replace(/ /g, '_')
                .replace(/\(/g, '_')
                .replace(/\:/g, '_')
                .replace(/\-/g, '_')
                .replace(/\)/g, '_');
            return [key, node.id];
        });
        this.generatedTokensMap = Object.fromEntries(tokensMap);
        return this.generatedTokensMap;
    }
    getInstanceWrapperAndCollectionByNodeId(id) {
        const node = this.serializedGraph.getNodeById(id);
        if (!node) {
            throw Error(`Node with the given ID: "${id}" does not exist.`);
        }
        if (node.metadata.type === 'module') {
            throw Error(`Module nodes can not be retrieved using the "get()" function.`);
        }
        const classNode = node;
        if (classNode.metadata.internal) {
            throw Error(`Internal nodes can not be retrieved using the "get()" function.`);
        }
        const hostRef = this.modulesContainer.getById(classNode.parent);
        const [instanceWrapper, collection] = this.getInstanceWrapperAndCollectionByType(node, hostRef);
        if (!instanceWrapper) {
            throw Error(`Node with the given ID: "${id}" does not exist.`);
        }
        return [instanceWrapper, collection];
    }
    getInstanceWrapperAndCollectionByType(node, host) {
        switch (node.metadata.type) {
            case 'controller':
                return [host.getControllerById(node.id), host.controllers];
            case 'provider':
                return [host.getProviderById(node.id), host.providers];
            case 'injectable':
                return [host.getInjectableById(node.id), host.injectables];
            case 'middleware':
                return [host.getMiddlewareById(node.id), host.middlewares];
        }
    }
    runInNewContext(code, context) {
        const sandbox = this.getSandbox();
        const executableFactory = sandbox.compileAsync(code);
        const exec = context ? executableFactory(context) : executableFactory();
        return exec.run();
    }
    getSandbox() {
        if (this._sandbox) {
            return this._sandbox;
        }
        const prototypeWhitelist = sandboxjs_1.default.SAFE_PROTOTYPES;
        const whitelistWrapper = (wrapper) => {
            var _a;
            let proto = wrapper.inject
                ? (_a = wrapper.instance) === null || _a === void 0 ? void 0 : _a.constructor
                : wrapper.metatype;
            while (proto) {
                if (!prototypeWhitelist.has(proto)) {
                    prototypeWhitelist.set(proto, new Set());
                }
                proto = Object.getPrototypeOf(proto);
            }
        };
        this.modulesContainer.forEach(moduleRef => {
            moduleRef.controllers.forEach(wrapper => whitelistWrapper(wrapper));
            moduleRef.providers.forEach(wrapper => whitelistWrapper(wrapper));
            moduleRef.injectables.forEach(wrapper => whitelistWrapper(wrapper));
        });
        this._sandbox = new sandboxjs_1.default({
            globals: sandboxjs_1.default.SAFE_GLOBALS,
            prototypeWhitelist,
        });
        return this._sandbox;
    }
};
SandboxedCodeExecutor = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [serialized_graph_1.SerializedGraph,
        injector_1.ModulesContainer,
        metadata_scanner_1.MetadataScanner])
], SandboxedCodeExecutor);
exports.SandboxedCodeExecutor = SandboxedCodeExecutor;
