/// <reference types="node" />
import { ModulesContainer } from '@nestjs/core/injector';
import { SerializedGraph } from '@nestjs/core/inspector/serialized-graph';
import { MetadataScanner } from '@nestjs/core/metadata-scanner';
import { ServerResponse } from 'http';
export declare class SandboxedCodeExecutor {
    private readonly serializedGraph;
    private readonly modulesContainer;
    private readonly metadataScanner;
    private readonly injector;
    private generatedTokensMap;
    private _sandbox;
    constructor(serializedGraph: SerializedGraph, modulesContainer: ModulesContainer, metadataScanner: MetadataScanner);
    execute(code: string, res: ServerResponse): Promise<void>;
    private generateTokensMap;
    private getInstanceWrapperAndCollectionByNodeId;
    private getInstanceWrapperAndCollectionByType;
    private runInNewContext;
    private getSandbox;
}
