"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DevtoolsHttpServerHost = void 0;
const common_1 = require("@nestjs/common");
const serialized_graph_1 = require("@nestjs/core/inspector/serialized-graph");
const chalk_1 = __importDefault(require("chalk"));
const crypto_1 = require("crypto");
const http = __importStar(require("http"));
const devtools_module_definition_1 = require("./devtools.module-definition");
const sandboxed_code_executor_1 = require("./sandboxed-code.executor");
const DEFAULT_PORT = 8000;
let DevtoolsHttpServerHost = class DevtoolsHttpServerHost {
    constructor(serializedGraph, sandboxedCodeExecutor, options) {
        this.serializedGraph = serializedGraph;
        this.sandboxedCodeExecutor = sandboxedCodeExecutor;
        this.options = options;
    }
    onModuleInit() {
        this.routes = {
            ['/inspector/graph/snapshot']: (req, res) => this.handleGetSnapshotRoute(req, res),
            ['/inspector/graph/interact']: (req, res) => this.handleGraphInteraction(req, res),
        };
    }
    onApplicationBootstrap() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.initHttpServer();
            this.sandboxSessionToken = this.generateSandboxSessionToken();
            setTimeout(() => this.printSandboxSessionToken(this.sandboxSessionToken), 1000);
        });
    }
    onApplicationShutdown() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.httpServer) {
                this.httpServer.close();
                setImmediate(() => this.httpServer.emit('close'));
            }
        });
    }
    initHttpServer() {
        var _a, _b, _c;
        return __awaiter(this, void 0, void 0, function* () {
            if (!((_a = this.options) === null || _a === void 0 ? void 0 : _a.http)) {
                return;
            }
            const requestListener = (req, res) => __awaiter(this, void 0, void 0, function* () {
                res.setHeader('Access-Control-Allow-Origin', this.getAppUrl());
                res.setHeader('Access-Control-Allow-Methods', 'OPTIONS, GET, POST');
                res.setHeader('Access-Control-Allow-Headers', 'Content-Type, x-sandbox-session-token');
                res.setHeader('Access-Control-Max-Age', 2592000);
                if (req.method === 'OPTIONS') {
                    res.writeHead(204);
                    res.end();
                    return;
                }
                const url = req.url;
                const routeHandler = this.routes[url];
                if (routeHandler) {
                    yield routeHandler(req, res);
                }
                else {
                    res.writeHead(405);
                    res.end(`${req.method} is not allowed for the request.`);
                }
            });
            const server = http.createServer(requestListener);
            this.httpServer = server.listen((_c = (_b = this.options) === null || _b === void 0 ? void 0 : _b.port) !== null && _c !== void 0 ? _c : DEFAULT_PORT);
            yield new Promise((resolve, reject) => {
                server.on('listening', resolve);
                server.on('error', reject);
            });
        });
    }
    handleGetSnapshotRoute(req, res) {
        if (!this.validateOrigin(req.headers.origin)) {
            res.writeHead(403, { 'Content-Type': 'text/plain' });
            res.end('Forbidden: Invalid origin. Request blocked to prevent DNS rebinding attacks.');
            return;
        }
        if (req.method === 'GET') {
            res.writeHead(200, { 'Content-Type': 'application/json' });
            res.write(this.serializedGraph.toString());
            res.end();
        }
    }
    handleGraphInteraction(req, res) {
        if (!this.validateOrigin(req.headers.origin)) {
            res.writeHead(403, { 'Content-Type': 'text/plain' });
            res.end('Forbidden: Invalid origin. Request blocked to prevent DNS rebinding attacks.');
            return;
        }
        if (req.headers['content-type'] !== 'application/json') {
            res.writeHead(400, { 'Content-Type': 'text/plain' });
            res.end('Bad Request: Content-Type must be application/json');
            return;
        }
        const sessionToken = req.headers['x-sandbox-session-token'];
        if (!sessionToken) {
            this.sendUnauthorized(res);
            return;
        }
        const providedBuffer = Buffer.from(sessionToken, 'utf-8');
        const expectedBuffer = Buffer.from(this.sandboxSessionToken);
        if (providedBuffer.length !== expectedBuffer.length) {
            this.sendUnauthorized(res);
            return;
        }
        if (!(0, crypto_1.timingSafeEqual)(providedBuffer, expectedBuffer)) {
            this.sendUnauthorized(res);
            return;
        }
        if (req.method === 'POST') {
            let body = '';
            req.on('data', data => {
                body += data;
            });
            req.on('end', () => __awaiter(this, void 0, void 0, function* () {
                res.writeHead(200, { 'Content-Type': 'application/plain' });
                const json = JSON.parse(body);
                yield this.sandboxedCodeExecutor.execute(json.code, res);
            }));
        }
    }
    getAppUrl() {
        var _a;
        return (_a = process.env.DEVTOOLS_APP_URL) !== null && _a !== void 0 ? _a : 'https://devtools.nestjs.com';
    }
    validateOrigin(origin) {
        if (!origin) {
            return false;
        }
        const allowedOrigins = [
            'https://devtools.nestjs.com',
            'http://localhost:4000',
        ];
        return allowedOrigins.includes(origin);
    }
    generateSandboxSessionToken() {
        return (0, crypto_1.randomBytes)(32).toString('hex');
    }
    printSandboxSessionToken(token) {
        console.log((0, chalk_1.default) `Sandbox session token: {green {bold ${token}}}\nUse this token to interact with Devtools Playground.`);
    }
    sendUnauthorized(res) {
        res.writeHead(401, { 'Content-Type': 'text/plain' });
        res.end('Unauthorized: Invalid or missing session token.');
    }
};
DevtoolsHttpServerHost = __decorate([
    (0, common_1.Injectable)(),
    __param(2, (0, common_1.Inject)(devtools_module_definition_1.DEVTOOLS_MODULE_OPTIONS)),
    __metadata("design:paramtypes", [serialized_graph_1.SerializedGraph,
        sandboxed_code_executor_1.SandboxedCodeExecutor, Object])
], DevtoolsHttpServerHost);
exports.DevtoolsHttpServerHost = DevtoolsHttpServerHost;
