import { OnApplicationBootstrap, OnApplicationShutdown, OnModuleInit } from '@nestjs/common';
import { SerializedGraph } from '@nestjs/core/inspector/serialized-graph';
import { DevtoolsModuleOptions } from './devtools.module-definition';
import { SandboxedCodeExecutor } from './sandboxed-code.executor';
export declare class DevtoolsHttpServerHost implements OnApplicationBootstrap, OnApplicationShutdown, OnModuleInit {
    private readonly serializedGraph;
    private readonly sandboxedCodeExecutor;
    private readonly options;
    private httpServer;
    private routes;
    private sandboxSessionToken;
    constructor(serializedGraph: SerializedGraph, sandboxedCodeExecutor: SandboxedCodeExecutor, options: typeof DevtoolsModuleOptions);
    onModuleInit(): void;
    onApplicationBootstrap(): Promise<void>;
    onApplicationShutdown(): Promise<void>;
    private initHttpServer;
    private handleGetSnapshotRoute;
    private handleGraphInteraction;
    private getAppUrl;
    private validateOrigin;
    private generateSandboxSessionToken;
    private printSandboxSessionToken;
    private sendUnauthorized;
}
