'use strict';

var fs = require('fs-extra');
var path = require('path');
var tsMorph = require('ts-morph');
var LiveServer = require('@compodoc/live-server');
var _ = require('lodash');
var ts = require('typescript');
var semver = require('semver');
var i18next = require('i18next');
var JSON5 = require('json5');
var htmlEntities = require('html-entities');
var cheerio = require('cheerio');
var uuid = require('uuid');
var cosmiconfig = require('cosmiconfig');

function _interopNamespaceDefault(e) {
    var n = Object.create(null);
    if (e) {
        Object.keys(e).forEach(function (k) {
            if (k !== 'default') {
                var d = Object.getOwnPropertyDescriptor(e, k);
                Object.defineProperty(n, k, d.get ? d : {
                    enumerable: true,
                    get: function () { return e[k]; }
                });
            }
        });
    }
    n.default = e;
    return Object.freeze(n);
}

var fs__namespace = /*#__PURE__*/_interopNamespaceDefault(fs);
var path__namespace = /*#__PURE__*/_interopNamespaceDefault(path);
var LiveServer__namespace = /*#__PURE__*/_interopNamespaceDefault(LiveServer);
var ___namespace = /*#__PURE__*/_interopNamespaceDefault(_);
var ts__namespace = /*#__PURE__*/_interopNamespaceDefault(ts);
var semver__namespace = /*#__PURE__*/_interopNamespaceDefault(semver);
var JSON5__namespace = /*#__PURE__*/_interopNamespaceDefault(JSON5);
var cheerio__namespace = /*#__PURE__*/_interopNamespaceDefault(cheerio);

/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise, SuppressedError, Symbol, Iterator */

var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
    return extendStatics(d, b);
};

function __extends(d, b) {
    if (typeof b !== "function" && b !== null)
        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
    extendStatics(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};

function __values(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}

function __read(o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
}

function __spreadArray(to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
}

typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
    var e = new Error(message);
    return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
};

var log = require('fancy-log');
var c = require('picocolors');
var LEVEL;
(function (LEVEL) {
    LEVEL[LEVEL["INFO"] = 0] = "INFO";
    LEVEL[LEVEL["DEBUG"] = 1] = "DEBUG";
    LEVEL[LEVEL["ERROR"] = 2] = "ERROR";
    LEVEL[LEVEL["WARN"] = 3] = "WARN";
})(LEVEL || (LEVEL = {}));
var Logger = /** @class */ (function () {
    function Logger() {
        this.logger = log;
        this.silent = true;
    }
    Logger.prototype.info = function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        if (!this.silent) {
            return;
        }
        this.logger(this.format.apply(this, __spreadArray([LEVEL.INFO], __read(args), false)));
    };
    Logger.prototype.error = function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        this.logger(this.format.apply(this, __spreadArray([LEVEL.ERROR], __read(args), false)));
    };
    Logger.prototype.warn = function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        if (!this.silent) {
            return;
        }
        this.logger(this.format.apply(this, __spreadArray([LEVEL.WARN], __read(args), false)));
    };
    Logger.prototype.debug = function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        if (!this.silent) {
            return;
        }
        this.logger(this.format.apply(this, __spreadArray([LEVEL.DEBUG], __read(args), false)));
    };
    Logger.prototype.format = function (level) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        var pad = function (s, l, z) {
            return s + Array(Math.max(0, l - s.length + 1)).join(z);
        };
        var msg = args.join(' ');
        if (args.length > 1) {
            msg = "".concat(pad(args.shift(), 15, ' '), ": ").concat(args.join(' '));
        }
        switch (level) {
            case LEVEL.INFO:
                msg = c.green(msg);
                break;
            case LEVEL.DEBUG:
                msg = c.cyan(msg);
                break;
            case LEVEL.WARN:
                msg = c.yellow(msg);
                break;
            case LEVEL.ERROR:
                msg = c.red(msg);
                break;
        }
        return [msg].join('');
    };
    return Logger;
}());
var logger = new Logger();

var COMPODOC_DEFAULTS = {
    title: 'Application documentation',
    additionalEntryName: 'Additional documentation',
    additionalEntryPath: 'additional-documentation',
    folder: './documentation/',
    hostname: '127.0.0.1',
    port: 8080,
    theme: 'gitbook',
    exportFormat: 'html',
    exportFormatsSupported: ['html', 'json'],
    base: '/',
    defaultCoverageThreshold: 70,
    defaultCoverageMinimumPerFile: 0,
    coverageTestThresholdFail: true,
    toggleMenuItems: ['all'],
    navTabConfig: [],
    disableSourceCode: false,
    disableDomTree: false,
    disableTemplateTab: false,
    disableStyleTab: false,
    disableGraph: false,
    disableMainGraph: false,
    disableCoverage: false,
    disablePrivate: false,
    disableProtected: false,
    disableInternal: false,
    disableLifeCycleHooks: false,
    disableConstructors: false,
    disableRoutesGraph: false,
    disableDependencies: false,
    disableProperties: false,
    PAGE_TYPES: {
        ROOT: 'root',
        INTERNAL: 'internal'
    },
    gaSite: 'auto',
    coverageTestShowOnlyFailed: false,
    language: 'en-US',
    maxSearchResults: 15
};

var Configuration = /** @class */ (function () {
    function Configuration() {
        this._pages = [];
        this._mainData = {
            output: COMPODOC_DEFAULTS.folder,
            theme: COMPODOC_DEFAULTS.theme,
            extTheme: '',
            serve: false,
            hostname: COMPODOC_DEFAULTS.hostname,
            host: '',
            port: COMPODOC_DEFAULTS.port,
            open: false,
            assetsFolder: '',
            documentationMainName: COMPODOC_DEFAULTS.title,
            documentationMainDescription: '',
            base: COMPODOC_DEFAULTS.base,
            hideGenerator: false,
            hideDarkModeToggle: false,
            hasFilesToCoverage: false,
            modules: [],
            readme: false,
            changelog: '',
            contributing: '',
            license: '',
            todo: '',
            markdowns: [],
            additionalPages: [],
            pipes: [],
            classes: [],
            interfaces: [],
            components: [],
            controllers: [],
            entities: [],
            directives: [],
            injectables: [],
            interceptors: [],
            guards: [],
            miscellaneous: [],
            routes: [],
            tsconfig: '',
            toggleMenuItems: COMPODOC_DEFAULTS.toggleMenuItems,
            navTabConfig: [],
            templates: '',
            includes: '',
            includesName: COMPODOC_DEFAULTS.additionalEntryName,
            includesFolder: COMPODOC_DEFAULTS.additionalEntryPath,
            disableSourceCode: COMPODOC_DEFAULTS.disableSourceCode,
            disableDomTree: COMPODOC_DEFAULTS.disableDomTree,
            disableTemplateTab: COMPODOC_DEFAULTS.disableTemplateTab,
            disableStyleTab: COMPODOC_DEFAULTS.disableStyleTab,
            disableGraph: COMPODOC_DEFAULTS.disableGraph,
            disableMainGraph: COMPODOC_DEFAULTS.disableMainGraph,
            disableCoverage: COMPODOC_DEFAULTS.disableCoverage,
            disablePrivate: COMPODOC_DEFAULTS.disablePrivate,
            disableInternal: COMPODOC_DEFAULTS.disableInternal,
            disableProtected: COMPODOC_DEFAULTS.disableProtected,
            disableLifeCycleHooks: COMPODOC_DEFAULTS.disableLifeCycleHooks,
            disableConstructors: COMPODOC_DEFAULTS.disableConstructors,
            disableRoutesGraph: COMPODOC_DEFAULTS.disableRoutesGraph,
            disableSearch: false,
            disableDependencies: COMPODOC_DEFAULTS.disableDependencies,
            disableProperties: COMPODOC_DEFAULTS.disableProperties,
            watch: false,
            mainGraph: '',
            coverageTest: false,
            coverageTestThreshold: COMPODOC_DEFAULTS.defaultCoverageThreshold,
            coverageTestThresholdFail: COMPODOC_DEFAULTS.coverageTestThresholdFail,
            coverageTestPerFile: false,
            coverageMinimumPerFile: COMPODOC_DEFAULTS.defaultCoverageMinimumPerFile,
            unitTestCoverage: '',
            unitTestData: undefined,
            coverageTestShowOnlyFailed: COMPODOC_DEFAULTS.coverageTestShowOnlyFailed,
            routesLength: 0,
            angularVersion: '',
            exportFormat: COMPODOC_DEFAULTS.exportFormat,
            coverageData: {},
            customFavicon: '',
            customLogo: '',
            packageDependencies: [],
            packagePeerDependencies: [],
            packageProperties: {},
            gaID: '',
            gaSite: '',
            angularProject: false,
            angularJSProject: false,
            language: COMPODOC_DEFAULTS.language,
            maxSearchResults: 15
        };
    }
    Configuration.getInstance = function () {
        if (!Configuration.instance) {
            Configuration.instance = new Configuration();
        }
        return Configuration.instance;
    };
    Configuration.prototype.addPage = function (page) {
        var indexPage = ___namespace.findIndex(this._pages, { name: page.name });
        if (indexPage === -1) {
            this._pages.push(page);
        }
    };
    Configuration.prototype.hasPage = function (name) {
        var indexPage = ___namespace.findIndex(this._pages, { name: name });
        return indexPage !== -1;
    };
    Configuration.prototype.addAdditionalPage = function (page) {
        this._mainData.additionalPages.push(page);
    };
    Configuration.prototype.getAdditionalPageById = function (id) {
        return this._mainData.additionalPages.find(function (page) { return page.id === id; });
    };
    Configuration.prototype.resetPages = function () {
        this._pages = [];
    };
    Configuration.prototype.resetAdditionalPages = function () {
        this._mainData.additionalPages = [];
    };
    Configuration.prototype.resetRootMarkdownPages = function () {
        var indexPage = ___namespace.findIndex(this._pages, { name: 'index' });
        this._pages.splice(indexPage, 1);
        indexPage = ___namespace.findIndex(this._pages, { name: 'changelog' });
        this._pages.splice(indexPage, 1);
        indexPage = ___namespace.findIndex(this._pages, { name: 'contributing' });
        this._pages.splice(indexPage, 1);
        indexPage = ___namespace.findIndex(this._pages, { name: 'license' });
        this._pages.splice(indexPage, 1);
        indexPage = ___namespace.findIndex(this._pages, { name: 'todo' });
        this._pages.splice(indexPage, 1);
        this._mainData.markdowns = [];
    };
    Object.defineProperty(Configuration.prototype, "pages", {
        get: function () {
            return this._pages;
        },
        set: function (pages) {
            this._pages = [];
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Configuration.prototype, "markDownPages", {
        get: function () {
            return this._pages.filter(function (page) { return page.markdown; });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Configuration.prototype, "mainData", {
        get: function () {
            return this._mainData;
        },
        set: function (data) {
            Object.assign(this._mainData, data);
        },
        enumerable: false,
        configurable: true
    });
    return Configuration;
}());
var Configuration$1 = Configuration.getInstance();

var AngularAPIs = require('../src/data/api-list.json');
var AngularApiUtil = /** @class */ (function () {
    function AngularApiUtil() {
    }
    AngularApiUtil.getInstance = function () {
        if (!AngularApiUtil.instance) {
            AngularApiUtil.instance = new AngularApiUtil();
        }
        return AngularApiUtil.instance;
    };
    AngularApiUtil.prototype.findApi = function (type) {
        var foundedApi;
        ___namespace.forEach(AngularAPIs, function (mainApi) {
            ___namespace.forEach(mainApi.items, function (api) {
                if (api.title === type) {
                    foundedApi = api;
                }
            });
        });
        return {
            source: 'external',
            data: foundedApi
        };
    };
    return AngularApiUtil;
}());
var AngularApiUtil$1 = AngularApiUtil.getInstance();

function extractLeadingText(string, completeTag) {
    var tagIndex = string.indexOf(completeTag);
    var leadingText = undefined;
    var leadingTextRegExp = /\[(.+?)\]/g;
    var leadingTextInfo = leadingTextRegExp.exec(string);
    // did we find leading text, and if so, does it immediately precede the tag?
    while (leadingTextInfo && leadingTextInfo.length) {
        if (leadingTextInfo.index + leadingTextInfo[0].length === tagIndex) {
            string = string.replace(leadingTextInfo[0], '');
            leadingText = leadingTextInfo[1];
            break;
        }
        leadingTextInfo = leadingTextRegExp.exec(string);
    }
    return {
        leadingText: leadingText,
        string: string
    };
}
function splitLinkText(text) {
    var linkText;
    var target;
    var splitIndex;
    // if a pipe is not present, we split on the first space
    splitIndex = text.indexOf('|');
    if (splitIndex === -1) {
        splitIndex = text.search(/\s/);
    }
    if (splitIndex !== -1) {
        linkText = text.substr(splitIndex + 1);
        // Normalize subsequent newlines to a single space.
        linkText = linkText.replace(/\n+/, ' ');
        target = text.substr(0, splitIndex);
    }
    return {
        linkText: linkText,
        target: target || text
    };
}
var LinkParser = (function () {
    var processTheLink = function (string, tagInfo, leadingText) {
        var leading = extractLeadingText(string, tagInfo.completeTag), linkText, split, target, stringtoReplace;
        linkText = leadingText ? leadingText : leading.leadingText || '';
        split = splitLinkText(tagInfo.text);
        target = split.target;
        if (leading.leadingText !== undefined) {
            stringtoReplace = '[' + leading.leadingText + ']' + tagInfo.completeTag;
        }
        else if (typeof split.linkText !== 'undefined') {
            stringtoReplace = tagInfo.completeTag;
            linkText = split.linkText;
        }
        if (linkText === '' || linkText == null || target == null) {
            return string;
        }
        return string.replace(stringtoReplace, '[' + linkText + '](' + target + ')');
    };
    /**
     * Convert
     * {@link http://www.google.com|Google} or {@link https://github.com GitHub} or [Github]{@link https://github.com} to [Github](https://github.com)
     */
    var replaceLinkTag = function (str) {
        if (typeof str === 'undefined') {
            return {
                newString: ''
            };
        }
        // new RegExp('\\[((?:.|\n)+?)]\\{@link\\s+((?:.|\n)+?)\\}', 'i').exec('ee [TO DO]{@link Todo} fo') -> "[TO DO]{@link Todo}", "TO DO", "Todo"
        // new RegExp('\\{@link\\s+((?:.|\n)+?)\\}', 'i').exec('ee [TODO]{@link Todo} fo') -> "{@link Todo}", "Todo"
        var tagRegExpLight = new RegExp('\\{@link\\s+((?:.|\n)+?)\\}', 'i'), tagRegExpFull = new RegExp('\\{@link\\s+((?:.|\n)+?)\\}', 'i'), tagRegExp, matches, previousString;
        tagRegExp = str.indexOf(']{') !== -1 ? tagRegExpFull : tagRegExpLight;
        function replaceMatch(replacer, tag, match, text, linkText) {
            var matchedTag = {
                completeTag: match,
                tag: tag,
                text: text
            };
            if (linkText) {
                return replacer(str, matchedTag, linkText);
            }
            else {
                return replacer(str, matchedTag);
            }
        }
        do {
            matches = tagRegExp.exec(str);
            if (matches) {
                previousString = str;
                if (matches.length === 2) {
                    str = replaceMatch(processTheLink, 'link', matches[0], matches[1]);
                }
                if (matches.length === 3) {
                    str = replaceMatch(processTheLink, 'link', matches[0], matches[2], matches[1]);
                }
            }
        } while (matches && previousString !== str);
        return {
            newString: str
        };
    };
    var _resolveLinks = function (str) {
        return replaceLinkTag(str).newString;
    };
    return {
        resolveLinks: _resolveLinks
    };
})();

var AngularLifecycleHooks;
(function (AngularLifecycleHooks) {
    AngularLifecycleHooks[AngularLifecycleHooks["ngOnChanges"] = 0] = "ngOnChanges";
    AngularLifecycleHooks[AngularLifecycleHooks["ngOnInit"] = 1] = "ngOnInit";
    AngularLifecycleHooks[AngularLifecycleHooks["ngDoCheck"] = 2] = "ngDoCheck";
    AngularLifecycleHooks[AngularLifecycleHooks["ngAfterContentInit"] = 3] = "ngAfterContentInit";
    AngularLifecycleHooks[AngularLifecycleHooks["ngAfterContentChecked"] = 4] = "ngAfterContentChecked";
    AngularLifecycleHooks[AngularLifecycleHooks["ngAfterViewInit"] = 5] = "ngAfterViewInit";
    AngularLifecycleHooks[AngularLifecycleHooks["ngAfterViewChecked"] = 6] = "ngAfterViewChecked";
    AngularLifecycleHooks[AngularLifecycleHooks["ngOnDestroy"] = 7] = "ngOnDestroy";
})(AngularLifecycleHooks || (AngularLifecycleHooks = {}));

var KindType;
(function (KindType) {
    KindType["UNKNOWN"] = "";
    KindType["STRING"] = "string";
    KindType["NUMBER"] = "number";
    KindType["ARRAY"] = "[]";
    KindType["VOID"] = "void";
    KindType["FUNCTION"] = "function";
    KindType["TEMPLATE_LITERAL"] = "template literal type";
    KindType["LITERAL"] = "literal type";
    KindType["BOOLEAN"] = "boolean";
    KindType["ANY"] = "any";
    KindType["NULL"] = "null";
    KindType["SYMBOL"] = "symbol";
    KindType["NEVER"] = "never";
    KindType["UNDEFINED"] = "undefined";
    KindType["OBJECT"] = "object";
})(KindType || (KindType = {}));
var IsKindType = {
    ANY: function (kind) {
        return kindToType(kind) === KindType.ANY;
    },
    ARRAY: function (kind) {
        return kindToType(kind) === KindType.ARRAY;
    },
    BOOLEAN: function (kind) {
        return kindToType(kind) === KindType.BOOLEAN;
    },
    FUNCTION: function (kind) {
        return kindToType(kind) === KindType.FUNCTION;
    },
    LITERAL: function (kind) {
        return kindToType(kind) === KindType.LITERAL;
    },
    NEVER: function (kind) {
        return kindToType(kind) === KindType.NEVER;
    },
    NULL: function (kind) {
        return kindToType(kind) === KindType.NULL;
    },
    NUMBER: function (kind) {
        return kindToType(kind) === KindType.NUMBER;
    },
    OBJECT: function (kind) {
        return kindToType(kind) === KindType.OBJECT;
    },
    STRING: function (kind) {
        return kindToType(kind) === KindType.STRING;
    },
    SYMBOL: function (kind) {
        return kindToType(kind) === KindType.SYMBOL;
    },
    TEMPLATE_LITERAL: function (kind) {
        return kindToType(kind) === KindType.TEMPLATE_LITERAL;
    },
    UNDEFINED: function (kind) {
        return kindToType(kind) === KindType.UNDEFINED;
    },
    UNKNOWN: function (kind) {
        return kindToType(kind) === KindType.UNKNOWN;
    },
    VOID: function (kind) {
        return kindToType(kind) === KindType.VOID;
    }
};
function kindToType(kind) {
    var _type = KindType.UNKNOWN;
    switch (kind) {
        case tsMorph.SyntaxKind.StringKeyword:
        case tsMorph.SyntaxKind.StringLiteral:
            _type = KindType.STRING;
            break;
        case tsMorph.SyntaxKind.NumberKeyword:
        case tsMorph.SyntaxKind.NumericLiteral:
            _type = KindType.NUMBER;
            break;
        case tsMorph.SyntaxKind.ArrayType:
        case tsMorph.SyntaxKind.ArrayLiteralExpression:
            _type = KindType.ARRAY;
            break;
        case tsMorph.SyntaxKind.VoidKeyword:
            _type = KindType.VOID;
            break;
        case tsMorph.SyntaxKind.FunctionType:
            _type = KindType.FUNCTION;
            break;
        case tsMorph.SyntaxKind.TemplateLiteralType:
            _type = KindType.TEMPLATE_LITERAL;
            break;
        case tsMorph.SyntaxKind.TypeLiteral:
            _type = KindType.LITERAL;
            break;
        case tsMorph.SyntaxKind.BooleanKeyword:
            _type = KindType.BOOLEAN;
            break;
        case tsMorph.SyntaxKind.AnyKeyword:
            _type = KindType.ANY;
            break;
        case tsMorph.SyntaxKind.NullKeyword:
            _type = KindType.NULL;
            break;
        case tsMorph.SyntaxKind.SymbolKeyword:
            _type = KindType.SYMBOL;
            break;
        case tsMorph.SyntaxKind.NeverKeyword:
            _type = KindType.NEVER;
            break;
        case tsMorph.SyntaxKind.UndefinedKeyword:
            _type = KindType.UNDEFINED;
            break;
        case tsMorph.SyntaxKind.ObjectKeyword:
        case tsMorph.SyntaxKind.ObjectLiteralExpression:
            _type = KindType.OBJECT;
            break;
    }
    return _type;
}

var tsany = ts__namespace;
// https://github.com/Microsoft/TypeScript/blob/v2.1.4/src/compiler/utilities.ts#L1423
function getJSDocCommentRanges(node, text) {
    return tsany.getJSDocCommentRanges.apply(this, arguments);
}

var JsdocParserUtil = /** @class */ (function () {
    function JsdocParserUtil() {
    }
    JsdocParserUtil.prototype.isVariableLike = function (node) {
        if (node) {
            switch (node.kind) {
                case tsMorph.SyntaxKind.BindingElement:
                case tsMorph.SyntaxKind.EnumMember:
                case tsMorph.SyntaxKind.Parameter:
                case tsMorph.SyntaxKind.PropertyAssignment:
                case tsMorph.SyntaxKind.PropertyDeclaration:
                case tsMorph.SyntaxKind.PropertySignature:
                case tsMorph.SyntaxKind.ShorthandPropertyAssignment:
                case tsMorph.SyntaxKind.VariableDeclaration:
                    return true;
            }
        }
        return false;
    };
    JsdocParserUtil.prototype.isTopmostModuleDeclaration = function (node) {
        if (node.nextContainer && node.nextContainer.kind === tsMorph.ts.SyntaxKind.ModuleDeclaration) {
            var next = node.nextContainer;
            if (node.name.end + 1 === next.name.pos) {
                return false;
            }
        }
        return true;
    };
    JsdocParserUtil.prototype.getRootModuleDeclaration = function (node) {
        while (node.parent && node.parent.kind === tsMorph.ts.SyntaxKind.ModuleDeclaration) {
            var parent = node.parent;
            if (node.name.pos === parent.name.end + 1) {
                node = parent;
            }
            else {
                break;
            }
        }
        return node;
    };
    JsdocParserUtil.prototype.getMainCommentOfNode = function (node, sourceFile) {
        var description = '';
        if (node.parent && node.parent.kind === tsMorph.ts.SyntaxKind.VariableDeclarationList) {
            node = node.parent.parent;
        }
        else if (node.kind === tsMorph.ts.SyntaxKind.ModuleDeclaration) {
            if (!this.isTopmostModuleDeclaration(node)) {
                return null;
            }
            else {
                node = this.getRootModuleDeclaration(node);
            }
        }
        var comments = getJSDocCommentRanges(node, sourceFile.text);
        if (comments && comments.length) {
            var comment = void 0;
            if (node.kind === tsMorph.ts.SyntaxKind.SourceFile) {
                if (comments.length === 1) {
                    return null;
                }
                comment = comments[0];
            }
            else {
                comment = comments[comments.length - 1];
            }
            description = sourceFile.text.substring(comment.pos, comment.end);
        }
        return description;
    };
    JsdocParserUtil.prototype.parseComment = function (text) {
        var comment = '';
        var shortText = 0;
        function readBareLine(line) {
            comment += '\n' + line;
            if (line === '' && shortText === 0) ;
            else if (line === '' && shortText === 1) {
                shortText = 2;
            }
            else {
                if (shortText === 2) {
                    comment += (comment === '' ? '' : '\n') + line;
                }
            }
        }
        var CODE_FENCE = /^\s*```(?!.*```)/;
        var inCode = false;
        var inExample = false; // first line with @example, end line with empty string or string or */
        function readLine(line, index) {
            line = line.replace(/^\s*\*? ?/, '');
            line = line.replace(/\s*$/, '');
            if (CODE_FENCE.test(line)) {
                inCode = !inCode;
            }
            if (line.indexOf('@example') !== -1) {
                inExample = true;
                line = '```html';
            }
            if (inExample && line === '') {
                inExample = false;
                line = '```';
            }
            if (!inCode) {
                var tag = /^@(\S+)/.exec(line);
                var SeeTag = /^@see/.exec(line);
                if (SeeTag) {
                    line = line.replace(/^@see/, 'See');
                }
                if (tag && !SeeTag) {
                    return;
                }
            }
            readBareLine(line);
        }
        text = text.replace(/^\s*\/\*+/, '');
        text = text.replace(/\*+\/\s*$/, '');
        text.split(/\r\n?|\n/).length;
        text.split(/\r\n?|\n/).forEach(readLine);
        return comment;
    };
    JsdocParserUtil.prototype.getJSDocTags = function (node, kind) {
        var e_1, _a;
        var docs = this.getJSDocs(node);
        if (docs) {
            var result = [];
            try {
                for (var docs_1 = __values(docs), docs_1_1 = docs_1.next(); !docs_1_1.done; docs_1_1 = docs_1.next()) {
                    var doc = docs_1_1.value;
                    if (tsMorph.ts.isJSDocParameterTag(doc)) {
                        if (doc.kind === kind) {
                            result.push(doc);
                        }
                    }
                    else if (tsMorph.ts.isJSDoc(doc)) {
                        result.push.apply(result, __spreadArray([], __read(___namespace.filter(doc.tags, function (tag) { return tag.kind === kind; })), false));
                    }
                    else {
                        throw new Error('Unexpected type');
                    }
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (docs_1_1 && !docs_1_1.done && (_a = docs_1.return)) _a.call(docs_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            return result;
        }
    };
    JsdocParserUtil.prototype.getJSDocs = function (node) {
        // TODO: jsDocCache is internal, see if there's a way around it
        var cache = node.jsDocCache;
        if (!cache) {
            cache = this.getJSDocsWorker(node, []).filter(function (x) { return x; });
            node.jsDocCache = cache;
        }
        return cache;
    };
    // Try to recognize this pattern when node is initializer
    // of variable declaration and JSDoc comments are on containing variable statement.
    // /**
    //   * @param {number} name
    //   * @returns {number}
    //   */
    // var x = function(name) { return name.length; }
    JsdocParserUtil.prototype.getJSDocsWorker = function (node, cache) {
        var parent = node.parent;
        var isInitializerOfVariableDeclarationInStatement = this.isVariableLike(parent) &&
            parent.initializer === node &&
            tsMorph.ts.isVariableStatement(parent.parent.parent);
        var isVariableOfVariableDeclarationStatement = this.isVariableLike(node) && tsMorph.ts.isVariableStatement(parent.parent);
        var variableStatementNode = isInitializerOfVariableDeclarationInStatement
            ? parent.parent.parent
            : isVariableOfVariableDeclarationStatement
                ? parent.parent
                : undefined;
        if (variableStatementNode) {
            cache = this.getJSDocsWorker(variableStatementNode, cache);
        }
        // Also recognize when the node is the RHS of an assignment expression
        var isSourceOfAssignmentExpressionStatement = parent &&
            parent.parent &&
            tsMorph.ts.isBinaryExpression(parent) &&
            parent.operatorToken.kind === tsMorph.SyntaxKind.EqualsToken &&
            tsMorph.ts.isExpressionStatement(parent.parent);
        if (isSourceOfAssignmentExpressionStatement) {
            cache = this.getJSDocsWorker(parent.parent, cache);
        }
        var isModuleDeclaration = tsMorph.ts.isModuleDeclaration(node) && parent && tsMorph.ts.isModuleDeclaration(parent);
        var isPropertyAssignmentExpression = parent && tsMorph.ts.isPropertyAssignment(parent);
        if (isModuleDeclaration || isPropertyAssignmentExpression) {
            cache = this.getJSDocsWorker(parent, cache);
        }
        // Pull parameter comments from declaring function as well
        if (tsMorph.ts.isParameter(node)) {
            cache = ___namespace.concat(cache, this.getJSDocParameterTags(node));
        }
        if (this.isVariableLike(node) && node.initializer) {
            cache = ___namespace.concat(cache, node.initializer.jsDoc);
        }
        cache = ___namespace.concat(cache, node.jsDoc);
        return cache;
    };
    JsdocParserUtil.prototype.getJSDocParameterTags = function (param) {
        var func = param.parent;
        var tags = this.getJSDocTags(func, tsMorph.SyntaxKind.JSDocParameterTag);
        if (!param.name) {
            // this is an anonymous jsdoc param from a `function(type1, type2): type3` specification
            var i = func.parameters.indexOf(param);
            var paramTags = ___namespace.filter(tags, function (tag) { return tsMorph.ts.isJSDocParameterTag(tag); });
            if (paramTags && 0 <= i && i < paramTags.length) {
                return [paramTags[i]];
            }
        }
        else if (tsMorph.ts.isIdentifier(param.name)) {
            var name_1 = param.name.text;
            return ___namespace.filter(tags, function (tag) {
                if (tsMorph.ts && tsMorph.ts.isJSDocParameterTag(tag)) {
                    var t = tag;
                    if (typeof t.parameterName !== 'undefined') {
                        return t.parameterName.text === name_1;
                    }
                    else if (typeof t.name !== 'undefined') {
                        if (typeof t.name.escapedText !== 'undefined') {
                            return t.name.escapedText === name_1;
                        }
                    }
                }
            });
        }
        else {
            // TODO: it's a destructured parameter, so it should look up an "object type" series of multiple lines
            // But multi-line object types aren't supported yet either
            return undefined;
        }
    };
    JsdocParserUtil.prototype.parseJSDocNode = function (node) {
        var rawDescription = '';
        if (typeof node.comment === 'string') {
            rawDescription += node.comment;
        }
        else {
            if (node.comment) {
                var len = node.comment.length;
                for (var i = 0; i < len; i++) {
                    var JSDocNode = node.comment[i];
                    switch (JSDocNode.kind) {
                        case tsMorph.SyntaxKind.JSDocComment:
                            rawDescription += JSDocNode.comment;
                            break;
                        case tsMorph.SyntaxKind.JSDocText:
                            rawDescription += JSDocNode.text;
                            break;
                        case tsMorph.SyntaxKind.JSDocLink:
                            if (JSDocNode.name) {
                                var text = JSDocNode.name.escapedText;
                                if (text === undefined &&
                                    JSDocNode.name.left &&
                                    JSDocNode.name.right) {
                                    text =
                                        JSDocNode.name.left.escapedText +
                                            '.' +
                                            JSDocNode.name.right.escapedText;
                                }
                                rawDescription += JSDocNode.text + '{@link ' + text + '}';
                            }
                            break;
                    }
                }
            }
        }
        return rawDescription;
    };
    return JsdocParserUtil;
}());

var marked = require('marked').marked;
marked.use({
    mangle: false,
    headerIds: false
});
var markedAcl = marked;

var getCurrentDirectory = tsMorph.ts.sys.getCurrentDirectory;
var useCaseSensitiveFileNames = tsMorph.ts.sys.useCaseSensitiveFileNames;
var newLine = tsMorph.ts.sys.newLine;
function getNewLine() {
    return newLine;
}
function cleanNameWithoutSpaceAndToLowerCase(name) {
    return name.toLowerCase().replace(/ /g, '-');
}
function getCanonicalFileName(fileName) {
    return useCaseSensitiveFileNames ? fileName : fileName.toLowerCase();
}
var formatDiagnosticsHost = {
    getCurrentDirectory: getCurrentDirectory,
    getCanonicalFileName: getCanonicalFileName,
    getNewLine: getNewLine
};
function markedtags(tags) {
    var jsdocParserUtil = new JsdocParserUtil();
    var mtags = tags;
    ___namespace.forEach(mtags, function (tag) {
        var rawComment = jsdocParserUtil.parseJSDocNode(tag);
        tag.comment = markedAcl(LinkParser.resolveLinks(rawComment));
    });
    return mtags;
}
function mergeTagsAndArgs(args, jsdoctags) {
    var margs = ___namespace.cloneDeep(args);
    ___namespace.forEach(margs, function (arg) {
        arg.tagName = {
            text: 'param'
        };
        if (jsdoctags) {
            ___namespace.forEach(jsdoctags, function (jsdoctag) {
                if (jsdoctag.name && jsdoctag.name.text === arg.name) {
                    arg.tagName = jsdoctag.tagName;
                    arg.name = jsdoctag.name;
                    arg.comment = jsdoctag.comment;
                    arg.typeExpression = jsdoctag.typeExpression;
                }
            });
        }
    });
    // Add example & returns & private
    if (jsdoctags) {
        ___namespace.forEach(jsdoctags, function (jsdoctag) {
            if (jsdoctag.tagName &&
                (jsdoctag.tagName.text === 'example' || jsdoctag.tagName.text === 'private')) {
                margs.push({
                    tagName: jsdoctag.tagName,
                    comment: jsdoctag.comment
                });
            }
            if (jsdoctag.tagName &&
                (jsdoctag.tagName.text === 'returns' || jsdoctag.tagName.text === 'return')) {
                var ret = {
                    tagName: jsdoctag.tagName,
                    comment: jsdoctag.comment
                };
                if (jsdoctag.typeExpression && jsdoctag.typeExpression.type) {
                    ret.returnType = kindToType(jsdoctag.typeExpression.type.kind);
                }
                margs.push(ret);
            }
        });
    }
    return margs;
}
function readConfig(configFile) {
    var result = tsMorph.ts.readConfigFile(configFile, tsMorph.ts.sys.readFile);
    if (result.error) {
        var message = tsMorph.ts.formatDiagnostics([result.error], formatDiagnosticsHost);
        throw new Error(message);
    }
    return result.config;
}
function stripBom(source) {
    if (source.charCodeAt(0) === 0xfeff) {
        return source.slice(1);
    }
    return source;
}
function hasBom(source) {
    return source.charCodeAt(0) === 0xfeff;
}
function cleanLifecycleHooksFromMethods(methods) {
    var result = [];
    if (typeof methods !== 'undefined') {
        var i = 0;
        var len = methods.length;
        for (i; i < len; i++) {
            if (!(methods[i].name in AngularLifecycleHooks)) {
                result.push(methods[i]);
            }
        }
    }
    return result;
}
function cleanSourcesForWatch(list) {
    return list.filter(function (element) {
        if (fs__namespace.existsSync(process.cwd() + path__namespace.sep + element)) {
            return element;
        }
    });
}
function getNamesCompareFn(name) {
    /**
     * Copyright https://github.com/ng-bootstrap/ng-bootstrap
     */
    name = name || 'name';
    var t = function (a, b) {
        if (a[name]) {
            return a[name].localeCompare(b[name]);
        }
        else {
            return 0;
        }
    };
    return t;
}
function isIgnore(member) {
    var e_1, _a, e_2, _b;
    if (member.jsDoc) {
        try {
            for (var _c = __values(member.jsDoc), _d = _c.next(); !_d.done; _d = _c.next()) {
                var doc = _d.value;
                if (doc.tags) {
                    try {
                        for (var _e = (e_2 = void 0, __values(doc.tags)), _f = _e.next(); !_f.done; _f = _e.next()) {
                            var tag = _f.value;
                            if (tag.tagName.text.indexOf('ignore') > -1) {
                                return true;
                            }
                        }
                    }
                    catch (e_2_1) { e_2 = { error: e_2_1 }; }
                    finally {
                        try {
                            if (_f && !_f.done && (_b = _e.return)) _b.call(_e);
                        }
                        finally { if (e_2) throw e_2.error; }
                    }
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
            }
            finally { if (e_1) throw e_1.error; }
        }
    }
    return false;
}
// https://tc39.github.io/ecma262/#sec-array.prototype.includes
if (!Array.prototype.includes) {
    Object.defineProperty(Array.prototype, 'includes', {
        value: function (searchElement, fromIndex) {
            if (this == null) {
                throw new TypeError('"this" is null or not defined');
            }
            // 1. Let O be ? ToObject(this value).
            var o = Object(this);
            // 2. Let len be ? ToLength(? Get(O, "length")).
            var len = o.length >>> 0;
            // 3. If len is 0, return false.
            if (len === 0) {
                return false;
            }
            // 4. Let n be ? ToInteger(fromIndex).
            //    (If fromIndex is undefined, this step produces the value 0.)
            var n = fromIndex | 0;
            // 5. If n ≥ 0, then
            //  a. Let k be n.
            // 6. Else n < 0,
            //  a. Let k be len + n.
            //  b. If k < 0, let k be 0.
            var k = Math.max(n >= 0 ? n : len - Math.abs(n), 0);
            function sameValueZero(x, y) {
                return (x === y ||
                    (typeof x === 'number' && typeof y === 'number' && isNaN(x) && isNaN(y)));
            }
            // 7. Repeat, while k < len
            while (k < len) {
                // a. Let elementK be the result of ? Get(O, ! ToString(k)).
                // b. If SameValueZero(searchElement, elementK) is true, return true.
                if (sameValueZero(o[k], searchElement)) {
                    return true;
                }
                // c. Increase k by 1.
                k++;
            }
            // 8. Return false
            return false;
        }
    });
}
function findMainSourceFolder(files) {
    var mainFolder = '';
    var mainFolderCount = 0;
    var rawFolders = files.map(function (filepath) {
        var shortPath = filepath.replace(process.cwd() + path__namespace.sep, '');
        return path__namespace.dirname(shortPath);
    });
    var folders = {};
    rawFolders = ___namespace.uniq(rawFolders);
    for (var i = 0; i < rawFolders.length; i++) {
        var sep = rawFolders[i].split(path__namespace.sep);
        sep.forEach(function (folder) {
            if (folders[folder]) {
                folders[folder] += 1;
            }
            else {
                folders[folder] = 1;
            }
        });
    }
    for (var f in folders) {
        if (folders[f] > mainFolderCount) {
            mainFolderCount = folders[f];
            mainFolder = f;
        }
    }
    return mainFolder;
}
// Create a compilerHost object to allow the compiler to read and write files
function compilerHost(transpileOptions) {
    var inputFileName = transpileOptions.fileName || (transpileOptions.jsx ? 'module.tsx' : 'module.ts');
    var toReturn = {
        getSourceFile: function (fileName) {
            if (fileName.lastIndexOf('.ts') !== -1 || fileName.lastIndexOf('.js') !== -1) {
                if (fileName === 'lib.d.ts') {
                    return undefined;
                }
                if (fileName.substr(-5) === '.d.ts') {
                    return undefined;
                }
                if (path__namespace.isAbsolute(fileName) === false) {
                    fileName = path__namespace.join(transpileOptions.tsconfigDirectory, fileName);
                }
                if (!fs__namespace.existsSync(fileName)) {
                    return undefined;
                }
                var libSource = '';
                try {
                    libSource = fs__namespace.readFileSync(fileName).toString();
                    if (hasBom(libSource)) {
                        libSource = stripBom(libSource);
                    }
                }
                catch (e) {
                    logger.debug(e, fileName);
                }
                return tsMorph.ts.createSourceFile(fileName, libSource, transpileOptions.target, false);
            }
            return undefined;
        },
        writeFile: function (name, text) { },
        getDefaultLibFileName: function () { return 'lib.d.ts'; },
        useCaseSensitiveFileNames: function () { return false; },
        getCanonicalFileName: function (fileName) { return fileName; },
        getCurrentDirectory: function () { return ''; },
        getNewLine: function () { return '\n'; },
        fileExists: function (fileName) { return fileName === inputFileName; },
        readFile: function () { return ''; },
        directoryExists: function () { return true; },
        getDirectories: function () { return []; }
    };
    return toReturn;
}
function detectIndent(str, count) {
    var stripIndent = function (stripedString) {
        var match = stripedString.match(/^[ \t]*(?=\S)/gm);
        if (!match) {
            return stripedString;
        }
        // TODO: use spread operator when targeting Node.js 6
        var indent = Math.min.apply(Math, match.map(function (x) { return x.length; })); // eslint-disable-line
        var re = new RegExp("^[ \\t]{".concat(indent, "}"), 'gm');
        return indent > 0 ? stripedString.replace(re, '') : stripedString;
    };
    var repeating = function (n, repeatString) {
        repeatString = repeatString === undefined ? ' ' : repeatString;
        if (typeof repeatString !== 'string') {
            throw new TypeError("Expected `input` to be a `string`, got `".concat(typeof repeatString, "`"));
        }
        if (n < 0) {
            throw new TypeError("Expected `count` to be a positive finite number, got `".concat(n, "`"));
        }
        var ret = '';
        do {
            if (n & 1) {
                ret += repeatString;
            }
            repeatString += repeatString;
        } while ((n >>= 1));
        return ret;
    };
    var indentString = function (indentedString, indentCount) {
        var indent = ' ';
        indentCount = indentCount === undefined ? 1 : indentCount;
        if (typeof indentedString !== 'string') {
            throw new TypeError("Expected `input` to be a `string`, got `".concat(typeof indentedString, "`"));
        }
        if (typeof indentCount !== 'number') {
            throw new TypeError("Expected `count` to be a `number`, got `".concat(typeof indentCount, "`"));
        }
        if (typeof indent !== 'string') {
            throw new TypeError("Expected `indent` to be a `string`, got `".concat(typeof indent, "`"));
        }
        if (indentCount === 0) {
            return indentedString;
        }
        indent = indentCount > 1 ? repeating(indentCount, indent) : indent;
        return indentedString.replace(/^(?!\s*$)/gm, indent);
    };
    return indentString(stripIndent(str), 0);
}
var INCLUDE_PATTERNS = ['**/*.ts', '**/*.tsx'];
var EXCLUDE_PATTERNS = ['**/.git', '**/node_modules', '**/*.d.ts', '**/*.spec.ts'];

var traverse$3 = require('neotraverse/legacy');
var DependenciesEngine = /** @class */ (function () {
    function DependenciesEngine() {
        this.miscellaneous = {
            variables: [],
            functions: [],
            typealiases: [],
            enumerations: [],
            groupedVariables: [],
            groupedFunctions: [],
            groupedEnumerations: [],
            groupedTypeAliases: []
        };
    }
    DependenciesEngine.getInstance = function () {
        if (!DependenciesEngine.instance) {
            DependenciesEngine.instance = new DependenciesEngine();
        }
        return DependenciesEngine.instance;
    };
    DependenciesEngine.prototype.updateModulesDeclarationsExportsTypes = function () {
        var _this = this;
        var mergeTypes = function (entry) {
            var directive = _this.findInCompodocDependencies(entry.name, _this.directives, entry.file);
            if (typeof directive.data !== 'undefined') {
                entry.type = 'directive';
                entry.id = directive.data.id;
            }
            var component = _this.findInCompodocDependencies(entry.name, _this.components, entry.file);
            if (typeof component.data !== 'undefined') {
                entry.type = 'component';
                entry.id = component.data.id;
            }
            var pipe = _this.findInCompodocDependencies(entry.name, _this.pipes, entry.file);
            if (typeof pipe.data !== 'undefined') {
                entry.type = 'pipe';
                entry.id = pipe.data.id;
            }
        };
        this.modules.forEach(function (module) {
            module.declarations.forEach(function (declaration) {
                mergeTypes(declaration);
            });
            module.exports.forEach(function (expt) {
                mergeTypes(expt);
            });
            module.entryComponents.forEach(function (ent) {
                mergeTypes(ent);
            });
        });
    };
    DependenciesEngine.prototype.init = function (data) {
        traverse$3(data).forEach(function (node) {
            if (node) {
                if (node.parent) {
                    delete node.parent;
                }
                if (node.initializer) {
                    delete node.initializer;
                }
            }
        });
        this.rawData = data;
        this.modules = ___namespace.sortBy(this.rawData.modules, [function (el) { return el.name.toLowerCase(); }]);
        this.rawModulesForOverview = ___namespace.sortBy(data.modulesForGraph, [function (el) { return el.name.toLowerCase(); }]);
        this.rawModules = ___namespace.sortBy(data.modulesForGraph, [function (el) { return el.name.toLowerCase(); }]);
        this.components = ___namespace.sortBy(this.rawData.components, [function (el) { return el.name.toLowerCase(); }]);
        this.controllers = ___namespace.sortBy(this.rawData.controllers, [function (el) { return el.name.toLowerCase(); }]);
        this.entities = ___namespace.sortBy(this.rawData.entities, [function (el) { return el.name.toLowerCase(); }]);
        this.directives = ___namespace.sortBy(this.rawData.directives, [function (el) { return el.name.toLowerCase(); }]);
        this.injectables = ___namespace.sortBy(this.rawData.injectables, [function (el) { return el.name.toLowerCase(); }]);
        this.interceptors = ___namespace.sortBy(this.rawData.interceptors, [function (el) { return el.name.toLowerCase(); }]);
        this.guards = ___namespace.sortBy(this.rawData.guards, [function (el) { return el.name.toLowerCase(); }]);
        this.interfaces = ___namespace.sortBy(this.rawData.interfaces, [function (el) { return el.name.toLowerCase(); }]);
        this.pipes = ___namespace.sortBy(this.rawData.pipes, [function (el) { return el.name.toLowerCase(); }]);
        this.classes = ___namespace.sortBy(this.rawData.classes, [function (el) { return el.name.toLowerCase(); }]);
        this.miscellaneous = this.rawData.miscellaneous;
        this.prepareMiscellaneous();
        this.updateModulesDeclarationsExportsTypes();
        this.routes = this.rawData.routesTree;
        this.manageDuplicatesName();
        this.cleanRawModulesNames();
    };
    DependenciesEngine.prototype.cleanRawModulesNames = function () {
        this.rawModulesForOverview = this.rawModulesForOverview.map(function (module) {
            module.name = module.name.replace('$', '');
            return module;
        });
    };
    DependenciesEngine.prototype.findInCompodocDependencies = function (name, data, file) {
        var _result = {
            source: 'internal',
            data: undefined,
            score: 0
        };
        var nameFoundCounter = 0;
        if (data && data.length > 0) {
            for (var i = 0; i < data.length; i++) {
                if (typeof name !== 'undefined') {
                    if (typeof file !== 'undefined') {
                        if (name === data[i].name &&
                            file.replace(/\\/g, '/').indexOf(data[i].file) !== -1) {
                            nameFoundCounter += 1;
                            _result.data = data[i];
                            _result.score = 2;
                        }
                        else if (name.indexOf(data[i].name) !== -1 &&
                            file.replace(/\\/g, '/').indexOf(data[i].file) !== -1) {
                            nameFoundCounter += 1;
                            _result.data = data[i];
                            _result.score = 1;
                        }
                    }
                    else {
                        if (name === data[i].name) {
                            nameFoundCounter += 1;
                            _result.data = data[i];
                            _result.score = 2;
                        }
                        else if (name.indexOf(data[i].name) !== -1) {
                            nameFoundCounter += 1;
                            _result.data = data[i];
                            _result.score = 1;
                        }
                    }
                }
            }
            // Prevent wrong matching like MultiSelectOptionDirective with SelectOptionDirective, or QueryParamGroupService with QueryParamGroup
            if (nameFoundCounter > 1) {
                var found = false;
                for (var i = 0; i < data.length; i++) {
                    if (typeof name !== 'undefined') {
                        if (typeof file !== 'undefined') {
                            if (name === data[i].name) {
                                found = true;
                                _result.data = data[i];
                                _result.score = 2;
                            }
                        }
                        else {
                            if (name === data[i].name) {
                                found = true;
                                _result.data = data[i];
                                _result.score = 2;
                            }
                        }
                    }
                }
                if (!found) {
                    _result = {
                        source: 'internal',
                        data: undefined,
                        score: 0
                    };
                }
            }
        }
        return _result;
    };
    DependenciesEngine.prototype.manageDuplicatesName = function () {
        var processDuplicates = function (element, index, array) {
            var elementsWithSameName = ___namespace.filter(array, { name: element.name });
            if (elementsWithSameName.length > 1) {
                // First element is the reference for duplicates
                for (var i = 1; i < elementsWithSameName.length; i++) {
                    var elementToEdit = elementsWithSameName[i];
                    if (typeof elementToEdit.isDuplicate === 'undefined') {
                        elementToEdit.isDuplicate = true;
                        elementToEdit.duplicateId = i;
                        elementToEdit.duplicateName =
                            elementToEdit.name + '-' + elementToEdit.duplicateId;
                        elementToEdit.id = elementToEdit.id + '-' + elementToEdit.duplicateId;
                    }
                }
            }
            return element;
        };
        this.classes = this.classes.map(processDuplicates);
        this.interfaces = this.interfaces.map(processDuplicates);
        this.injectables = this.injectables.map(processDuplicates);
        this.pipes = this.pipes.map(processDuplicates);
        this.interceptors = this.interceptors.map(processDuplicates);
        this.guards = this.guards.map(processDuplicates);
        this.modules = this.modules.map(processDuplicates);
        this.components = this.components.map(processDuplicates);
        this.controllers = this.controllers.map(processDuplicates);
        this.entities = this.entities.map(processDuplicates);
        this.directives = this.directives.map(processDuplicates);
    };
    DependenciesEngine.prototype.find = function (name) {
        var e_1, _a;
        var _this = this;
        var searchFunctions = [
            function () { return _this.findInCompodocDependencies(name, _this.modules); },
            function () { return _this.findInCompodocDependencies(name, _this.injectables); },
            function () { return _this.findInCompodocDependencies(name, _this.interceptors); },
            function () { return _this.findInCompodocDependencies(name, _this.guards); },
            function () { return _this.findInCompodocDependencies(name, _this.interfaces); },
            function () { return _this.findInCompodocDependencies(name, _this.classes); },
            function () { return _this.findInCompodocDependencies(name, _this.components); },
            function () { return _this.findInCompodocDependencies(name, _this.controllers); },
            function () { return _this.findInCompodocDependencies(name, _this.entities); },
            function () { return _this.findInCompodocDependencies(name, _this.directives); },
            function () { return _this.findInCompodocDependencies(name, _this.miscellaneous.variables); },
            function () { return _this.findInCompodocDependencies(name, _this.miscellaneous.functions); },
            function () { return _this.findInCompodocDependencies(name, _this.miscellaneous.typealiases); },
            function () { return _this.findInCompodocDependencies(name, _this.miscellaneous.enumerations); },
            function () { return AngularApiUtil$1.findApi(name); }
        ];
        var bestScore = 0;
        var bestResult = undefined;
        try {
            for (var searchFunctions_1 = __values(searchFunctions), searchFunctions_1_1 = searchFunctions_1.next(); !searchFunctions_1_1.done; searchFunctions_1_1 = searchFunctions_1.next()) {
                var searchFunction = searchFunctions_1_1.value;
                var result = searchFunction();
                if (result.data && result.score > bestScore) {
                    bestScore = result.score;
                    bestResult = result;
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (searchFunctions_1_1 && !searchFunctions_1_1.done && (_a = searchFunctions_1.return)) _a.call(searchFunctions_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return bestResult;
    };
    DependenciesEngine.prototype.update = function (updatedData) {
        var _this = this;
        if (updatedData.modules.length > 0) {
            ___namespace.forEach(updatedData.modules, function (module) {
                var _index = ___namespace.findIndex(_this.modules, { name: module.name });
                _this.modules[_index] = module;
            });
        }
        if (updatedData.components.length > 0) {
            ___namespace.forEach(updatedData.components, function (component) {
                var _index = ___namespace.findIndex(_this.components, { name: component.name });
                _this.components[_index] = component;
            });
        }
        if (updatedData.controllers.length > 0) {
            ___namespace.forEach(updatedData.controllers, function (controller) {
                var _index = ___namespace.findIndex(_this.controllers, { name: controller.name });
                _this.controllers[_index] = controller;
            });
        }
        if (updatedData.entities.length > 0) {
            ___namespace.forEach(updatedData.entities, function (entity) {
                var _index = ___namespace.findIndex(_this.entities, { name: entity.name });
                _this.entities[_index] = entity;
            });
        }
        if (updatedData.directives.length > 0) {
            ___namespace.forEach(updatedData.directives, function (directive) {
                var _index = ___namespace.findIndex(_this.directives, { name: directive.name });
                _this.directives[_index] = directive;
            });
        }
        if (updatedData.injectables.length > 0) {
            ___namespace.forEach(updatedData.injectables, function (injectable) {
                var _index = ___namespace.findIndex(_this.injectables, { name: injectable.name });
                _this.injectables[_index] = injectable;
            });
        }
        if (updatedData.interceptors.length > 0) {
            ___namespace.forEach(updatedData.interceptors, function (interceptor) {
                var _index = ___namespace.findIndex(_this.interceptors, { name: interceptor.name });
                _this.interceptors[_index] = interceptor;
            });
        }
        if (updatedData.guards.length > 0) {
            ___namespace.forEach(updatedData.guards, function (guard) {
                var _index = ___namespace.findIndex(_this.guards, { name: guard.name });
                _this.guards[_index] = guard;
            });
        }
        if (updatedData.interfaces.length > 0) {
            ___namespace.forEach(updatedData.interfaces, function (int) {
                var _index = ___namespace.findIndex(_this.interfaces, { name: int.name });
                _this.interfaces[_index] = int;
            });
        }
        if (updatedData.pipes.length > 0) {
            ___namespace.forEach(updatedData.pipes, function (pipe) {
                var _index = ___namespace.findIndex(_this.pipes, { name: pipe.name });
                _this.pipes[_index] = pipe;
            });
        }
        if (updatedData.classes.length > 0) {
            ___namespace.forEach(updatedData.classes, function (classe) {
                var _index = ___namespace.findIndex(_this.classes, { name: classe.name });
                _this.classes[_index] = classe;
            });
        }
        /**
         * Miscellaneous update
         */
        if (updatedData.miscellaneous.variables.length > 0) {
            ___namespace.forEach(updatedData.miscellaneous.variables, function (variable) {
                var _index = ___namespace.findIndex(_this.miscellaneous.variables, {
                    name: variable.name,
                    file: variable.file
                });
                _this.miscellaneous.variables[_index] = variable;
            });
        }
        if (updatedData.miscellaneous.functions.length > 0) {
            ___namespace.forEach(updatedData.miscellaneous.functions, function (func) {
                var _index = ___namespace.findIndex(_this.miscellaneous.functions, {
                    name: func.name,
                    file: func.file
                });
                _this.miscellaneous.functions[_index] = func;
            });
        }
        if (updatedData.miscellaneous.typealiases.length > 0) {
            ___namespace.forEach(updatedData.miscellaneous.typealiases, function (typealias) {
                var _index = ___namespace.findIndex(_this.miscellaneous.typealiases, {
                    name: typealias.name,
                    file: typealias.file
                });
                _this.miscellaneous.typealiases[_index] = typealias;
            });
        }
        if (updatedData.miscellaneous.enumerations.length > 0) {
            ___namespace.forEach(updatedData.miscellaneous.enumerations, function (enumeration) {
                var _index = ___namespace.findIndex(_this.miscellaneous.enumerations, {
                    name: enumeration.name,
                    file: enumeration.file
                });
                _this.miscellaneous.enumerations[_index] = enumeration;
            });
        }
        this.prepareMiscellaneous();
    };
    DependenciesEngine.prototype.findInCompodoc = function (name) {
        var mergedData = ___namespace.concat([], this.modules, this.components, this.controllers, this.entities, this.directives, this.injectables, this.interceptors, this.guards, this.interfaces, this.pipes, this.classes, this.miscellaneous.enumerations, this.miscellaneous.typealiases, this.miscellaneous.variables, this.miscellaneous.functions);
        var result = ___namespace.find(mergedData, { name: name });
        return result || false;
    };
    DependenciesEngine.prototype.prepareMiscellaneous = function () {
        this.miscellaneous.variables.sort(getNamesCompareFn());
        this.miscellaneous.functions.sort(getNamesCompareFn());
        this.miscellaneous.enumerations.sort(getNamesCompareFn());
        this.miscellaneous.typealiases.sort(getNamesCompareFn());
        // group each subgoup by file
        this.miscellaneous.groupedVariables = ___namespace.groupBy(this.miscellaneous.variables, 'file');
        this.miscellaneous.groupedFunctions = ___namespace.groupBy(this.miscellaneous.functions, 'file');
        this.miscellaneous.groupedEnumerations = ___namespace.groupBy(this.miscellaneous.enumerations, 'file');
        this.miscellaneous.groupedTypeAliases = ___namespace.groupBy(this.miscellaneous.typealiases, 'file');
    };
    DependenciesEngine.prototype.getModule = function (name) {
        return ___namespace.find(this.modules, ['name', name]);
    };
    DependenciesEngine.prototype.getRawModule = function (name) {
        return ___namespace.find(this.rawModules, ['name', name]);
    };
    DependenciesEngine.prototype.getModules = function () {
        return this.modules;
    };
    DependenciesEngine.prototype.getComponents = function () {
        return this.components;
    };
    DependenciesEngine.prototype.getControllers = function () {
        return this.controllers;
    };
    DependenciesEngine.prototype.getEntities = function () {
        return this.entities;
    };
    DependenciesEngine.prototype.getDirectives = function () {
        return this.directives;
    };
    DependenciesEngine.prototype.getInjectables = function () {
        return this.injectables;
    };
    DependenciesEngine.prototype.getInterceptors = function () {
        return this.interceptors;
    };
    DependenciesEngine.prototype.getGuards = function () {
        return this.guards;
    };
    DependenciesEngine.prototype.getInterfaces = function () {
        return this.interfaces;
    };
    DependenciesEngine.prototype.getRoutes = function () {
        return this.routes;
    };
    DependenciesEngine.prototype.getPipes = function () {
        return this.pipes;
    };
    DependenciesEngine.prototype.getClasses = function () {
        return this.classes;
    };
    DependenciesEngine.prototype.getMiscellaneous = function () {
        return this.miscellaneous;
    };
    return DependenciesEngine;
}());
var DependenciesEngine$1 = DependenciesEngine.getInstance();

var FileEngine = /** @class */ (function () {
    function FileEngine() {
    }
    FileEngine.getInstance = function () {
        if (!FileEngine.instance) {
            FileEngine.instance = new FileEngine();
        }
        return FileEngine.instance;
    };
    FileEngine.prototype.get = function (filepath) {
        return new Promise(function (resolve, reject) {
            fs__namespace.readFile(path__namespace.resolve(filepath), 'utf8', function (err, data) {
                if (err) {
                    reject('Error during ' + filepath + ' read');
                }
                else {
                    resolve(data);
                }
            });
        });
    };
    FileEngine.prototype.write = function (filepath, contents) {
        return new Promise(function (resolve, reject) {
            fs__namespace.outputFile(path__namespace.resolve(filepath), contents, function (err) {
                if (err) {
                    reject(err);
                }
                else {
                    resolve();
                }
            });
        });
    };
    FileEngine.prototype.writeSync = function (filepath, contents) {
        fs__namespace.outputFileSync(filepath, contents);
    };
    FileEngine.prototype.getSync = function (filepath) {
        return fs__namespace.readFileSync(path__namespace.resolve(filepath), 'utf8');
    };
    /**
     * @param file The file to check
     */
    FileEngine.prototype.existsSync = function (file) {
        return fs__namespace.existsSync(file);
    };
    return FileEngine;
}());
var FileEngine$1 = FileEngine.getInstance();

var traverse$2 = require('neotraverse/legacy');
var ExportJsonEngine = /** @class */ (function () {
    function ExportJsonEngine() {
    }
    ExportJsonEngine.getInstance = function () {
        if (!ExportJsonEngine.instance) {
            ExportJsonEngine.instance = new ExportJsonEngine();
        }
        return ExportJsonEngine.instance;
    };
    ExportJsonEngine.prototype.export = function (outputFolder, data) {
        var exportData = {};
        traverse$2(data).forEach(function (node) {
            if (node) {
                if (node.parent) {
                    delete node.parent;
                }
                if (node.initializer) {
                    delete node.initializer;
                }
                if (Configuration$1.mainData.disableSourceCode) {
                    delete node.sourceCode;
                    delete node.templateData;
                    delete node.styleUrlsData;
                    delete node.stylesData;
                }
            }
        });
        exportData.pipes = data.pipes;
        exportData.interfaces = data.interfaces;
        exportData.injectables = data.injectables;
        exportData.guards = data.guards;
        exportData.interceptors = data.interceptors;
        exportData.classes = data.classes;
        exportData.directives = data.directives;
        exportData.components = data.components;
        exportData.modules = this.processModules();
        exportData.miscellaneous = data.miscellaneous;
        if (!Configuration$1.mainData.disableRoutesGraph) {
            exportData.routes = data.routes;
        }
        if (!Configuration$1.mainData.disableCoverage) {
            exportData.coverage = data.coverageData;
        }
        return FileEngine$1.write(outputFolder + path__namespace.sep + '/documentation.json', JSON.stringify(exportData, undefined, 4)).catch(function (err) {
            logger.error('Error during export file generation ', err);
            return Promise.reject(err);
        });
    };
    ExportJsonEngine.prototype.processModules = function () {
        var modules = DependenciesEngine$1.getModules();
        var _resultedModules = [];
        for (var moduleNr = 0; moduleNr < modules.length; moduleNr++) {
            var module_1 = modules[moduleNr];
            var moduleElement = {
                name: module_1.name,
                id: module_1.id,
                description: module_1.description,
                rawDescription: module_1.rawDescription,
                deprecationMessage: module_1.deprecationMessage,
                deprecated: module_1.deprecated,
                file: module_1.file,
                methods: module_1.methods,
                sourceCode: module_1.sourceCode,
                children: [
                    {
                        type: 'providers',
                        elements: []
                    },
                    {
                        type: 'declarations',
                        elements: []
                    },
                    {
                        type: 'imports',
                        elements: []
                    },
                    {
                        type: 'exports',
                        elements: []
                    },
                    {
                        type: 'bootstrap',
                        elements: []
                    },
                    {
                        type: 'classes',
                        elements: []
                    }
                ]
            };
            for (var k = 0; k < module_1.providers.length; k++) {
                var providerElement = {
                    name: module_1.providers[k].name
                };
                moduleElement.children[0].elements.push(providerElement);
            }
            for (var k = 0; k < module_1.declarations.length; k++) {
                var declarationElement = {
                    name: module_1.declarations[k].name
                };
                moduleElement.children[1].elements.push(declarationElement);
            }
            for (var k = 0; k < module_1.imports.length; k++) {
                var importElement = {
                    name: module_1.imports[k].name
                };
                moduleElement.children[2].elements.push(importElement);
            }
            for (var k = 0; k < module_1.exports.length; k++) {
                var exportElement = {
                    name: module_1.exports[k].name
                };
                moduleElement.children[3].elements.push(exportElement);
            }
            for (var k = 0; k < module_1.bootstrap.length; k++) {
                var bootstrapElement = {
                    name: module_1.bootstrap[k].name
                };
                moduleElement.children[4].elements.push(bootstrapElement);
            }
            _resultedModules.push(moduleElement);
        }
        return _resultedModules;
    };
    return ExportJsonEngine;
}());
var ExportJsonEngine$1 = ExportJsonEngine.getInstance();

var ExportEngine = /** @class */ (function () {
    function ExportEngine() {
    }
    ExportEngine.getInstance = function () {
        if (!ExportEngine.instance) {
            ExportEngine.instance = new ExportEngine();
        }
        return ExportEngine.instance;
    };
    ExportEngine.prototype.export = function (outputFolder, data) {
        switch (Configuration$1.mainData.exportFormat) {
            case 'json':
                return ExportJsonEngine$1.export(outputFolder, data);
            /*case 'pdf':
                return ExportPdfEngine.export(outputFolder);*/
        }
    };
    return ExportEngine;
}());
var ExportEngine$1 = ExportEngine.getInstance();

var Handlebars$9 = require('handlebars');
var BreakCommaHelper = /** @class */ (function () {
    function BreakCommaHelper(bars) {
        this.bars = bars;
    }
    BreakCommaHelper.prototype.helperFunc = function (context, text) {
        text = this.bars.Utils.escapeExpression(text);
        text = text.replace(/,/g, ',<br>');
        return new Handlebars$9.SafeString(text);
    };
    return BreakCommaHelper;
}());

var Handlebars$8 = require('handlebars');
var BreakLinesHelper = /** @class */ (function () {
    function BreakLinesHelper(bars) {
        this.bars = bars;
    }
    BreakLinesHelper.prototype.helperFunc = function (context, text) {
        text = this.bars.Utils.escapeExpression(text);
        text = text.replace(/(\r\n|\n|\r)/gm, '<br>');
        text = text.replace(/ /gm, '&nbsp;');
        text = text.replace(/	/gm, '&nbsp;&nbsp;&nbsp;&nbsp;');
        return new Handlebars$8.SafeString(text);
    };
    return BreakLinesHelper;
}());

require('handlebars');
var CapitalizeHelper = /** @class */ (function () {
    function CapitalizeHelper() {
    }
    CapitalizeHelper.prototype.helperFunc = function (context, text) {
        return text.charAt(0).toUpperCase() + text.slice(1);
    };
    return CapitalizeHelper;
}());

var Handlebars$7 = require('handlebars');
var CleanParagraphHelper = /** @class */ (function () {
    function CleanParagraphHelper() {
    }
    CleanParagraphHelper.prototype.helperFunc = function (context, text) {
        text = text.replace(/<p>/gm, '');
        text = text.replace(/<\/p>/gm, '');
        return new Handlebars$7.SafeString(text);
    };
    return CleanParagraphHelper;
}());

var CompareHelper = /** @class */ (function () {
    function CompareHelper() {
    }
    CompareHelper.prototype.helperFunc = function (context, a, operator, b, options) {
        if (arguments.length < 4) {
            throw new Error('handlebars Helper {{compare}} expects 4 arguments');
        }
        var result;
        switch (operator) {
            case 'indexof':
                result = b.indexOf(a) !== -1;
                break;
            case '===':
                result = a === b;
                break;
            case '!==':
                result = a !== b;
                break;
            case '>':
                result = a > b;
                break;
            default: {
                throw new Error('helper {{compare}}: invalid operator: `' + operator + '`');
            }
        }
        if (result === false) {
            return options.inverse(context);
        }
        return options.fn(context);
    };
    return CompareHelper;
}());

var DebugHelper = /** @class */ (function () {
    function DebugHelper() {
    }
    DebugHelper.prototype.helperFunc = function (context, optionalValue) {
        console.log('Current Context');
        console.log('====================');
        console.log(context);
        if (optionalValue) {
            console.log('OptionalValue');
            console.log('====================');
            console.log(optionalValue);
        }
    };
    return DebugHelper;
}());

var ElementAloneHelper = /** @class */ (function () {
    function ElementAloneHelper() {
    }
    ElementAloneHelper.prototype.helperFunc = function (context, elements, elementType, options) {
        var alones = [];
        var modules = DependenciesEngine$1.modules;
        elements.forEach(function (element) {
            var foundInOneModule = false;
            modules.forEach(function (module) {
                module.declarations.forEach(function (declaration) {
                    if (declaration.id === element.id) {
                        foundInOneModule = true;
                    }
                    if (declaration.file === element.file) {
                        foundInOneModule = true;
                    }
                });
                module.bootstrap.forEach(function (boostrapedElement) {
                    if (boostrapedElement.id === element.id) {
                        foundInOneModule = true;
                    }
                    if (boostrapedElement.file === element.file) {
                        foundInOneModule = true;
                    }
                });
                module.controllers.forEach(function (controller) {
                    if (controller.id === element.id) {
                        foundInOneModule = true;
                    }
                    if (controller.file === element.file) {
                        foundInOneModule = true;
                    }
                });
                module.providers.forEach(function (provider) {
                    if (provider.id === element.id) {
                        foundInOneModule = true;
                    }
                    if (provider.file === element.file) {
                        foundInOneModule = true;
                    }
                });
            });
            if (!foundInOneModule) {
                alones.push(element);
            }
        });
        if (alones.length > 0) {
            switch (elementType) {
                case 'component':
                    context.components = alones;
                    break;
                case 'directive':
                    context.directives = alones;
                    break;
                case 'controller':
                    context.controllers = alones;
                    break;
                case 'injectable':
                    context.injectables = alones;
                    break;
                case 'pipe':
                    context.pipes = alones;
                    break;
            }
            return options.fn(context);
        }
    };
    return ElementAloneHelper;
}());

var EscapeSimpleQuoteHelper = /** @class */ (function () {
    function EscapeSimpleQuoteHelper() {
    }
    EscapeSimpleQuoteHelper.prototype.helperFunc = function (context, text) {
        if (!text) {
            return;
        }
        text = text.replace(/'/g, "\\'");
        text = text.replace(/(\r\n|\n|\r)/gm, '');
        return text;
    };
    return EscapeSimpleQuoteHelper;
}());

var FilterAngular2ModulesHelper = /** @class */ (function () {
    function FilterAngular2ModulesHelper() {
    }
    FilterAngular2ModulesHelper.prototype.helperFunc = function (context, text, options) {
        var NG2_MODULES = [
            'BrowserModule',
            'FormsModule',
            'HttpModule',
            'RouterModule'
        ];
        var len = NG2_MODULES.length;
        var i = 0;
        var result = false;
        for (i; i < len; i++) {
            if (text.indexOf(NG2_MODULES[i]) > -1) {
                result = true;
            }
        }
        if (result) {
            return options.fn(context);
        }
        else {
            return options.inverse(context);
        }
    };
    return FilterAngular2ModulesHelper;
}());

var AngularVersionUtil = /** @class */ (function () {
    function AngularVersionUtil() {
    }
    AngularVersionUtil.getInstance = function () {
        if (!AngularVersionUtil.instance) {
            AngularVersionUtil.instance = new AngularVersionUtil();
        }
        return AngularVersionUtil.instance;
    };
    AngularVersionUtil.prototype.cleanVersion = function (version) {
        return version
            .replace('~', '')
            .replace('^', '')
            .replace('=', '')
            .replace('<', '')
            .replace('>', '');
    };
    AngularVersionUtil.prototype.getAngularVersionOfProject = function (packageData) {
        var _result = '';
        if (packageData.dependencies) {
            var angularCore = packageData.dependencies[AngularVersionUtil.CorePackage];
            if (angularCore) {
                _result = this.cleanVersion(angularCore);
            }
        }
        return _result;
    };
    AngularVersionUtil.prototype.isAngularVersionArchived = function (version) {
        var result;
        try {
            result = semver__namespace.compare(version, '2.4.10') <= 0;
        }
        catch (e) { }
        return result;
    };
    AngularVersionUtil.prototype.prefixOfficialDoc = function (version) {
        return this.isAngularVersionArchived(version) ? 'v2.' : '';
    };
    AngularVersionUtil.prototype.getApiLink = function (api, angularVersion) {
        var angularDocPrefix = this.prefixOfficialDoc(angularVersion);
        return "https://".concat(angularDocPrefix, "angular.io/").concat(api.path);
    };
    AngularVersionUtil.CorePackage = '@angular/core';
    return AngularVersionUtil;
}());
var AngularVersionUtil$1 = AngularVersionUtil.getInstance();

var BasicTypes;
(function (BasicTypes) {
    BasicTypes[BasicTypes["number"] = 0] = "number";
    BasicTypes[BasicTypes["boolean"] = 1] = "boolean";
    BasicTypes[BasicTypes["string"] = 2] = "string";
    BasicTypes[BasicTypes["object"] = 3] = "object";
    BasicTypes[BasicTypes["date"] = 4] = "date";
    BasicTypes[BasicTypes["function"] = 5] = "function";
})(BasicTypes || (BasicTypes = {}));
var BasicTypeScriptTypes;
(function (BasicTypeScriptTypes) {
    BasicTypeScriptTypes[BasicTypeScriptTypes["any"] = 0] = "any";
    BasicTypeScriptTypes[BasicTypeScriptTypes["void"] = 1] = "void";
})(BasicTypeScriptTypes || (BasicTypeScriptTypes = {}));
var BasicTypeUtil = /** @class */ (function () {
    function BasicTypeUtil() {
    }
    BasicTypeUtil.getInstance = function () {
        if (!BasicTypeUtil.instance) {
            BasicTypeUtil.instance = new BasicTypeUtil();
        }
        return BasicTypeUtil.instance;
    };
    /**
     * Checks if a given types is a basic javascript type
     * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects
     * @param type The type to check
     */
    BasicTypeUtil.prototype.isJavascriptType = function (type) {
        if (typeof type !== 'undefined' && type.toLowerCase) {
            return type.toLowerCase() in BasicTypes;
        }
        else {
            return false;
        }
    };
    /**
     * Checks if a given type is a typescript type (That is not a javascript type)
     * https://www.typescriptlang.org/docs/handbook/basic-types.html
     * @param type The type to check
     */
    BasicTypeUtil.prototype.isTypeScriptType = function (type) {
        if (typeof type !== 'undefined' && type.toLowerCase) {
            return type.toLowerCase() in BasicTypeScriptTypes;
        }
        else {
            return false;
        }
    };
    /**
     * Check if the type is a typescript or javascript type
     * @param type The type to check
     */
    BasicTypeUtil.prototype.isKnownType = function (type) {
        return this.isJavascriptType(type) || this.isTypeScriptType(type);
    };
    /**
     * Returns a official documentation link to either the javascript or typescript type
     * @param type The type to check
     * @returns The documentation link or undefined if type not found
     */
    BasicTypeUtil.prototype.getTypeUrl = function (type) {
        if (this.isJavascriptType(type)) {
            return "https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/".concat(type);
        }
        if (this.isTypeScriptType(type)) {
            return "https://www.typescriptlang.org/docs/handbook/basic-types.html";
        }
        return undefined;
    };
    return BasicTypeUtil;
}());
var BasicTypeUtil$1 = BasicTypeUtil.getInstance();

var Handlebars$6 = require('handlebars');
var FunctionSignatureHelper = /** @class */ (function () {
    function FunctionSignatureHelper() {
    }
    FunctionSignatureHelper.prototype.handleFunction = function (arg) {
        var _this = this;
        if (arg.function.length === 0) {
            return "".concat(arg.name).concat(this.getOptionalString(arg), ": () => void");
        }
        var argums = arg.function.map(function (argu) {
            var _result = DependenciesEngine$1.find(argu.type);
            if (_result) {
                if (_result.source === 'internal') {
                    var path = _result.data.type;
                    if (_result.data.type === 'class') {
                        path = 'classe';
                    }
                    return "".concat(argu.name).concat(_this.getOptionalString(arg), ": <a href=\"../").concat(path, "s/").concat(_result.data.name, ".html\">").concat(argu.type, "</a>");
                }
                else {
                    var path = AngularVersionUtil$1.getApiLink(_result.data, Configuration$1.mainData.angularVersion);
                    return "".concat(argu.name).concat(_this.getOptionalString(arg), ": <a href=\"").concat(path, "\" target=\"_blank\">").concat(argu.type, "</a>");
                }
            }
            else if (BasicTypeUtil$1.isKnownType(argu.type)) {
                var path = BasicTypeUtil$1.getTypeUrl(argu.type);
                return "".concat(argu.name).concat(_this.getOptionalString(arg), ": <a href=\"").concat(path, "\" target=\"_blank\">").concat(argu.type, "</a>");
            }
            else {
                if (argu.name && argu.type) {
                    return "".concat(argu.name).concat(_this.getOptionalString(arg), ": ").concat(argu.type);
                }
                else {
                    if (argu.name) {
                        return "".concat(argu.name.text);
                    }
                    else {
                        return '';
                    }
                }
            }
        });
        return "".concat(arg.name).concat(this.getOptionalString(arg), ": (").concat(argums, ") => void");
    };
    FunctionSignatureHelper.prototype.getOptionalString = function (arg) {
        return arg.optional ? '?' : '';
    };
    FunctionSignatureHelper.prototype.helperFunc = function (context, method) {
        var _this = this;
        var args = '';
        var argDestructuredCounterInitial = 0;
        var argDestructuredCounterReal = 0;
        if (method.args) {
            method.args.forEach(function (arg) {
                if (arg.destructuredParameter) {
                    argDestructuredCounterInitial += 1;
                }
            });
            method.args.forEach(function (arg, index) {
                var _result = DependenciesEngine$1.find(arg.type);
                if (arg.destructuredParameter) {
                    if (argDestructuredCounterReal === 0) {
                        args += '__namedParameters: {';
                    }
                    argDestructuredCounterReal += 1;
                }
                if (_result) {
                    if (_result.source === 'internal') {
                        var path = _result.data.type;
                        if (_result.data.type === 'class') {
                            path = 'classe';
                        }
                        args += "".concat(arg.name).concat(_this.getOptionalString(arg), ": <a href=\"../").concat(path, "s/").concat(_result.data.name, ".html\" target=\"_self\">").concat(Handlebars$6.escapeExpression(arg.type), "</a>");
                    }
                    else {
                        var path = AngularVersionUtil$1.getApiLink(_result.data, Configuration$1.mainData.angularVersion);
                        args += "".concat(arg.name).concat(_this.getOptionalString(arg), ": <a href=\"").concat(path, "\" target=\"_blank\">").concat(Handlebars$6.escapeExpression(arg.type), "</a>");
                    }
                }
                else if (arg.dotDotDotToken) {
                    args += "...".concat(arg.name, ": ").concat(arg.type);
                }
                else if (arg.function) {
                    args += _this.handleFunction(arg);
                }
                else if (BasicTypeUtil$1.isKnownType(arg.type)) {
                    var path = BasicTypeUtil$1.getTypeUrl(arg.type);
                    args += "".concat(arg.name).concat(_this.getOptionalString(arg), ": <a href=\"").concat(path, "\" target=\"_blank\">").concat(Handlebars$6.escapeExpression(arg.type), "</a>");
                }
                else {
                    if (arg.type) {
                        args += "".concat(arg.name).concat(_this.getOptionalString(arg), ": ").concat(arg.type);
                    }
                    else {
                        args += "".concat(arg.name).concat(_this.getOptionalString(arg));
                    }
                }
                if (arg.destructuredParameter) {
                    if (argDestructuredCounterReal === argDestructuredCounterInitial) {
                        args += '}';
                    }
                }
                if (index < method.args.length - 1) {
                    args += ', ';
                }
            });
        }
        if (method.name) {
            return "".concat(method.name, "(").concat(args, ")");
        }
        else {
            return "(".concat(args, ")");
        }
    };
    return FunctionSignatureHelper;
}());

var HasOwnHelper = /** @class */ (function () {
    function HasOwnHelper() {
    }
    HasOwnHelper.prototype.helperFunc = function (context, entity, key, options) {
        if (Object.hasOwnProperty.call(entity, key)) {
            return options.fn(context);
        }
        else {
            return options.inverse(context);
        }
    };
    return HasOwnHelper;
}());

var TRANSLATION_DE_DE = {
    accessors: 'Accessors',
    arguments: 'Argumente',
    bootstrap: 'Bootstrap',
    branches: 'Branches',
    browse: 'Durchsuche',
    classe: 'Klasse',
    classes: 'Klassen',
    component: 'Komponente',
    components: 'Komponenten',
    constructor: 'Konstruktor',
    controllers: 'Controllers',
    controller: 'Controller',
    'coverage-page-title': 'Dokumentation Abdeckung',
    declarations: 'Declarations',
    decorators: 'Decorators',
    'default-value': 'Standardwert',
    'defined-in': 'Definiert in',
    dependencies: 'Abhängigkeiten',
    deprecated: 'Veraltet',
    description: 'Beschreibung',
    directive: 'Direktive',
    directives: 'Direktiven',
    'dom tree': 'DOM baum',
    entities: 'Entities',
    entity: 'Entity',
    entrycomponents: 'EntryComponents',
    enumerations: 'Enumerations',
    enums: 'Enums',
    example: 'Beispiel',
    examples: 'Beispiele',
    exports: 'Exportiert',
    extends: 'Erweitert',
    file: 'Datei',
    functions: 'Funktionen',
    'generated-using': 'Dokumentation generiert mit',
    'getting-started': "Los geht's",
    guard: 'Guard',
    guards: 'Guards',
    hostbindings: 'HostBindings',
    hostdirectives: 'HostDirectives',
    hostlisteners: 'HostListeners',
    'html-element': 'Html Element',
    'html-element-with-directive': 'Html-Element mit Direktive',
    identifier: 'Kennung',
    implements: 'Implementiert',
    imports: 'Importiert',
    index: 'Index',
    indexable: 'Indizierbar',
    info: 'Information',
    'inherited-from': 'Geerbt von',
    injectable: 'Injectable',
    injectables: 'Injectables',
    inputs: 'Inputs',
    interceptors: 'Interceptors',
    interface: 'Interface',
    interfaces: 'Interfaces',
    legend: 'Legende',
    license: 'Lizenz',
    lines: 'Linien',
    metadata: 'Metadata',
    methods: 'Methoden',
    miscellaneous: 'Verschiedenes',
    module: 'Modul',
    modules: 'Module',
    name: 'Name',
    no: 'Nein',
    'no-graph': 'Kein Graph verfügbar.',
    'no-iframe': 'Dein Browser unterstützt keine iframes.',
    'no-result-matching': 'Kein passendes Ergebnis',
    'no-svg': 'Dein Browser unterstützt kein SVG',
    optional: 'Optional',
    outputs: 'Ausgaben',
    overview: 'Übersicht',
    parameters: 'Parameter',
    'peer-dependencies': 'Peer-Abhängigkeiten',
    pipe: 'Pipe',
    pipes: 'Pipes',
    prefix: 'Präfix',
    properties: 'Eigenschaften',
    providers: 'Providers',
    pure: 'Pure',
    readme: 'README',
    required: 'Erforderlich',
    reset: 'Zurücksetzen',
    'results-matching': 'übereinstimmende Ergebnisse',
    returns: 'Returns',
    route: 'Route',
    routes: 'Routen',
    schemas: 'Schemata',
    'search-placeholder': 'Eingeben zur Suche',
    selector: 'Selektor',
    signature: 'Unterschrift',
    source: 'Quelle',
    standalone: 'Standalone',
    statements: 'Statements',
    styles: 'Stile',
    template: 'Vorlage',
    type: 'Typ',
    'type-aliases': 'Typ Aliase',
    'type-parameters': 'Typ Parameter',
    types: 'Typen',
    'unamed-property': 'Unbenannte Eigenschaft',
    'unit-test-coverage': 'Unit-Test-Abdeckung',
    value: 'Wert',
    variables: 'Variablen',
    yes: 'Ja',
    zoomin: 'Vergrößern',
    zoomout: 'Verkleinern'
};

var TRANSLATION_EN_US = {
    accessors: 'Accessors',
    arguments: 'Arguments',
    bootstrap: 'Bootstrap',
    branches: 'Branches',
    browse: 'Browse',
    classe: 'Class',
    classes: 'Classes',
    component: 'Component',
    components: 'Components',
    constructor: 'Constructor',
    controllers: 'Controllers',
    controller: 'Controller',
    'coverage-page-title': 'Documentation coverage',
    declarations: 'Declarations',
    decorators: 'Decorators',
    'default-value': 'Default value',
    'defined-in': 'Defined in',
    dependencies: 'Dependencies',
    deprecated: 'Deprecated',
    description: 'Description',
    directive: 'Directive',
    directives: 'Directives',
    'dom tree': 'DOM tree',
    entities: 'Entities',
    entity: 'Entity',
    entrycomponents: 'EntryComponents',
    enumerations: 'Enumerations',
    enums: 'Enums',
    example: 'Example',
    examples: 'Examples',
    exports: 'Exports',
    extends: 'Extends',
    file: 'File',
    functions: 'Functions',
    'generated-using': 'Documentation generated using',
    'getting-started': 'Getting started',
    guard: 'Guard',
    guards: 'Guards',
    hostbindings: 'HostBindings',
    hostdirectives: 'HostDirectives',
    hostlisteners: 'HostListeners',
    'html-element': 'Html element',
    'html-element-with-directive': 'Html element with directive',
    identifier: 'Identifier',
    implements: 'Implements',
    imports: 'Imports',
    index: 'Index',
    indexable: 'Indexable',
    info: 'Information',
    'inherited-from': 'Inherited from',
    injectable: 'Injectable',
    injectables: 'Injectables',
    inputs: 'Inputs',
    interceptors: 'Interceptors',
    interface: 'Interface',
    interfaces: 'Interfaces',
    legend: 'Legend',
    license: 'License',
    lines: 'Lines',
    metadata: 'Metadata',
    methods: 'Methods',
    miscellaneous: 'Miscellaneous',
    module: 'Module',
    modules: 'Modules',
    name: 'Name',
    no: 'No',
    'no-graph': 'No graph available.',
    'no-iframe': 'Your browser does not support iframes.',
    'no-result-matching': 'No results matching',
    'no-svg': 'Your browser does not support SVG',
    optional: 'Optional',
    outputs: 'Outputs',
    overview: 'Overview',
    parameters: 'Parameters',
    'peer-dependencies': 'Peer dependencies',
    pipe: 'Pipe',
    pipes: 'Pipes',
    prefix: 'Prefix',
    properties: 'Properties',
    providers: 'Providers',
    pure: 'Pure',
    readme: 'README',
    required: 'Required',
    reset: 'Reset',
    'results-matching': 'results matching',
    returns: 'Returns',
    route: 'Route',
    routes: 'Routes',
    schemas: 'Schemas',
    'search-placeholder': 'Type to search',
    selector: 'Selector',
    signature: 'Signature',
    source: 'Source',
    standalone: 'Standalone',
    statements: 'Statements',
    styles: 'Styles',
    template: 'Template',
    type: 'Type',
    'type-aliases': 'Type aliases',
    'type-parameters': 'Type parameters',
    types: 'Types',
    'unamed-property': 'Unamed property',
    'unit-test-coverage': 'Unit test coverage',
    value: 'Value',
    variables: 'Variables',
    yes: 'Yes',
    zoomin: 'Zoom in',
    zoomout: 'Zoom out'
};

var TRANSLATION_ES_ES = {
    accessors: 'Accesorios',
    arguments: 'Argumentos',
    bootstrap: 'Arranque',
    branches: 'Ramas',
    browse: 'Navegar',
    classe: 'Clase',
    classes: 'Clases',
    component: 'Componente',
    components: 'Componentes',
    constructor: 'Constructor',
    controllers: 'Controladores',
    controller: 'Controlador',
    'coverage-page-title': 'Cobertura de la documentación',
    declarations: 'Declaraciones',
    decorators: 'Decoradores',
    'default-value': 'Valor por defecto',
    'defined-in': 'Definido en',
    dependencies: 'Dependencias',
    deprecated: 'Obsoleta',
    description: 'Descripción',
    directive: 'Directiva',
    directives: 'Directivas',
    'dom tree': 'DOM arbol',
    entities: 'Entidades',
    entity: 'Entidad',
    entrycomponents: 'Componentes de entrada',
    enumerations: 'Enumeraciones',
    enums: 'Enums',
    example: 'Ejemplo',
    examples: 'Ejemplos',
    exports: 'Exporta',
    extends: 'Extiende',
    file: 'Fichero',
    functions: 'Funciones',
    'generated-using': 'Documentación generada utilizando',
    'getting-started': 'Comenzando',
    guard: 'Guardia',
    guards: 'Guardias',
    hostbindings: 'Fijaciones de Host',
    hostdirectives: 'HostDirectives',
    hostlisteners: 'Escuchadores de Host',
    'html-element': 'Elemento Html',
    'html-element-with-directive': 'Elemento Html con directiva',
    identifier: 'Identificador',
    implements: 'Implementa',
    imports: 'Importa',
    index: 'Índice',
    indexable: 'Indexable',
    info: 'Información',
    'inherited-from': 'Heredado desde',
    injectable: 'Inyectable',
    injectables: 'Inyectables',
    inputs: 'Entradas',
    interceptors: 'Interceptores',
    interface: 'Interfaz',
    interfaces: 'Interfaces',
    legend: 'Leyenda',
    license: 'Licencia',
    lines: 'Líneas',
    metadata: 'Meta datos',
    methods: 'Métodos',
    miscellaneous: 'Miscelánea',
    module: 'Módulo',
    modules: 'Módulos',
    name: 'Nombre',
    no: 'No',
    'no-graph': 'No hay gráfica disponible.',
    'no-iframe': 'Tu navegador no soporta iframes.',
    'no-result-matching': 'No hay resultados que coincidan',
    'no-svg': 'Tu navegador no soporta SVG',
    optional: 'Opcional',
    outputs: 'Salidas',
    overview: 'Descripción general',
    parameters: 'Parámetros',
    'peer-dependencies': 'Dependencias entre pares',
    pipe: 'Tubería',
    pipes: 'Tuberías',
    prefix: 'Prefijo',
    properties: 'Propiedades',
    providers: 'Proveedores',
    pure: 'Puro',
    readme: 'Léeme',
    required: 'Requerido',
    reset: 'Restablecer',
    'results-matching': 'comparación de resultados',
    returns: 'Devuelve',
    route: 'Ruta',
    routes: 'Rutas',
    schemas: 'Esquemas',
    'search-placeholder': 'Escribe para buscar',
    selector: 'Selector',
    signature: 'Firma',
    source: 'Fuente',
    standalone: 'Standalone',
    statements: 'Declaraciones',
    styles: 'Estilos',
    template: 'Plantilla',
    type: 'Tipo',
    'type-aliases': 'Alias de tipo',
    'type-parameters': 'Parámetros de tipo',
    types: 'Tipos',
    'unamed-property': 'Propiedad sin nombre',
    'unit-test-coverage': 'Cobertura de las pruebas unitarias',
    value: 'Valor',
    variables: 'Variables',
    yes: 'Si',
    zoomin: 'Ampliar',
    zoomout: 'Alejar'
};

var TRANSLATION_FR_FR = {
    accessors: 'Accesseurs',
    arguments: 'Arguments',
    bootstrap: 'Bootstrap',
    branches: 'Branches',
    browse: 'Parcourir',
    classe: 'Class',
    classes: 'Classes',
    component: 'Composant',
    components: 'Composants',
    constructor: 'Constructeur',
    controllers: 'Contrôleurs',
    controller: 'Contrôleur',
    'coverage-page-title': 'Couverture de documentation',
    declarations: 'Déclarations',
    decorators: 'Décorateurs',
    'default-value': 'Valeur par défaut',
    'defined-in': 'Défini dans',
    dependencies: 'Dépendances',
    deprecated: 'Obsolète',
    description: 'Description',
    directive: 'Directive',
    directives: 'Directives',
    'dom tree': 'Arbre DOM',
    entities: 'Entités',
    entity: 'Entité',
    entrycomponents: "Composants d'entrée",
    enumerations: 'Enumérations',
    enums: 'Enumérations',
    example: 'Example',
    examples: 'Examples',
    exports: 'Exports',
    extends: 'Etend',
    file: 'Fichier',
    functions: 'Fonctions',
    'generated-using': 'Documentation générée avec',
    'getting-started': 'Démarrage',
    guard: 'Garde',
    guards: 'Gardes',
    hostbindings: 'HostBindings',
    hostdirectives: 'HostDirectives',
    hostlisteners: 'HostListeners',
    'html-element': 'Elément Html',
    'html-element-with-directive': 'Elément Html avec une directive',
    identifier: 'Identifiant',
    implements: 'Implémente',
    imports: 'Imports',
    index: 'Index',
    indexable: 'Indexable',
    info: 'Information',
    'inherited-from': 'Hérité de',
    injectable: 'Injectable',
    injectables: 'Injectables',
    inputs: 'Entrées',
    interceptors: 'Intercepteurs',
    interface: 'Interface',
    interfaces: 'Interfaces',
    legend: 'Légende',
    license: 'License',
    lines: 'Lignes',
    metadata: 'Métadonnées',
    methods: 'Méthodes',
    miscellaneous: 'Divers',
    module: 'Module',
    modules: 'Modules',
    name: 'Nom',
    no: 'Non',
    'no-graph': 'Aucun graphique disponible.',
    'no-iframe': 'Votre navigateur ne supporte pas les iframes.',
    'no-result-matching': 'Aucun résultat matchant',
    'no-svg': 'Votre navigateur ne supporte pas le SVG',
    optional: 'Optionnel',
    outputs: 'Sorties',
    overview: "Vue d'ensemble",
    parameters: 'Paramètres',
    'peer-dependencies': 'Dépendances de pair',
    pipe: 'Pipe',
    pipes: 'Pipes',
    prefix: 'Préfixe',
    properties: 'Propriétés',
    providers: 'Providers',
    pure: 'Pure',
    readme: 'README',
    required: 'Requis',
    reset: 'Remise à zéro',
    'results-matching': 'résultats matchant',
    returns: 'Renvoie',
    route: 'Route',
    routes: 'Routes',
    schemas: 'Schémas',
    'search-placeholder': 'Saisissez un texte',
    selector: 'Sélecteur',
    signature: 'Signature',
    source: 'Source',
    standalone: 'Standalone',
    statements: 'Déclarations',
    styles: 'Styles',
    template: 'Template',
    'table-of-contents': 'Table des matières',
    type: 'Type',
    'type-aliases': 'Alias de type',
    'type-parameters': 'Paramètres de type',
    types: 'Types',
    'unamed-property': 'Propriété non nommée',
    'unit-test-coverage': 'Couverture de test unitaire',
    value: 'Valeur',
    variables: 'Variables',
    yes: 'Oui',
    zoomin: 'Zoom avant',
    zoomout: 'Zoom arrière'
};

var TRANSLATION_HU_HU = {
    accessors: 'Getter/setter metódusok',
    arguments: 'Argumentumok',
    bootstrap: 'Betöltés',
    branches: 'Branchek',
    browse: 'Böngészés',
    classe: 'Osztály',
    classes: 'Osztályok',
    component: 'Komponens',
    components: 'Komponensek',
    constructor: 'Konstruktor',
    controllers: 'Kontrollerek',
    controller: 'Kontroller',
    'coverage-page-title': 'Dokumentáció lefedettség',
    declarations: 'Deklarációk',
    decorators: 'Dekorátorok',
    'default-value': 'Alapértelmezett érték',
    'defined-in': 'Definíció helye:',
    dependencies: 'Függőségek',
    deprecated: 'Elavult',
    description: 'Leírás',
    directive: 'Direktíva',
    directives: 'Direktívák',
    'dom tree': 'DOM fa',
    entities: 'Entitások',
    entity: 'Entitás',
    entrycomponents: 'Entry komponensek',
    enumerations: 'Enumerációk',
    enums: 'Enumok',
    example: 'Példa',
    examples: 'Példák',
    exports: 'Exportok',
    extends: 'Ősosztály',
    file: 'File',
    functions: 'Függvények',
    'generated-using': 'A dokumentációt generálta:',
    'getting-started': 'Bevezető',
    guard: 'Guard',
    guards: 'Guardok',
    hostbindings: 'HostBindingok',
    hostdirectives: 'HostDirectives',
    hostlisteners: 'HostListenerek',
    'html-element': 'Html elem',
    'html-element-with-directive': 'Html elem direktívával',
    identifier: 'Azonosító',
    implements: 'Implementált interfészek',
    imports: 'Importok',
    index: 'Tartalomjegyzék',
    indexable: 'Indexelhető',
    info: 'Információ',
    'inherited-from': 'Örökölve innen:',
    injectable: 'Injektálható',
    injectables: 'Injektálhatók',
    inputs: 'Bemenetek',
    interceptors: 'Interceptorok',
    interface: 'Interfész',
    interfaces: 'Interfészek',
    legend: 'Jelmagyarázat',
    license: 'Licenc',
    lines: 'Sorok',
    metadata: 'Metaadatok',
    methods: 'Metódusok',
    miscellaneous: 'Egyéb',
    module: 'Modul',
    modules: 'Modulok',
    name: 'Név',
    no: 'Nem',
    'no-graph': 'Grafikon nem elérhető.',
    'no-iframe': 'A böngészője nem támogatja az iframe-eket.',
    'no-result-matching': 'Nincs találat',
    'no-svg': 'A böngészője nem támogatja az SVG formátumot.',
    optional: 'Opcionális',
    outputs: 'Kimenetek',
    overview: 'Áttekintés',
    parameters: 'Paraméterek',
    'peer-dependencies': 'Peer függőségek',
    pipe: 'Pipe',
    pipes: 'Pipe-ok',
    prefix: 'Előtag',
    properties: 'Tagváltozók',
    providers: 'Providerek',
    pure: 'Pure',
    readme: 'README',
    required: 'Kívánt',
    reset: 'Visszaállít',
    'results-matching': 'találat',
    returns: 'Visszatérési érték',
    route: 'Útvonal',
    routes: 'Útvonalak',
    schemas: 'Sémák',
    'search-placeholder': 'Keresendő kifejezés',
    selector: 'Szelektor',
    signature: 'Aláírás',
    source: 'Forrás',
    standalone: 'Standalone',
    statements: 'Utasítások',
    styles: 'Stílusok',
    template: 'Sablon',
    type: 'Típus',
    'type-aliases': 'Típus álnév',
    'type-parameters': 'Típus paraméterek',
    types: 'Típusok',
    'unamed-property': 'Névtelen property',
    'unit-test-coverage': 'Unit teszt lefedettség',
    value: 'Érték',
    variables: 'Változók',
    yes: 'Igen',
    zoomin: 'Nagyítás',
    zoomout: 'Kicsinyítés'
};

var TRANSLATION_IT_IT = {
    accessors: 'Accessori',
    arguments: 'Argomenti',
    bootstrap: 'Bootstrap',
    branches: 'Rami',
    browse: 'Cerca',
    classe: 'Classe',
    classes: 'Classi',
    component: 'Componente',
    components: 'Componenti',
    constructor: 'Costruttore',
    controllers: 'Controllers',
    controller: 'Controller',
    'coverage-page-title': 'Copertura codice',
    declarations: 'Dichiarazioni',
    decorators: 'Decorators',
    'default-value': 'Valore predefinito',
    'defined-in': 'Definito in',
    dependencies: 'Dependencies',
    deprecated: 'Deprecata',
    description: 'Descrizione',
    directive: 'Direttiva',
    directives: 'Direttive',
    'dom tree': 'Albero DOM',
    entities: 'Entità',
    entity: 'Entità',
    entrycomponents: 'EntryComponents',
    enumerations: 'Enumerations',
    enums: 'Enums',
    example: 'Esempio',
    examples: 'Esempi',
    exports: 'Exports',
    extends: 'Extends',
    file: 'File',
    functions: 'Funzioni',
    'generated-using': 'Documentazione generata usando',
    'getting-started': 'Iniziamo',
    guard: 'Guardia',
    guards: 'Guardie',
    hostbindings: 'HostBindings',
    hostdirectives: 'HostDirectives',
    hostlisteners: 'HostListeners',
    'html-element': 'Elemento Html',
    'html-element-with-directive': 'Elemento html con direttive',
    identifier: 'Identificatore',
    implements: 'Implementa',
    imports: 'Importa',
    index: 'Indice',
    indexable: 'Indicizzabile',
    info: 'Informazione',
    'inherited-from': 'ereditato da',
    injectable: 'Injectable',
    injectables: 'Injectables',
    inputs: 'Input',
    interceptors: 'Interceptors',
    interface: 'Interfaccia',
    interfaces: 'Interfacce',
    legend: 'Legenda',
    license: 'Licenza',
    lines: 'Linee',
    metadata: 'Metadati',
    methods: 'Metodi',
    miscellaneous: 'Varie',
    module: 'Modulo',
    modules: 'Moduli',
    name: 'Nome',
    no: 'No',
    'no-graph': 'Grafico non disponibile.',
    'no-iframe': 'Il tuo browser non supporta iframe.',
    'no-result-matching': 'Nessun risultato corrispondente',
    'no-svg': 'Il tuo browser non supporta SVG',
    optional: 'Opzionale',
    outputs: 'Output',
    overview: 'Sommario',
    parameters: 'Parametri',
    'peer-dependencies': 'Peer dependencies',
    pipe: 'Pipe',
    pipes: 'Pipes',
    prefix: 'Prefisso',
    properties: 'Proprietà',
    providers: 'Providers',
    pure: 'Pure',
    readme: 'README',
    required: 'Necessario',
    reset: 'Reset',
    'results-matching': 'corrispondenza',
    returns: 'Returns',
    route: 'Route',
    routes: 'Routes',
    schemas: 'Schemas',
    'search-placeholder': 'Digita per avviare la ricerca',
    selector: 'Selector',
    signature: 'Signature',
    source: 'Fonte',
    standalone: 'Standalone',
    statements: 'Statements',
    styles: 'Stili',
    template: 'Modello',
    type: 'Tipo',
    'type-aliases': 'Type aliases',
    'type-parameters': 'Type parameters',
    types: 'Tipi',
    'unamed-property': 'Proprietà senza nome',
    'unit-test-coverage': 'Copertura unit test',
    value: 'Valori',
    variables: 'Variabili',
    yes: 'Si',
    zoomin: 'Ingrandisci',
    zoomout: 'Rimpocciolisci'
};

var TRANSLATION_JA_JP = {
    accessors: 'アクセサ',
    arguments: '引数',
    bootstrap: 'ブートストラップ',
    branches: 'ブランチ',
    browse: 'ブラウズ',
    classe: 'クラス',
    classes: 'クラス',
    component: 'コンポーネント',
    components: 'コンポーネント',
    constructor: 'コンストラクタ',
    controllers: 'コントローラー',
    controller: 'コントローラー',
    'coverage-page-title': 'カバレッジ',
    declarations: '宣言',
    decorators: 'デコレーター',
    'default-value': '初期値',
    'defined-in': 'Defined in',
    dependencies: '依存関係',
    deprecated: '非推奨',
    description: '説明',
    directive: 'ディレクティブ',
    directives: 'ディレクティブ',
    'dom tree': 'DOM ツリー',
    entities: 'エンティティ',
    entity: '実在物',
    entrycomponents: 'エントリーコンポーネント',
    enumerations: '列挙型',
    enums: 'Enums',
    example: '例',
    examples: '例',
    exports: 'エクスポート',
    extends: '継承',
    file: 'ファイル',
    functions: '関数',
    'generated-using': 'このドキュメントは以下を使用して生成されています',
    'getting-started': 'はじめに',
    guard: 'ガード',
    guards: 'ガード',
    hostbindings: 'ホストバインディング',
    hostdirectives: 'HostDirectives',
    hostlisteners: 'ホストリスナー',
    'html-element': 'Html要素',
    'html-element-with-directive': 'ディレクティブHtml要素',
    identifier: '識別子',
    implements: '実装',
    imports: 'インポート',
    index: '索引',
    indexable: 'インデクサブル',
    info: '情報',
    'inherited-from': 'Inherited from',
    injectable: 'インジェクタブル',
    injectables: 'インジェクタブル',
    inputs: '入力',
    interceptors: 'インターセプター',
    interface: 'インターフェイス',
    interfaces: 'インターフェイス',
    legend: '凡例',
    license: 'ライセンス',
    lines: '行数',
    metadata: 'メタデータ',
    methods: 'メソッド',
    miscellaneous: 'その他',
    module: 'モジュール',
    modules: 'モジュール',
    name: '名前',
    no: 'いいえ',
    'no-graph': '使用できるグラフがありません',
    'no-iframe': 'ブラウザがiframeを対応していません',
    'no-result-matching': '見つかりませんでした',
    'no-svg': 'ブラウザがSVGに対応してません',
    optional: 'オプション',
    outputs: '出力',
    overview: '概要',
    parameters: 'パラメータ',
    'peer-dependencies': 'Peer dependencies',
    pipe: 'パイプ',
    pipes: 'パイプ',
    prefix: '接頭辞',
    properties: 'プロパティ',
    providers: 'プロバイダー',
    pure: 'Pure',
    readme: 'README',
    required: '必要',
    reset: 'リセット',
    'results-matching': '件の結果が一致しました',
    returns: '戻り値',
    route: 'ルート',
    routes: 'ルート',
    schemas: 'スキーマ',
    'search-placeholder': '入力して検索',
    selector: 'セレクタ',
    signature: 'シグネチャ',
    source: 'ソース',
    standalone: 'Standalone',
    statements: '文',
    styles: 'スタイル',
    template: 'テンプレート',
    type: '型',
    'type-aliases': 'タイプエイリアス',
    'type-parameters': '型パラメーター',
    types: '型',
    'unamed-property': '匿名プロパティ',
    'unit-test-coverage': 'ユニットテストカバレッジ',
    value: '値',
    variables: '変数',
    yes: 'はい',
    zoomin: '拡大',
    zoomout: '縮小'
};

var TRANSLATION_KA_GE = {
    accessors: 'აქსესორი',
    arguments: 'არგუმენტები',
    bootstrap: 'ჩამტვირთავი',
    branches: 'ტოტები',
    browse: 'დაათვალიერე',
    classe: 'კლასი',
    classes: 'კლასები',
    component: 'კომპონენტი',
    components: 'კომპონენტები',
    constructor: 'კონსტრუქტორი',
    controllers: 'კონტროლერები',
    controller: 'კონტროლერი',
    'coverage-page-title': 'დოკუმენტაციის გაშუქება',
    declarations: 'დეკლარაციები',
    decorators: 'დეკორატორები',
    'default-value': 'ნაგულისხმევი მნიშვნელობა',
    'defined-in': 'აღწერილია',
    dependencies: 'დამოკიდებულებები',
    deprecated: 'მოძველებულია',
    description: 'აღწერა',
    directive: 'დირექტივა',
    directives: 'დირექტივები',
    'dom tree': 'DOM ხე',
    entities: 'სუბიექტები',
    entity: 'სუბიექტი',
    entrycomponents: 'შესვლის კომპონენტები',
    enumerations: 'ჩამოთვლები',
    enums: 'ენამები',
    example: 'მაგალითი',
    examples: 'მაგალითები',
    exports: 'ექსპორტი',
    extends: 'აგრძელებს',
    file: 'ფაილი',
    functions: 'ფუნქციები',
    'generated-using': 'დოკუმენტაცია დაგენერირდა გამოყენებით',
    'getting-started': 'ვიწყებთ',
    guard: 'მცველი',
    guards: 'მცველები',
    hostbindings: 'ჰოსტის დამაკავშირებლები',
    hostdirectives: 'ჰოსტის დირექტივები',
    hostlisteners: 'ჰოსტის მსმენელები',
    'html-element': 'Html ელემენტი',
    'html-element-with-directive': 'Html ელემენტი დირექტივით',
    identifier: 'იდენტიფიკატორი',
    implements: 'ახორციელებს',
    imports: 'იმპორტი',
    index: 'ინდექსი',
    indexable: 'ინდექსირებადი',
    info: 'ინფორმაცია',
    'inherited-from': 'მემკვიდრეობით მიიღო',
    injectable: 'ინექცია',
    injectables: 'საინექციო საშუალებები',
    inputs: 'შეყვანები',
    interceptors: 'ჩამჭრელები',
    interface: 'ინტერფეისი',
    interfaces: 'ინტერფეისები',
    legend: 'ლეგენდა',
    license: 'ლიცენზია',
    lines: 'ხაზები',
    metadata: 'მეტამონაცემები',
    methods: 'მეთოდები',
    miscellaneous: 'სხვადასხვა',
    module: 'მოდული',
    modules: 'მოდულები',
    name: 'სახელები',
    no: 'არა',
    'no-graph': 'გრაფი არ არის ხელმისაწვდომი.',
    'no-iframe': 'თქვენს ბრაუზერს არ აქვს iframes-ის მხარდაჭერა.',
    'no-result-matching': 'არ არის შესაბამისი შედეგები',
    'no-svg': 'თქვენს ბრაუზერს არ აქვს SVG მხარდაჭერა',
    optional: 'სურვილისამებრ',
    outputs: 'შედეგები',
    overview: 'მიმოხილვა',
    parameters: 'პარამეტრები',
    'peer-dependencies': 'თანატოლებთან დამოკიდებულებები',
    pipe: 'მილი',
    pipes: 'მილები',
    prefix: 'პრეფიქსი',
    properties: 'თვისება',
    providers: 'პროვაიდერი',
    pure: 'წმინდა',
    readme: 'README',
    required: 'აუცილებელი',
    reset: 'გადატვირთვა',
    'results-matching': 'შედეგები ემთხვევა',
    returns: 'ბრუნდება',
    route: 'მარშრუტი',
    routes: 'მარშრუტები',
    schemas: 'სქემები',
    'search-placeholder': 'დაწერე მოსაძებნად',
    selector: 'სელექტორი',
    signature: 'ხელმოწერა',
    source: 'წყარო',
    standalone: 'დამოუკიდებელი',
    statements: 'განცხადებები',
    styles: 'სტილები',
    template: 'შაბლონი',
    type: 'ტიპი',
    'type-aliases': 'მეტსახელის ტიპი',
    'type-parameters': 'პარამეტრების ტიპი',
    types: 'ტიპები',
    'unamed-property': 'უსახელო თვისება',
    'unit-test-coverage': 'ერთეული ტესტის გაშუქება',
    value: 'მნიშვნელობა',
    variables: 'ცვლადები',
    yes: 'კი',
    zoomin: 'მიახლოვება',
    zoomout: 'მასშტაბირება'
};

var TRANSLATION_KO_KR = {
    accessors: '접근자',
    arguments: '인수',
    bootstrap: 'Bootstrap',
    branches: '브랜치',
    browse: '탐색',
    classe: '클래스',
    classes: '클래스',
    component: '컴포넌트',
    components: '컴포넌트',
    constructor: '생성자',
    controllers: '컨트롤러',
    controller: '컨트롤러',
    'coverage-page-title': '문서 커버리지',
    declarations: '선언',
    decorators: '데코레이터',
    'default-value': '기본 값',
    'defined-in': '다음에 정의됨',
    dependencies: '의존성',
    deprecated: '비추천',
    description: '설명',
    directive: 'Directive',
    directives: 'Directives',
    'dom tree': '돔 트리',
    entities: '엔티티',
    entity: '실재',
    entrycomponents: 'EntryComponents',
    enumerations: '열거',
    enums: 'Enums',
    example: '예시',
    examples: '예',
    exports: '내보내기',
    extends: 'Extends',
    file: '파일',
    functions: '함수',
    'generated-using': '이 문서는 다음을 이용하여 생성되었습니다',
    'getting-started': '시작하기',
    guard: '가드',
    guards: '가드',
    hostbindings: 'HostBindings',
    hostdirectives: 'HostDirectives',
    hostlisteners: 'HostListeners',
    'html-element': 'HTML 요소',
    'html-element-with-directive': '지시어가 있는 HTML 요소',
    identifier: '식별자',
    implements: '구현',
    imports: '가져오기',
    index: '색인',
    indexable: 'Indexable',
    info: '정보',
    'inherited-from': '다음에서 상속됨',
    injectable: 'Injectable',
    injectables: 'Injectables',
    inputs: '입력',
    interceptors: 'Interceptors',
    interface: '인터페이스',
    interfaces: '인터페이스',
    legend: '범례',
    license: '라이선스',
    lines: '줄',
    metadata: '메타데이터',
    methods: '메소드',
    miscellaneous: '기타',
    module: '모듈',
    modules: '모듈',
    name: '이름',
    no: '아니오',
    'no-graph': '사용할 수 있는 그래프가 없습니다.',
    'no-iframe': '사용중인 브라우저가 iframe을 지원하지 않습니다',
    'no-result-matching': '검색 결과가 없습니다',
    'no-svg': '브라우저가 SVG를 지원하지 않습니다',
    optional: '선택적',
    outputs: '결과물',
    overview: '개요',
    parameters: '매개변수',
    'peer-dependencies': '상호 의존성',
    pipe: '파이프',
    pipes: '파이프',
    prefix: '접두어',
    properties: '속성',
    providers: '제공자',
    pure: 'Pure',
    readme: 'README',
    required: '필수의',
    reset: '초기화',
    'results-matching': '개의 결과가 일치했습니다',
    returns: '반환',
    route: 'Route',
    routes: 'Routes',
    schemas: '스키마',
    'search-placeholder': '검색어 입력',
    selector: '선택자',
    signature: 'Signature',
    source: '출처',
    standalone: 'Standalone',
    statements: 'Statements',
    styles: '스타일',
    template: '주형',
    type: '타입',
    'type-aliases': '타입 별칭',
    'type-parameters': '타입 매개 변수',
    types: '타입',
    'unamed-property': '익명 속성',
    'unit-test-coverage': '단위 테스트 커버리지',
    value: '값',
    variables: '변수',
    yes: '네',
    zoomin: '확대',
    zoomout: '축소'
};

var TRANSLATION_NL_NL = {
    accessors: 'Accessors',
    arguments: 'Argumenten',
    bootstrap: 'Bootstrap',
    branches: 'Branches',
    browse: 'Browse',
    classe: 'Klasse',
    classes: 'Klassen',
    component: 'Component',
    components: 'Componenten',
    constructor: 'Constructor',
    controllers: 'Controllers',
    controller: 'Controller',
    'coverage-page-title': 'Documentatie coverage',
    declarations: 'Declaraties',
    decorators: 'Decorators',
    'default-value': 'Default waarde',
    'defined-in': 'Gedefinieerd in',
    dependencies: 'Dependencies',
    deprecated: 'Verouderd',
    description: 'Omschrijving',
    directive: 'Directive',
    directives: 'Directives',
    'dom tree': 'DOM boom',
    entities: 'Entiteiten',
    entity: 'Entiteit',
    entrycomponents: 'EntryComponents',
    enumerations: 'Enumerations',
    enums: 'Enums',
    example: 'Voorbeeld',
    examples: 'Voorbeelden',
    exports: 'Exports',
    extends: 'Extends',
    file: 'Bestand',
    functions: 'Functies',
    'generated-using': 'Documentatie gegenereed met',
    'getting-started': 'Aan de slag',
    guard: 'Guard',
    guards: 'Guards',
    hostbindings: 'HostBindings',
    hostdirectives: 'HostDirectives',
    hostlisteners: 'HostListeners',
    'html-element': 'Html element',
    'html-element-with-directive': 'Html element met directive',
    identifier: 'Identifier',
    implements: 'Implementeert',
    imports: 'Imports',
    index: 'Index',
    indexable: 'Indexeerbaar',
    info: 'Informatie',
    'inherited-from': 'Inherited van',
    injectable: 'Injectable',
    injectables: 'Injectables',
    inputs: 'Inputs',
    interceptors: 'Interceptors',
    interface: 'Interface',
    interfaces: 'Interfaces',
    legend: 'Legenda',
    license: 'Licentie',
    lines: 'Regels',
    metadata: 'Metadata',
    methods: 'Methods',
    miscellaneous: 'Diversen',
    module: 'Module',
    modules: 'Modules',
    name: 'Naam',
    no: 'Nee',
    'no-graph': 'Geen diagram beschikbaar.',
    'no-iframe': 'Uw browser ondersteund geen iframes.',
    'no-result-matching': 'Geen overeenkomende resultaten',
    'no-svg': 'Uw browser ondersteund geen SVG',
    optional: 'Optioneel',
    outputs: 'Outputs',
    overview: 'Overzicht',
    parameters: 'Parameters',
    'peer-dependencies': 'Peer dependencies',
    pipe: 'Pipe',
    pipes: 'Pipes',
    prefix: 'Voorvoegsel',
    properties: 'Properties',
    providers: 'Providers',
    pure: 'Puur',
    readme: 'README',
    required: 'Vereist',
    reset: 'Reset',
    'results-matching': 'overeenkomende resultaten',
    returns: 'Returns',
    route: 'Route',
    routes: 'Routes',
    schemas: "Schema's",
    'search-placeholder': 'Type om te zoeken',
    selector: 'Selector',
    signature: 'Handtekening',
    source: 'Bron',
    standalone: 'Standalone',
    statements: 'Statements',
    styles: 'Stijlen',
    template: 'Sjabloon',
    type: 'Type',
    'type-aliases': 'Type aliassen',
    'type-parameters': 'Type parameters',
    types: 'Types',
    'unamed-property': 'Naamloze property',
    'unit-test-coverage': 'Unit test coverage',
    value: 'Waarde',
    variables: 'Variabelen',
    yes: 'Ja',
    zoomin: 'Zoom in',
    zoomout: 'Zoom uit'
};

var TRANSLATION_PL_PL = {
    accessors: 'Akcesor',
    arguments: 'Argumenty',
    bootstrap: 'Uruchomienie',
    branches: 'Gałęzie',
    browse: 'Przeglądaj',
    classe: 'Klasa',
    classes: 'Klasy',
    component: 'Komponent',
    components: 'Komponenty',
    constructor: 'Konstruktor',
    controllers: 'Kontrolery',
    controller: 'Kontroler',
    'coverage-page-title': 'Pokrycie dokumentacją',
    declarations: 'Deklaracje',
    decorators: 'Dekoratory',
    'default-value': 'Domyślna wartość',
    'defined-in': 'Zdefiniowane w',
    dependencies: 'Biblioteki',
    deprecated: 'Przestarzałe',
    description: 'Opis',
    directive: 'Dyrektywa',
    directives: 'Dyrektywy',
    'dom tree': 'DOM drzewo',
    entities: 'Podmioty',
    entity: 'Podmiot',
    entrycomponents: 'EntryComponents',
    enumerations: 'Enumeracje',
    enums: 'Enumy',
    example: 'Przykład',
    examples: 'Przykłady',
    exports: 'Exporty',
    extends: 'Rozszerza',
    file: 'Plik',
    functions: 'Funkcje',
    'generated-using': 'Dokumentacja wygenerowana przy użyciu',
    'getting-started': 'Start',
    guard: 'Guard',
    guards: "Guard'y",
    hostbindings: 'HostBindingi',
    hostdirectives: 'HostDirectives',
    hostlisteners: 'HostListenery',
    'html-element': 'Html element',
    'html-element-with-directive': 'Html element z dyrektywą',
    identifier: 'Identyfikator',
    implements: 'Implementuje',
    imports: 'Importuje',
    index: 'Indeks',
    indexable: 'Indeksowany',
    info: 'Informatie',
    'inherited-from': 'Dziedziczy z',
    injectable: 'Injectable',
    injectables: 'Injectables',
    inputs: 'Inputy',
    interceptors: 'Interceptory',
    interface: 'Interfejs',
    interfaces: 'Interfejsy',
    legend: 'Legenda',
    license: 'Licencja',
    lines: 'Linie',
    metadata: 'Metadane',
    methods: 'Metody',
    miscellaneous: 'Różne',
    module: 'Moduł',
    modules: 'Moduły',
    name: 'Nazwa',
    no: 'Nie',
    'no-graph': 'Graf niedostępny.',
    'no-iframe': "Twoja przeglądarka nie wspiera iframe'ów.",
    'no-result-matching': 'Brak pasujących wyników',
    'no-svg': 'Twoja przeglądarka nie wspiera SVG',
    optional: 'Opcjonalne',
    outputs: 'Outputy',
    overview: 'Przegląd',
    parameters: 'Parametry',
    'peer-dependencies': 'Biblioteki zależne',
    pipe: 'Pipe',
    pipes: "Pipe'y",
    prefix: 'Prefiks',
    properties: 'Włąściwości',
    providers: 'Dostarczyciele',
    pure: 'Czysty',
    readme: 'README',
    required: 'Wymagany',
    reset: 'Reset',
    'results-matching': 'pasujących wyników',
    returns: 'Zwraca',
    route: 'Route',
    routes: "Route'y",
    schemas: 'Schematy',
    'search-placeholder': 'Wprowadź tekst wyszukiwania',
    selector: 'Selektor',
    signature: 'Podpis',
    source: 'Source',
    standalone: 'Standalone',
    statements: 'Instrukcje',
    styles: 'Estilos',
    template: 'Modelo',
    type: 'Typ',
    'type-aliases': 'Aliasy typów',
    'type-parameters': 'Parametry typów',
    types: 'Typy',
    'unamed-property': 'Nienazwana właśność',
    'unit-test-coverage': 'Pokrycie testami jednostkowymi',
    value: 'Wartość',
    variables: 'Zmienne',
    yes: 'Tak',
    zoomin: 'Przybliż',
    zoomout: 'Oddal'
};

var TRANSLATION_PT_BR = {
    accessors: 'Acessores',
    arguments: 'Argumentos',
    bootstrap: 'Bootstrap',
    branches: 'Branches',
    browse: 'Navegar',
    classe: 'Classe',
    classes: 'Classes',
    component: 'Componente',
    components: 'Componentes',
    constructor: 'Construtor',
    controllers: 'Controladores',
    controller: 'Controlador',
    'coverage-page-title': 'Cobertura da documentação',
    declarations: 'Declarações',
    decorators: 'Decoradores',
    'default-value': 'Valor padrão',
    'defined-in': 'Definido em',
    dependencies: 'Dependências',
    deprecated: 'Descontinuada',
    description: 'Descrição',
    directive: 'Diretiva',
    directives: 'Diretivas',
    'dom tree': 'Arvore DOM',
    entities: 'Entidades',
    entity: 'Entidade',
    entrycomponents: 'EntryComponents',
    enumerations: 'Enumerações',
    enums: 'Enums',
    example: 'Exemplo',
    examples: 'Exemplos',
    exports: 'Exports',
    extends: 'Extende',
    file: 'Arquivo',
    functions: 'Funções',
    'generated-using': 'Documentação gerada usando',
    'getting-started': 'Começando',
    guard: 'Guarda',
    guards: 'Guardas',
    hostbindings: 'HostBindings',
    hostdirectives: 'HostDirectives',
    hostlisteners: 'HostListeners',
    'html-element': 'Elemento HTML',
    'html-element-with-directive': 'Elemento HTML com diretiva',
    identifier: 'Identificador',
    implements: 'Implementa',
    imports: 'Imports',
    index: 'Index',
    indexable: 'Indexável',
    info: 'Informação',
    'inherited-from': 'Herdado de',
    injectable: 'Injetável',
    injectables: 'Injetáveis',
    inputs: 'Inputs',
    interceptors: 'Interceptors',
    interface: 'Interface',
    interfaces: 'Interfaces',
    legend: 'Legend',
    license: 'Licença',
    lines: 'Linhas',
    metadata: 'Metadata',
    methods: 'Métodos',
    miscellaneous: 'Miscelânea',
    module: 'Módulo',
    modules: 'Módulos',
    name: 'Nome',
    no: 'Não',
    'no-graph': 'Sem gráfico disponível.',
    'no-iframe': 'Seu browser não tem suporte a iframes.',
    'no-result-matching': 'Nenhum resultado correspondente',
    'no-svg': 'Seu browser não tem suporte a SVG',
    optional: 'Opcional',
    outputs: 'Outputs',
    overview: 'Visão geral',
    parameters: 'Parâmetros',
    'peer-dependencies': 'Peer dependencies',
    pipe: 'Pipe',
    pipes: 'Pipes',
    prefix: 'Prefixo',
    properties: 'Propriedades',
    providers: 'Providers',
    pure: 'Puro',
    readme: 'README',
    required: 'Obrigatório',
    reset: 'Resetar',
    'results-matching': 'resultados correspondentes',
    returns: 'Retorna',
    route: 'Rota',
    routes: 'Rotas',
    schemas: 'Esquemas',
    'search-placeholder': 'Digite para pesquisar',
    selector: 'Seletor',
    signature: 'Assinatura',
    source: 'Fonte',
    standalone: 'Standalone',
    statements: 'Statements',
    styles: 'Estilos',
    template: 'Modelo',
    type: 'Tipo',
    'type-aliases': 'Aliases de tipo',
    'type-parameters': 'Parâmetros de tipo',
    types: 'Tipos',
    'unamed-property': 'Propriedade não-nomeada',
    'unit-test-coverage': 'Cobertura de teste unitário',
    value: 'Valor',
    variables: 'Variáveis',
    yes: 'Sim',
    zoomin: 'Zoom in',
    zoomout: 'Zoom out'
};

var TRANSLATION_RU_RU = {
    accessors: 'Аксессор',
    arguments: 'Аргументы',
    bootstrap: 'Загрузчик',
    branches: 'Ветки',
    browse: 'Обзор',
    classe: 'Класс',
    classes: 'Классы',
    component: 'Компонент',
    components: 'Компоненты',
    constructor: 'Конструктор',
    controllers: 'Контроллеры',
    controller: 'Контроллер',
    'coverage-page-title': 'Покрытие документацией',
    declarations: 'Декларации',
    decorators: 'Декораторы',
    'default-value': 'Значение по умолчанию',
    'defined-in': 'Определен в',
    dependencies: 'Зависимости',
    deprecated: 'Устаревшая',
    description: 'Описание',
    directive: 'Директива',
    directives: 'Директивы',
    'dom tree': 'DOM-дерево',
    entities: 'Сущности',
    entity: 'Сущность',
    entrycomponents: 'Входные компоненты',
    enumerations: 'Перечисления',
    enums: 'Перечисления',
    example: 'Пример',
    examples: 'Примеры',
    exports: 'Экспорт',
    extends: 'Расширяет',
    file: 'Файл',
    functions: 'Функции',
    'generated-using': 'Документация создана с помощью',
    'getting-started': 'Начало работы',
    guard: 'Защитник',
    guards: 'Защитники',
    hostbindings: 'Привязки хоста',
    hostdirectives: 'Директивы хоста',
    hostlisteners: 'Слушатели хоста',
    'html-element': 'Html-элемент',
    'html-element-with-directive': 'Html-элемент с директивой',
    identifier: 'Идентификатор',
    implements: 'Реализует',
    imports: 'Импорт',
    index: 'Индекс',
    indexable: 'Индексируемый',
    info: 'Информация',
    'inherited-from': 'Наследуемый из',
    injectable: 'Внедрение',
    injectables: 'Внедрения',
    inputs: 'Входные данные',
    interceptors: 'Перехватчики',
    interface: 'Интерфейс',
    interfaces: 'Интерфейсы',
    legend: 'Легенда',
    license: 'Лицензия',
    lines: 'Строки',
    metadata: 'Метаданные',
    methods: 'Методы',
    miscellaneous: 'Разное',
    module: 'Модуль',
    modules: 'Модули',
    name: 'Имя',
    no: 'Нет',
    'no-graph': 'Диаграмма недоступна.',
    'no-iframe': 'Браузер не поддерживает iframes.',
    'no-result-matching': 'Результаты не найдены',
    'no-svg': 'Браузер не поддерживает SVG',
    optional: 'Опциональный',
    outputs: 'Выходные данные',
    overview: 'Обзор',
    parameters: 'Параметры',
    'peer-dependencies': 'Одноранговые зависимости',
    pipe: 'Конвейер',
    pipes: 'Конвейеры',
    prefix: 'Префикс',
    properties: 'Свойства',
    providers: 'Провайдеры',
    pure: 'Чистый',
    readme: 'README',
    required: 'Требуемый',
    reset: 'Сброс',
    'results-matching': 'результатов найдено',
    returns: 'Тип возвращаемого значения',
    route: 'Маршрут',
    routes: 'Маршруты',
    schemas: 'Схемы',
    'search-placeholder': 'Введите для поиска',
    selector: 'Селектор',
    signature: 'Сигнатура',
    source: 'Источник',
    standalone: 'Автономный',
    statements: 'Утверждения',
    styles: 'Стили',
    template: 'Шаблон',
    type: 'Тип',
    'type-aliases': 'Псевдонимы типов',
    'type-parameters': 'Типы параметров',
    types: 'Типы',
    'unamed-property': 'Безымянное свойство',
    'unit-test-coverage': 'Покрытие модульными тестами',
    value: 'Значение',
    variables: 'Переменные',
    yes: 'Да',
    zoomin: 'Приблизить',
    zoomout: 'Отдалить'
};

var TRANSLATION_SK_SK = {
    accessors: 'Modifikátory prístupu',
    arguments: 'Argumenty',
    bootstrap: 'Bootstrap',
    branches: 'Vetvy',
    browse: 'Prezerať',
    classe: 'Trieda',
    classes: 'Triedy',
    component: 'Komponent',
    components: 'Komponenty',
    constructor: 'Konštruktor',
    controllers: 'Controllers',
    controller: 'Controller',
    'coverage-page-title': 'Pokrytie dokumentáciou',
    declarations: 'Deklarácie',
    decorators: 'Dekorátory',
    'default-value': 'Predvolená hodnota',
    'defined-in': 'Definované v',
    dependencies: 'Závislosti',
    deprecated: 'Zastarel',
    description: 'Popis',
    directive: 'Direktíva',
    directives: 'Direktívy',
    'dom tree': 'DOM strom',
    entities: 'Subjektov',
    entity: 'Subjekt',
    entrycomponents: 'EntryComponents',
    enumerations: 'Enumerátory',
    enums: 'Enumerátory',
    example: 'Príklad',
    examples: 'Príklady',
    exports: 'Exporty',
    extends: 'Rozširuje',
    file: 'Súbor',
    functions: 'Funkcie',
    'generated-using': 'Dokumentácia vytvorená pomocou',
    'getting-started': 'Začíname',
    guard: 'Guard',
    guards: 'Guards',
    hostbindings: 'HostBindings',
    hostdirectives: 'HostDirectives',
    hostlisteners: 'HostListeners',
    'html-element': 'HTML element',
    'html-element-with-directive': 'HTML element s direktívou',
    identifier: 'Identifikátor',
    implements: 'Implementuje',
    imports: 'Importuje',
    index: 'Index',
    indexable: 'Indexovateľný',
    info: 'Informácie',
    'inherited-from': 'Zdedené od',
    injectable: 'Injectable',
    injectables: 'Injectables',
    inputs: 'Vstupy',
    interceptors: 'Interceptors',
    interface: 'Rozhranie',
    interfaces: 'Rozhrania',
    legend: 'Legenda',
    license: 'Licencia',
    lines: 'Riadky',
    metadata: 'Metadáta',
    methods: 'Metódy',
    miscellaneous: 'Rôzne',
    module: 'Modul',
    modules: 'Moduly',
    name: 'Názov',
    no: 'Nie',
    'no-graph': 'Nie je k dispozícii žiadny graf.',
    'no-iframe': 'Váš prehliadač nepodporuje iframe',
    'no-result-matching': 'Nenájdené žiadne výsledky pre',
    'no-svg': 'Váš prehliadač nepodporuje SVG',
    optional: 'Voliteľný',
    outputs: 'Výstupy',
    overview: 'Prehľad',
    parameters: 'Parametre',
    'peer-dependencies': 'Peer dependencies',
    pipe: 'Pipe',
    pipes: 'Pipes',
    prefix: 'Prefix',
    properties: 'Vlastnosti',
    providers: 'Providers',
    pure: 'Pure',
    readme: 'README',
    required: 'Požadovaný',
    reset: 'Resetovať',
    'results-matching': 'výsledkov pre',
    returns: 'Návratová hodnota',
    route: 'Route',
    routes: 'Routes',
    schemas: 'Schémy',
    'search-placeholder': 'Zadajte hľadaný text',
    selector: 'Selektor',
    signature: 'Podpis',
    source: 'Zdroj',
    standalone: 'Standalone',
    statements: 'Statements',
    styles: 'Štýly',
    template: 'Šablóna',
    type: 'Typ',
    'type-aliases': 'Type aliases',
    'type-parameters': 'Type parameters',
    types: 'Typy',
    'unamed-property': 'Nepomenovaný atribút',
    'unit-test-coverage': 'Pokrytie unit testami',
    value: 'Hodnota',
    variables: 'Premenné',
    yes: 'Áno',
    zoomin: 'Priblížiť',
    zoomout: 'Oddialiť'
};

var TRANSLATION_ZH_CN = {
    accessors: '存取器',
    arguments: 'Arguments',
    bootstrap: '根组件',
    branches: '分支',
    browse: '查看',
    classe: '类',
    classes: '类列表',
    component: '组件',
    components: '组件列表',
    constructor: '构造方法',
    controllers: 'Controllers',
    controller: 'Controller',
    'coverage-page-title': '文档概览',
    declarations: '可声明对象列表',
    decorators: '装饰器列表',
    'default-value': '缺省值',
    'defined-in': '被定义在',
    dependencies: '依赖项',
    deprecated: '已弃用',
    description: '描述',
    directive: '指令',
    directives: '指令列表',
    'dom tree': 'DOM 树',
    entities: '实体',
    entity: '实体',
    entrycomponents: '入口组件列表',
    enumerations: '列举',
    enums: '枚举列表',
    example: '例子',
    examples: '例子',
    exports: '导出',
    extends: '继承',
    file: '文件',
    functions: '函数',
    'generated-using': '文档生成使用',
    'getting-started': '入门指南',
    guard: '路由守卫',
    guards: '路由守卫列表',
    hostbindings: '宿主绑定',
    hostdirectives: 'Host Directives',
    hostlisteners: '宿主监听',
    'html-element': 'Html 元素',
    'html-element-with-directive': '带指令的Html元素',
    identifier: '标识符',
    implements: '实现',
    imports: '引入',
    index: '索引',
    indexable: 'Indexable',
    info: '信息',
    'inherited-from': '继承自',
    injectable: '可注入的',
    injectables: '可注入的',
    inputs: '输入属性',
    interceptors: '拦截器',
    interface: '接口',
    interfaces: '接口',
    legend: '图例',
    license: '许可协议',
    lines: 'Lines',
    metadata: '元数据',
    methods: '方法',
    miscellaneous: '其他',
    module: '模块',
    modules: '模块列表',
    name: '名称',
    no: '否',
    'no-graph': '无数据显示',
    'no-iframe': '你的浏览器不支持iframes',
    'no-result-matching': '无匹配的结果',
    'no-svg': '你的浏览器不支持SVG',
    optional: '可选的',
    outputs: '输出属性',
    overview: '概述',
    parameters: '参数列表',
    'peer-dependencies': '同级依赖',
    pipe: '管道',
    pipes: '管道列表',
    prefix: '字首',
    properties: '属性列表',
    providers: '提供商列表',
    pure: 'Pure',
    readme: '手册',
    required: '必需的',
    reset: '重置',
    'results-matching': '匹配的结果',
    returns: '返回',
    route: '路由',
    routes: '路由列表',
    schemas: '模式',
    'search-placeholder': '请输入查询关键字',
    selector: '选择器',
    signature: '签名',
    source: '来源',
    standalone: 'Standalone',
    statements: '注释',
    styles: '样式',
    template: '模板',
    type: '类型',
    'type-aliases': '类型别名',
    'type-parameters': '类型参数',
    types: '类型',
    'unamed-property': '未命名属性',
    'unit-test-coverage': '单元测试概览',
    value: '值',
    variables: '变量',
    yes: '是',
    zoomin: '放大',
    zoomout: '缩小'
};

var TRANSLATION_ZH_TW = {
    accessors: '存取器',
    arguments: '參數',
    bootstrap: '根元件',
    branches: '分支',
    browse: '瀏覽',
    classe: '類別',
    classes: '類別',
    component: '元件',
    components: '元件列表',
    constructor: '建構式方法',
    controllers: 'Controllers',
    controller: 'Controller',
    'coverage-page-title': '覆蓋率頁面標題',
    declarations: 'Declarations',
    decorators: '裝飾器列表',
    'default-value': '預設值',
    'defined-in': '被定義在',
    dependencies: '依賴項',
    deprecated: '已棄用',
    description: '描述',
    directive: '指令 (Directive)',
    directives: '指令 (Directives)',
    'dom tree': 'DOM 樹',
    entities: '實體',
    entity: '實體',
    entrycomponents: 'Entrycomponents',
    enumerations: '列舉',
    enums: '枚舉列表',
    example: '範例',
    examples: '範例',
    exports: '匯出',
    extends: '繼承',
    file: '檔案',
    functions: '函數',
    'generated-using': '產生文件使用',
    'getting-started': '快速上手',
    guard: '路由守衛',
    guards: '路由守衛列表',
    hostbindings: 'Host Bindings',
    hostdirectives: 'Host Directives',
    hostlisteners: 'Host Listeners',
    'html-element': 'HTML 元素',
    'html-element-with-directive': '帶指令的 HTML 元素',
    identifier: '識別符號',
    implements: '實作',
    imports: '匯入',
    index: '索引',
    indexable: 'Indexable',
    info: '資訊',
    'inherited-from': '繼承自',
    injectable: 'Injectable',
    injectables: 'Injectables',
    inputs: '輸入屬性',
    interceptors: '攔截器',
    interface: '介面',
    interfaces: '介面',
    legend: '圖例',
    license: '授權協議',
    lines: 'Lines',
    metadata: '元數據',
    methods: '方法',
    miscellaneous: '其他',
    module: '模組',
    modules: '模組列表',
    name: '名稱',
    no: '否',
    'no-graph': '無數據顯示',
    'no-iframe': '你的瀏覽器不支援 iframes',
    'no-result-matching': '無匹配的結果',
    'no-svg': '你的瀏覽器不支援 SVG',
    optional: '可選的',
    outputs: '輸出屬性',
    overview: '概述',
    parameters: '參數列表',
    'peer-dependencies': 'Peer Dependencies',
    pipe: '管道',
    pipes: '管道列表',
    prefix: '前置詞',
    properties: '屬性列表',
    providers: '提供者列表',
    pure: 'Pure',
    readme: 'README',
    required: '必需的',
    reset: '重設',
    'results-matching': '匹配的結果',
    returns: '回傳值',
    route: '路由',
    routes: '路由列表',
    schemas: 'Schemas',
    'search-placeholder': '請輸入查詢關鍵字',
    selector: '選擇器',
    signature: '簽名',
    source: '來源',
    standalone: 'Standalone',
    statements: '陳述式',
    styles: '樣式',
    template: '範本',
    type: '型別',
    'type-aliases': '型別別名',
    'type-parameters': '型別參數',
    types: '型別',
    'unamed-property': '未命名屬性',
    'unit-test-coverage': '單元測試覆蓋率',
    value: '值',
    variables: '變數',
    yes: '是',
    zoomin: '放大',
    zoomout: '縮小'
};

var I18nEngine = /** @class */ (function () {
    function I18nEngine() {
        this.availablesLanguages = {
            'bg-BG': 'bg-BG',
            'de-DE': 'de-DE',
            'en-US': 'en-US',
            'es-ES': 'es-ES',
            'fr-FR': 'fr-FR',
            'hu-HU': 'hu-HU',
            'it-IT': 'it-IT',
            'ja-JP': 'ja-JP',
            'ka-GE': 'ka-GE',
            'ko-KR': 'ko-KR',
            'nl-NL': 'nl-NL',
            'pl-PL': 'pl-PL',
            'pt-BR': 'pt-BR',
            'ru-RU': 'ru-RU',
            'sk-SK': 'sk-SK',
            'zh-CN': 'zh-CN',
            'zh-TW': 'zh-TW'
        };
        this.fallbackLanguage = 'en-US';
    }
    I18nEngine.getInstance = function () {
        if (!I18nEngine.instance) {
            I18nEngine.instance = new I18nEngine();
        }
        return I18nEngine.instance;
    };
    I18nEngine.prototype.init = function (language) {
        i18next.init({
            lng: language,
            fallbackLng: this.fallbackLanguage,
            interpolation: {
                skipOnVariables: false
            }
        });
        i18next.addResources('de-DE', 'translation', TRANSLATION_DE_DE);
        i18next.addResources('en-US', 'translation', TRANSLATION_EN_US);
        i18next.addResources('es-ES', 'translation', TRANSLATION_ES_ES);
        i18next.addResources('fr-FR', 'translation', TRANSLATION_FR_FR);
        i18next.addResources('hu-HU', 'translation', TRANSLATION_HU_HU);
        i18next.addResources('it-IT', 'translation', TRANSLATION_IT_IT);
        i18next.addResources('ja-JP', 'translation', TRANSLATION_JA_JP);
        i18next.addResources('ka-GE', 'translation', TRANSLATION_KA_GE);
        i18next.addResources('ko-KR', 'translation', TRANSLATION_KO_KR);
        i18next.addResources('nl-NL', 'translation', TRANSLATION_NL_NL);
        i18next.addResources('pl-PL', 'translation', TRANSLATION_PL_PL);
        i18next.addResources('pt-BR', 'translation', TRANSLATION_PT_BR);
        i18next.addResources('ru-RU', 'translation', TRANSLATION_RU_RU);
        i18next.addResources('sk-SK', 'translation', TRANSLATION_SK_SK);
        i18next.addResources('zh-CN', 'translation', TRANSLATION_ZH_CN);
        i18next.addResources('zh-TW', 'translation', TRANSLATION_ZH_TW);
    };
    I18nEngine.prototype.translate = function (key) {
        return i18next.t(key);
    };
    I18nEngine.prototype.exists = function (key) {
        return i18next.exists(key);
    };
    I18nEngine.prototype.supportLanguage = function (language) {
        return typeof this.availablesLanguages[language] !== 'undefined';
    };
    return I18nEngine;
}());
var I18nEngine$1 = I18nEngine.getInstance();

require('handlebars');
var I18nHelper = /** @class */ (function () {
    function I18nHelper() {
    }
    I18nHelper.prototype.helperFunc = function (context, i18n_key) {
        if (I18nEngine$1.exists(i18n_key)) {
            return I18nEngine$1.translate(i18n_key.toLowerCase());
        }
        else {
            return i18n_key;
        }
    };
    return I18nHelper;
}());

var IfStringHelper = /** @class */ (function () {
    function IfStringHelper() {
    }
    IfStringHelper.prototype.helperFunc = function (context, a, options) {
        if (typeof a === 'string') {
            return options.fn(context);
        }
        return options.inverse(context);
    };
    return IfStringHelper;
}());

var IndexableSignatureHelper = /** @class */ (function () {
    function IndexableSignatureHelper() {
    }
    IndexableSignatureHelper.prototype.helperFunc = function (context, method) {
        var args = method.args.map(function (arg) { return "".concat(arg.name, ": ").concat(arg.type); }).join(', ');
        if (method.name) {
            return "".concat(method.name, "[").concat(args, "]");
        }
        else {
            return "[".concat(args, "]");
        }
    };
    return IndexableSignatureHelper;
}());

var IsInitialTabHelper = /** @class */ (function () {
    function IsInitialTabHelper() {
    }
    IsInitialTabHelper.prototype.helperFunc = function (context, tabs, tabId, options) {
        return tabs[0].id === tabId ? options.fn(context) : options.inverse(context);
    };
    return IsInitialTabHelper;
}());

var IsNotToggleHelper = /** @class */ (function () {
    function IsNotToggleHelper() {
    }
    IsNotToggleHelper.prototype.helperFunc = function (context, type, options) {
        var result = Configuration$1.mainData.toggleMenuItems.indexOf(type);
        if (Configuration$1.mainData.toggleMenuItems.indexOf('all') !== -1) {
            return options.inverse(context);
        }
        else if (result !== -1) {
            return options.fn(context);
        }
        else {
            return options.inverse(context);
        }
    };
    return IsNotToggleHelper;
}());

var IsTabEnabledHelper = /** @class */ (function () {
    function IsTabEnabledHelper() {
    }
    IsTabEnabledHelper.prototype.helperFunc = function (context, tabs, tabId, options) {
        var isTabEnabled = -1 !== ___namespace.findIndex(tabs, { id: tabId });
        return isTabEnabled ? options.fn(context) : options.inverse(context);
    };
    return IsTabEnabledHelper;
}());

var JsdocCodeExampleHelper = /** @class */ (function () {
    function JsdocCodeExampleHelper() {
    }
    JsdocCodeExampleHelper.prototype.cleanTag = function (comment) {
        if (comment.charAt(0) === '*') {
            comment = comment.substring(1, comment.length);
        }
        if (comment.charAt(0) === ' ') {
            comment = comment.substring(1, comment.length);
        }
        if (comment.indexOf('<p>') === 0) {
            comment = comment.substring(3, comment.length);
        }
        if (comment.substr(-1) === '\n') {
            comment = comment.substring(0, comment.length - 1);
        }
        if (comment.substr(-4) === '</p>') {
            comment = comment.substring(0, comment.length - 4);
        }
        return comment;
    };
    JsdocCodeExampleHelper.prototype.getHtmlEntities = function (str) {
        return String(str)
            .replace(/&/g, '&amp;')
            .replace(/</g, '&lt;')
            .replace(/>/g, '&gt;')
            .replace(/"/g, '&quot;');
    };
    JsdocCodeExampleHelper.prototype.helperFunc = function (context, jsdocTags, options) {
        var i = 0;
        var len = jsdocTags.length;
        var tags = [];
        var type = 'html';
        if (options.hash.type) {
            type = options.hash.type;
        }
        for (i; i < len; i++) {
            if (jsdocTags[i].tagName) {
                if (jsdocTags[i].tagName.text === 'example') {
                    var tag = {};
                    if (jsdocTags[i].comment) {
                        if (jsdocTags[i].comment.indexOf('<caption>') !== -1) {
                            tag.comment = jsdocTags[i].comment
                                .replace(/<caption>/g, '<b><i>')
                                .replace(/\/caption>/g, '/b></i>');
                        }
                        else {
                            tag.comment =
                                "<pre class=\"line-numbers\"><code class=\"language-".concat(type, "\">") +
                                    this.getHtmlEntities(this.cleanTag(jsdocTags[i].comment)) +
                                    "</code></pre>";
                        }
                        tags.push(tag);
                    }
                }
            }
        }
        if (tags.length > 0) {
            context.tags = tags;
            return options.fn(context);
        }
    };
    return JsdocCodeExampleHelper;
}());

var JsdocDefaultHelper = /** @class */ (function () {
    function JsdocDefaultHelper() {
    }
    JsdocDefaultHelper.prototype.helperFunc = function (context, jsdocTags, options) {
        if (jsdocTags) {
            var i = 0;
            var len = jsdocTags.length;
            var tag = {};
            var defaultValue = false;
            for (i; i < len; i++) {
                if (jsdocTags[i].tagName) {
                    if (jsdocTags[i].tagName.text === 'default') {
                        defaultValue = true;
                        if (jsdocTags[i].typeExpression && jsdocTags[i].typeExpression.type.name) {
                            tag.type = jsdocTags[i].typeExpression.type.name.text;
                        }
                        if (jsdocTags[i].comment) {
                            tag.comment = jsdocTags[i].comment;
                        }
                        if (jsdocTags[i].name) {
                            tag.name = jsdocTags[i].name.text;
                        }
                    }
                }
            }
            if (defaultValue) {
                context.tag = tag;
                return options.fn(context);
            }
        }
    };
    return JsdocDefaultHelper;
}());

var JsdocExampleHelper = /** @class */ (function () {
    function JsdocExampleHelper() {
    }
    JsdocExampleHelper.prototype.helperFunc = function (context, jsdocTags, options) {
        var i = 0;
        var len = jsdocTags.length;
        var tags = [];
        for (i; i < len; i++) {
            if (jsdocTags[i].tagName) {
                if (jsdocTags[i].tagName.text === 'example') {
                    var tag = {};
                    if (jsdocTags[i].comment) {
                        tag.comment = jsdocTags[i].comment
                            .replace(/<caption>/g, '<b><i>')
                            .replace(/\/caption>/g, '/b></i>');
                    }
                    tags.push(tag);
                }
            }
        }
        if (tags.length > 0) {
            context.tags = tags;
            return options.fn(context);
        }
    };
    return JsdocExampleHelper;
}());

var JsdocParamsValidHelper = /** @class */ (function () {
    function JsdocParamsValidHelper() {
    }
    JsdocParamsValidHelper.prototype.helperFunc = function (context, jsdocTags, options) {
        var i = 0;
        var len = jsdocTags.length;
        var valid = false;
        for (i; i < len; i++) {
            if (jsdocTags[i].tagName) {
                if (jsdocTags[i].tagName.text === 'param') {
                    valid = true;
                }
            }
        }
        if (valid) {
            return options.fn(context);
        }
        else {
            return options.inverse(context);
        }
    };
    return JsdocParamsValidHelper;
}());

var JsdocParamsHelper = /** @class */ (function () {
    function JsdocParamsHelper() {
    }
    JsdocParamsHelper.prototype.helperFunc = function (context, jsdocTags, options) {
        var i = 0;
        var len = jsdocTags.length;
        var tags = [];
        for (i; i < len; i++) {
            if (jsdocTags[i].tagName) {
                if (jsdocTags[i].tagName.text === 'param') {
                    var tag = {};
                    if (jsdocTags[i].typeExpression && jsdocTags[i].typeExpression.type.kind) {
                        tag.type = kindToType(jsdocTags[i].typeExpression.type.kind);
                    }
                    if (jsdocTags[i].typeExpression && jsdocTags[i].typeExpression.type.name) {
                        tag.type = jsdocTags[i].typeExpression.type.name.text;
                    }
                    else {
                        tag.type = jsdocTags[i].type;
                    }
                    if (jsdocTags[i].comment) {
                        tag.comment = jsdocTags[i].comment;
                    }
                    if (jsdocTags[i].defaultValue) {
                        tag.defaultValue = jsdocTags[i].defaultValue;
                    }
                    if (jsdocTags[i].name) {
                        if (jsdocTags[i].name.text) {
                            tag.name = jsdocTags[i].name.text;
                        }
                        else {
                            tag.name = jsdocTags[i].name;
                        }
                    }
                    if (jsdocTags[i].optional) {
                        tag.optional = true;
                    }
                    tags.push(tag);
                }
            }
        }
        if (tags.length >= 1) {
            context.tags = tags;
            return options.fn(context);
        }
    };
    return JsdocParamsHelper;
}());

var JsdocReturnsCommentHelper = /** @class */ (function () {
    function JsdocReturnsCommentHelper() {
    }
    JsdocReturnsCommentHelper.prototype.helperFunc = function (context, jsdocTags, options) {
        var i = 0;
        var len = jsdocTags.length;
        var result;
        for (i; i < len; i++) {
            if (jsdocTags[i].tagName) {
                if (jsdocTags[i].tagName.text === 'returns' ||
                    jsdocTags[i].tagName.text === 'return') {
                    result = jsdocTags[i].comment;
                    break;
                }
            }
        }
        return result;
    };
    return JsdocReturnsCommentHelper;
}());

var ast$1 = new tsMorph.Project();
var ImportsUtil = /** @class */ (function () {
    function ImportsUtil() {
    }
    ImportsUtil.getInstance = function () {
        if (!ImportsUtil.instance) {
            ImportsUtil.instance = new ImportsUtil();
        }
        return ImportsUtil.instance;
    };
    /**
     * Find for a sourceFile a variable value in a local enum
     * @param srcFile
     * @param variableName
     * @param variableValue
     */
    ImportsUtil.prototype.findInEnums = function (srcFile, variableName, variableValue) {
        var res = '';
        srcFile.getEnum(function (e) {
            if (e.getName() === variableName) {
                e.getMember(function (m) {
                    if (m.getName() === variableValue) {
                        res = m.getValue();
                    }
                });
            }
        });
        return res;
    };
    /**
     * Find for a sourceFile a variable value in a local static class
     * @param srcFile
     * @param variableName
     * @param variableValue
     */
    ImportsUtil.prototype.findInClasses = function (srcFile, variableName, variableValue) {
        var res = '';
        srcFile.getClass(function (c) {
            var staticProperty = c.getStaticProperty(variableValue);
            if (staticProperty) {
                if (staticProperty.getInitializer()) {
                    res = staticProperty.getInitializer().getText();
                }
            }
        });
        return res;
    };
    /**
     * Find a value in a local variable declaration like an object
     * @param variableDeclaration
     * @param variablesAttributes
     */
    ImportsUtil.prototype.findInObjectVariableDeclaration = function (variableDeclaration, variablesAttributes) {
        var variableKind = variableDeclaration.getKind();
        if (variableKind && variableKind === tsMorph.SyntaxKind.VariableDeclaration) {
            var initializer = variableDeclaration.getInitializer();
            if (initializer) {
                var initializerKind = initializer.getKind();
                if (initializerKind && initializerKind === tsMorph.SyntaxKind.ObjectLiteralExpression) {
                    var compilerNode = initializer.compilerNode, finalValue_1 = '';
                    // Find thestring from AVAR.BVAR.thestring inside properties
                    var depth_1 = 0;
                    var loopProperties_1 = function (properties) {
                        properties.forEach(function (prop) {
                            if (prop.name) {
                                if (variablesAttributes[depth_1 + 1]) {
                                    if (prop.name.getText() === variablesAttributes[depth_1 + 1]) {
                                        if (prop.initializer) {
                                            if (prop.initializer.properties) {
                                                depth_1 += 1;
                                                loopProperties_1(prop.initializer.properties);
                                            }
                                            else {
                                                finalValue_1 = prop.initializer.text;
                                            }
                                        }
                                        else {
                                            finalValue_1 = prop.initializer.text;
                                        }
                                    }
                                }
                            }
                        });
                    };
                    loopProperties_1(compilerNode.properties);
                    return finalValue_1;
                }
            }
        }
    };
    /**
     * Find in imports something like myvar
     * @param  {string} inputVariableName              like myvar
     * @return {[type]}                                myvar value
     */
    ImportsUtil.prototype.findValueInImportOrLocalVariables = function (inputVariableName, sourceFile, decoratorType) {
        var e_1, _a;
        var metadataVariableName = inputVariableName, searchedImport, aliasOriginalName = '', foundWithNamedImport = false, foundWithAlias = false;
        var file = typeof ast$1.getSourceFile(sourceFile.fileName) !== 'undefined'
            ? ast$1.getSourceFile(sourceFile.fileName)
            : ast$1.addSourceFileAtPathIfExists(sourceFile.fileName); // tslint:disable-line
        var imports = file.getImportDeclarations();
        /**
         * Loop through all imports, and find one matching inputVariableName
         */
        imports.forEach(function (i) {
            var namedImports = i.getNamedImports(), namedImportsLength = namedImports.length, j = 0;
            if (namedImportsLength > 0) {
                for (j; j < namedImportsLength; j++) {
                    var importName = namedImports[j].getNameNode().getText(), importAlias = void 0;
                    if (namedImports[j].getAliasNode()) {
                        importAlias = namedImports[j].getAliasNode().getText();
                    }
                    if (importName === metadataVariableName) {
                        foundWithNamedImport = true;
                        searchedImport = i;
                        break;
                    }
                    if (importAlias === metadataVariableName) {
                        foundWithNamedImport = true;
                        foundWithAlias = true;
                        aliasOriginalName = importName;
                        searchedImport = i;
                        break;
                    }
                }
            }
            var namespaceImport = i.getNamespaceImport();
            if (namespaceImport) {
                var namespaceImportLocalName = namespaceImport.getText();
                if (namespaceImportLocalName === metadataVariableName) {
                    searchedImport = i;
                }
            }
            if (!foundWithNamedImport) {
                var defaultImport = i.getDefaultImport();
                if (defaultImport) {
                    var defaultImportText = defaultImport.getText();
                    if (defaultImportText === metadataVariableName) {
                        searchedImport = i;
                    }
                }
            }
        });
        function hasFoundValues(variableDeclaration) {
            var variableKind = variableDeclaration.getKind();
            if (variableKind && variableKind === tsMorph.SyntaxKind.VariableDeclaration) {
                var initializer = variableDeclaration.getInitializer();
                if (initializer) {
                    var initializerKind = initializer.getKind();
                    if (initializerKind && initializerKind === tsMorph.SyntaxKind.ObjectLiteralExpression) {
                        var compilerNode = initializer.compilerNode;
                        return compilerNode.properties;
                    }
                }
            }
        }
        if (typeof searchedImport !== 'undefined') {
            var importPathReference = searchedImport.getModuleSpecifierSourceFile();
            var importPath = void 0;
            if (typeof importPathReference !== 'undefined') {
                importPath = importPathReference.compilerNode.fileName;
                var sourceFileImport = typeof ast$1.getSourceFile(importPath) !== 'undefined'
                    ? ast$1.getSourceFile(importPath)
                    : ast$1.addSourceFileAtPathIfExists(importPath); // tslint:disable-line
                if (sourceFileImport) {
                    var variableName_1 = foundWithAlias ? aliasOriginalName : metadataVariableName;
                    var variableDeclaration = sourceFileImport.getVariableDeclaration(variableName_1);
                    if (variableDeclaration) {
                        return hasFoundValues(variableDeclaration);
                    }
                    else {
                        // Try with exports
                        var exportDeclarations = sourceFileImport.getExportedDeclarations();
                        if (exportDeclarations && exportDeclarations.size > 0) {
                            try {
                                for (var exportDeclarations_1 = __values(exportDeclarations), exportDeclarations_1_1 = exportDeclarations_1.next(); !exportDeclarations_1_1.done; exportDeclarations_1_1 = exportDeclarations_1.next()) {
                                    var _b = __read(exportDeclarations_1_1.value, 2), exportDeclarationKey = _b[0], exportDeclarationValues = _b[1];
                                    exportDeclarationValues.forEach(function (exportDeclarationValue) {
                                        if (exportDeclarationValue instanceof tsMorph.VariableDeclaration &&
                                            exportDeclarationValue.getName() === variableName_1) {
                                            return hasFoundValues(exportDeclarationValue);
                                        }
                                    });
                                }
                            }
                            catch (e_1_1) { e_1 = { error: e_1_1 }; }
                            finally {
                                try {
                                    if (exportDeclarations_1_1 && !exportDeclarations_1_1.done && (_a = exportDeclarations_1.return)) _a.call(exportDeclarations_1);
                                }
                                finally { if (e_1) throw e_1.error; }
                            }
                        }
                    }
                }
            }
            if (!importPathReference &&
                decoratorType === 'template' &&
                searchedImport.getModuleSpecifierValue().indexOf('.html') !== -1) {
                var originalSourceFilePath = sourceFile.path;
                var originalSourceFilePathFolder = originalSourceFilePath.substring(0, originalSourceFilePath.lastIndexOf('/'));
                var finalImportedPath = originalSourceFilePathFolder + '/' + searchedImport.getModuleSpecifierValue();
                var finalImportedPathData = FileEngine$1.getSync(finalImportedPath);
                return finalImportedPathData;
            }
        }
        else {
            // Find in local variables of the file
            var variableDeclaration = file.getVariableDeclaration(metadataVariableName);
            if (variableDeclaration) {
                var variableKind = variableDeclaration.getKind();
                if (variableKind && variableKind === tsMorph.SyntaxKind.VariableDeclaration) {
                    var initializer = variableDeclaration.getInitializer();
                    if (initializer) {
                        var initializerKind = initializer.getKind();
                        if (initializerKind &&
                            initializerKind === tsMorph.SyntaxKind.ObjectLiteralExpression) {
                            var compilerNode = initializer.compilerNode;
                            return compilerNode.properties;
                        }
                        else if (initializerKind &&
                            (initializerKind === tsMorph.SyntaxKind.StringLiteral ||
                                initializerKind === tsMorph.SyntaxKind.NoSubstitutionTemplateLiteral)) {
                            if (decoratorType === 'template') {
                                return initializer.getText();
                            }
                            else {
                                return variableDeclaration.compilerNode;
                            }
                        }
                        else if (initializerKind) {
                            return variableDeclaration.compilerNode;
                        }
                    }
                }
            }
        }
        return [];
    };
    ImportsUtil.prototype.getFileNameOfImport = function (variableName, sourceFile) {
        var file = typeof ast$1.getSourceFile(sourceFile.fileName) !== 'undefined'
            ? ast$1.getSourceFile(sourceFile.fileName)
            : ast$1.addSourceFileAtPath(sourceFile.fileName); // tslint:disable-line
        var imports = file.getImportDeclarations();
        var searchedImport, finalPath = '';
        imports.forEach(function (i) {
            var namedImports = i.getNamedImports(), namedImportsLength = namedImports.length, j = 0;
            if (namedImportsLength > 0) {
                for (j; j < namedImportsLength; j++) {
                    var importName = namedImports[j].getNameNode().getText(), importAlias = void 0;
                    if (namedImports[j].getAliasNode()) {
                        importAlias = namedImports[j].getAliasNode().getText();
                    }
                    if (importName === variableName) {
                        searchedImport = i;
                        break;
                    }
                    if (importAlias === variableName) {
                        searchedImport = i;
                        break;
                    }
                }
            }
        });
        if (typeof searchedImport !== 'undefined') {
            var importPath = path__namespace.resolve(path__namespace.dirname(sourceFile.fileName) +
                '/' +
                searchedImport.getModuleSpecifierValue() +
                '.ts');
            var cleaner = (process.cwd() + path__namespace.sep).replace(/\\/g, '/');
            finalPath = importPath.replace(cleaner, '');
        }
        return finalPath;
    };
    /**
     * Find the file path of imported variable
     * @param  {string} inputVariableName  like thestring
     * @return {[type]}                    thestring destination path
     */
    ImportsUtil.prototype.findFilePathOfImportedVariable = function (inputVariableName, sourceFilePath) {
        var searchedImport, finalPath = '';
        var file = typeof ast$1.getSourceFile(sourceFilePath) !== 'undefined'
            ? ast$1.getSourceFile(sourceFilePath)
            : ast$1.addSourceFileAtPath(sourceFilePath); // tslint:disable-line
        var imports = file.getImportDeclarations();
        /**
         * Loop through all imports, and find one matching inputVariableName
         */
        imports.forEach(function (i) {
            var namedImports = i.getNamedImports(), namedImportsLength = namedImports.length, j = 0;
            if (namedImportsLength > 0) {
                for (j; j < namedImportsLength; j++) {
                    var importName = namedImports[j].getNameNode().getText(), importAlias = void 0;
                    if (namedImports[j].getAliasNode()) {
                        importAlias = namedImports[j].getAliasNode().getText();
                    }
                    if (importName === inputVariableName) {
                        searchedImport = i;
                        break;
                    }
                    if (importAlias === inputVariableName) {
                        searchedImport = i;
                        break;
                    }
                }
            }
        });
        if (typeof searchedImport !== 'undefined') {
            finalPath = path__namespace.resolve(path__namespace.dirname(sourceFilePath) +
                '/' +
                searchedImport.getModuleSpecifierValue() +
                '.ts');
        }
        return finalPath;
    };
    /**
     * Find in imports something like VAR.AVAR.BVAR.thestring
     * @param  {string} inputVariableName                   like VAR.AVAR.BVAR.thestring
     * @return {[type]}                                thestring value
     */
    ImportsUtil.prototype.findPropertyValueInImportOrLocalVariables = function (inputVariableName, sourceFile) {
        var variablesAttributes = inputVariableName.split('.'), metadataVariableName = variablesAttributes[0], searchedImport, aliasOriginalName = '', foundWithAlias = false;
        var file = typeof ast$1.getSourceFile(sourceFile.fileName) !== 'undefined'
            ? ast$1.getSourceFile(sourceFile.fileName)
            : ast$1.addSourceFileAtPath(sourceFile.fileName); // tslint:disable-line
        var imports = file.getImportDeclarations();
        /**
         * Loop through all imports, and find one matching inputVariableName
         */
        imports.forEach(function (i) {
            var namedImports = i.getNamedImports(), namedImportsLength = namedImports.length, j = 0;
            if (namedImportsLength > 0) {
                for (j; j < namedImportsLength; j++) {
                    var importName = namedImports[j].getNameNode().getText(), importAlias = void 0;
                    if (namedImports[j].getAliasNode()) {
                        importAlias = namedImports[j].getAliasNode().getText();
                    }
                    if (importName === metadataVariableName) {
                        searchedImport = i;
                        break;
                    }
                    if (importAlias === metadataVariableName) {
                        foundWithAlias = true;
                        aliasOriginalName = importName;
                        searchedImport = i;
                        break;
                    }
                }
            }
        });
        var fileToSearchIn, variableDeclaration;
        if (typeof searchedImport !== 'undefined') {
            var importPath = path__namespace.resolve(path__namespace.dirname(sourceFile.fileName) +
                '/' +
                searchedImport.getModuleSpecifierValue() +
                '.ts');
            var sourceFileImport = typeof ast$1.getSourceFile(importPath) !== 'undefined'
                ? ast$1.getSourceFile(importPath)
                : ast$1.addSourceFileAtPath(importPath); // tslint:disable-line
            if (sourceFileImport) {
                fileToSearchIn = sourceFileImport;
                var variableName = foundWithAlias ? aliasOriginalName : metadataVariableName;
                variableDeclaration = fileToSearchIn.getVariableDeclaration(variableName);
            }
        }
        else {
            fileToSearchIn = file;
            // Find in local variables of the file
            variableDeclaration = fileToSearchIn.getVariableDeclaration(metadataVariableName);
        }
        if (variableDeclaration) {
            return this.findInObjectVariableDeclaration(variableDeclaration, variablesAttributes);
        }
        // Try find it in enums
        if (variablesAttributes.length > 0) {
            if (typeof fileToSearchIn !== 'undefined') {
                var val = this.findInEnums(fileToSearchIn, metadataVariableName, variablesAttributes[1]);
                if (val !== '') {
                    return val;
                }
                val = this.findInClasses(fileToSearchIn, metadataVariableName, variablesAttributes[1]);
                if (val !== '') {
                    return val;
                }
            }
        }
    };
    return ImportsUtil;
}());
var ImportsUtil$1 = ImportsUtil.getInstance();

var Handlebars$5 = require('handlebars');
var traverse$1 = require('neotraverse/legacy');
var ast = new tsMorph.Project();
var RouterParserUtil = /** @class */ (function () {
    function RouterParserUtil() {
        this.scannedFiles = [];
        this.routes = [];
        this.incompleteRoutes = [];
        this.modules = [];
        this.modulesWithRoutes = [];
        this.transformAngular8ImportSyntax = /(['"]loadChildren['"]:)\(\)(:[^)]+?)?=>"import\((\\'|'|"|`)([^'"]+?)(\\'|'|"|`)\)\.then\(\(?\w+?\)?=>\S+?\.([^)]+?)\)(\\'|'|")/g;
        this.transformAngular8ImportSyntaxComponent = /(['"]loadComponent['"]:)\(\)(:[^)]+?)?=>"import\((\\'|'|"|`)([^'"]+?)(\\'|'|"|`)\)\.then\(\(?\w+?\)?=>\S+?\.([^)]+?)\)(\\'|'|")/g;
        this.transformAngular8ImportSyntaxAsyncAwait = /(['"]loadChildren['"]:)\(\)(:[^)]+?)?=>\("import\((\\'|'|"|`)([^'"]+?)(\\'|'|"|`)\)"\)\.['"]([^)]+?)['"]/g;
        this.transformAngular8ImportSyntaxComponentAsyncAwait = /(['"]loadComponent['"]:)\(\)(:[^)]+?)?=>\("import\((\\'|'|"|`)([^'"]+?)(\\'|'|"|`)\)"\)\.['"]([^)]+?)['"]/g;
        this.trailingComma = /,\s*([\]})])/g;
    }
    RouterParserUtil.getInstance = function () {
        if (!RouterParserUtil.instance) {
            RouterParserUtil.instance = new RouterParserUtil();
        }
        return RouterParserUtil.instance;
    };
    RouterParserUtil.prototype.addRoute = function (route) {
        this.routes.push(route);
        this.routes = ___namespace.sortBy(___namespace.uniqWith(this.routes, ___namespace.isEqual), ['name']);
    };
    RouterParserUtil.prototype.addIncompleteRoute = function (route) {
        this.incompleteRoutes.push(route);
        this.incompleteRoutes = ___namespace.sortBy(___namespace.uniqWith(this.incompleteRoutes, ___namespace.isEqual), ['name']);
    };
    RouterParserUtil.prototype.addModuleWithRoutes = function (moduleName, moduleImports, filename) {
        this.modulesWithRoutes.push({
            name: moduleName,
            importsNode: moduleImports,
            filename: filename
        });
        this.modulesWithRoutes = ___namespace.sortBy(___namespace.uniqWith(this.modulesWithRoutes, ___namespace.isEqual), ['name']);
    };
    RouterParserUtil.prototype.addModule = function (moduleName, moduleImports) {
        this.modules.push({
            name: moduleName,
            importsNode: moduleImports
        });
        this.modules = ___namespace.sortBy(___namespace.uniqWith(this.modules, ___namespace.isEqual), ['name']);
    };
    RouterParserUtil.prototype.cleanRawRouteParsed = function (route) {
        return JSON5__namespace.parse(this.cleanRawRoute(route));
    };
    RouterParserUtil.prototype.cleanRawRoute = function (route) {
        return route
            .replace(/\s/g, '')
            .replace(this.trailingComma, '$1')
            .replace(this.transformAngular8ImportSyntax, '$1"$4#$6"')
            .replace(this.transformAngular8ImportSyntaxAsyncAwait, '$1"$4#$6"')
            .replace(this.transformAngular8ImportSyntaxComponent, '$1"$4#$6"')
            .replace(this.transformAngular8ImportSyntaxComponentAsyncAwait, '$1"$4#$6"');
    };
    RouterParserUtil.prototype.setRootModule = function (module) {
        this.rootModule = module;
    };
    RouterParserUtil.prototype.hasRouterModuleInImports = function (imports) {
        for (var i = 0; i < imports.length; i++) {
            if (imports[i].name.indexOf('RouterModule.forChild') !== -1 ||
                imports[i].name.indexOf('RouterModule.forRoot') !== -1 ||
                imports[i].name.indexOf('RouterModule') !== -1) {
                return true;
            }
        }
        return false;
    };
    RouterParserUtil.prototype.fixIncompleteRoutes = function (miscellaneousVariables) {
        var matchingVariables = [];
        // For each incompleteRoute, scan if one misc variable is in code
        // if ok, try recreating complete route
        for (var i = 0; i < this.incompleteRoutes.length; i++) {
            for (var j = 0; j < miscellaneousVariables.length; j++) {
                if (this.incompleteRoutes[i].data.indexOf(miscellaneousVariables[j].name) !== -1) {
                    console.log('found one misc var inside incompleteRoute');
                    console.log(miscellaneousVariables[j].name);
                    matchingVariables.push(miscellaneousVariables[j]);
                }
            }
            // Clean incompleteRoute
            this.incompleteRoutes[i].data = this.incompleteRoutes[i].data.replace('[', '');
            this.incompleteRoutes[i].data = this.incompleteRoutes[i].data.replace(']', '');
        }
    };
    RouterParserUtil.prototype.linkModulesAndRoutes = function () {
        var _this = this;
        var i = 0;
        var len = this.modulesWithRoutes.length;
        for (i; i < len; i++) {
            ___namespace.forEach(this.modulesWithRoutes[i].importsNode, function (node) {
                var initializer = node.initializer;
                if (initializer) {
                    if (initializer.elements) {
                        ___namespace.forEach(initializer.elements, function (element) {
                            // find element with arguments
                            if (element.arguments) {
                                ___namespace.forEach(element.arguments, function (argument) {
                                    ___namespace.forEach(_this.routes, function (route) {
                                        if (argument.text &&
                                            route.name === argument.text &&
                                            route.filename === _this.modulesWithRoutes[i].filename) {
                                            route.module = _this.modulesWithRoutes[i].name;
                                        }
                                        else if (argument.text &&
                                            route.name === argument.text &&
                                            route.filename !== _this.modulesWithRoutes[i].filename) {
                                            var argumentImportPath = ImportsUtil$1.findFilePathOfImportedVariable(argument.text, _this.modulesWithRoutes[i].filename);
                                            argumentImportPath = argumentImportPath
                                                .replace(process.cwd() + path__namespace.sep, '')
                                                .replace(/\\/g, '/');
                                            if (argument.text &&
                                                route.name === argument.text &&
                                                route.filename === argumentImportPath) {
                                                route.module = _this.modulesWithRoutes[i].name;
                                            }
                                        }
                                    });
                                });
                            }
                        });
                    }
                }
                /**
                 * direct support of for example
                 * export const HomeRoutingModule: ModuleWithProviders = RouterModule.forChild(HOME_ROUTES);
                 */
                if (tsMorph.ts.isCallExpression(node)) {
                    if (node.arguments) {
                        ___namespace.forEach(node.arguments, function (argument) {
                            ___namespace.forEach(_this.routes, function (route) {
                                if (argument.text &&
                                    route.name === argument.text &&
                                    route.filename === _this.modulesWithRoutes[i].filename) {
                                    route.module = _this.modulesWithRoutes[i].name;
                                }
                            });
                        });
                    }
                }
            });
        }
    };
    RouterParserUtil.prototype.foundRouteWithModuleName = function (moduleName) {
        return ___namespace.find(this.routes, { module: moduleName });
    };
    RouterParserUtil.prototype.foundLazyModuleWithPath = function (modulePath) {
        // path is like app/customers/customers.module#CustomersModule
        var split = modulePath.split('#');
        var lazyModuleName = split[1];
        return lazyModuleName;
    };
    RouterParserUtil.prototype.foundLazyComponentWithPath = function (componentPath) {
        // path is like app/customers/customers.component#CustomersComponent
        var split = componentPath.split('#');
        var lazyComponentName = split[1];
        return lazyComponentName;
    };
    RouterParserUtil.prototype.constructRoutesTree = function () {
        var _this = this;
        // routes[] contains routes with module link
        // modulesTree contains modules tree
        // make a final routes tree with that
        traverse$1(this.modulesTree).forEach(function (node) {
            if (node) {
                if (node.parent) {
                    delete node.parent;
                }
                if (node.initializer) {
                    delete node.initializer;
                }
                if (node.importsNode) {
                    delete node.importsNode;
                }
            }
        });
        this.cleanModulesTree = ___namespace.cloneDeep(this.modulesTree);
        var routesTree = {
            name: '<root>',
            kind: 'module',
            className: this.rootModule,
            children: []
        };
        var loopModulesParser = function (node) {
            if (node.children && node.children.length > 0) {
                // If module has child modules
                for (var i in node.children) {
                    var route = _this.foundRouteWithModuleName(node.children[i].name);
                    if (route && route.data) {
                        try {
                            route.children = JSON5__namespace.parse(route.data);
                        }
                        catch (e) {
                            logger.error('Error during generation of routes JSON file, maybe a trailing comma or an external variable inside one route.');
                        }
                        delete route.data;
                        route.kind = 'module';
                        routesTree.children.push(route);
                    }
                    if (node.children[i].children) {
                        loopModulesParser(node.children[i]);
                    }
                }
            }
            else {
                // else routes are directly inside the module
                var rawRoutes = _this.foundRouteWithModuleName(node.name);
                if (rawRoutes) {
                    var routes = JSON5__namespace.parse(rawRoutes.data);
                    if (routes) {
                        var i = 0;
                        var len = routes.length;
                        var routeAddedOnce = false;
                        for (i; i < len; i++) {
                            var route = routes[i];
                            if (routes[i].component) {
                                routeAddedOnce = true;
                                routesTree.children.push({
                                    kind: 'component',
                                    component: routes[i].component,
                                    path: routes[i].path
                                });
                            }
                        }
                        if (!routeAddedOnce) {
                            routesTree.children = __spreadArray(__spreadArray([], __read(routesTree.children), false), __read(routes), false);
                        }
                    }
                }
            }
        };
        var startModule = ___namespace.find(this.cleanModulesTree, { name: this.rootModule });
        if (startModule) {
            loopModulesParser(startModule);
            // Loop twice for routes with lazy loading
            // loopModulesParser(routesTree);
        }
        var cleanedRoutesTree = undefined;
        var cleanRoutesTree = function (route) {
            for (var i in route.children) {
                route.children[i].routes;
            }
            return route;
        };
        cleanedRoutesTree = cleanRoutesTree(routesTree);
        // Try updating routes with lazy loading
        var loopInsideModule = function (mod, _rawModule) {
            if (mod.children) {
                for (var z in mod.children) {
                    var route = _this.foundRouteWithModuleName(mod.children[z].name);
                    if (typeof route !== 'undefined') {
                        if (route.data) {
                            route.children = JSON5__namespace.parse(route.data);
                            delete route.data;
                            route.kind = 'module';
                            _rawModule.children.push(route);
                        }
                    }
                }
            }
            else {
                var route = _this.foundRouteWithModuleName(mod.name);
                if (typeof route !== 'undefined') {
                    if (route.data) {
                        route.children = JSON5__namespace.parse(route.data);
                        delete route.data;
                        route.kind = 'module';
                        _rawModule.children.push(route);
                    }
                }
            }
        };
        var loopRoutesParser = function (route) {
            if (route.children) {
                for (var i in route.children) {
                    if (route.children[i].loadChildren) {
                        var child = _this.foundLazyModuleWithPath(route.children[i].loadChildren);
                        var module_1 = ___namespace.find(_this.cleanModulesTree, {
                            name: child
                        });
                        if (module_1) {
                            var _rawModule = {};
                            _rawModule.kind = 'module';
                            _rawModule.children = [];
                            _rawModule.module = module_1.name;
                            loopInsideModule(module_1, _rawModule);
                            route.children[i].children = [];
                            route.children[i].children.push(_rawModule);
                        }
                    }
                    if (route.children[i].loadComponent) {
                        var child = _this.foundLazyComponentWithPath(route.children[i].loadComponent);
                        if (child) {
                            route.children[i].component = child;
                        }
                    }
                    loopRoutesParser(route.children[i]);
                }
            }
        };
        loopRoutesParser(cleanedRoutesTree);
        return cleanedRoutesTree;
    };
    RouterParserUtil.prototype.constructModulesTree = function () {
        var _this = this;
        var getNestedChildren = function (arr, parent) {
            var out = [];
            for (var i in arr) {
                if (arr[i].parent === parent) {
                    var children = getNestedChildren(arr, arr[i].name);
                    if (children.length) {
                        arr[i].children = children;
                    }
                    out.push(arr[i]);
                }
            }
            return out;
        };
        // Scan each module and add parent property
        ___namespace.forEach(this.modules, function (firstLoopModule) {
            ___namespace.forEach(firstLoopModule.importsNode, function (importNode) {
                ___namespace.forEach(_this.modules, function (module) {
                    if (module.name === importNode.name) {
                        module.parent = firstLoopModule.name;
                    }
                });
            });
        });
        this.modulesTree = getNestedChildren(this.modules);
    };
    RouterParserUtil.prototype.generateRoutesIndex = function (outputFolder, routes) {
        return FileEngine$1.get(__dirname + '/../src/templates/partials/routes-index.hbs').then(function (data) {
            var template = Handlebars$5.compile(data);
            var result = template({
                routes: JSON.stringify(routes)
            });
            var testOutputDir = outputFolder.match(process.cwd());
            if (testOutputDir && testOutputDir.length > 0) {
                outputFolder = outputFolder.replace(process.cwd() + path__namespace.sep, '');
            }
            return FileEngine$1.write(outputFolder + path__namespace.sep + '/js/routes/routes_index.js', result);
        }, function (err) { return Promise.reject('Error during routes index generation'); });
    };
    RouterParserUtil.prototype.routesLength = function () {
        var _n = 0;
        var routesParser = function (route) {
            if (typeof route.path !== 'undefined') {
                _n += 1;
            }
            if (route.children) {
                for (var j in route.children) {
                    routesParser(route.children[j]);
                }
            }
        };
        for (var i in this.routes) {
            routesParser(this.routes[i]);
        }
        return _n;
    };
    RouterParserUtil.prototype.printRoutes = function () {
        console.log('');
        console.log('printRoutes: ');
        console.log(this.routes);
    };
    RouterParserUtil.prototype.printModulesRoutes = function () {
        console.log('');
        console.log('printModulesRoutes: ');
        console.log(this.modulesWithRoutes);
    };
    RouterParserUtil.prototype.isVariableRoutes = function (node) {
        var result = false;
        if (node.declarationList && node.declarationList.declarations) {
            var i = 0;
            var len = node.declarationList.declarations.length;
            for (i; i < len; i++) {
                if (node.declarationList.declarations[i].type) {
                    if (node.declarationList.declarations[i].type.typeName &&
                        node.declarationList.declarations[i].type.typeName.text === 'Routes') {
                        result = true;
                    }
                }
            }
        }
        return result;
    };
    RouterParserUtil.prototype.cleanFileIdentifiers = function (sourceFile) {
        var e_1, _a, e_2, _b;
        var _this = this;
        var file = sourceFile;
        var identifiers = file.getDescendantsOfKind(tsMorph.SyntaxKind.Identifier).filter(function (p) {
            return (tsMorph.Node.isArrayLiteralExpression(p.getParentOrThrow()) ||
                tsMorph.Node.isPropertyAssignment(p.getParentOrThrow()));
        });
        var identifiersInRoutesVariableStatement = [];
        var _loop_1 = function (identifier) {
            // Loop through their parents nodes, and if one is a variableStatement and === 'routes'
            var foundParentVariableStatement = false;
            identifier.getParentWhile(function (n) {
                if (n.getKind() === tsMorph.SyntaxKind.VariableStatement) {
                    if (_this.isVariableRoutes(n.compilerNode)) {
                        foundParentVariableStatement = true;
                    }
                }
                return true;
            });
            if (foundParentVariableStatement) {
                identifiersInRoutesVariableStatement.push(identifier);
            }
        };
        try {
            for (var identifiers_1 = __values(identifiers), identifiers_1_1 = identifiers_1.next(); !identifiers_1_1.done; identifiers_1_1 = identifiers_1.next()) {
                var identifier = identifiers_1_1.value;
                _loop_1(identifier);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (identifiers_1_1 && !identifiers_1_1.done && (_a = identifiers_1.return)) _a.call(identifiers_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        try {
            // inline the property access expressions
            for (var identifiersInRoutesVariableStatement_1 = __values(identifiersInRoutesVariableStatement), identifiersInRoutesVariableStatement_1_1 = identifiersInRoutesVariableStatement_1.next(); !identifiersInRoutesVariableStatement_1_1.done; identifiersInRoutesVariableStatement_1_1 = identifiersInRoutesVariableStatement_1.next()) {
                var identifier = identifiersInRoutesVariableStatement_1_1.value;
                var identifierDeclaration = identifier
                    .getSymbolOrThrow()
                    .getValueDeclarationOrThrow();
                if (!tsMorph.Node.isPropertyAssignment(identifierDeclaration) &&
                    tsMorph.Node.isVariableDeclaration(identifierDeclaration) &&
                    tsMorph.Node.isPropertyAssignment(identifierDeclaration) &&
                    !tsMorph.Node.isVariableDeclaration(identifierDeclaration)) {
                    throw new Error("Not implemented referenced declaration kind: ".concat(identifierDeclaration.getKindName()));
                }
                if (tsMorph.Node.isVariableDeclaration(identifierDeclaration)) {
                    identifier.replaceWithText(identifierDeclaration.getInitializerOrThrow().getText());
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (identifiersInRoutesVariableStatement_1_1 && !identifiersInRoutesVariableStatement_1_1.done && (_b = identifiersInRoutesVariableStatement_1.return)) _b.call(identifiersInRoutesVariableStatement_1);
            }
            finally { if (e_2) throw e_2.error; }
        }
        return file;
    };
    RouterParserUtil.prototype.cleanFileSpreads = function (sourceFile) {
        var e_3, _a, e_4, _b;
        var _this = this;
        var file = sourceFile;
        var spreadElements = file
            .getDescendantsOfKind(tsMorph.SyntaxKind.SpreadElement)
            .filter(function (p) { return tsMorph.Node.isArrayLiteralExpression(p.getParentOrThrow()); });
        var spreadElementsInRoutesVariableStatement = [];
        var _loop_2 = function (spreadElement) {
            // Loop through their parents nodes, and if one is a variableStatement and === 'routes'
            var foundParentVariableStatement = false;
            spreadElement.getParentWhile(function (n) {
                if (n.getKind() === tsMorph.SyntaxKind.VariableStatement) {
                    if (_this.isVariableRoutes(n.compilerNode)) {
                        foundParentVariableStatement = true;
                    }
                }
                return true;
            });
            if (foundParentVariableStatement) {
                spreadElementsInRoutesVariableStatement.push(spreadElement);
            }
        };
        try {
            for (var spreadElements_1 = __values(spreadElements), spreadElements_1_1 = spreadElements_1.next(); !spreadElements_1_1.done; spreadElements_1_1 = spreadElements_1.next()) {
                var spreadElement = spreadElements_1_1.value;
                _loop_2(spreadElement);
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (spreadElements_1_1 && !spreadElements_1_1.done && (_a = spreadElements_1.return)) _a.call(spreadElements_1);
            }
            finally { if (e_3) throw e_3.error; }
        }
        var _loop_3 = function (spreadElement) {
            var spreadElementIdentifier = spreadElement.getExpression().getText(), searchedImport, aliasOriginalName = '', foundWithAliasInImports = false, foundWithAlias = false;
            // Try to find it in imports
            var imports = file.getImportDeclarations();
            imports.forEach(function (i) {
                var namedImports = i.getNamedImports(), namedImportsLength = namedImports.length, j = 0;
                if (namedImportsLength > 0) {
                    for (j; j < namedImportsLength; j++) {
                        var importName = namedImports[j].getNameNode().getText(), importAlias = void 0;
                        if (namedImports[j].getAliasNode()) {
                            importAlias = namedImports[j].getAliasNode().getText();
                        }
                        if (importName === spreadElementIdentifier) {
                            foundWithAliasInImports = true;
                            searchedImport = i;
                            break;
                        }
                        if (importAlias === spreadElementIdentifier) {
                            foundWithAliasInImports = true;
                            foundWithAlias = true;
                            aliasOriginalName = importName;
                            searchedImport = i;
                            break;
                        }
                    }
                }
            });
            var referencedDeclaration = void 0;
            if (foundWithAliasInImports) {
                if (typeof searchedImport !== 'undefined') {
                    var routePathIsBad = function (path) {
                        var result = _this.scannedFiles.find(function (scannedFile) { return path === scannedFile.path; });
                        return !result;
                    };
                    var getIndicesOf = function (searchStr, str, caseSensitive) {
                        var searchStrLen = searchStr.length;
                        if (searchStrLen == 0) {
                            return [];
                        }
                        var startIndex = 0, index, indices = [];
                        if (!caseSensitive) {
                            str = str.toLowerCase();
                            searchStr = searchStr.toLowerCase();
                        }
                        while ((index = str.indexOf(searchStr, startIndex)) > -1) {
                            indices.push(index);
                            startIndex = index + searchStrLen;
                        }
                        return indices;
                    };
                    var dirNamePath = path__namespace.dirname(file.getFilePath());
                    var searchedImportPath = searchedImport.getModuleSpecifierValue();
                    var leadingFilePath = searchedImportPath.split('/').shift();
                    var importPath = path__namespace.resolve(dirNamePath + '/' + searchedImport.getModuleSpecifierValue() + '.ts');
                    if (routePathIsBad(importPath)) {
                        var leadingIndices = getIndicesOf(leadingFilePath, importPath, true);
                        if (leadingIndices.length > 1) {
                            // Nested route fixes
                            var startIndex = leadingIndices[0];
                            var endIndex = leadingIndices[leadingIndices.length - 1];
                            importPath =
                                importPath.slice(0, startIndex) + importPath.slice(endIndex);
                        }
                        else {
                            // Top level route fixes
                            importPath =
                                path__namespace.dirname(dirNamePath) + '/' + searchedImportPath + '.ts';
                        }
                    }
                    var sourceFileImport = typeof ast.getSourceFile(importPath) !== 'undefined'
                        ? ast.getSourceFile(importPath)
                        : ast.addSourceFileAtPath(importPath);
                    if (sourceFileImport) {
                        var variableName = foundWithAlias
                            ? aliasOriginalName
                            : spreadElementIdentifier;
                        referencedDeclaration =
                            sourceFileImport.getVariableDeclaration(variableName);
                    }
                }
            }
            else {
                // if not, try directly in file
                referencedDeclaration = spreadElement
                    .getExpression()
                    .getSymbolOrThrow()
                    .getValueDeclarationOrThrow();
            }
            if (!tsMorph.Node.isVariableDeclaration(referencedDeclaration)) {
                throw new Error("Not implemented referenced declaration kind: ".concat(referencedDeclaration.getKindName()));
            }
            var referencedArray = referencedDeclaration.getInitializerIfKindOrThrow(tsMorph.SyntaxKind.ArrayLiteralExpression);
            var spreadElementArray = spreadElement.getParentIfKindOrThrow(tsMorph.SyntaxKind.ArrayLiteralExpression);
            var insertIndex = spreadElementArray.getElements().indexOf(spreadElement);
            spreadElementArray.removeElement(spreadElement);
            spreadElementArray.insertElements(insertIndex, referencedArray.getElements().map(function (e) { return e.getText(); }));
        };
        try {
            // inline the ArrayLiteralExpression SpreadElements
            for (var spreadElementsInRoutesVariableStatement_1 = __values(spreadElementsInRoutesVariableStatement), spreadElementsInRoutesVariableStatement_1_1 = spreadElementsInRoutesVariableStatement_1.next(); !spreadElementsInRoutesVariableStatement_1_1.done; spreadElementsInRoutesVariableStatement_1_1 = spreadElementsInRoutesVariableStatement_1.next()) {
                var spreadElement = spreadElementsInRoutesVariableStatement_1_1.value;
                _loop_3(spreadElement);
            }
        }
        catch (e_4_1) { e_4 = { error: e_4_1 }; }
        finally {
            try {
                if (spreadElementsInRoutesVariableStatement_1_1 && !spreadElementsInRoutesVariableStatement_1_1.done && (_b = spreadElementsInRoutesVariableStatement_1.return)) _b.call(spreadElementsInRoutesVariableStatement_1);
            }
            finally { if (e_4) throw e_4.error; }
        }
        return file;
    };
    RouterParserUtil.prototype.cleanFileDynamics = function (sourceFile) {
        var e_5, _a, e_6, _b;
        var _this = this;
        var file = sourceFile;
        var propertyAccessExpressions = file
            .getDescendantsOfKind(tsMorph.SyntaxKind.PropertyAccessExpression)
            .filter(function (p) { return !tsMorph.Node.isPropertyAccessExpression(p.getParentOrThrow()); });
        var propertyAccessExpressionsInRoutesVariableStatement = [];
        var _loop_4 = function (propertyAccessExpression) {
            // Loop through their parents nodes, and if one is a variableStatement and === 'routes'
            var foundParentVariableStatement = false;
            propertyAccessExpression.getParentWhile(function (n) {
                if (n.getKind() === tsMorph.SyntaxKind.VariableStatement) {
                    if (_this.isVariableRoutes(n.compilerNode)) {
                        foundParentVariableStatement = true;
                    }
                }
                return true;
            });
            if (foundParentVariableStatement) {
                propertyAccessExpressionsInRoutesVariableStatement.push(propertyAccessExpression);
            }
        };
        try {
            for (var propertyAccessExpressions_1 = __values(propertyAccessExpressions), propertyAccessExpressions_1_1 = propertyAccessExpressions_1.next(); !propertyAccessExpressions_1_1.done; propertyAccessExpressions_1_1 = propertyAccessExpressions_1.next()) {
                var propertyAccessExpression = propertyAccessExpressions_1_1.value;
                _loop_4(propertyAccessExpression);
            }
        }
        catch (e_5_1) { e_5 = { error: e_5_1 }; }
        finally {
            try {
                if (propertyAccessExpressions_1_1 && !propertyAccessExpressions_1_1.done && (_a = propertyAccessExpressions_1.return)) _a.call(propertyAccessExpressions_1);
            }
            finally { if (e_5) throw e_5.error; }
        }
        try {
            // inline the property access expressions
            for (var propertyAccessExpressionsInRoutesVariableStatement_1 = __values(propertyAccessExpressionsInRoutesVariableStatement), propertyAccessExpressionsInRoutesVariableStatement_1_1 = propertyAccessExpressionsInRoutesVariableStatement_1.next(); !propertyAccessExpressionsInRoutesVariableStatement_1_1.done; propertyAccessExpressionsInRoutesVariableStatement_1_1 = propertyAccessExpressionsInRoutesVariableStatement_1.next()) {
                var propertyAccessExpression = propertyAccessExpressionsInRoutesVariableStatement_1_1.value;
                var propertyAccessExpressionNodeName = propertyAccessExpression.getNameNode();
                if (propertyAccessExpressionNodeName) {
                    try {
                        var propertyAccessExpressionNodeNameSymbol = propertyAccessExpressionNodeName.getSymbolOrThrow();
                        if (propertyAccessExpressionNodeNameSymbol) {
                            var referencedDeclaration = propertyAccessExpressionNodeNameSymbol.getValueDeclarationOrThrow();
                            if (!tsMorph.Node.isPropertyAssignment(referencedDeclaration) &&
                                tsMorph.Node.isEnumMember(referencedDeclaration) &&
                                tsMorph.Node.isPropertyAssignment(referencedDeclaration) &&
                                !tsMorph.Node.isEnumMember(referencedDeclaration)) {
                                throw new Error("Not implemented referenced declaration kind: ".concat(referencedDeclaration.getKindName()));
                            }
                            if (typeof referencedDeclaration.getInitializerOrThrow !== 'undefined') {
                                propertyAccessExpression.replaceWithText(referencedDeclaration.getInitializerOrThrow().getText());
                            }
                        }
                    }
                    catch (e) { }
                }
            }
        }
        catch (e_6_1) { e_6 = { error: e_6_1 }; }
        finally {
            try {
                if (propertyAccessExpressionsInRoutesVariableStatement_1_1 && !propertyAccessExpressionsInRoutesVariableStatement_1_1.done && (_b = propertyAccessExpressionsInRoutesVariableStatement_1.return)) _b.call(propertyAccessExpressionsInRoutesVariableStatement_1);
            }
            finally { if (e_6) throw e_6.error; }
        }
        return file;
    };
    /**
     * replace callexpressions with string : utils.doWork() -> 'utils.doWork()' doWork() -> 'doWork()'
     * @param sourceFile ts.SourceFile
     */
    RouterParserUtil.prototype.cleanCallExpressions = function (sourceFile) {
        var e_7, _a;
        var file = sourceFile;
        var variableStatements = sourceFile.getVariableDeclaration(function (v) {
            var result = false;
            var type = v.compilerNode.type;
            if (typeof type !== 'undefined' && typeof type.typeName !== 'undefined') {
                result = type.typeName.text === 'Routes';
            }
            return result;
        });
        var initializer = variableStatements.getInitializer();
        var _loop_5 = function (callExpr) {
            if (callExpr.wasForgotten()) {
                return "continue";
            }
            callExpr.replaceWithText(function (writer) { return writer.quote(callExpr.getText()); });
        };
        try {
            for (var _b = __values(initializer.getDescendantsOfKind(tsMorph.SyntaxKind.CallExpression)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var callExpr = _c.value;
                _loop_5(callExpr);
            }
        }
        catch (e_7_1) { e_7 = { error: e_7_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_7) throw e_7.error; }
        }
        return file;
    };
    /**
     * Clean routes definition with imported data, for example path, children, or dynamic stuff inside data
     *
     * const MY_ROUTES: Routes = [
     *     {
     *         path: 'home',
     *         component: HomeComponent
     *     },
     *     {
     *         path: PATHS.home,
     *         component: HomeComponent
     *     }
     * ];
     *
     * The initializer is an array (ArrayLiteralExpression - 177 ), it has elements, objects (ObjectLiteralExpression - 178)
     * with properties (PropertyAssignment - 261)
     *
     * For each know property (https://angular.io/api/router/Routes#description), we try to see if we have what we want
     *
     * Ex: path and pathMatch want a string, component a component reference.
     *
     * It is an imperative approach, not a generic way, parsing all the tree
     * and find something like this which willl break JSON.stringify : MYIMPORT.path
     *
     * @param  {ts.Node} initializer The node of routes definition
     * @return {ts.Node}             The edited node
     */
    RouterParserUtil.prototype.cleanRoutesDefinitionWithImport = function (initializer, node, sourceFile) {
        initializer.elements.forEach(function (element) {
            element.properties.forEach(function (property) {
                var propertyName = property.name.getText(), propertyInitializer = property.initializer;
                switch (propertyName) {
                    case 'path':
                    case 'redirectTo':
                    case 'outlet':
                    case 'pathMatch':
                        if (propertyInitializer) {
                            if (propertyInitializer.kind !== tsMorph.SyntaxKind.StringLiteral) {
                                // Identifier(71) won't break parsing, but it will be better to retrive them
                                // PropertyAccessExpression(179) ex: MYIMPORT.path will break it, find it in import
                                if (propertyInitializer.kind === tsMorph.SyntaxKind.PropertyAccessExpression) {
                                    var lastObjectLiteralAttributeName = propertyInitializer.name.getText(), firstObjectLiteralAttributeName = void 0;
                                    if (propertyInitializer.expression) {
                                        firstObjectLiteralAttributeName =
                                            propertyInitializer.expression.getText();
                                        var result = ImportsUtil$1.findPropertyValueInImportOrLocalVariables(firstObjectLiteralAttributeName +
                                            '.' +
                                            lastObjectLiteralAttributeName, sourceFile); // tslint:disable-line
                                        if (result !== '') {
                                            propertyInitializer.kind = 9;
                                            propertyInitializer.text = result;
                                        }
                                    }
                                }
                            }
                        }
                        break;
                }
            });
        });
        return initializer;
    };
    return RouterParserUtil;
}());
var RouterParserUtil$1 = RouterParserUtil.getInstance();

function isModuleWithProviders(node) {
    var result = false;
    if (node.declarationList) {
        if (node.declarationList.declarations && node.declarationList.declarations.length > 0) {
            var i = 0; node.declarationList.declarations; var len = node.declarationList.declarations.length;
            for (i; i < len; i++) {
                var declaration = node.declarationList.declarations[i];
                if (declaration.type) {
                    var type = declaration.type;
                    if (type.typeName) {
                        var text = type.typeName.getText();
                        if (text === 'ModuleWithProviders') {
                            result = true;
                        }
                    }
                }
            }
        }
    }
    return result;
}

function getModuleWithProviders(node) {
    var result;
    if (node.declarationList) {
        if (node.declarationList.declarations && node.declarationList.declarations.length > 0) {
            var i = 0, len = node.declarationList.declarations.length;
            for (i; i < len; i++) {
                var declaration = node.declarationList.declarations[i];
                if (declaration.type) {
                    var type = declaration.type;
                    if (type.typeName) {
                        var text = type.typeName.getText();
                        if (text === 'ModuleWithProviders') {
                            result = declaration.initializer;
                        }
                    }
                }
            }
        }
    }
    return result;
}

var ExtendsMerger = /** @class */ (function () {
    function ExtendsMerger() {
    }
    ExtendsMerger.getInstance = function () {
        if (!ExtendsMerger.instance) {
            ExtendsMerger.instance = new ExtendsMerger();
        }
        return ExtendsMerger.instance;
    };
    ExtendsMerger.prototype.merge = function (deps) {
        var _this = this;
        this.components = deps.components;
        this.classes = deps.classes;
        this.injectables = deps.injectables;
        this.directives = deps.directives;
        this.controllers = deps.controllers;
        this.aliases = deps.aliases;
        var mergeExtendedProperties = function (component) {
            var ext;
            if (typeof component.extends !== 'undefined') {
                ext = _this.findInDependencies(component.extends[0]);
                if (ext) {
                    var recursiveScanWithInheritance_1 = function (cls) {
                        // From class to component
                        if (typeof cls.methods !== 'undefined' && cls.methods.length > 0) {
                            var newMethods = _.cloneDeep(cls.methods);
                            newMethods = _this.markInheritance(newMethods, cls);
                            if (typeof component.methodsClass !== 'undefined') {
                                _this.mergeInheritance(component, 'methodsClass', newMethods);
                            }
                        }
                        if (typeof cls.properties !== 'undefined' && cls.properties.length > 0) {
                            var newProperties = _.cloneDeep(cls.properties);
                            newProperties = _this.markInheritance(newProperties, cls);
                            if (typeof component.propertiesClass !== 'undefined') {
                                _this.mergeInheritance(component, 'propertiesClass', newProperties);
                            }
                        }
                        // From component to component or directive to component
                        if (typeof cls.inputsClass !== 'undefined' && cls.inputsClass.length > 0) {
                            var newInputs = _.cloneDeep(cls.inputsClass);
                            newInputs = _this.markInheritance(newInputs, cls);
                            if (typeof component.inputsClass !== 'undefined') {
                                _this.mergeInheritance(component, 'inputsClass', newInputs);
                            }
                        }
                        if (typeof cls.outputsClass !== 'undefined' &&
                            cls.outputsClass.length > 0) {
                            var newOutputs = _.cloneDeep(cls.outputsClass);
                            newOutputs = _this.markInheritance(newOutputs, cls);
                            if (typeof component.outputsClass !== 'undefined') {
                                _this.mergeInheritance(component, 'outputsClass', newOutputs);
                            }
                        }
                        if (typeof cls.methodsClass !== 'undefined' &&
                            cls.methodsClass.length > 0) {
                            var newMethods = _.cloneDeep(cls.methodsClass);
                            newMethods = _this.markInheritance(newMethods, cls);
                            if (typeof component.methodsClass !== 'undefined') {
                                _this.mergeInheritance(component, 'methodsClass', newMethods);
                            }
                        }
                        if (typeof cls.propertiesClass !== 'undefined' &&
                            cls.propertiesClass.length > 0) {
                            var newProperties = _.cloneDeep(cls.propertiesClass);
                            newProperties = _this.markInheritance(newProperties, cls);
                            if (typeof component.propertiesClass !== 'undefined') {
                                _this.mergeInheritance(component, 'propertiesClass', newProperties);
                            }
                        }
                        if (typeof cls.hostBindings !== 'undefined' &&
                            cls.hostBindings.length > 0) {
                            var newHostBindings = _.cloneDeep(cls.hostBindings);
                            newHostBindings = _this.markInheritance(newHostBindings, cls);
                            if (typeof component.hostBindings !== 'undefined') {
                                _this.mergeInheritance(component, 'hostBindings', newHostBindings);
                            }
                        }
                        if (typeof cls.hostListeners !== 'undefined' &&
                            cls.hostListeners.length > 0) {
                            var newHostListeners = _.cloneDeep(cls.hostListeners);
                            newHostListeners = _this.markInheritance(newHostListeners, cls);
                            if (typeof component.hostListeners !== 'undefined') {
                                _this.mergeInheritance(component, 'hostListeners', newHostListeners);
                            }
                        }
                        if (Configuration$1.mainData.disableLifeCycleHooks) {
                            component.methodsClass = cleanLifecycleHooksFromMethods(component.methodsClass);
                        }
                        if (cls.extends) {
                            recursiveScanWithInheritance_1(_this.findInDependencies(cls.extends[0]));
                        }
                    };
                    // From class to class
                    recursiveScanWithInheritance_1(ext);
                }
            }
        };
        this.components.forEach(mergeExtendedProperties);
        this.directives.forEach(mergeExtendedProperties);
        this.controllers.forEach(mergeExtendedProperties);
        var mergeExtendedClasses = function (el) {
            var ext;
            if (typeof el.extends !== 'undefined') {
                ext = _this.findInDependencies(el.extends[0]);
                if (ext) {
                    var recursiveScanWithInheritance_2 = function (cls) {
                        if (typeof cls.methods !== 'undefined' && cls.methods.length > 0) {
                            var newMethods = _.cloneDeep(cls.methods);
                            newMethods = _this.markInheritance(newMethods, cls);
                            if (typeof el.methods !== 'undefined') {
                                _this.mergeInheritance(el, 'methods', newMethods);
                            }
                        }
                        if (typeof cls.properties !== 'undefined' && cls.properties.length > 0) {
                            var newProperties = _.cloneDeep(cls.properties);
                            newProperties = _this.markInheritance(newProperties, cls);
                            if (typeof el.properties !== 'undefined') {
                                _this.mergeInheritance(el, 'properties', newProperties);
                            }
                        }
                        if (cls.extends) {
                            recursiveScanWithInheritance_2(_this.findInDependencies(cls.extends[0]));
                        }
                    };
                    // From elss to elss
                    recursiveScanWithInheritance_2(ext);
                }
            }
        };
        this.classes.forEach(mergeExtendedClasses);
        this.injectables.forEach(mergeExtendedClasses);
        this.directives.forEach(mergeExtendedClasses);
        this.controllers.forEach(mergeExtendedClasses);
        return deps;
    };
    ExtendsMerger.prototype.markInheritance = function (data, originalource) {
        return data.map(function (el) {
            var newElement = el;
            newElement.inheritance = {
                file: originalource.name
            };
            return newElement;
        });
    };
    ExtendsMerger.prototype.mergeInheritance = function (component, metaPropertyId, newMembers) {
        newMembers.forEach(function (newMember) {
            var overriddenMethod = component[metaPropertyId].find(function (componentMember) { return componentMember.name === newMember.name; });
            if (overriddenMethod) {
                overriddenMethod.inheritance = newMember.inheritance;
            }
            else {
                component[metaPropertyId].push(newMember);
            }
        });
    };
    ExtendsMerger.prototype.findInDependencies = function (name) {
        var mergedData = _.concat([], this.components, this.classes, this.injectables, this.directives, this.controllers);
        var result = _.find(mergedData, { name: name });
        // Find in aliases ?
        if (!result) {
            var aliases = Object.values(this.aliases);
            var isInAlias = aliases.includes(name);
            if (isInAlias) {
                var finalOriginalName = this.findInAliases(name);
                if (finalOriginalName) {
                    result = _.find(mergedData, { name: finalOriginalName });
                }
            }
        }
        return result || false;
    };
    ExtendsMerger.prototype.findInAliases = function (name) {
        var finalOriginalName = null;
        for (var originalName in this.aliases) {
            if (this.aliases[originalName].includes(name)) {
                finalOriginalName = originalName;
            }
        }
        return finalOriginalName;
    };
    return ExtendsMerger;
}());
var ExtendsMerger$1 = ExtendsMerger.getInstance();

var LinkTypeHelper = /** @class */ (function () {
    function LinkTypeHelper() {
    }
    LinkTypeHelper.prototype.helperFunc = function (context, name, options) {
        var _result = DependenciesEngine$1.find(name);
        // Find in aliases ?
        if (!_result) {
            var potentialAlias = ExtendsMerger$1.findInAliases(name);
            if (potentialAlias) {
                _result = DependenciesEngine$1.find(potentialAlias);
            }
        }
        var angularDocPrefix = AngularVersionUtil$1.prefixOfficialDoc(Configuration$1.mainData.angularVersion);
        if (_result) {
            context.type = {
                raw: name,
                indexKey: ''
            };
            if (_result.source === 'internal') {
                if (_result.data.type === 'class') {
                    _result.data.type = 'classe';
                }
                context.type.href = '../' + _result.data.type + 's/' + _result.data.name + '.html';
                if (context.indexKey !== '' && context.indexKey !== undefined) {
                    context.type.href += '#' + context.indexKey;
                    context.type.indexKey = context.indexKey;
                }
                if (_result.data.type === 'miscellaneous' ||
                    (_result.data.ctype && _result.data.ctype === 'miscellaneous')) {
                    var mainpage = '';
                    switch (_result.data.subtype) {
                        case 'enum':
                            mainpage = 'enumerations';
                            break;
                        case 'function':
                            mainpage = 'functions';
                            break;
                        case 'typealias':
                            mainpage = 'typealiases';
                            break;
                        case 'variable':
                            mainpage = 'variables';
                    }
                    context.type.href = '../' + _result.data.ctype + '/' + mainpage + '.html';
                    if (_result.data && _result.data.name) {
                        context.type.href += '#' + _result.data.name;
                    }
                }
                if (!context.type.indexKey) {
                    context.type.indexKey = '';
                }
                context.type.target = '_self';
            }
            else {
                context.type.href = "https://".concat(angularDocPrefix, "angular.io/").concat(_result.data.path);
                context.type.target = '_blank';
            }
            return options.fn(context);
        }
        else if (BasicTypeUtil$1.isKnownType(name)) {
            context.type = {
                raw: name,
                indexKey: ''
            };
            context.type.target = '_blank';
            context.type.href = BasicTypeUtil$1.getTypeUrl(name);
            return options.fn(context);
        }
        else {
            return options.inverse(context);
        }
    };
    return LinkTypeHelper;
}());

var ModifIconHelper = /** @class */ (function () {
    function ModifIconHelper() {
    }
    ModifIconHelper.prototype.helperFunc = function (context, kind) {
        var _kindText = '';
        switch (kind) {
            case tsMorph.SyntaxKind.PrivateKeyword:
                _kindText = 'lock'; // private
                break;
            case tsMorph.SyntaxKind.ProtectedKeyword:
                _kindText = 'lock'; // protected
                break;
            case tsMorph.SyntaxKind.StaticKeyword:
                _kindText = 'reset'; // static
                break;
            case tsMorph.SyntaxKind.ExportKeyword:
                _kindText = 'export'; // export
                break;
            default:
                _kindText = 'reset';
                break;
        }
        return _kindText;
    };
    return ModifIconHelper;
}());

var Handlebars$4 = require('handlebars');
var ModifKindHelper = /** @class */ (function () {
    function ModifKindHelper() {
    }
    /**
     * Transform SyntaxKind into string
     * @param  {any}           context Handlebars context
     * @param  {SyntaxKind[]} kind  SyntaxKind concatenated
     * @return {string}                Parsed string
     */
    ModifKindHelper.prototype.helperFunc = function (context, kind) {
        var _kindText = '';
        switch (kind) {
            case tsMorph.SyntaxKind.PrivateKeyword:
                _kindText = 'Private';
                break;
            case tsMorph.SyntaxKind.ReadonlyKeyword:
                _kindText = 'Readonly';
                break;
            case tsMorph.SyntaxKind.ProtectedKeyword:
                _kindText = 'Protected';
                break;
            case tsMorph.SyntaxKind.PublicKeyword:
                _kindText = 'Public';
                break;
            case tsMorph.SyntaxKind.StaticKeyword:
                _kindText = 'Static';
                break;
            case tsMorph.SyntaxKind.AsyncKeyword:
                _kindText = 'Async';
                break;
            case tsMorph.SyntaxKind.AbstractKeyword:
                _kindText = 'Abstract';
                break;
        }
        return new Handlebars$4.SafeString(_kindText);
    };
    return ModifKindHelper;
}());

var ObjectLengthHelper = /** @class */ (function () {
    function ObjectLengthHelper() {
    }
    ObjectLengthHelper.prototype.helperFunc = function (context, obj, operator, length) {
        var len = arguments.length - 1;
        var options = arguments[len];
        if (typeof obj !== 'object') {
            return options.inverse(context);
        }
        var size = 0, key;
        for (key in obj) {
            if (obj.hasOwnProperty(key)) {
                size++;
            }
        }
        var result;
        switch (operator) {
            case '===':
                result = size === length;
                break;
            case '!==':
                result = size !== length;
                break;
            case '>':
                result = size > length;
                break;
            default: {
                throw new Error('helper {{objectLength}}: invalid operator: `' + operator + '`');
            }
        }
        if (result === false) {
            return options.inverse(context);
        }
        return options.fn(context);
    };
    return ObjectLengthHelper;
}());

var Handlebars$3 = require('handlebars');
var ObjectHelper = /** @class */ (function () {
    function ObjectHelper() {
    }
    ObjectHelper.prototype.helperFunc = function (context, text) {
        text = JSON.stringify(text);
        text = text.replace(/{"/, '{<br>&nbsp;&nbsp;&nbsp;&nbsp;"');
        text = text.replace(/,"/, ',<br>&nbsp;&nbsp;&nbsp;&nbsp;"');
        text = text.replace(/}$/, '<br>}');
        return new Handlebars$3.SafeString(text);
    };
    return ObjectHelper;
}());

var OneParameterHasHelper = /** @class */ (function () {
    function OneParameterHasHelper() {
    }
    OneParameterHasHelper.prototype.helperFunc = function (context, tags, typeToCheck) {
        var result = false;
        var len = arguments.length - 1;
        var options = arguments[len];
        var i = 0, leng = tags.length;
        for (i; i < leng; i++) {
            if (typeof tags[i][typeToCheck] !== 'undefined' && tags[i][typeToCheck] !== '') {
                result = true;
            }
        }
        if (result) {
            return options.fn(context);
        }
        else {
            return options.inverse(context);
        }
    };
    return OneParameterHasHelper;
}());

var OrLengthHelper = /** @class */ (function () {
    function OrLengthHelper() {
    }
    OrLengthHelper.prototype.helperFunc = function (context /* any, any, ..., options */) {
        var len = arguments.length - 1;
        var options = arguments[len];
        // We start at 1 because of options
        for (var i = 1; i < len; i++) {
            if (typeof arguments[i] !== 'undefined') {
                if (Object.keys(arguments[i]).length > 0) {
                    return options.fn(context);
                }
            }
        }
        return options.inverse(context);
    };
    return OrLengthHelper;
}());

var OrHelper = /** @class */ (function () {
    function OrHelper() {
    }
    OrHelper.prototype.helperFunc = function (context /* any, any, ..., options */) {
        var len = arguments.length - 1;
        var options = arguments[len];
        // We start at 1 because of options
        for (var i = 1; i < len; i++) {
            if (arguments[i]) {
                return options.fn(context);
            }
        }
        return options.inverse(context);
    };
    return OrHelper;
}());

var ParseDescriptionHelper = /** @class */ (function () {
    function ParseDescriptionHelper() {
    }
    ParseDescriptionHelper.prototype.helperFunc = function (context, description, depth) {
        var tagRegExpLight = new RegExp('\\{@link\\s+((?:.|\n)+?)\\}', 'i');
        var tagRegExpFull = new RegExp('\\{@link\\s+((?:.|\n)+?)\\}', 'i');
        var tagRegExp;
        var matches;
        var previousString;
        tagRegExp = description.indexOf(']{') !== -1 ? tagRegExpFull : tagRegExpLight;
        var processTheLink = function (originalDescription, matchedTag, leadingText) {
            var leading = extractLeadingText(originalDescription, matchedTag.completeTag);
            var split;
            var resultInCompodoc;
            var newLink;
            var rootPath;
            var stringtoReplace;
            var anchor = '';
            var label;
            var pageName;
            split = splitLinkText(matchedTag.text);
            if (typeof split.linkText !== 'undefined') {
                resultInCompodoc = DependenciesEngine$1.findInCompodoc(split.target);
            }
            else {
                var info = matchedTag.text;
                if (matchedTag.text.indexOf('#') !== -1) {
                    anchor = matchedTag.text.substr(matchedTag.text.indexOf('#'), matchedTag.text.length);
                    info = matchedTag.text.substr(0, matchedTag.text.indexOf('#'));
                }
                resultInCompodoc = DependenciesEngine$1.findInCompodoc(info);
            }
            if (resultInCompodoc) {
                label = resultInCompodoc.name;
                pageName = resultInCompodoc.name;
                if (leadingText) {
                    stringtoReplace = '[' + leadingText + ']' + matchedTag.completeTag;
                }
                else if (leading.leadingText !== undefined) {
                    stringtoReplace = '[' + leading.leadingText + ']' + matchedTag.completeTag;
                }
                else if (typeof split.linkText !== 'undefined') {
                    stringtoReplace = matchedTag.completeTag;
                }
                else {
                    stringtoReplace = matchedTag.completeTag;
                }
                if (resultInCompodoc.type === 'class') {
                    resultInCompodoc.type = 'classes';
                }
                else if (resultInCompodoc.type === 'miscellaneous' ||
                    (resultInCompodoc.ctype && resultInCompodoc.ctype === 'miscellaneous')) {
                    resultInCompodoc.type = 'miscellaneous'; // Not a typo, it is for matching other single types : component, module etc
                    label = resultInCompodoc.name;
                    anchor = '#' + resultInCompodoc.name;
                    if (resultInCompodoc.subtype === 'enum') {
                        pageName = 'enumerations';
                    }
                    else if (resultInCompodoc.subtype === 'function') {
                        pageName = 'functions';
                    }
                    else if (resultInCompodoc.subtype === 'typealias') {
                        pageName = 'typealiases';
                    }
                    else if (resultInCompodoc.subtype === 'variable') {
                        pageName = 'variables';
                    }
                }
                rootPath = '';
                switch (depth) {
                    case 0:
                        rootPath = './';
                        break;
                    case 1:
                    case 2:
                    case 3:
                    case 4:
                    case 5:
                        rootPath = '../'.repeat(depth);
                        break;
                }
                if (leading.leadingText !== undefined) {
                    label = leading.leadingText;
                }
                if (typeof split.linkText !== 'undefined') {
                    label = split.linkText;
                }
                if (resultInCompodoc.type === 'miscellaneous' ||
                    resultInCompodoc.type === 'classes') {
                    newLink = "<a href=\"".concat(rootPath).concat(resultInCompodoc.type, "/").concat(pageName, ".html").concat(anchor, "\">").concat(label, "</a>");
                }
                else {
                    newLink = "<a href=\"".concat(rootPath).concat(resultInCompodoc.type, "s/").concat(pageName, ".html").concat(anchor, "\">").concat(label, "</a>");
                }
                return originalDescription.replace(stringtoReplace, newLink);
            }
            else if (!resultInCompodoc && typeof split.linkText !== 'undefined') {
                newLink = "<a href=\"".concat(split.target, "\">").concat(split.linkText, "</a>");
                if (leadingText) {
                    stringtoReplace = '[' + leadingText + ']' + matchedTag.completeTag;
                }
                else if (leading.leadingText !== undefined) {
                    stringtoReplace = '[' + leading.leadingText + ']' + matchedTag.completeTag;
                }
                else if (typeof split.linkText !== 'undefined') {
                    stringtoReplace = matchedTag.completeTag;
                }
                else {
                    stringtoReplace = matchedTag.completeTag;
                }
                return originalDescription.replace(stringtoReplace, newLink);
            }
            else if (!resultInCompodoc && leading && typeof leading.leadingText !== 'undefined') {
                newLink = "<a href=\"".concat(split.target, "\">").concat(leading.leadingText, "</a>");
                if (leadingText) {
                    stringtoReplace = '[' + leadingText + ']' + matchedTag.completeTag;
                }
                else if (leading.leadingText !== undefined) {
                    stringtoReplace = '[' + leading.leadingText + ']' + matchedTag.completeTag;
                }
                else if (typeof split.linkText !== 'undefined') {
                    stringtoReplace = matchedTag.completeTag;
                }
                else {
                    stringtoReplace = matchedTag.completeTag;
                }
                return originalDescription.replace(stringtoReplace, newLink);
            }
            else if (!resultInCompodoc && typeof split.linkText === 'undefined') {
                newLink = "<a href=\"".concat(split.target, "\">").concat(split.target, "</a>");
                if (leadingText) {
                    stringtoReplace = '[' + leadingText + ']' + matchedTag.completeTag;
                }
                else if (leading.leadingText !== undefined) {
                    stringtoReplace = '[' + leading.leadingText + ']' + matchedTag.completeTag;
                }
                else {
                    stringtoReplace = matchedTag.completeTag;
                }
                return originalDescription.replace(stringtoReplace, newLink);
            }
            else {
                return originalDescription;
            }
        };
        function replaceMatch(replacer, tag, match, text, linkText) {
            var matchedTag = {
                completeTag: match,
                tag: tag,
                text: text
            };
            if (linkText) {
                return replacer(description, matchedTag, linkText);
            }
            else {
                return replacer(description, matchedTag);
            }
        }
        // Clean description for marked a tag parsed too early
        if (description.indexOf('href=') !== -1) {
            var insideMarkedATagResults = description.match(/<a [^>]+>([^<]+)<\/a>/g);
            if (insideMarkedATagResults && insideMarkedATagResults.length > 0) {
                for (var i = 0; i < insideMarkedATagResults.length; i++) {
                    var markedATagRegExp = new RegExp('<a [^>]+>([^<]+)</a>', 'gm');
                    var parsedATag = markedATagRegExp.exec(description);
                    if (parsedATag && parsedATag.length === 2) {
                        var insideMarkedATag = parsedATag[1];
                        description = description.replace("{@link <a href=\"".concat(encodeURI(insideMarkedATag), "\">").concat(insideMarkedATag, "</a>"), "{@link ".concat(insideMarkedATag));
                    }
                }
            }
        }
        do {
            matches = tagRegExp.exec(description);
            // Did we have {@link ?
            if (matches) {
                previousString = description;
                if (matches.length === 2) {
                    description = replaceMatch(processTheLink, 'link', matches[0], matches[1]);
                }
                if (matches.length === 3) {
                    description = replaceMatch(processTheLink, 'link', matches[0], matches[2], matches[1]);
                }
            }
        } while (matches && previousString !== description);
        return description;
    };
    return ParseDescriptionHelper;
}());

require('handlebars');
var ParsePropertyHelper = /** @class */ (function () {
    function ParsePropertyHelper() {
    }
    ParsePropertyHelper.prototype.helperFunc = function (context, text) {
        var prop = text;
        if (!!text && text.constructor === Object && text['url'] !== undefined) {
            prop = text['url'];
        }
        if (!!text && text.constructor === Object && text['name'] !== undefined) {
            prop = text['name'];
        }
        if (!!text && text.constructor === Object && Object.keys(text).length === 0) {
            prop = '';
        }
        if (prop instanceof String && prop !== '' && prop.indexOf('https') !== -1) {
            return "<a href=\"".concat(prop, "\" target=\"_blank\">").concat(prop, "</a>");
        }
        else if (prop !== '' && prop instanceof Array && prop.length > 0) {
            prop = JSON.stringify(prop);
            prop = prop.replace(/","/g, ', ');
            prop = prop.replace(/\["/g, '');
            prop = prop.replace(/"]/g, '');
            return prop;
        }
        else {
            return prop;
        }
    };
    return ParsePropertyHelper;
}());

var RelativeURLHelper = /** @class */ (function () {
    function RelativeURLHelper() {
    }
    RelativeURLHelper.prototype.helperFunc = function (context, currentDepth, options) {
        switch (currentDepth) {
            case 0:
                return './';
            case 1:
            case 2:
            case 3:
            case 4:
            case 5:
                return '../'.repeat(currentDepth);
        }
        return '';
    };
    return RelativeURLHelper;
}());

var ShortURLHelper = /** @class */ (function () {
    function ShortURLHelper() {
    }
    ShortURLHelper.prototype.helperFunc = function (context, url, options) {
        var newUrl = url;
        var firstIndexOfSlash = newUrl.indexOf('/');
        var lastIndexOfSlash = newUrl.lastIndexOf('/');
        if (firstIndexOfSlash !== -1 || lastIndexOfSlash !== -1) {
            newUrl =
                newUrl.substr(0, firstIndexOfSlash + 1) +
                    '...' +
                    newUrl.substr(lastIndexOfSlash, newUrl.length);
        }
        return newUrl;
    };
    return ShortURLHelper;
}());

var StripURLHelper = /** @class */ (function () {
    function StripURLHelper() {
    }
    StripURLHelper.prototype.helperFunc = function (context, prefix, url, options) {
        return prefix + url.split("/").pop();
    };
    return StripURLHelper;
}());

var IfEqualStringHelper = /** @class */ (function () {
    function IfEqualStringHelper() {
    }
    IfEqualStringHelper.prototype.helperFunc = function (context, a, b, options) {
        if (a == b) {
            return options.fn(context);
        }
        return options.inverse(context);
    };
    return IfEqualStringHelper;
}());

var Handlebars$2 = require('handlebars');
var HtmlEngineHelpers = /** @class */ (function () {
    function HtmlEngineHelpers() {
    }
    HtmlEngineHelpers.prototype.registerHelpers = function (bars) {
        this.registerHelper(bars, 'compare', new CompareHelper());
        this.registerHelper(bars, 'or', new OrHelper());
        this.registerHelper(bars, 'functionSignature', new FunctionSignatureHelper());
        this.registerHelper(bars, 'isNotToggle', new IsNotToggleHelper());
        this.registerHelper(bars, 'isInitialTab', new IsInitialTabHelper());
        this.registerHelper(bars, 'isTabEnabled', new IsTabEnabledHelper());
        this.registerHelper(bars, 'ifString', new IfStringHelper());
        this.registerHelper(bars, 'ifEqualString', new IfEqualStringHelper());
        this.registerHelper(bars, 'orLength', new OrLengthHelper());
        this.registerHelper(bars, 'filterAngular2Modules', new FilterAngular2ModulesHelper());
        this.registerHelper(bars, 'debug', new DebugHelper());
        this.registerHelper(bars, 'breaklines', new BreakLinesHelper(bars));
        this.registerHelper(bars, 'clean-paragraph', new CleanParagraphHelper());
        this.registerHelper(bars, 'escapeSimpleQuote', new EscapeSimpleQuoteHelper());
        this.registerHelper(bars, 'breakComma', new BreakCommaHelper(bars));
        this.registerHelper(bars, 'modifKind', new ModifKindHelper());
        this.registerHelper(bars, 'modifIcon', new ModifIconHelper());
        this.registerHelper(bars, 'relativeURL', new RelativeURLHelper());
        this.registerHelper(bars, 'jsdoc-returns-comment', new JsdocReturnsCommentHelper());
        this.registerHelper(bars, 'jsdoc-code-example', new JsdocCodeExampleHelper());
        this.registerHelper(bars, 'jsdoc-example', new JsdocExampleHelper());
        this.registerHelper(bars, 'jsdoc-params', new JsdocParamsHelper());
        this.registerHelper(bars, 'jsdoc-params-valid', new JsdocParamsValidHelper());
        this.registerHelper(bars, 'jsdoc-default', new JsdocDefaultHelper());
        this.registerHelper(bars, 'linkType', new LinkTypeHelper());
        this.registerHelper(bars, 'indexableSignature', new IndexableSignatureHelper());
        this.registerHelper(bars, 'object', new ObjectHelper());
        this.registerHelper(bars, 'objectLength', new ObjectLengthHelper());
        this.registerHelper(bars, 'parseDescription', new ParseDescriptionHelper());
        this.registerHelper(bars, 'one-parameter-has', new OneParameterHasHelper());
        this.registerHelper(bars, 'element-alone', new ElementAloneHelper());
        this.registerHelper(bars, 'hasOwn', new HasOwnHelper());
        this.registerHelper(bars, 'short-url', new ShortURLHelper());
        this.registerHelper(bars, 'strip-url', new StripURLHelper());
        this.registerHelper(bars, 't', new I18nHelper());
        this.registerHelper(bars, 'capitalize', new CapitalizeHelper());
        this.registerHelper(bars, 'parse-property', new ParsePropertyHelper());
    };
    HtmlEngineHelpers.prototype.registerHelper = function (bars, key, helper) {
        Handlebars$2.registerHelper(key, function () {
            // tslint:disable-next-line:no-invalid-this
            return helper.helperFunc.apply(helper, __spreadArray([this], __read(___namespace.slice(arguments)), false));
        });
    };
    return HtmlEngineHelpers;
}());

var Handlebars$1 = require('handlebars');
var HtmlEngine = /** @class */ (function () {
    function HtmlEngine() {
        this.cache = {};
        var helper = new HtmlEngineHelpers();
        helper.registerHelpers(Handlebars$1);
    }
    HtmlEngine.getInstance = function () {
        if (!HtmlEngine.instance) {
            HtmlEngine.instance = new HtmlEngine();
        }
        return HtmlEngine.instance;
    };
    HtmlEngine.prototype.init = function (templatePath) {
        var _this = this;
        var partials = [
            'overview',
            'markdown',
            'modules',
            'module',
            'component',
            'controller',
            'entity',
            'component-detail',
            'directive',
            'injectable',
            'interceptor',
            'guard',
            'pipe',
            'class',
            'interface',
            'routes',
            'index',
            'index-misc',
            'search-results',
            'search-input',
            'link-type',
            'block-method',
            'block-host-listener',
            'block-enum',
            'block-property',
            'block-index',
            'block-constructor',
            'block-typealias',
            'block-accessors',
            'block-input',
            'block-output',
            'coverage-report',
            'unit-test-report',
            'miscellaneous-functions',
            'miscellaneous-variables',
            'miscellaneous-typealiases',
            'miscellaneous-enumerations',
            'additional-page',
            'package-dependencies',
            'package-properties'
        ];
        if (templatePath) {
            if (FileEngine$1.existsSync(path__namespace.resolve(process.cwd() + path__namespace.sep + templatePath)) ===
                false) {
                logger.warn('Template path specificed but does not exist...using default templates');
            }
        }
        return Promise.all(partials.map(function (partial) {
            var partialPath = _this.determineTemplatePath(templatePath, 'partials/' + partial + '.hbs');
            return FileEngine$1.get(partialPath).then(function (data) {
                return Handlebars$1.registerPartial(partial, data);
            });
        }))
            .then(function () {
            var pagePath = _this.determineTemplatePath(templatePath, 'page.hbs');
            return FileEngine$1.get(pagePath).then(function (data) {
                _this.cache.page = data;
                _this.compiledPage = Handlebars$1.compile(_this.cache.page, {
                    preventIndent: true,
                    strict: true
                });
            });
        })
            .then(function () {
            var menuPath = _this.determineTemplatePath(templatePath, 'partials/menu.hbs');
            return FileEngine$1.get(menuPath).then(function (menuTemplate) {
                _this.precompiledMenu = Handlebars$1.compile(menuTemplate, {
                    preventIndent: true,
                    strict: true
                });
            });
        });
    };
    HtmlEngine.prototype.renderMenu = function (templatePath, data) {
        var menuPath = this.determineTemplatePath(templatePath, 'partials/menu.hbs');
        return FileEngine$1.get(menuPath).then(function (menuTemplate) {
            data.menu = 'normal';
            return Handlebars$1.compile(menuTemplate, {
                preventIndent: true,
                strict: true
            })(__assign({}, data));
        });
    };
    HtmlEngine.prototype.render = function (mainData, page) {
        var o = mainData;
        Object.assign(o, page);
        // let mem = process.memoryUsage();
        // console.log(`heapTotal: ${mem.heapTotal} | heapUsed: ${mem.heapUsed}`);
        return this.compiledPage({
            data: o
        });
    };
    HtmlEngine.prototype.determineTemplatePath = function (templatePath, filePath) {
        var outPath = path__namespace.resolve(__dirname + '/../src/templates/' + filePath);
        if (templatePath) {
            var testPath = path__namespace.resolve(process.cwd() + path__namespace.sep + templatePath + path__namespace.sep + filePath);
            outPath = FileEngine$1.existsSync(testPath) ? testPath : outPath;
        }
        return outPath;
    };
    HtmlEngine.prototype.generateCoverageBadge = function (outputFolder, label, coverageData) {
        return FileEngine$1.get(path__namespace.resolve(__dirname + '/../src/templates/partials/coverage-badge.hbs')).then(function (data) {
            var template = Handlebars$1.compile(data);
            coverageData.label = label;
            var result = template({
                data: coverageData
            });
            var testOutputDir = outputFolder.match(process.cwd());
            if (testOutputDir && testOutputDir.length > 0) {
                outputFolder = outputFolder.replace(process.cwd() + path__namespace.sep, '');
            }
            return FileEngine$1.write(outputFolder + path__namespace.sep + '/images/coverage-badge-' + label + '.svg', result).catch(function (err) {
                logger.error('Error during coverage badge ' + label + ' file generation ', err);
                return Promise.reject(err);
            });
        }, function (err) { return Promise.reject('Error during coverage badge generation'); });
    };
    return HtmlEngine;
}());
var HtmlEngine$1 = HtmlEngine.getInstance();

var decache = require('decache');
var MarkdownEngine = /** @class */ (function () {
    function MarkdownEngine() {
        var _this = this;
        /**
         * List of markdown files without .md extension
         */
        this.markdownFiles = ['README', 'CHANGELOG', 'LICENSE', 'CONTRIBUTING', 'TODO'];
        decache('marked');
        this.markedInstance = markedAcl;
        var renderer = new this.markedInstance.Renderer();
        renderer.code = function (code, language) {
            var highlighted = code;
            if (!language) {
                language = 'none';
            }
            highlighted = _this.escape(code);
            return "<b>".concat(I18nEngine$1.translate('example'), " :</b><div><pre class=\"line-numbers\"><code class=\"language-").concat(language, "\">").concat(highlighted, "</code></pre></div>");
        };
        renderer.table = function (header, body) {
            return ('<table class="table table-bordered compodoc-table">\n' +
                '<thead>\n' +
                header +
                '</thead>\n' +
                '<tbody>\n' +
                body +
                '</tbody>\n' +
                '</table>\n');
        };
        renderer.image = function (href, title, text) {
            var out = '<img src="' + href + '" alt="' + text + '" class="img-responsive"';
            if (title) {
                out += ' title="' + title + '"';
            }
            out += '>';
            return out;
        };
        this.markedInstance.setOptions({
            renderer: renderer,
            gfm: true,
            breaks: false
        });
    }
    MarkdownEngine.getInstance = function () {
        if (!MarkdownEngine.instance) {
            MarkdownEngine.instance = new MarkdownEngine();
        }
        return MarkdownEngine.instance;
    };
    MarkdownEngine.prototype.getTraditionalMarkdown = function (filepath) {
        var _this = this;
        return FileEngine$1.get(process.cwd() + path__namespace.sep + filepath + '.md')
            .catch(function (err) { return FileEngine$1.get(process.cwd() + path__namespace.sep + filepath).then(); })
            .then(function (data) {
            var returnedData = {
                markdown: _this.markedInstance(data),
                rawData: data
            };
            return returnedData;
        });
    };
    MarkdownEngine.prototype.getTraditionalMarkdownSync = function (filepath) {
        return this.markedInstance(FileEngine$1.getSync(process.cwd() + path__namespace.sep + filepath));
    };
    MarkdownEngine.prototype.getReadmeFile = function () {
        var _this = this;
        return FileEngine$1.get(process.cwd() + path__namespace.sep + 'README.md').then(function (data) {
            return _this.markedInstance(data);
        });
    };
    MarkdownEngine.prototype.readNeighbourReadmeFile = function (file) {
        var dirname = path__namespace.dirname(file);
        var readmeFile = dirname + path__namespace.sep + path__namespace.basename(file, '.ts') + '.md';
        return fs__namespace.readFileSync(readmeFile, 'utf8');
    };
    MarkdownEngine.prototype.hasNeighbourReadmeFile = function (file) {
        var dirname = path__namespace.dirname(file);
        var readmeFile = dirname + path__namespace.sep + path__namespace.basename(file, '.ts') + '.md';
        return FileEngine$1.existsSync(readmeFile);
    };
    MarkdownEngine.prototype.componentReadmeFile = function (file) {
        var dirname = path__namespace.dirname(file);
        var readmeFile = dirname + path__namespace.sep + 'README.md';
        var readmeAlternativeFile = dirname + path__namespace.sep + path__namespace.basename(file, '.ts') + '.md';
        var finalPath = '';
        if (FileEngine$1.existsSync(readmeFile)) {
            finalPath = readmeFile;
        }
        else {
            finalPath = readmeAlternativeFile;
        }
        return finalPath;
    };
    /**
     * Checks if any of the markdown files is exists with or without endings
     */
    MarkdownEngine.prototype.hasRootMarkdowns = function () {
        return this.addEndings(this.markdownFiles).some(function (x) {
            return FileEngine$1.existsSync(process.cwd() + path__namespace.sep + x);
        });
    };
    MarkdownEngine.prototype.listRootMarkdowns = function () {
        var foundFiles = this.markdownFiles.filter(function (x) {
            return FileEngine$1.existsSync(process.cwd() + path__namespace.sep + x + '.md') ||
                FileEngine$1.existsSync(process.cwd() + path__namespace.sep + x);
        });
        return this.addEndings(foundFiles);
    };
    MarkdownEngine.prototype.escape = function (html) {
        return html
            .replace(/&/g, '&amp;')
            .replace(/</g, '&lt;')
            .replace(/>/g, '&gt;')
            .replace(/"/g, '&quot;')
            .replace(/'/g, '&#39;')
            .replace(/@/g, '&#64;');
    };
    /**
     * ['README'] => ['README', 'README.md']
     */
    MarkdownEngine.prototype.addEndings = function (files) {
        return ___namespace.flatMap(files, function (x) { return [x, x + '.md']; });
    };
    return MarkdownEngine;
}());
var MarkdownEngine$1 = MarkdownEngine.getInstance();

var ngdT = require('@compodoc/ngd-transformer');
var NgdEngine = /** @class */ (function () {
    function NgdEngine() {
    }
    NgdEngine.getInstance = function () {
        if (!NgdEngine.instance) {
            NgdEngine.instance = new NgdEngine();
        }
        return NgdEngine.instance;
    };
    NgdEngine.prototype.init = function (outputpath) {
        this.engine = new ngdT.DotEngine({
            output: outputpath,
            displayLegend: true,
            outputFormats: 'svg',
            silent: true
        });
    };
    NgdEngine.prototype.renderGraph = function (filepath, outputpath, type, name) {
        this.engine.updateOutput(outputpath);
        if (type === 'f') {
            return this.engine.generateGraph([DependenciesEngine$1.getRawModule(name)]);
        }
        else {
            return this.engine.generateGraph(DependenciesEngine$1.rawModulesForOverview);
        }
    };
    NgdEngine.prototype.readGraph = function (filepath, name) {
        return FileEngine$1.get(filepath).catch(function (err) {
            return Promise.reject('Error during graph read ' + name);
        });
    };
    return NgdEngine;
}());
var NgdEngine$1 = NgdEngine.getInstance();

var COMPODOC_CONSTANTS = {
    navTabDefinitions: [
        {
            id: 'info',
            href: '#info',
            'data-link': 'info',
            label: 'Info',
            depTypes: ['all']
        },
        {
            id: 'readme',
            href: '#readme',
            'data-link': 'readme',
            label: 'README',
            depTypes: ['all']
        },
        {
            id: 'source',
            href: '#source',
            'data-link': 'source',
            label: 'Source',
            depTypes: ['all']
        },
        {
            id: 'templateData',
            href: '#templateData',
            'data-link': 'template',
            label: 'Template',
            depTypes: ['component']
        },
        {
            id: 'styleData',
            href: '#styleData',
            'data-link': 'style',
            label: 'Styles',
            depTypes: ['component']
        },
        {
            id: 'tree',
            href: '#tree',
            'data-link': 'dom-tree',
            label: 'DOM Tree',
            depTypes: ['component']
        },
        {
            id: 'example',
            href: '#example',
            'data-link': 'example',
            label: 'Examples',
            depTypes: ['component', 'directive', 'injectable', 'pipe']
        }
    ]
};
/**
 * Max length for the string of a file during Lunr search engine indexing.
 * Prevent stack size exceeded
 */
var MAX_SIZE_FILE_SEARCH_INDEX = 50000;
/**
 * Max length for the string of a file during cheerio parsing.
 * Prevent stack size exceeded
 */
var MAX_SIZE_FILE_CHEERIO_PARSING = 400000000;

var Handlebars = require('handlebars');
var lunr = require('lunr');
var SearchEngine = /** @class */ (function () {
    function SearchEngine() {
        this.searchDocuments = [];
        this.documentsStore = {};
        this.amountOfMemory = 0;
    }
    SearchEngine.getInstance = function () {
        if (!SearchEngine.instance) {
            SearchEngine.instance = new SearchEngine();
        }
        return SearchEngine.instance;
    };
    SearchEngine.prototype.indexPage = function (page) {
        var text;
        this.amountOfMemory += page.rawData.length;
        if (this.amountOfMemory < MAX_SIZE_FILE_CHEERIO_PARSING) {
            var indexStartContent = page.rawData.indexOf('<!-- START CONTENT -->');
            var indexEndContent = page.rawData.indexOf('<!-- END CONTENT -->');
            var $ = cheerio__namespace.load(page.rawData.substring(indexStartContent + 1, indexEndContent));
            text = $('.content').html();
            text = htmlEntities.decode(text);
            text = text.replace(/(<([^>]+)>)/gi, '');
            page.url = page.url.replace(Configuration$1.mainData.output, '');
            var doc = {
                url: page.url,
                title: page.infos.context + ' - ' + page.infos.name,
                body: text
            };
            if (!this.documentsStore.hasOwnProperty(doc.url) &&
                doc.body.length < MAX_SIZE_FILE_SEARCH_INDEX) {
                this.documentsStore[doc.url] = doc;
                this.searchDocuments.push(doc);
            }
        }
    };
    SearchEngine.prototype.generateSearchIndexJson = function (outputFolder) {
        var _this = this;
        var that = this;
        var searchIndex = lunr(function () {
            /* tslint:disable:no-invalid-this */
            this.ref('url');
            this.field('title');
            this.field('body');
            this.pipeline.remove(lunr.stemmer);
            var i = 0;
            var len = that.searchDocuments.length;
            for (i; i < len; i++) {
                this.add(that.searchDocuments[i]);
            }
        });
        return FileEngine$1.get(__dirname + '/../src/templates/partials/search-index.hbs').then(function (data) {
            var template = Handlebars.compile(data);
            var result = template({
                index: JSON.stringify(searchIndex),
                store: JSON.stringify(_this.documentsStore)
            });
            var testOutputDir = outputFolder.match(process.cwd());
            if (testOutputDir && testOutputDir.length > 0) {
                outputFolder = outputFolder.replace(process.cwd() + path__namespace.sep, '');
            }
            return FileEngine$1.write(outputFolder + path__namespace.sep + '/js/search/search_index.js', result).catch(function (err) {
                logger.error('Error during search index file generation ', err);
                return Promise.reject(err);
            });
        }, function (err) { return Promise.reject('Error during search index generation'); });
    };
    return SearchEngine;
}());
var SearchEngine$1 = SearchEngine.getInstance();

var ComponentsTreeEngine = /** @class */ (function () {
    function ComponentsTreeEngine() {
        this.components = [];
        this.componentsForTree = [];
    }
    ComponentsTreeEngine.getInstance = function () {
        if (!ComponentsTreeEngine.instance) {
            ComponentsTreeEngine.instance = new ComponentsTreeEngine();
        }
        return ComponentsTreeEngine.instance;
    };
    ComponentsTreeEngine.prototype.addComponent = function (component) {
        this.components.push(component);
    };
    ComponentsTreeEngine.prototype.readTemplates = function () {
        var _this = this;
        return new Promise(function (resolve, reject) {
            var i = 0;
            var len = _this.componentsForTree.length;
            var loop = function () {
                if (i <= len - 1) {
                    if (_this.componentsForTree[i].templateUrl) {
                        var filePath = process.cwd() +
                            path__namespace.sep +
                            path__namespace.dirname(_this.componentsForTree[i].file) +
                            path__namespace.sep +
                            _this.componentsForTree[i].templateUrl;
                        FileEngine$1.get(filePath).then(function (templateData) {
                            _this.componentsForTree[i].templateData = templateData;
                            i++;
                            loop();
                        }, function (e) {
                            logger.error(e);
                            reject();
                        });
                    }
                    else {
                        _this.componentsForTree[i].templateData = _this.componentsForTree[i].template;
                        i++;
                        loop();
                    }
                }
                else {
                    resolve();
                }
            };
            loop();
        });
    };
    ComponentsTreeEngine.prototype.findChildrenAndParents = function () {
        var _this = this;
        return new Promise(function (resolve, reject) {
            ___namespace.forEach(_this.componentsForTree, function (component) {
                var $component = cheerio__namespace(component.templateData);
                ___namespace.forEach(_this.componentsForTree, function (componentToFind) {
                    if ($component.find(componentToFind.selector).length > 0) {
                        console.log(componentToFind.name + ' found in ' + component.name);
                        component.children.push(componentToFind.name);
                    }
                });
            });
            resolve();
        });
    };
    ComponentsTreeEngine.prototype.createTreesForComponents = function () {
        var _this = this;
        return new Promise(function (resolve, reject) {
            ___namespace.forEach(_this.components, function (component) {
                var _component = {
                    name: component.name,
                    file: component.file,
                    selector: component.selector,
                    children: [],
                    template: '',
                    templateUrl: ''
                };
                if (typeof component.template !== 'undefined') {
                    _component.template = component.template;
                }
                if (component.templateUrl.length > 0) {
                    _component.templateUrl = component.templateUrl[0];
                }
                _this.componentsForTree.push(_component);
            });
            _this.readTemplates().then(function () {
                _this.findChildrenAndParents().then(function () {
                    // console.log('this.componentsForTree: ', this.componentsForTree);
                    resolve();
                }, function (e) {
                    logger.error(e);
                    reject();
                });
            }, function (e) {
                logger.error(e);
            });
        });
    };
    return ComponentsTreeEngine;
}());
var ComponentsTreeEngine$1 = ComponentsTreeEngine.getInstance();

function StringifyArrowFunction(af) {
    var i = 0, result = '(';
    var len = af.parameters.length;
    if (len === 1) {
        result = '';
    }
    for (i; i < len; i++) {
        if (af.parameters[i].name && af.parameters[i].name.escapedText) {
            result += af.parameters[i].name.escapedText;
        }
        if (i < len - 1) {
            result += ', ';
        }
    }
    if (len > 1 || len === 0) {
        result += ')';
    }
    // body
    result += ' => ';
    if (af.body) {
        if (af.body.kind === tsMorph.SyntaxKind.Identifier && af.body.escapedText) {
            result += af.body.escapedText;
        }
        else if (af.body.kind === tsMorph.SyntaxKind.PropertyAccessExpression &&
            af.body.expression &&
            af.body.name) {
            result += af.body.expression.escapedText;
            result += '.' + af.body.name.escapedText;
        }
        else if (af.body.kind === tsMorph.SyntaxKind.StringLiteral && af.body.text) {
            result += af.body.text;
        }
    }
    return result;
}

function StringifyObjectLiteralExpression(ole) {
    var returnedString = '{';
    if (ole.properties && ole.properties.length > 0) {
        ole.properties.forEach(function (property, index) {
            if (property.name) {
                returnedString += property.name.text + ': ';
            }
            if (property.initializer) {
                if (property.initializer.kind === tsMorph.SyntaxKind.StringLiteral) {
                    returnedString += "'" + property.initializer.text + "'";
                }
                else if (property.initializer.kind === tsMorph.SyntaxKind.TrueKeyword) {
                    returnedString += "true";
                }
                else if (property.initializer.kind === tsMorph.SyntaxKind.FalseKeyword) {
                    returnedString += "false";
                }
                else if (property.initializer.kind === tsMorph.SyntaxKind.ArrowFunction) {
                    returnedString += StringifyArrowFunction(property.initializer);
                }
                else {
                    returnedString += property.initializer.text;
                }
            }
            if (index < ole.properties.length - 1) {
                returnedString += ', ';
            }
        });
    }
    returnedString += '}';
    return returnedString;
}

function nodeHasDecorator(node) {
    var result = false;
    var nodeModifiers = node.modifiers; // ts.getModifiers(node);
    if (nodeModifiers && nodeModifiers.length > 0) {
        nodeModifiers.forEach(function (nodeModifier) {
            if (nodeModifier.kind === tsMorph.ts.SyntaxKind.Decorator) {
                result = true;
            }
        });
    }
    return result;
}
function getNodeDecorators(node) {
    var result = [];
    var nodeModifiers = node.modifiers; // ts.getModifiers(node);
    if (nodeModifiers && nodeModifiers.length > 0) {
        nodeModifiers.forEach(function (nodeModifier) {
            if (nodeModifier.kind === tsMorph.ts.SyntaxKind.Decorator) {
                result.push(nodeModifier);
            }
        });
    }
    return result;
}

var crypto$7 = require('crypto');
var ClassHelper = /** @class */ (function () {
    function ClassHelper(typeChecker) {
        this.typeChecker = typeChecker;
        this.jsdocParserUtil = new JsdocParserUtil();
    }
    /**
     * HELPERS
     */
    ClassHelper.prototype.stringifyDefaultValue = function (node) {
        /**
         * Copyright https://github.com/ng-bootstrap/ng-bootstrap
         */
        if (node.getText()) {
            return node.getText();
        }
        else if (node.kind === tsMorph.SyntaxKind.FalseKeyword) {
            return 'false';
        }
        else if (node.kind === tsMorph.SyntaxKind.TrueKeyword) {
            return 'true';
        }
    };
    ClassHelper.prototype.checkForDeprecation = function (tags, result) {
        ___namespace.forEach(tags, function (tag) {
            if (tag.tagName && tag.tagName.text && tag.tagName.text.indexOf('deprecated') > -1) {
                result.deprecated = true;
                result.deprecationMessage = tag.comment || '';
            }
        });
    };
    ClassHelper.prototype.getDecoratorOfType = function (node, decoratorType) {
        var decorators = getNodeDecorators(node) || [];
        var result = [];
        var len = decorators.length;
        if (len > 1) {
            for (var i = 0; i < decorators.length; i++) {
                if (decorators[i].expression.expression) {
                    if (decorators[i].expression.expression.text === decoratorType) {
                        result.push(decorators[i]);
                    }
                }
            }
            if (result.length > 0) {
                return result;
            }
        }
        else {
            if (len === 1 && decorators[0].expression && decorators[0].expression.expression) {
                if (decorators[0].expression.expression.text === decoratorType) {
                    result.push(decorators[0]);
                    return result;
                }
            }
        }
        return undefined;
    };
    ClassHelper.prototype.formatDecorators = function (decorators) {
        var _this = this;
        var _decorators = [];
        ___namespace.forEach(decorators, function (decorator) {
            if (decorator.expression) {
                if (decorator.expression.text) {
                    _decorators.push({ name: decorator.expression.text });
                }
                if (decorator.expression.expression) {
                    var info = { name: decorator.expression.expression.text };
                    if (decorator.expression.arguments) {
                        info.stringifiedArguments = _this.stringifyArguments(decorator.expression.arguments);
                    }
                    _decorators.push(info);
                }
            }
        });
        return _decorators;
    };
    ClassHelper.prototype.handleFunction = function (arg) {
        var _this = this;
        if (arg.function.length === 0) {
            return "".concat(arg.name).concat(this.getOptionalString(arg), ": () => void");
        }
        var argums = arg.function.map(function (argu) {
            var _result = DependenciesEngine$1.find(argu.type);
            if (_result) {
                if (_result.source === 'internal') {
                    var path = _result.data.type;
                    if (_result.data.type === 'class') {
                        path = 'classe';
                    }
                    return "".concat(argu.name).concat(_this.getOptionalString(arg), ": <a href=\"../").concat(path, "s/").concat(_result.data.name, ".html\">").concat(argu.type, "</a>");
                }
                else {
                    var path = AngularVersionUtil$1.getApiLink(_result.data, Configuration$1.mainData.angularVersion);
                    return "".concat(argu.name).concat(_this.getOptionalString(arg), ": <a href=\"").concat(path, "\" target=\"_blank\">").concat(argu.type, "</a>");
                }
            }
            else if (BasicTypeUtil$1.isKnownType(argu.type)) {
                var path = BasicTypeUtil$1.getTypeUrl(argu.type);
                return "".concat(argu.name).concat(_this.getOptionalString(arg), ": <a href=\"").concat(path, "\" target=\"_blank\">").concat(argu.type, "</a>");
            }
            else {
                if (argu.name && argu.type) {
                    return "".concat(argu.name).concat(_this.getOptionalString(arg), ": ").concat(argu.type);
                }
                else {
                    if (argu.name) {
                        return "".concat(argu.name.text);
                    }
                    else {
                        return '';
                    }
                }
            }
        });
        return "".concat(arg.name).concat(this.getOptionalString(arg), ": (").concat(argums, ") => void");
    };
    ClassHelper.prototype.getOptionalString = function (arg) {
        return arg.optional ? '?' : '';
    };
    ClassHelper.prototype.stringifyArguments = function (args) {
        var _this = this;
        var stringifyArgs = [];
        stringifyArgs = args
            .map(function (arg) {
            var _result = DependenciesEngine$1.find(arg.type);
            if (_result) {
                if (_result.source === 'internal') {
                    var path = _result.data.type;
                    if (_result.data.type === 'class') {
                        path = 'classe';
                    }
                    return "".concat(arg.name).concat(_this.getOptionalString(arg), ": <a href=\"../").concat(path, "s/").concat(_result.data.name, ".html\">").concat(arg.type, "</a>");
                }
                else {
                    var path = AngularVersionUtil$1.getApiLink(_result.data, Configuration$1.mainData.angularVersion);
                    return "".concat(arg.name).concat(_this.getOptionalString(arg), ": <a href=\"").concat(path, "\" target=\"_blank\">").concat(arg.type, "</a>");
                }
            }
            else if (arg.dotDotDotToken) {
                return "...".concat(arg.name, ": ").concat(arg.type);
            }
            else if (arg.function) {
                return _this.handleFunction(arg);
            }
            else if (arg.expression && arg.name) {
                return arg.expression.text + '.' + arg.name.text;
            }
            else if (arg.expression && arg.kind === tsMorph.SyntaxKind.NewExpression) {
                return 'new ' + arg.expression.text + '()';
            }
            else if (arg.kind && arg.kind === tsMorph.SyntaxKind.StringLiteral) {
                return "'" + arg.text + "'";
            }
            else if (arg.kind &&
                arg.kind === tsMorph.SyntaxKind.ArrayLiteralExpression &&
                arg.elements &&
                arg.elements.length > 0) {
                var i = 0, len = arg.elements.length, result = '[';
                for (i; i < len; i++) {
                    result += "'" + arg.elements[i].text + "'";
                    if (i < len - 1) {
                        result += ', ';
                    }
                }
                result += ']';
                return result;
            }
            else if (arg.kind &&
                arg.kind === tsMorph.SyntaxKind.ArrowFunction &&
                arg.parameters &&
                arg.parameters.length > 0) {
                return StringifyArrowFunction(arg);
            }
            else if (arg.kind && arg.kind === tsMorph.SyntaxKind.ObjectLiteralExpression) {
                return StringifyObjectLiteralExpression(arg);
            }
            else if (BasicTypeUtil$1.isKnownType(arg.type)) {
                var path = BasicTypeUtil$1.getTypeUrl(arg.type);
                return "".concat(arg.name).concat(_this.getOptionalString(arg), ": <a href=\"").concat(path, "\" target=\"_blank\">").concat(arg.type, "</a>");
            }
            else {
                if (arg.type) {
                    var finalStringifiedArgument = '';
                    var separator = ':';
                    if (arg.name) {
                        finalStringifiedArgument += arg.name;
                    }
                    if (arg.kind === tsMorph.SyntaxKind.AsExpression &&
                        arg.expression &&
                        arg.expression.text) {
                        finalStringifiedArgument += arg.expression.text;
                        separator = ' as';
                    }
                    if (arg.optional) {
                        finalStringifiedArgument += _this.getOptionalString(arg);
                    }
                    if (arg.type) {
                        finalStringifiedArgument += separator + ' ' + _this.visitType(arg.type);
                    }
                    return finalStringifiedArgument;
                }
                else if (arg.text) {
                    return "".concat(arg.text);
                }
                else {
                    return "".concat(arg.name).concat(_this.getOptionalString(arg));
                }
            }
        })
            .join(', ');
        return stringifyArgs;
    };
    ClassHelper.prototype.getPosition = function (node, sourceFile) {
        var position;
        if (node.name && node.name.end) {
            position = tsMorph.ts.getLineAndCharacterOfPosition(sourceFile, node.name.end);
        }
        else {
            position = tsMorph.ts.getLineAndCharacterOfPosition(sourceFile, node.pos);
        }
        return position;
    };
    ClassHelper.prototype.addAccessor = function (accessors, nodeAccessor, sourceFile) {
        var _this = this;
        var nodeName = '';
        if (nodeAccessor.name) {
            nodeName = nodeAccessor.name.text;
            var jsdoctags = this.jsdocParserUtil.getJSDocs(nodeAccessor);
            if (!accessors[nodeName]) {
                accessors[nodeName] = {
                    name: nodeName,
                    setSignature: undefined,
                    getSignature: undefined
                };
            }
            if (nodeAccessor.kind === tsMorph.SyntaxKind.SetAccessor) {
                var setSignature = {
                    name: nodeName,
                    type: 'void',
                    deprecated: false,
                    deprecationMessage: '',
                    args: nodeAccessor.parameters.map(function (param) { return _this.visitArgument(param); }),
                    returnType: nodeAccessor.type ? this.visitType(nodeAccessor.type) : 'void',
                    line: this.getPosition(nodeAccessor, sourceFile).line + 1
                };
                if (nodeAccessor.jsDoc && nodeAccessor.jsDoc.length >= 1) {
                    var comment = this.jsdocParserUtil.getMainCommentOfNode(nodeAccessor, sourceFile);
                    if (typeof comment !== 'undefined') {
                        var cleanedDescription = this.jsdocParserUtil.parseComment(comment);
                        setSignature.rawdescription = cleanedDescription;
                        setSignature.description = markedAcl(cleanedDescription);
                    }
                }
                if (jsdoctags && jsdoctags.length >= 1 && jsdoctags[0].tags) {
                    this.checkForDeprecation(jsdoctags[0].tags, setSignature);
                    setSignature.jsdoctags = markedtags(jsdoctags[0].tags);
                }
                if (setSignature.jsdoctags && setSignature.jsdoctags.length > 0) {
                    setSignature.jsdoctags = mergeTagsAndArgs(setSignature.args, setSignature.jsdoctags);
                }
                else if (setSignature.args && setSignature.args.length > 0) {
                    setSignature.jsdoctags = mergeTagsAndArgs(setSignature.args);
                }
                accessors[nodeName].setSignature = setSignature;
            }
            if (nodeAccessor.kind === tsMorph.SyntaxKind.GetAccessor) {
                var getSignature = {
                    name: nodeName,
                    type: nodeAccessor.type ? kindToType(nodeAccessor.type.kind) : '',
                    returnType: nodeAccessor.type ? this.visitType(nodeAccessor.type) : '',
                    line: this.getPosition(nodeAccessor, sourceFile).line + 1
                };
                if (nodeAccessor.jsDoc && nodeAccessor.jsDoc.length >= 1) {
                    var comment = this.jsdocParserUtil.getMainCommentOfNode(nodeAccessor, sourceFile);
                    if (typeof comment !== 'undefined') {
                        var cleanedDescription = this.jsdocParserUtil.parseComment(comment);
                        getSignature.rawdescription = cleanedDescription;
                        getSignature.description = markedAcl(cleanedDescription);
                    }
                }
                if (jsdoctags && jsdoctags.length >= 1 && jsdoctags[0].tags) {
                    this.checkForDeprecation(jsdoctags[0].tags, getSignature);
                    getSignature.jsdoctags = markedtags(jsdoctags[0].tags);
                }
                accessors[nodeName].getSignature = getSignature;
            }
        }
    };
    ClassHelper.prototype.isDirectiveDecorator = function (decorator) {
        if (decorator.expression.expression) {
            var decoratorIdentifierText = decorator.expression.expression.text;
            return (decoratorIdentifierText === 'Directive' || decoratorIdentifierText === 'Component');
        }
        else {
            return false;
        }
    };
    ClassHelper.prototype.isServiceDecorator = function (decorator) {
        return decorator.expression.expression
            ? decorator.expression.expression.text === 'Injectable'
            : false;
    };
    ClassHelper.prototype.isPrivate = function (member) {
        /**
         * Copyright https://github.com/ng-bootstrap/ng-bootstrap
         */
        if (member.modifiers) {
            var isPrivate = member.modifiers.some(function (modifier) { return modifier.kind === tsMorph.SyntaxKind.PrivateKeyword; });
            if (isPrivate) {
                return true;
            }
        }
        // Check for ECMAScript Private Fields
        if (member.name && member.name.escapedText) {
            var isPrivate = member.name.escapedText.indexOf('#') === 0;
            if (isPrivate) {
                return true;
            }
        }
        return this.isHiddenMember(member);
    };
    ClassHelper.prototype.isProtected = function (member) {
        if (member.modifiers) {
            var isProtected = member.modifiers.some(function (modifier) { return modifier.kind === tsMorph.SyntaxKind.ProtectedKeyword; });
            if (isProtected) {
                return true;
            }
        }
        return this.isHiddenMember(member);
    };
    ClassHelper.prototype.isInternal = function (member) {
        var e_1, _a, e_2, _b;
        /**
         * Copyright https://github.com/ng-bootstrap/ng-bootstrap
         */
        var internalTags = ['internal'];
        if (member.jsDoc) {
            try {
                for (var _c = __values(member.jsDoc), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var doc = _d.value;
                    if (doc.tags) {
                        try {
                            for (var _e = (e_2 = void 0, __values(doc.tags)), _f = _e.next(); !_f.done; _f = _e.next()) {
                                var tag = _f.value;
                                if (internalTags.indexOf(tag.tagName.text) > -1) {
                                    return true;
                                }
                            }
                        }
                        catch (e_2_1) { e_2 = { error: e_2_1 }; }
                        finally {
                            try {
                                if (_f && !_f.done && (_b = _e.return)) _b.call(_e);
                            }
                            finally { if (e_2) throw e_2.error; }
                        }
                    }
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
                }
                finally { if (e_1) throw e_1.error; }
            }
        }
        return false;
    };
    ClassHelper.prototype.isPublic = function (member) {
        if (member.modifiers) {
            var isPublic = member.modifiers.some(function (modifier) { return modifier.kind === tsMorph.SyntaxKind.PublicKeyword; });
            if (isPublic) {
                return true;
            }
        }
        return this.isHiddenMember(member);
    };
    ClassHelper.prototype.isHiddenMember = function (member) {
        var e_3, _a, e_4, _b;
        /**
         * Copyright https://github.com/ng-bootstrap/ng-bootstrap
         */
        var internalTags = ['hidden'];
        if (member.jsDoc) {
            try {
                for (var _c = __values(member.jsDoc), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var doc = _d.value;
                    if (doc.tags) {
                        try {
                            for (var _e = (e_4 = void 0, __values(doc.tags)), _f = _e.next(); !_f.done; _f = _e.next()) {
                                var tag = _f.value;
                                if (internalTags.indexOf(tag.tagName.text) > -1) {
                                    return true;
                                }
                            }
                        }
                        catch (e_4_1) { e_4 = { error: e_4_1 }; }
                        finally {
                            try {
                                if (_f && !_f.done && (_b = _e.return)) _b.call(_e);
                            }
                            finally { if (e_4) throw e_4.error; }
                        }
                    }
                }
            }
            catch (e_3_1) { e_3 = { error: e_3_1 }; }
            finally {
                try {
                    if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
                }
                finally { if (e_3) throw e_3.error; }
            }
        }
        return false;
    };
    ClassHelper.prototype.isPipeDecorator = function (decorator) {
        return decorator.expression.expression
            ? decorator.expression.expression.text === 'Pipe'
            : false;
    };
    ClassHelper.prototype.isControllerDecorator = function (decorator) {
        return decorator.expression.expression
            ? decorator.expression.expression.text === 'Controller'
            : false;
    };
    ClassHelper.prototype.isModuleDecorator = function (decorator) {
        return decorator.expression.expression
            ? decorator.expression.expression.text === 'NgModule' ||
                decorator.expression.expression.text === 'Module'
            : false;
    };
    /**
     * VISITERS
     */
    ClassHelper.prototype.visitClassDeclaration = function (fileName, classDeclaration, sourceFile, astFile) {
        var symbol = this.typeChecker.getSymbolAtLocation(classDeclaration.name);
        var rawdescription = '';
        var deprecated = false;
        var deprecationMessage = '';
        var description = '';
        var jsdoctags = [];
        if (symbol) {
            var comment = this.jsdocParserUtil.getMainCommentOfNode(classDeclaration, sourceFile);
            rawdescription = this.jsdocParserUtil.parseComment(comment);
            description = markedAcl(rawdescription);
            if (symbol.valueDeclaration && isIgnore(symbol.valueDeclaration)) {
                return [{ ignore: true }];
            }
            if (symbol.declarations && symbol.declarations.length > 0) {
                var declarationsjsdoctags = this.jsdocParserUtil.getJSDocs(symbol.declarations[0]);
                if (declarationsjsdoctags &&
                    declarationsjsdoctags.length >= 1 &&
                    declarationsjsdoctags[0].tags) {
                    var deprecation = { deprecated: false, deprecationMessage: '' };
                    this.checkForDeprecation(declarationsjsdoctags[0].tags, deprecation);
                    deprecated = deprecation.deprecated;
                    deprecationMessage = deprecation.deprecationMessage;
                }
                if (isIgnore(symbol.declarations[0])) {
                    return [{ ignore: true }];
                }
            }
            if (symbol.valueDeclaration) {
                jsdoctags = this.jsdocParserUtil.getJSDocs(symbol.valueDeclaration);
                if (jsdoctags && jsdoctags.length >= 1 && jsdoctags[0].tags) {
                    var deprecation = { deprecated: false, deprecationMessage: '' };
                    this.checkForDeprecation(jsdoctags[0].tags, deprecation);
                    deprecated = deprecation.deprecated;
                    deprecationMessage = deprecation.deprecationMessage;
                    jsdoctags = markedtags(jsdoctags[0].tags);
                }
            }
        }
        var className = classDeclaration.name.text;
        var members;
        var implementsElements = [];
        var extendsElements = [];
        if (typeof tsMorph.ts.getEffectiveImplementsTypeNodes !== 'undefined') {
            var implementedTypes = tsMorph.ts.getEffectiveImplementsTypeNodes(classDeclaration);
            if (implementedTypes) {
                var i = 0;
                var len = implementedTypes.length;
                for (i; i < len; i++) {
                    if (implementedTypes[i].expression) {
                        implementsElements.push(implementedTypes[i].expression.text);
                    }
                }
            }
        }
        if (typeof tsMorph.ts.getClassExtendsHeritageElement !== 'undefined') {
            if (astFile) {
                var interfaceOrClassNode = astFile.getInterface(className);
                if (!interfaceOrClassNode) {
                    interfaceOrClassNode = astFile.getClass(className);
                }
                if (interfaceOrClassNode) {
                    var extendsListRaw = interfaceOrClassNode.getExtends();
                    var extendsList_1 = [];
                    if (extendsListRaw) {
                        if (Array.isArray(extendsListRaw)) {
                            if (extendsListRaw.length > 0) {
                                extendsListRaw.forEach(function (extendElement) {
                                    var extendElementExpression = extendElement.getExpression();
                                    if (extendElementExpression) {
                                        var text = extendElementExpression.getText();
                                        if (text) {
                                            extendsList_1.push(text);
                                        }
                                    }
                                });
                            }
                        }
                        else {
                            var extendElementExpression = extendsListRaw.getExpression();
                            if (extendElementExpression) {
                                var text = extendElementExpression.getText();
                                if (text) {
                                    extendsList_1.push(text);
                                }
                            }
                        }
                    }
                    extendsElements = extendsList_1;
                }
            }
        }
        members = this.visitMembers(classDeclaration.members, sourceFile);
        if (nodeHasDecorator(classDeclaration)) {
            var classDecorators = getNodeDecorators(classDeclaration);
            // Loop and search for official decorators at top-level :
            // Angular : @NgModule, @Component, @Directive, @Injectable, @Pipe
            // Nestjs : @Controller, @Module, @Injectable
            // Stencil : @Component
            var isDirective = false;
            var isService = false;
            var isPipe = false;
            var isModule = false;
            var isController = false;
            for (var a = 0; a < classDecorators.length; a++) {
                //console.log(classDeclaration.decorators[i].expression);
                // RETURN TOO EARLY FOR MANY DECORATORS !!!!
                // iterating through the decorators array we have to keep the flags `true` values from the previous loop iteration
                isDirective = isDirective || this.isDirectiveDecorator(classDecorators[a]);
                isService = isService || this.isServiceDecorator(classDecorators[a]);
                isPipe = isPipe || this.isPipeDecorator(classDecorators[a]);
                isModule = isModule || this.isModuleDecorator(classDecorators[a]);
                isController = isController || this.isControllerDecorator(classDecorators[a]);
            }
            if (isDirective) {
                return {
                    deprecated: deprecated,
                    deprecationMessage: deprecationMessage,
                    description: description,
                    rawdescription: rawdescription,
                    inputs: members.inputs,
                    outputs: members.outputs,
                    hostBindings: members.hostBindings,
                    hostListeners: members.hostListeners,
                    properties: members.properties,
                    methods: members.methods,
                    indexSignatures: members.indexSignatures,
                    kind: members.kind,
                    constructor: members.constructor,
                    jsdoctags: jsdoctags,
                    extends: extendsElements,
                    implements: implementsElements,
                    accessors: members.accessors
                };
            }
            else if (isService) {
                return [
                    {
                        fileName: fileName,
                        className: className,
                        deprecated: deprecated,
                        deprecationMessage: deprecationMessage,
                        description: description,
                        rawdescription: rawdescription,
                        methods: members.methods,
                        indexSignatures: members.indexSignatures,
                        properties: members.properties,
                        kind: members.kind,
                        constructor: members.constructor,
                        jsdoctags: jsdoctags,
                        extends: extendsElements,
                        implements: implementsElements,
                        accessors: members.accessors
                    }
                ];
            }
            else if (isPipe) {
                return [
                    {
                        fileName: fileName,
                        className: className,
                        deprecated: deprecated,
                        deprecationMessage: deprecationMessage,
                        description: description,
                        rawdescription: rawdescription,
                        jsdoctags: jsdoctags,
                        properties: members.properties,
                        methods: members.methods
                    }
                ];
            }
            else if (isModule) {
                return [
                    {
                        fileName: fileName,
                        className: className,
                        deprecated: deprecated,
                        deprecationMessage: deprecationMessage,
                        description: description,
                        rawdescription: rawdescription,
                        jsdoctags: jsdoctags,
                        methods: members.methods
                    }
                ];
            }
            else {
                return [
                    {
                        deprecated: deprecated,
                        deprecationMessage: deprecationMessage,
                        description: description,
                        rawdescription: rawdescription,
                        methods: members.methods,
                        indexSignatures: members.indexSignatures,
                        properties: members.properties,
                        kind: members.kind,
                        constructor: members.constructor,
                        jsdoctags: jsdoctags,
                        extends: extendsElements,
                        implements: implementsElements,
                        accessors: members.accessors
                    }
                ];
            }
        }
        else if (description) {
            return [
                {
                    deprecated: deprecated,
                    deprecationMessage: deprecationMessage,
                    description: description,
                    rawdescription: rawdescription,
                    inputs: members.inputs,
                    outputs: members.outputs,
                    hostBindings: members.hostBindings,
                    hostListeners: members.hostListeners,
                    methods: members.methods,
                    indexSignatures: members.indexSignatures,
                    properties: members.properties,
                    kind: members.kind,
                    constructor: members.constructor,
                    jsdoctags: jsdoctags,
                    extends: extendsElements,
                    implements: implementsElements,
                    accessors: members.accessors
                }
            ];
        }
        else {
            return [
                {
                    deprecated: deprecated,
                    deprecationMessage: deprecationMessage,
                    methods: members.methods,
                    inputs: members.inputs,
                    outputs: members.outputs,
                    hostBindings: members.hostBindings,
                    hostListeners: members.hostListeners,
                    indexSignatures: members.indexSignatures,
                    properties: members.properties,
                    kind: members.kind,
                    constructor: members.constructor,
                    jsdoctags: jsdoctags,
                    extends: extendsElements,
                    implements: implementsElements,
                    accessors: members.accessors
                }
            ];
        }
    };
    ClassHelper.prototype.visitMembers = function (members, sourceFile) {
        /**
         * Copyright https://github.com/ng-bootstrap/ng-bootstrap
         */
        var inputs = [];
        var outputs = [];
        var methods = [];
        var properties = [];
        var indexSignatures = [];
        var kind;
        var inputDecorator;
        var hostBindings = [];
        var hostListeners = [];
        var constructor;
        var outputDecorator;
        var accessors = {};
        var result = {};
        for (var i = 0; i < members.length; i++) {
            // Allows typescript guess type when using ts.is*
            var member = members[i];
            inputDecorator = this.getDecoratorOfType(member, 'Input');
            outputDecorator = this.getDecoratorOfType(member, 'Output');
            var parsedHostBindings = this.getDecoratorOfType(member, 'HostBinding');
            var parsedHostListeners = this.getDecoratorOfType(member, 'HostListener');
            kind = member.kind;
            if (isIgnore(member)) {
                continue;
            }
            if (this.isInternal(member) && Configuration$1.mainData.disableInternal) {
                continue;
            }
            if (inputDecorator && inputDecorator.length > 0) {
                inputs.push(this.visitInputAndHostBinding(member, inputDecorator[0], sourceFile));
                if (tsMorph.ts.isSetAccessorDeclaration(member)) {
                    this.addAccessor(accessors, members[i], sourceFile);
                }
            }
            else if (outputDecorator && outputDecorator.length > 0) {
                outputs.push(this.visitOutput(member, outputDecorator[0], sourceFile));
            }
            else if (parsedHostBindings && parsedHostBindings.length > 0) {
                var k = 0;
                var lenHB = parsedHostBindings.length;
                for (k; k < lenHB; k++) {
                    hostBindings.push(this.visitInputAndHostBinding(member, parsedHostBindings[k], sourceFile));
                }
            }
            else if (parsedHostListeners && parsedHostListeners.length > 0) {
                var l = 0;
                var lenHL = parsedHostListeners.length;
                for (l; l < lenHL; l++) {
                    hostListeners.push(this.visitHostListener(member, parsedHostListeners[l], sourceFile));
                }
            }
            if (!this.isHiddenMember(member)) {
                if (!(this.isPrivate(member) && Configuration$1.mainData.disablePrivate)) {
                    if (!(this.isInternal(member) && Configuration$1.mainData.disableInternal)) {
                        if (!(this.isProtected(member) && Configuration$1.mainData.disableProtected)) {
                            if (tsMorph.ts.isMethodDeclaration(member) || tsMorph.ts.isMethodSignature(member)) {
                                methods.push(this.visitMethodDeclaration(member, sourceFile));
                            }
                            else if (tsMorph.ts.isPropertyDeclaration(member) ||
                                tsMorph.ts.isPropertySignature(member)) {
                                if (!inputDecorator && !outputDecorator) {
                                    properties.push(this.visitProperty(member, sourceFile));
                                }
                            }
                            else if (tsMorph.ts.isCallSignatureDeclaration(member)) {
                                properties.push(this.visitCallDeclaration(member, sourceFile));
                            }
                            else if (tsMorph.ts.isGetAccessorDeclaration(member) ||
                                tsMorph.ts.isSetAccessorDeclaration(member)) {
                                this.addAccessor(accessors, members[i], sourceFile);
                            }
                            else if (tsMorph.ts.isIndexSignatureDeclaration(member)) {
                                indexSignatures.push(this.visitIndexDeclaration(member, sourceFile));
                            }
                            else if (tsMorph.ts.isConstructorDeclaration(member)) {
                                var _constructorProperties = this.visitConstructorProperties(member, sourceFile);
                                var j = 0;
                                var len = _constructorProperties.length;
                                for (j; j < len; j++) {
                                    properties.push(_constructorProperties[j]);
                                }
                                constructor = this.visitConstructorDeclaration(member, sourceFile);
                            }
                        }
                    }
                }
            }
        }
        inputs.sort(getNamesCompareFn());
        outputs.sort(getNamesCompareFn());
        hostBindings.sort(getNamesCompareFn());
        hostListeners.sort(getNamesCompareFn());
        properties.sort(getNamesCompareFn());
        methods.sort(getNamesCompareFn());
        indexSignatures.sort(getNamesCompareFn());
        result = {
            inputs: inputs,
            outputs: outputs,
            hostBindings: hostBindings,
            hostListeners: hostListeners,
            methods: methods,
            properties: properties,
            indexSignatures: indexSignatures,
            kind: kind,
            constructor: constructor
        };
        if (Object.keys(accessors).length) {
            result['accessors'] = accessors;
        }
        return result;
    };
    ClassHelper.prototype.visitTypeName = function (typeName) {
        if (typeName.escapedText) {
            return typeName.escapedText;
        }
        if (typeName.text) {
            return typeName.text;
        }
        if (typeName.left && typeName.right) {
            return this.visitTypeName(typeName.left) + '.' + this.visitTypeName(typeName.right);
        }
        return '';
    };
    ClassHelper.prototype.visitTypeIndex = function (node) {
        var _return = '';
        if (!node) {
            return _return;
        }
        if (node.type &&
            node.type.kind === tsMorph.SyntaxKind.IndexedAccessType &&
            node.type.indexType &&
            node.type.indexType.literal) {
            return this.visitTypeName(node.type.indexType.literal);
        }
        return _return;
    };
    ClassHelper.prototype.visitType = function (node) {
        var e_5, _a;
        var _this = this;
        var _return = 'void';
        if (!node) {
            return _return;
        }
        if (node.typeName) {
            _return = this.visitTypeName(node.typeName);
        }
        else if (node.type) {
            if (node.type.kind) {
                _return = kindToType(node.type.kind);
            }
            if (node.type.typeName) {
                _return = this.visitTypeName(node.type.typeName);
            }
            if (node.type.typeArguments) {
                _return += '<';
                var typeArguments = [];
                try {
                    for (var _b = __values(node.type.typeArguments), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var argument = _c.value;
                        typeArguments.push(this.visitType(argument));
                    }
                }
                catch (e_5_1) { e_5 = { error: e_5_1 }; }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                    }
                    finally { if (e_5) throw e_5.error; }
                }
                _return += typeArguments.join(' | ');
                _return += '>';
            }
            if (node.type.elementType) {
                var _firstPart = this.visitType(node.type.elementType);
                _return = _firstPart + kindToType(node.type.kind);
                if (node.type.elementType.kind === tsMorph.SyntaxKind.ParenthesizedType) {
                    _return = '(' + _firstPart + ')' + kindToType(node.type.kind);
                }
            }
            var parseTypesOrElements = function (arr, separator) {
                var e_6, _a;
                var i = 0;
                var len = arr.length;
                for (i; i < len; i++) {
                    var type = arr[i];
                    if (type.elementType) {
                        var _firstPart = _this.visitType(type.elementType);
                        if (type.elementType.kind === tsMorph.SyntaxKind.ParenthesizedType) {
                            _return += '(' + _firstPart + ')' + kindToType(type.kind);
                        }
                        else {
                            _return += _firstPart + kindToType(type.kind);
                        }
                    }
                    else {
                        if (tsMorph.ts.isLiteralTypeNode(type) && type.literal) {
                            if (type.literal.text) {
                                _return += '"' + type.literal.text + '"';
                            }
                            else {
                                _return += kindToType(type.literal.kind);
                            }
                        }
                        else {
                            _return += kindToType(type.kind);
                        }
                        if (type.typeName) {
                            _return += _this.visitTypeName(type.typeName);
                        }
                        if (type.kind === tsMorph.SyntaxKind.RestType && type.type) {
                            _return += '...' + _this.visitType(type.type);
                        }
                        if (type.typeArguments) {
                            _return += '<';
                            var typeArguments = [];
                            try {
                                for (var _b = (e_6 = void 0, __values(type.typeArguments)), _c = _b.next(); !_c.done; _c = _b.next()) {
                                    var argument = _c.value;
                                    typeArguments.push(_this.visitType(argument));
                                }
                            }
                            catch (e_6_1) { e_6 = { error: e_6_1 }; }
                            finally {
                                try {
                                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                                }
                                finally { if (e_6) throw e_6.error; }
                            }
                            _return += typeArguments.join(separator);
                            _return += '>';
                        }
                    }
                    if (i < len - 1) {
                        _return += separator;
                    }
                }
            };
            if (node.type.elements && tsMorph.ts.isTupleTypeNode(node.type)) {
                _return += '[';
                parseTypesOrElements(node.type.elements, ', ');
                _return += ']';
            }
            if (node.type.types && tsMorph.ts.isUnionTypeNode(node.type)) {
                parseTypesOrElements(node.type.types, ' | ');
            }
            if (node.type.elementTypes) {
                var elementTypes = node.type.elementTypes;
                var i = 0;
                var len = elementTypes.length;
                if (len > 0) {
                    _return = '[';
                    for (i; i < len; i++) {
                        var type = elementTypes[i];
                        if (type.kind === tsMorph.SyntaxKind.ArrayType && type.elementType) {
                            _return += kindToType(type.elementType.kind);
                            _return += kindToType(type.kind);
                        }
                        else {
                            _return += kindToType(type.kind);
                        }
                        if (tsMorph.ts.isLiteralTypeNode(type) && type.literal) {
                            if (type.literal.text) {
                                _return += '"' + type.literal.text + '"';
                            }
                            else {
                                _return += kindToType(type.literal.kind);
                            }
                        }
                        if (type.typeName) {
                            _return += this.visitTypeName(type.typeName);
                        }
                        if (type.kind === tsMorph.SyntaxKind.RestType && type.type) {
                            _return += '...' + this.visitType(type.type);
                        }
                        if (type.kind === tsMorph.SyntaxKind.TypeReference &&
                            type.typeName &&
                            typeof type.typeName.escapedText !== 'undefined' &&
                            type.typeName.escapedText === '') {
                            continue;
                        }
                        if (i < len - 1) {
                            _return += ', ';
                        }
                    }
                    _return += ']';
                }
            }
            if (node.type &&
                node.type.kind === tsMorph.SyntaxKind.IndexedAccessType &&
                node.type.objectType &&
                node.type.objectType.typeName) {
                _return = this.visitTypeName(node.type.objectType.typeName);
            }
        }
        else if (node.elementType) {
            _return = kindToType(node.elementType.kind) + kindToType(node.kind);
            if (node.elementType.typeName) {
                _return = this.visitTypeName(node.elementType.typeName) + kindToType(node.kind);
            }
        }
        else if (node.types && tsMorph.ts.isUnionTypeNode(node)) {
            _return = '';
            var i = 0;
            var len = node.types.length;
            for (i; i < len; i++) {
                var type = node.types[i];
                _return += kindToType(type.kind);
                if (tsMorph.ts.isLiteralTypeNode(type) && type.literal) {
                    if (type.literal.text) {
                        _return += '"' + type.literal.text + '"';
                    }
                    else {
                        _return += kindToType(type.literal.kind);
                    }
                }
                if (type.typeName) {
                    _return += this.visitTypeName(type.typeName);
                }
                if (i < len - 1) {
                    _return += ' | ';
                }
            }
        }
        else if (node.dotDotDotToken) {
            _return = 'any[]';
        }
        else {
            _return = kindToType(node.kind);
            if (_return === '' &&
                node.initializer &&
                node.initializer.kind &&
                (node.kind === tsMorph.SyntaxKind.PropertyDeclaration || node.kind === tsMorph.SyntaxKind.Parameter)) {
                _return = kindToType(node.initializer.kind);
            }
            if (node.kind === tsMorph.SyntaxKind.TypeParameter) {
                _return = node.name.text;
            }
            if (node.kind === tsMorph.SyntaxKind.LiteralType) {
                _return = node.literal.text;
            }
        }
        if (node.typeArguments && node.typeArguments.length > 0) {
            _return += '<';
            var i = 0, len = node.typeArguments.length;
            for (i; i < len; i++) {
                var argument = node.typeArguments[i];
                _return += this.visitType(argument);
                if (i >= 0 && i < len - 1) {
                    _return += ', ';
                }
            }
            _return += '>';
        }
        return _return;
    };
    ClassHelper.prototype.visitCallDeclaration = function (method, sourceFile) {
        var _this = this;
        var sourceCode = sourceFile.getText();
        var hash = crypto$7.createHash('sha512').update(sourceCode).digest('hex');
        var result = {
            id: 'call-declaration-' + hash,
            args: method.parameters ? method.parameters.map(function (prop) { return _this.visitArgument(prop); }) : [],
            returnType: this.visitType(method.type),
            line: this.getPosition(method, sourceFile).line + 1,
            deprecated: false,
            deprecationMessage: ''
        };
        if (method.jsDoc) {
            var comment = this.jsdocParserUtil.getMainCommentOfNode(method, sourceFile);
            var cleanedDescription = this.jsdocParserUtil.parseComment(comment);
            result.rawdescription = cleanedDescription;
            result.description = markedAcl(cleanedDescription);
        }
        var jsdoctags = this.jsdocParserUtil.getJSDocs(method);
        if (jsdoctags && jsdoctags.length >= 1 && jsdoctags[0].tags) {
            this.checkForDeprecation(jsdoctags[0].tags, result);
            result.jsdoctags = markedtags(jsdoctags[0].tags);
        }
        return result;
    };
    ClassHelper.prototype.visitIndexDeclaration = function (method, sourceFile) {
        var _this = this;
        var sourceCode = sourceFile.getText();
        var hash = crypto$7.createHash('sha512').update(sourceCode).digest('hex');
        var result = {
            id: 'index-declaration-' + hash,
            args: method.parameters ? method.parameters.map(function (prop) { return _this.visitArgument(prop); }) : [],
            returnType: this.visitType(method.type),
            line: this.getPosition(method, sourceFile).line + 1,
            deprecated: false,
            deprecationMessage: ''
        };
        var jsdoctags = this.jsdocParserUtil.getJSDocs(method);
        if (method.jsDoc) {
            var comment = this.jsdocParserUtil.getMainCommentOfNode(method, sourceFile);
            var cleanedDescription = this.jsdocParserUtil.parseComment(comment);
            result.rawdescription = cleanedDescription;
            result.description = markedAcl(cleanedDescription);
        }
        if (jsdoctags && jsdoctags.length >= 1) {
            if (jsdoctags[0].tags) {
                this.checkForDeprecation(jsdoctags[0].tags, result);
                if (method.jsDoc) {
                    result.jsdoctags = markedtags(jsdoctags[0].tags);
                }
            }
        }
        return result;
    };
    ClassHelper.prototype.visitConstructorDeclaration = function (method, sourceFile) {
        var _this = this;
        /**
         * Copyright https://github.com/ng-bootstrap/ng-bootstrap
         */
        var result = {
            name: 'constructor',
            description: '',
            deprecated: false,
            deprecationMessage: '',
            args: method.parameters ? method.parameters.map(function (prop) { return _this.visitArgument(prop); }) : [],
            line: this.getPosition(method, sourceFile).line + 1
        };
        var jsdoctags = this.jsdocParserUtil.getJSDocs(method);
        if (method.jsDoc) {
            var comment = this.jsdocParserUtil.getMainCommentOfNode(method, sourceFile);
            var cleanedDescription = this.jsdocParserUtil.parseComment(comment);
            result.rawdescription = cleanedDescription;
            result.description = markedAcl(cleanedDescription);
        }
        if (method.modifiers) {
            if (method.modifiers.length > 0) {
                var kinds = method.modifiers.map(function (modifier) {
                    return modifier.kind;
                });
                if (___namespace.indexOf(kinds, tsMorph.SyntaxKind.PublicKeyword) !== -1 &&
                    ___namespace.indexOf(kinds, tsMorph.SyntaxKind.StaticKeyword) !== -1) {
                    kinds = kinds.filter(function (kind) { return kind !== tsMorph.SyntaxKind.PublicKeyword; });
                }
                result.modifierKind = kinds;
            }
        }
        if (jsdoctags && jsdoctags.length >= 1 && jsdoctags[0].tags) {
            this.checkForDeprecation(jsdoctags[0].tags, result);
            result.jsdoctags = markedtags(jsdoctags[0].tags);
        }
        if (result.jsdoctags && result.jsdoctags.length > 0) {
            result.jsdoctags = mergeTagsAndArgs(result.args, result.jsdoctags);
        }
        else if (result.args.length > 0) {
            result.jsdoctags = mergeTagsAndArgs(result.args);
        }
        return result;
    };
    ClassHelper.prototype.visitProperty = function (property, sourceFile) {
        var result = {
            name: property.name.text,
            defaultValue: property.initializer
                ? this.stringifyDefaultValue(property.initializer)
                : undefined,
            deprecated: false,
            deprecationMessage: '',
            type: this.visitType(property),
            indexKey: this.visitTypeIndex(property),
            optional: typeof property.questionToken !== 'undefined',
            description: '',
            line: this.getPosition(property, sourceFile).line + 1
        };
        var jsdoctags;
        if (property.initializer && property.initializer.kind === tsMorph.SyntaxKind.ArrowFunction) {
            result.defaultValue = '() => {...}';
        }
        if (typeof result.name === 'undefined' && typeof property.name.expression !== 'undefined') {
            result.name = property.name.expression.text;
        }
        jsdoctags = this.jsdocParserUtil.getJSDocs(property);
        if (property.jsDoc) {
            var comment = this.jsdocParserUtil.getMainCommentOfNode(property, sourceFile);
            var cleanedDescription = this.jsdocParserUtil.parseComment(comment);
            result.rawdescription = cleanedDescription;
            result.description = markedAcl(cleanedDescription);
        }
        if (nodeHasDecorator(property)) {
            var propertyDecorators = getNodeDecorators(property);
            result.decorators = this.formatDecorators(propertyDecorators);
        }
        if (property.modifiers) {
            if (property.modifiers.length > 0) {
                var kinds = property.modifiers.map(function (modifier) {
                    return modifier.kind;
                });
                if (___namespace.indexOf(kinds, tsMorph.SyntaxKind.PublicKeyword) !== -1 &&
                    ___namespace.indexOf(kinds, tsMorph.SyntaxKind.StaticKeyword) !== -1) {
                    kinds = kinds.filter(function (kind) { return kind !== tsMorph.SyntaxKind.PublicKeyword; });
                }
                result.modifierKind = kinds;
            }
        }
        // Check for ECMAScript Private Fields
        if (this.isPrivate(property)) {
            if (!result.modifierKind) {
                result.modifierKind = [];
            }
            var hasAlreadyPrivateLeyword_1 = false;
            result.modifierKind.forEach(function (modifierKind) {
                if (modifierKind === tsMorph.SyntaxKind.PrivateKeyword) {
                    hasAlreadyPrivateLeyword_1 = true;
                }
            });
            if (!hasAlreadyPrivateLeyword_1) {
                result.modifierKind.push(tsMorph.SyntaxKind.PrivateKeyword);
            }
        }
        if (jsdoctags && jsdoctags.length >= 1 && jsdoctags[0].tags) {
            this.checkForDeprecation(jsdoctags[0].tags, result);
            if (property.jsDoc) {
                result.jsdoctags = markedtags(jsdoctags[0].tags);
            }
        }
        return result;
    };
    ClassHelper.prototype.visitConstructorProperties = function (constr, sourceFile) {
        if (constr.parameters) {
            var _parameters_1 = [];
            var i = 0;
            var len = constr.parameters.length;
            for (i; i < len; i++) {
                var parameterOfConstructor = constr.parameters[i];
                if (isIgnore(parameterOfConstructor)) {
                    continue;
                }
                if (this.isInternal(parameterOfConstructor) &&
                    Configuration$1.mainData.disableInternal) {
                    continue;
                }
                if (this.isPublic(parameterOfConstructor)) {
                    _parameters_1.push(this.visitProperty(constr.parameters[i], sourceFile));
                }
            }
            /**
             * Merge JSDoc tags description from constructor with parameters
             */
            if (constr.jsDoc) {
                if (constr.jsDoc.length > 0) {
                    var constrTags = constr.jsDoc[0].tags;
                    if (constrTags && constrTags.length > 0) {
                        constrTags.forEach(function (tag) {
                            _parameters_1.forEach(function (param) {
                                if (tag.tagName &&
                                    tag.tagName.escapedText &&
                                    tag.tagName.escapedText === 'param') {
                                    if (tag.name &&
                                        tag.name.escapedText &&
                                        tag.name.escapedText === param.name) {
                                        param.description = tag.comment;
                                    }
                                }
                            });
                        });
                    }
                }
            }
            return _parameters_1;
        }
        else {
            return [];
        }
    };
    ClassHelper.prototype.visitMethodDeclaration = function (method, sourceFile) {
        var _this = this;
        var result = {
            name: method.name.text,
            args: method.parameters ? method.parameters.map(function (prop) { return _this.visitArgument(prop); }) : [],
            optional: typeof method.questionToken !== 'undefined',
            returnType: this.visitType(method.type),
            typeParameters: [],
            line: this.getPosition(method, sourceFile).line + 1,
            deprecated: false,
            deprecationMessage: ''
        };
        var jsdoctags = this.jsdocParserUtil.getJSDocs(method);
        if (typeof method.type === 'undefined') {
            // Try to get inferred type
            if (method.symbol) {
                var symbol = method.symbol;
                if (symbol.valueDeclaration) {
                    var symbolType = this.typeChecker.getTypeOfSymbolAtLocation(symbol, symbol.valueDeclaration);
                    if (symbolType) {
                        try {
                            var signature = this.typeChecker.getSignatureFromDeclaration(method);
                            var returnType = signature.getReturnType();
                            result.returnType = this.typeChecker.typeToString(returnType);
                            // tslint:disable-next-line:no-empty
                        }
                        catch (error) { }
                    }
                }
            }
        }
        if (method.typeParameters && method.typeParameters.length > 0) {
            result.typeParameters = method.typeParameters.map(function (typeParameter) {
                return _this.visitType(typeParameter);
            });
        }
        if (method.jsDoc) {
            var comment = this.jsdocParserUtil.getMainCommentOfNode(method, sourceFile);
            var cleanedDescription = this.jsdocParserUtil.parseComment(comment);
            result.rawdescription = cleanedDescription;
            result.description = markedAcl(cleanedDescription);
        }
        if (nodeHasDecorator(method)) {
            var methodDecorators = getNodeDecorators(method);
            result.decorators = this.formatDecorators(methodDecorators);
        }
        if (method.modifiers) {
            if (method.modifiers.length > 0) {
                var kinds = method.modifiers.map(function (modifier) {
                    return modifier.kind;
                });
                if (___namespace.indexOf(kinds, tsMorph.SyntaxKind.PublicKeyword) !== -1 &&
                    ___namespace.indexOf(kinds, tsMorph.SyntaxKind.StaticKeyword) !== -1) {
                    kinds = kinds.filter(function (kind) { return kind !== tsMorph.SyntaxKind.PublicKeyword; });
                }
                result.modifierKind = kinds;
            }
        }
        // Check for ECMAScript Private Fields
        if (this.isPrivate(method)) {
            if (!result.modifierKind) {
                result.modifierKind = [];
            }
            var hasAlreadyPrivateLeyword_2 = false;
            result.modifierKind.forEach(function (modifierKind) {
                if (modifierKind === tsMorph.SyntaxKind.PrivateKeyword) {
                    hasAlreadyPrivateLeyword_2 = true;
                }
            });
            if (!hasAlreadyPrivateLeyword_2) {
                result.modifierKind.push(tsMorph.SyntaxKind.PrivateKeyword);
            }
        }
        if (jsdoctags && jsdoctags.length >= 1 && jsdoctags[0].tags) {
            this.checkForDeprecation(jsdoctags[0].tags, result);
            result.jsdoctags = markedtags(jsdoctags[0].tags);
        }
        if (result.jsdoctags && result.jsdoctags.length > 0) {
            result.jsdoctags = mergeTagsAndArgs(result.args, result.jsdoctags);
        }
        else if (result.args.length > 0) {
            result.jsdoctags = mergeTagsAndArgs(result.args);
        }
        return result;
    };
    ClassHelper.prototype.visitOutput = function (property, outDecorator, sourceFile) {
        var inArgs = outDecorator.expression.arguments;
        var _return = {
            name: inArgs.length > 0 ? inArgs[0].text : property.name.text,
            defaultValue: property.initializer
                ? this.stringifyDefaultValue(property.initializer)
                : undefined,
            deprecated: false,
            deprecationMessage: ''
        };
        if (property.jsDoc) {
            var comment = this.jsdocParserUtil.getMainCommentOfNode(property, sourceFile);
            var jsdoctags = this.jsdocParserUtil.getJSDocs(property);
            var cleanedDescription = this.jsdocParserUtil.parseComment(comment);
            _return.rawdescription = cleanedDescription;
            _return.description = markedAcl(cleanedDescription);
            if (jsdoctags && jsdoctags.length >= 1 && jsdoctags[0].tags) {
                this.checkForDeprecation(jsdoctags[0].tags, _return);
                _return.jsdoctags = markedtags(jsdoctags[0].tags);
            }
        }
        if (!_return.description) {
            if (property.jsDoc && property.jsDoc.length > 0) {
                if (typeof property.jsDoc[0].comment !== 'undefined') {
                    var rawDescription = property.jsDoc[0].comment;
                    _return.rawdescription = rawDescription;
                    _return.description = markedAcl(rawDescription);
                }
            }
        }
        _return.line = this.getPosition(property, sourceFile).line + 1;
        if (property.type) {
            _return.type = this.visitType(property);
        }
        else {
            // handle NewExpression
            if (property.initializer) {
                if (tsMorph.ts.isNewExpression(property.initializer)) {
                    if (property.initializer.expression) {
                        _return.type = property.initializer.expression.text;
                    }
                }
            }
        }
        return _return;
    };
    ClassHelper.prototype.visitArgument = function (arg) {
        var _this = this;
        var _result = {
            name: arg.name.text,
            type: this.visitType(arg),
            deprecated: false,
            deprecationMessage: ''
        };
        if (arg.dotDotDotToken) {
            _result.dotDotDotToken = true;
        }
        if (arg.questionToken) {
            _result.optional = true;
        }
        if (arg.type) {
            if (arg.type.kind) {
                if (tsMorph.ts.isFunctionTypeNode(arg.type)) {
                    _result.function = arg.type.parameters
                        ? arg.type.parameters.map(function (prop) { return _this.visitArgument(prop); })
                        : [];
                }
            }
        }
        if (arg.initializer) {
            _result.defaultValue = this.stringifyDefaultValue(arg.initializer);
        }
        var jsdoctags = this.jsdocParserUtil.getJSDocs(arg);
        if (jsdoctags && jsdoctags.length >= 1 && jsdoctags[0].tags) {
            this.checkForDeprecation(jsdoctags[0].tags, _result);
        }
        return _result;
    };
    ClassHelper.prototype.visitInputAndHostBinding = function (property, inDecorator, sourceFile) {
        var inArgs = inDecorator.expression.arguments;
        var _return = {};
        var isInputConfigStringLiteral = false;
        var isInputConfigObjectLiteralExpression = false;
        var hasRequiredField = false;
        var hasAlias = false;
        var getRequiredField = function () {
            return inArgs[0].properties.find(function (property) { return property.name.escapedText === 'required'; });
        };
        var getAliasProperty = function () {
            return inArgs[0].properties.find(function (property) { return property.name.escapedText === 'alias'; });
        };
        if (inArgs.length > 0) {
            isInputConfigStringLiteral = inArgs[0] && tsMorph.ts.isStringLiteral(inArgs[0]);
            isInputConfigObjectLiteralExpression =
                inArgs[0] && tsMorph.ts.isObjectLiteralExpression(inArgs[0]);
            if (isInputConfigObjectLiteralExpression && inArgs[0].properties) {
                hasRequiredField = isInputConfigObjectLiteralExpression && !!getRequiredField();
                hasAlias = isInputConfigObjectLiteralExpression ? !!getAliasProperty() : false;
                _return.required = !!getRequiredField();
            }
            _return.name = isInputConfigStringLiteral
                ? inArgs[0].text
                : hasAlias
                    ? getAliasProperty().initializer.text
                    : property.name.text;
        }
        else {
            _return.name = property.name.text;
        }
        _return.defaultValue = property.initializer
            ? this.stringifyDefaultValue(property.initializer)
            : undefined;
        _return.deprecated = false;
        _return.deprecationMessage = '';
        if (inArgs.length > 0 && inArgs[0].properties && hasRequiredField) {
            _return.optional = getRequiredField().initializer.kind !== tsMorph.SyntaxKind.TrueKeyword;
        }
        if (!_return.description) {
            if (property.jsDoc) {
                if (property.jsDoc.length > 0) {
                    var jsdoctags = this.jsdocParserUtil.getJSDocs(property);
                    if (jsdoctags && jsdoctags.length >= 1 && jsdoctags[0].tags) {
                        this.checkForDeprecation(jsdoctags[0].tags, _return);
                        _return.jsdoctags = markedtags(jsdoctags[0].tags);
                    }
                    if (typeof property.jsDoc[0].comment !== 'undefined') {
                        var comment = this.jsdocParserUtil.getMainCommentOfNode(property, sourceFile);
                        var cleanedDescription = this.jsdocParserUtil.parseComment(comment);
                        _return.rawdescription = cleanedDescription;
                        _return.description = markedAcl(cleanedDescription);
                    }
                }
            }
        }
        _return.line = this.getPosition(property, sourceFile).line + 1;
        if (property.type) {
            _return.type = this.visitType(property);
        }
        else {
            // handle NewExpression
            if (property.initializer) {
                if (tsMorph.ts.isNewExpression(property.initializer)) {
                    if (property.initializer.expression) {
                        _return.type = property.initializer.expression.text;
                    }
                }
            }
            // Try to get inferred type
            if (property.symbol) {
                var symbol = property.symbol;
                if (symbol.valueDeclaration) {
                    var symbolType = this.typeChecker.getTypeOfSymbolAtLocation(symbol, symbol.valueDeclaration);
                    if (symbolType) {
                        _return.type = this.typeChecker.typeToString(symbolType);
                    }
                }
            }
        }
        if (property.kind === tsMorph.SyntaxKind.SetAccessor) {
            // For setter accessor, find type in first parameter
            if (property.parameters && property.parameters.length === 1) {
                if (property.parameters[0].type) {
                    _return.type = this.visitType(property.parameters[0].type);
                }
            }
        }
        if (nodeHasDecorator(property)) {
            var propertyDecorators = getNodeDecorators(property);
            _return.decorators = this.formatDecorators(propertyDecorators).filter(function (item) { return item.name !== 'Input' && item.name !== 'HostBinding'; });
        }
        return _return;
    };
    ClassHelper.prototype.visitHostListener = function (property, hostListenerDecorator, sourceFile) {
        var _this = this;
        var inArgs = hostListenerDecorator.expression.arguments;
        var _return = {};
        _return.name = inArgs.length > 0 ? inArgs[0].text : property.name.text;
        _return.args = property.parameters
            ? property.parameters.map(function (prop) { return _this.visitArgument(prop); })
            : [];
        _return.argsDecorator =
            inArgs.length > 1
                ? inArgs[1].elements.map(function (prop) {
                    return prop.text;
                })
                : [];
        _return.deprecated = false;
        _return.deprecationMessage = '';
        if (property.jsDoc) {
            var comment = this.jsdocParserUtil.getMainCommentOfNode(property, sourceFile);
            var jsdoctags = this.jsdocParserUtil.getJSDocs(property);
            var cleanedDescription = this.jsdocParserUtil.parseComment(comment);
            _return.rawdescription = cleanedDescription;
            _return.description = markedAcl(cleanedDescription);
            if (jsdoctags && jsdoctags.length >= 1 && jsdoctags[0].tags) {
                this.checkForDeprecation(jsdoctags[0].tags, _return);
                _return.jsdoctags = markedtags(jsdoctags[0].tags);
            }
        }
        if (!_return.description) {
            if (property.jsDoc) {
                if (property.jsDoc.length > 0) {
                    if (typeof property.jsDoc[0].comment !== 'undefined') {
                        var rawDescription = property.jsDoc[0].comment;
                        _return.rawdescription = rawDescription;
                        _return.description = markedAcl(rawDescription);
                    }
                }
            }
        }
        _return.line = this.getPosition(property, sourceFile).line + 1;
        return _return;
    };
    return ClassHelper;
}());

var TsPrinterUtil = /** @class */ (function () {
    function TsPrinterUtil() {
        this.printer = tsMorph.ts.createPrinter({
            newLine: tsMorph.ts.NewLineKind.LineFeed
        });
    }
    TsPrinterUtil.prototype.print = function (node) {
        return this.printer.printNode(tsMorph.ts.EmitHint.Unspecified, node, tsMorph.ts.createSourceFile('', '', tsMorph.ts.ScriptTarget.Latest));
    };
    return TsPrinterUtil;
}());

var SymbolHelper = /** @class */ (function () {
    function SymbolHelper() {
        this.unknown = '???';
    }
    SymbolHelper.prototype.parseDeepIndentifier = function (name, srcFile) {
        var result = {
            name: '',
            type: ''
        };
        if (typeof name === 'undefined') {
            return result;
        }
        var nsModule = name.split('.');
        var type = this.getType(name);
        if (nsModule.length > 1) {
            result.ns = nsModule[0];
            result.name = name;
            result.type = type;
            return result;
        }
        if (typeof srcFile !== 'undefined') {
            result.file = ImportsUtil$1.getFileNameOfImport(name, srcFile);
        }
        result.name = name;
        result.type = type;
        return result;
    };
    SymbolHelper.prototype.getType = function (name) {
        var type;
        if (name.toLowerCase().indexOf('component') !== -1) {
            type = 'component';
        }
        else if (name.toLowerCase().indexOf('pipe') !== -1) {
            type = 'pipe';
        }
        else if (name.toLowerCase().indexOf('controller') !== -1) {
            type = 'controller';
        }
        else if (name.toLowerCase().indexOf('module') !== -1) {
            type = 'module';
        }
        else if (name.toLowerCase().indexOf('directive') !== -1) {
            type = 'directive';
        }
        else if (name.toLowerCase().indexOf('injectable') !== -1 ||
            name.toLowerCase().indexOf('service') !== -1) {
            type = 'injectable';
        }
        return type;
    };
    /**
     * Output
     * RouterModule.forRoot 179
     */
    SymbolHelper.prototype.buildIdentifierName = function (node, name) {
        if (tsMorph.ts.isIdentifier(node) && !tsMorph.ts.isPropertyAccessExpression(node)) {
            return "".concat(node.text, ".").concat(name);
        }
        name = name ? ".".concat(name) : '';
        var nodeName = this.unknown;
        if (node.name) {
            nodeName = node.name.text;
        }
        else if (node.text) {
            nodeName = node.text;
        }
        else if (node.expression) {
            if (node.expression.text) {
                nodeName = node.expression.text;
            }
            else if (node.expression.elements) {
                if (tsMorph.ts.isArrayLiteralExpression(node.expression)) {
                    nodeName = node.expression.elements.map(function (el) { return el.text; }).join(', ');
                    nodeName = "[".concat(nodeName, "]");
                }
            }
        }
        if (tsMorph.ts.isSpreadElement(node)) {
            return "...".concat(nodeName);
        }
        return "".concat(this.buildIdentifierName(node.expression, nodeName)).concat(name);
    };
    /**
     * parse expressions such as:
     * { provide: APP_BASE_HREF, useValue: '/' }
     * { provide: 'Date', useFactory: (d1, d2) => new Date(), deps: ['d1', 'd2'] }
     */
    SymbolHelper.prototype.parseProviderConfiguration = function (node) {
        if (node.kind && node.kind === tsMorph.SyntaxKind.ObjectLiteralExpression) {
            // Search for provide: HTTP_INTERCEPTORS
            // and if true, return type: 'interceptor' + name
            var interceptorName_1, hasInterceptor_1;
            if (node.properties) {
                if (node.properties.length > 0) {
                    ___namespace.forEach(node.properties, function (property) {
                        if (property.kind && property.kind === tsMorph.SyntaxKind.PropertyAssignment) {
                            if (property.name.text === 'provide') {
                                if (property.initializer.text === 'HTTP_INTERCEPTORS') {
                                    hasInterceptor_1 = true;
                                }
                            }
                            if (property.name.text === 'useClass' ||
                                property.name.text === 'useExisting') {
                                interceptorName_1 = property.initializer.text;
                            }
                        }
                    });
                }
            }
            if (hasInterceptor_1) {
                return interceptorName_1;
            }
            else {
                return new TsPrinterUtil().print(node);
            }
        }
        else {
            return new TsPrinterUtil().print(node);
        }
    };
    /**
     * Kind
     *  181 CallExpression => "RouterModule.forRoot(args)"
     *   71 Identifier     => "RouterModule" "TodoStore"
     *    9 StringLiteral  => "./app.component.css" "./tab.scss"
     */
    SymbolHelper.prototype.parseSymbolElements = function (node) {
        // parse expressions such as: AngularFireModule.initializeApp(firebaseConfig)
        // if (ts.isCallExpression(node) && ts.isPropertyAccessExpression(node.expression)) {
        if ((tsMorph.ts.isCallExpression(node) && tsMorph.ts.isPropertyAccessExpression(node.expression)) ||
            (tsMorph.ts.isNewExpression(node) && tsMorph.ts.isElementAccessExpression(node.expression))) {
            var className = this.buildIdentifierName(node.expression);
            // function arguments could be really complex. There are so
            // many use cases that we can't handle. Just print "args" to indicate
            // that we have arguments.
            var functionArgs = node.arguments.length > 0 ? 'args' : '';
            var text = "".concat(className, "(").concat(functionArgs, ")");
            return text;
        }
        else if (tsMorph.ts.isPropertyAccessExpression(node)) {
            // parse expressions such as: Shared.Module
            return this.buildIdentifierName(node);
        }
        else if (tsMorph.ts.isIdentifier(node)) {
            // parse expressions such as: MyComponent
            if (node.text) {
                return node.text;
            }
            if (node.escapedText) {
                return node.escapedText;
            }
        }
        else if (tsMorph.ts.isSpreadElement(node)) {
            // parse expressions such as: ...MYARRAY
            // Resolve MYARRAY in imports or local file variables after full scan, just return the name of the variable
            if (node.expression && node.expression.text) {
                return node.expression.text;
            }
        }
        return node.text ? node.text : this.parseProviderConfiguration(node);
    };
    /**
     * Kind
     *  177 ArrayLiteralExpression
     *  122 BooleanKeyword
     *    9 StringLiteral
     */
    SymbolHelper.prototype.parseSymbols = function (node, srcFile, decoratorType) {
        var _this = this;
        var localNode = node;
        if (tsMorph.ts.isShorthandPropertyAssignment(localNode) && decoratorType !== 'template') {
            localNode = ImportsUtil$1.findValueInImportOrLocalVariables(node.name.text, srcFile, decoratorType);
        }
        if (tsMorph.ts.isShorthandPropertyAssignment(localNode) && decoratorType === 'template') {
            var data = ImportsUtil$1.findValueInImportOrLocalVariables(node.name.text, srcFile, decoratorType);
            return [data];
        }
        if (localNode.initializer && tsMorph.ts.isArrayLiteralExpression(localNode.initializer)) {
            return localNode.initializer.elements.map(function (x) { return _this.parseSymbolElements(x); });
        }
        else if ((localNode.initializer && tsMorph.ts.isStringLiteral(localNode.initializer)) ||
            (localNode.initializer && tsMorph.ts.isTemplateLiteral(localNode.initializer)) ||
            (localNode.initializer &&
                tsMorph.ts.isPropertyAssignment(localNode) &&
                localNode.initializer.text)) {
            return [localNode.initializer.text];
        }
        else if (localNode.initializer &&
            localNode.initializer.kind &&
            (localNode.initializer.kind === tsMorph.SyntaxKind.TrueKeyword ||
                localNode.initializer.kind === tsMorph.SyntaxKind.FalseKeyword)) {
            return [localNode.initializer.kind === tsMorph.SyntaxKind.TrueKeyword ? true : false];
        }
        else if (localNode.initializer && tsMorph.ts.isPropertyAccessExpression(localNode.initializer)) {
            var identifier = this.parseSymbolElements(localNode.initializer);
            return [identifier];
        }
        else if (localNode.initializer &&
            localNode.initializer.elements &&
            localNode.initializer.elements.length > 0) {
            // Node replaced by ts-simple-ast & kind = 265
            return localNode.initializer.elements.map(function (x) { return _this.parseSymbolElements(x); });
        }
    };
    SymbolHelper.prototype.getSymbolDeps = function (props, decoratorType, srcFile, multiLine) {
        var _this = this;
        if (props.length === 0) {
            return [];
        }
        var i = 0, len = props.length, filteredProps = [];
        for (i; i < len; i++) {
            if (props[i].name && props[i].name.text === decoratorType) {
                filteredProps.push(props[i]);
            }
        }
        return filteredProps.map(function (x) { return _this.parseSymbols(x, srcFile, decoratorType); }).pop() || [];
    };
    SymbolHelper.prototype.getSymbolDepsRaw = function (props, type, multiLine) {
        return props.filter(function (node) { return node.name.text === type; });
    };
    return SymbolHelper;
}());

var ComponentHelper = /** @class */ (function () {
    function ComponentHelper(classHelper, symbolHelper) {
        if (symbolHelper === void 0) { symbolHelper = new SymbolHelper(); }
        this.classHelper = classHelper;
        this.symbolHelper = symbolHelper;
    }
    ComponentHelper.prototype.getComponentChangeDetection = function (props, srcFile) {
        return this.symbolHelper.getSymbolDeps(props, 'changeDetection', srcFile).pop();
    };
    ComponentHelper.prototype.getComponentEncapsulation = function (props, srcFile) {
        return this.symbolHelper.getSymbolDeps(props, 'encapsulation', srcFile);
    };
    ComponentHelper.prototype.getComponentPure = function (props, srcFile) {
        return this.symbolHelper.getSymbolDeps(props, 'pure', srcFile).pop();
    };
    ComponentHelper.prototype.getComponentName = function (props, srcFile) {
        return this.symbolHelper.getSymbolDeps(props, 'name', srcFile).pop();
    };
    ComponentHelper.prototype.getComponentExportAs = function (props, srcFile) {
        return this.symbolHelper.getSymbolDeps(props, 'exportAs', srcFile).pop();
    };
    ComponentHelper.prototype.getComponentHostDirectives = function (props) {
        var hostDirectiveSymbolParsed = this.symbolHelper.getSymbolDepsRaw(props, 'hostDirectives');
        var hostDirectiveSymbol = null;
        if (hostDirectiveSymbolParsed.length > 0) {
            hostDirectiveSymbol = hostDirectiveSymbolParsed.pop();
        }
        var result = [];
        if (hostDirectiveSymbol &&
            hostDirectiveSymbol.initializer &&
            hostDirectiveSymbol.initializer.elements &&
            hostDirectiveSymbol.initializer.elements.length > 0) {
            hostDirectiveSymbol.initializer.elements.forEach(function (element) {
                if (element.kind === tsMorph.SyntaxKind.Identifier) {
                    result.push({
                        name: element.escapedText
                    });
                }
                else if (element.kind === tsMorph.SyntaxKind.ObjectLiteralExpression &&
                    element.properties &&
                    element.properties.length > 0) {
                    var parsedDirective_1 = {
                        name: '',
                        inputs: [],
                        outputs: []
                    };
                    element.properties.forEach(function (property) {
                        if (property.name.escapedText === 'directive') {
                            parsedDirective_1.name = property.initializer.escapedText;
                        }
                        else if (property.name.escapedText === 'inputs') {
                            if (property.initializer &&
                                property.initializer.elements &&
                                property.initializer.elements.length > 0) {
                                property.initializer.elements.forEach(function (propertyElement) {
                                    parsedDirective_1.inputs.push(propertyElement.text);
                                });
                            }
                        }
                        else if (property.name.escapedText === 'outputs') {
                            if (property.initializer &&
                                property.initializer.elements &&
                                property.initializer.elements.length > 0) {
                                property.initializer.elements.forEach(function (propertyElement) {
                                    parsedDirective_1.outputs.push(propertyElement.text);
                                });
                            }
                        }
                    });
                    result.push(parsedDirective_1);
                }
            });
        }
        return result;
    };
    ComponentHelper.prototype.getComponentHost = function (props) {
        return this.getSymbolDepsObject(props, 'host');
    };
    ComponentHelper.prototype.getComponentTag = function (props, srcFile) {
        return this.symbolHelper.getSymbolDeps(props, 'tag', srcFile).pop();
    };
    ComponentHelper.prototype.getComponentInputsMetadata = function (props, srcFile) {
        return this.symbolHelper.getSymbolDeps(props, 'inputs', srcFile);
    };
    ComponentHelper.prototype.getInputSignals = function (props) {
        var inputSignals = [];
        props === null || props === void 0 ? void 0 : props.forEach(function (prop, i) {
            var _a, _b, _c, _d;
            var regexpInput = /input(?:\.(required))?(?:<([\w-]+)>)?\(([\w-]+)?\)/;
            var resInput = regexpInput.exec(prop.defaultValue);
            if (resInput) {
                var newInput = prop;
                newInput.defaultValue = resInput[resInput.length - 1];
                newInput.required = (_b = (_a = resInput[0]) === null || _a === void 0 ? void 0 : _a.includes('.required')) !== null && _b !== void 0 ? _b : false;
                inputSignals.push(newInput);
            }
            else {
                var regexpModel = /model(?:\.(required))?(?:<([\w-]+)>)?\(([\w-]+)?\)/;
                var resModel = regexpModel.exec(prop.defaultValue);
                if (resModel) {
                    var newInput = prop;
                    newInput.defaultValue = resModel[resModel.length - 1];
                    newInput.required = (_d = (_c = resModel[0]) === null || _c === void 0 ? void 0 : _c.includes('.required')) !== null && _d !== void 0 ? _d : false;
                    inputSignals.push(newInput);
                }
            }
        });
        return inputSignals;
    };
    ComponentHelper.prototype.getOutputSignals = function (props) {
        var outputSignals = [];
        props === null || props === void 0 ? void 0 : props.forEach(function (prop, i) {
            var _a, _b;
            var regexp = /output(?:\.(required))?(?:<([\w-]+)>)?\(([\w-]+)?\)/;
            var res = regexp.exec(prop.defaultValue);
            if (res) {
                var newOutput = prop;
                newOutput.defaultValue = res[res.length - 1];
                newOutput.required = (_b = (_a = res[0]) === null || _a === void 0 ? void 0 : _a.includes('.required')) !== null && _b !== void 0 ? _b : false;
                outputSignals.push(newOutput);
            }
        });
        return outputSignals;
    };
    ComponentHelper.prototype.getComponentStandalone = function (props, srcFile) {
        var result = null;
        var parsedData = this.symbolHelper.getSymbolDeps(props, 'standalone', srcFile);
        if (parsedData.length === 1) {
            result = JSON.parse(parsedData[0]);
        }
        return result;
    };
    ComponentHelper.prototype.getComponentTemplate = function (props, srcFile) {
        var t = this.symbolHelper.getSymbolDeps(props, 'template', srcFile, true).pop();
        if (t) {
            t = detectIndent(t);
            t = t.replace(/\n/, '');
            t = t.replace(/ +$/gm, '');
        }
        return t;
    };
    ComponentHelper.prototype.getComponentStyleUrls = function (props, srcFile) {
        return this.symbolHelper.getSymbolDeps(props, 'styleUrls', srcFile);
    };
    ComponentHelper.prototype.getComponentStyleUrl = function (props, srcFile) {
        return this.symbolHelper.getSymbolDeps(props, 'styleUrl', srcFile).pop();
    };
    ComponentHelper.prototype.getComponentShadow = function (props, srcFile) {
        return this.symbolHelper.getSymbolDeps(props, 'shadow', srcFile).pop();
    };
    ComponentHelper.prototype.getComponentScoped = function (props, srcFile) {
        return this.symbolHelper.getSymbolDeps(props, 'scoped', srcFile).pop();
    };
    ComponentHelper.prototype.getComponentAssetsDir = function (props, srcFile) {
        return this.symbolHelper.getSymbolDeps(props, 'assetsDir', srcFile).pop();
    };
    ComponentHelper.prototype.getComponentAssetsDirs = function (props, srcFile) {
        return this.sanitizeUrls(this.symbolHelper.getSymbolDeps(props, 'assetsDir', srcFile));
    };
    ComponentHelper.prototype.getComponentStyles = function (props, srcFile) {
        return this.symbolHelper.getSymbolDeps(props, 'styles', srcFile);
    };
    ComponentHelper.prototype.getComponentModuleId = function (props, srcFile) {
        return this.symbolHelper.getSymbolDeps(props, 'moduleId', srcFile).pop();
    };
    ComponentHelper.prototype.getComponentOutputs = function (props, srcFile) {
        return this.symbolHelper.getSymbolDeps(props, 'outputs', srcFile);
    };
    ComponentHelper.prototype.getComponentProviders = function (props, srcFile) {
        var _this = this;
        return this.symbolHelper
            .getSymbolDeps(props, 'providers', srcFile)
            .map(function (name) { return _this.symbolHelper.parseDeepIndentifier(name); });
    };
    ComponentHelper.prototype.getComponentImports = function (props, srcFile) {
        var _this = this;
        return this.symbolHelper
            .getSymbolDeps(props, 'imports', srcFile)
            .map(function (name) { return _this.symbolHelper.parseDeepIndentifier(name); });
    };
    ComponentHelper.prototype.getComponentEntryComponents = function (props, srcFile) {
        var _this = this;
        return this.symbolHelper
            .getSymbolDeps(props, 'entryComponents', srcFile)
            .map(function (name) { return _this.symbolHelper.parseDeepIndentifier(name); });
    };
    ComponentHelper.prototype.getComponentViewProviders = function (props, srcFile) {
        var _this = this;
        return this.symbolHelper
            .getSymbolDeps(props, 'viewProviders', srcFile)
            .map(function (name) { return _this.symbolHelper.parseDeepIndentifier(name); });
    };
    ComponentHelper.prototype.getComponentTemplateUrl = function (props, srcFile) {
        return this.symbolHelper.getSymbolDeps(props, 'templateUrl', srcFile);
    };
    ComponentHelper.prototype.getComponentExampleUrls = function (text) {
        var exampleUrlsMatches = text.match(/<example-url>(.*?)<\/example-url>/g);
        var exampleUrls = undefined;
        if (exampleUrlsMatches && exampleUrlsMatches.length) {
            exampleUrls = exampleUrlsMatches.map(function (val) {
                return val.replace(/<\/?example-url>/g, '');
            });
        }
        return exampleUrls;
    };
    ComponentHelper.prototype.getComponentPreserveWhitespaces = function (props, srcFile) {
        return this.symbolHelper.getSymbolDeps(props, 'preserveWhitespaces', srcFile).pop();
    };
    ComponentHelper.prototype.getComponentSelector = function (props, srcFile) {
        return this.symbolHelper.getSymbolDeps(props, 'selector', srcFile).pop();
    };
    ComponentHelper.prototype.parseProperties = function (node) {
        var obj = new Map();
        var properties = node.initializer.properties || [];
        properties.forEach(function (prop) {
            obj.set(prop.name.text, prop.initializer.text);
        });
        return obj;
    };
    ComponentHelper.prototype.getSymbolDepsObject = function (props, type, multiLine) {
        var _this = this;
        var i = 0, len = props.length, filteredProps = [];
        for (i; i < len; i++) {
            if (props[i].name && props[i].name.text === type) {
                filteredProps.push(props[i]);
            }
        }
        return filteredProps.map(function (x) { return _this.parseProperties(x); }).pop();
    };
    ComponentHelper.prototype.getComponentIO = function (filename, sourceFile, node, fileBody, astFile) {
        var _this = this;
        /**
         * Copyright https://github.com/ng-bootstrap/ng-bootstrap
         */
        var reducedSource = fileBody ? fileBody.statements : sourceFile.statements;
        var res = reducedSource.reduce(function (directive, statement) {
            if (tsMorph.ts.isClassDeclaration(statement)) {
                if (statement.pos === node.pos && statement.end === node.end) {
                    return directive.concat(_this.classHelper.visitClassDeclaration(filename, statement, sourceFile, astFile));
                }
            }
            return directive;
        }, []);
        return res[0] || {};
    };
    ComponentHelper.prototype.sanitizeUrls = function (urls) {
        return urls.map(function (url) { return url.replace('./', ''); });
    };
    return ComponentHelper;
}());
var ComponentCache = /** @class */ (function () {
    function ComponentCache() {
        this.cache = new Map();
    }
    ComponentCache.prototype.get = function (key) {
        return this.cache.get(key);
    };
    ComponentCache.prototype.set = function (key, value) {
        this.cache.set(key, value);
    };
    return ComponentCache;
}());

var FrameworkDependencies = /** @class */ (function () {
    function FrameworkDependencies(files, options) {
        this.files = files;
        var transpileOptions = {
            target: tsMorph.ts.ScriptTarget.ES5,
            module: tsMorph.ts.ModuleKind.CommonJS,
            tsconfigDirectory: options.tsconfigDirectory,
            allowJs: true
        };
        this.program = tsMorph.ts.createProgram(this.files, transpileOptions, compilerHost(transpileOptions));
        this.typeChecker = this.program.getTypeChecker();
        this.classHelper = new ClassHelper(this.typeChecker);
        this.componentHelper = new ComponentHelper(this.classHelper);
    }
    return FrameworkDependencies;
}());

var CodeGenerator = /** @class */ (function () {
    function CodeGenerator() {
    }
    CodeGenerator.prototype.generate = function (node) {
        return this.visitAndRecognize(node, []).join('');
    };
    CodeGenerator.prototype.visitAndRecognize = function (node, code, depth) {
        var _this = this;
        if (depth === void 0) { depth = 0; }
        this.recognize(node, code);
        node.getChildren().forEach(function (c) { return _this.visitAndRecognize(c, code, depth + 1); });
        return code;
    };
    CodeGenerator.prototype.recognize = function (node, code) {
        var _this = this;
        var conversion = TsKindConversion.find(function (x) { return x.kinds.some(function (z) { return z === node.kind; }); });
        if (conversion) {
            var result = conversion.output(node);
            result.forEach(function (text) { return _this.gen(text, code); });
        }
    };
    CodeGenerator.prototype.gen = function (token, code) {
        if (!token) {
            return;
        }
        if (token === '\n') {
            code.push('');
        }
        else {
            code.push(token);
        }
    };
    return CodeGenerator;
}());
var TsKindsToText = /** @class */ (function () {
    function TsKindsToText(output, kinds) {
        this.output = output;
        this.kinds = kinds;
    }
    return TsKindsToText;
}());
var TsKindConversion = [
    new TsKindsToText(function (node) { return ['"', node.text, '"']; }, [tsMorph.SyntaxKind.FirstLiteralToken, tsMorph.SyntaxKind.Identifier]),
    new TsKindsToText(function (node) { return ['"', node.text, '"']; }, [tsMorph.SyntaxKind.StringLiteral]),
    new TsKindsToText(function (node) { return []; }, [tsMorph.SyntaxKind.ArrayLiteralExpression]),
    new TsKindsToText(function (node) { return ['import', ' ']; }, [tsMorph.SyntaxKind.ImportKeyword]),
    new TsKindsToText(function (node) { return ['from', ' ']; }, [tsMorph.SyntaxKind.FromKeyword]),
    new TsKindsToText(function (node) { return ['\n', 'export', ' ']; }, [tsMorph.SyntaxKind.ExportKeyword]),
    new TsKindsToText(function (node) { return ['class', ' ']; }, [tsMorph.SyntaxKind.ClassKeyword]),
    new TsKindsToText(function (node) { return ['this']; }, [tsMorph.SyntaxKind.ThisKeyword]),
    new TsKindsToText(function (node) { return ['constructor']; }, [tsMorph.SyntaxKind.ConstructorKeyword]),
    new TsKindsToText(function (node) { return ['false']; }, [tsMorph.SyntaxKind.FalseKeyword]),
    new TsKindsToText(function (node) { return ['true']; }, [tsMorph.SyntaxKind.TrueKeyword]),
    new TsKindsToText(function (node) { return ['null']; }, [tsMorph.SyntaxKind.NullKeyword]),
    new TsKindsToText(function (node) { return []; }, [tsMorph.SyntaxKind.AtToken]),
    new TsKindsToText(function (node) { return ['+']; }, [tsMorph.SyntaxKind.PlusToken]),
    new TsKindsToText(function (node) { return [' => ']; }, [tsMorph.SyntaxKind.EqualsGreaterThanToken]),
    new TsKindsToText(function (node) { return ['(']; }, [tsMorph.SyntaxKind.OpenParenToken]),
    new TsKindsToText(function (node) { return ['{', ' ']; }, [tsMorph.SyntaxKind.ImportClause, tsMorph.SyntaxKind.ObjectLiteralExpression]),
    new TsKindsToText(function (node) { return ['{', '\n']; }, [tsMorph.SyntaxKind.Block]),
    new TsKindsToText(function (node) { return ['}']; }, [tsMorph.SyntaxKind.CloseBraceToken]),
    new TsKindsToText(function (node) { return [')']; }, [tsMorph.SyntaxKind.CloseParenToken]),
    new TsKindsToText(function (node) { return ['[']; }, [tsMorph.SyntaxKind.OpenBracketToken]),
    new TsKindsToText(function (node) { return [']']; }, [tsMorph.SyntaxKind.CloseBracketToken]),
    new TsKindsToText(function (node) { return [';', '\n']; }, [tsMorph.SyntaxKind.SemicolonToken]),
    new TsKindsToText(function (node) { return [',', ' ']; }, [tsMorph.SyntaxKind.CommaToken]),
    new TsKindsToText(function (node) { return [' ', ':', ' ']; }, [tsMorph.SyntaxKind.ColonToken]),
    new TsKindsToText(function (node) { return ['.']; }, [tsMorph.SyntaxKind.DotToken]),
    new TsKindsToText(function (node) { return []; }, [tsMorph.SyntaxKind.DoStatement]),
    new TsKindsToText(function (node) { return []; }, [tsMorph.SyntaxKind.Decorator]),
    new TsKindsToText(function (node) { return [' = ']; }, [tsMorph.SyntaxKind.FirstAssignment]),
    new TsKindsToText(function (node) { return [' ']; }, [tsMorph.SyntaxKind.FirstPunctuation]),
    new TsKindsToText(function (node) { return ['private', ' ']; }, [tsMorph.SyntaxKind.PrivateKeyword]),
    new TsKindsToText(function (node) { return ['public', ' ']; }, [tsMorph.SyntaxKind.PublicKeyword])
];

var crypto$6 = require('crypto');
var ComponentDepFactory = /** @class */ (function () {
    function ComponentDepFactory(helper) {
        this.helper = helper;
    }
    ComponentDepFactory.prototype.create = function (file, srcFile, name, props, IO) {
        // console.log(util.inspect(props, { showHidden: true, depth: 10 }));
        var sourceCode = srcFile.getText();
        var hash = crypto$6.createHash('sha512').update(sourceCode).digest('hex');
        var componentDep = {
            name: name,
            id: 'component-' + name + '-' + hash,
            file: file,
            // animations?: string[]; // TODO
            changeDetection: this.helper.getComponentChangeDetection(props, srcFile),
            encapsulation: this.helper.getComponentEncapsulation(props, srcFile),
            entryComponents: this.helper.getComponentEntryComponents(props, srcFile),
            exportAs: this.helper.getComponentExportAs(props, srcFile),
            host: this.helper.getComponentHost(props),
            inputs: this.helper.getComponentInputsMetadata(props, srcFile),
            // interpolation?: string; // TODO waiting doc infos
            moduleId: this.helper.getComponentModuleId(props, srcFile),
            outputs: this.helper.getComponentOutputs(props, srcFile),
            providers: this.helper.getComponentProviders(props, srcFile),
            // queries?: Deps[]; // TODO
            selector: this.helper.getComponentSelector(props, srcFile),
            styleUrls: this.helper.getComponentStyleUrls(props, srcFile),
            styles: this.helper.getComponentStyles(props, srcFile), // TODO fix args
            template: this.helper.getComponentTemplate(props, srcFile),
            templateUrl: this.helper.getComponentTemplateUrl(props, srcFile),
            viewProviders: this.helper.getComponentViewProviders(props, srcFile),
            hostDirectives: __spreadArray([], __read(this.helper.getComponentHostDirectives(props)), false),
            inputsClass: IO.inputs,
            outputsClass: IO.outputs,
            propertiesClass: IO.properties,
            methodsClass: IO.methods,
            deprecated: IO.deprecated,
            deprecationMessage: IO.deprecationMessage,
            hostBindings: IO.hostBindings,
            hostListeners: IO.hostListeners,
            standalone: this.helper.getComponentStandalone(props, srcFile) ? true : false,
            imports: this.helper.getComponentImports(props, srcFile),
            description: IO.description,
            rawdescription: IO.rawdescription,
            type: 'component',
            sourceCode: srcFile.getText(),
            exampleUrls: this.helper.getComponentExampleUrls(srcFile.getText()),
            tag: this.helper.getComponentTag(props, srcFile),
            styleUrl: this.helper.getComponentStyleUrl(props, srcFile),
            shadow: this.helper.getComponentShadow(props, srcFile),
            scoped: this.helper.getComponentScoped(props, srcFile),
            assetsDir: this.helper.getComponentAssetsDir(props, srcFile),
            assetsDirs: this.helper.getComponentAssetsDirs(props, srcFile),
            styleUrlsData: '',
            stylesData: ''
        };
        if (typeof this.helper.getComponentPreserveWhitespaces(props, srcFile) !== 'undefined') {
            componentDep.preserveWhitespaces = this.helper.getComponentPreserveWhitespaces(props, srcFile);
        }
        if (Configuration$1.mainData.disableLifeCycleHooks) {
            componentDep.methodsClass = cleanLifecycleHooksFromMethods(componentDep.methodsClass);
        }
        if (IO.jsdoctags && IO.jsdoctags.length > 0) {
            componentDep.jsdoctags = IO.jsdoctags[0].tags;
        }
        if (IO.constructor && !Configuration$1.mainData.disableConstructors) {
            componentDep.constructorObj = IO.constructor;
        }
        if (IO.extends) {
            componentDep.extends = IO.extends;
        }
        if (IO.implements && IO.implements.length > 0) {
            componentDep.implements = IO.implements;
        }
        if (IO.accessors) {
            componentDep.accessors = IO.accessors;
        }
        if (IO.properties) {
            componentDep.inputsClass = componentDep.inputsClass.concat(this.helper.getInputSignals(IO.properties));
            componentDep.outputsClass = componentDep.outputsClass.concat(this.helper.getOutputSignals(IO.properties));
        }
        return componentDep;
    };
    return ComponentDepFactory;
}());

var crypto$5 = require('crypto');
var ControllerDepFactory = /** @class */ (function () {
    function ControllerDepFactory() {
    }
    ControllerDepFactory.prototype.create = function (file, srcFile, name, properties, IO) {
        var sourceCode = srcFile.getText();
        var hash = crypto$5.createHash('sha512').update(sourceCode).digest('hex');
        var infos = {
            name: name,
            id: 'controller-' + name + '-' + hash,
            file: file,
            methodsClass: IO.methods,
            type: 'controller',
            description: IO.description,
            rawdescription: IO.rawdescription,
            sourceCode: srcFile.text,
            deprecated: IO.deprecated,
            deprecationMessage: IO.deprecationMessage
        };
        if (properties && properties.length === 1) {
            if (properties[0].text) {
                infos.prefix = properties[0].text;
            }
        }
        if (IO.extends) {
            infos.extends = IO.extends;
        }
        return infos;
    };
    return ControllerDepFactory;
}());

var crypto$4 = require('crypto');
var DirectiveDepFactory = /** @class */ (function () {
    function DirectiveDepFactory(helper) {
        this.helper = helper;
    }
    DirectiveDepFactory.prototype.create = function (file, srcFile, name, props, IO) {
        var sourceCode = srcFile.getText();
        var hash = crypto$4.createHash('sha512').update(sourceCode).digest('hex');
        var directiveDeps = {
            name: name,
            id: 'directive-' + name + '-' + hash,
            file: file,
            type: 'directive',
            description: IO.description,
            rawdescription: IO.rawdescription,
            sourceCode: srcFile.getText(),
            selector: this.helper.getComponentSelector(props, srcFile),
            providers: this.helper.getComponentProviders(props, srcFile),
            exportAs: this.helper.getComponentExportAs(props, srcFile),
            hostDirectives: __spreadArray([], __read(this.helper.getComponentHostDirectives(props)), false),
            standalone: this.helper.getComponentStandalone(props, srcFile) ? true : false,
            inputsClass: this.helper.getInputSignals(IO.properties).concat(IO.inputs),
            outputsClass: this.helper.getInputSignals(IO.properties).concat(IO.outputs),
            deprecated: IO.deprecated,
            deprecationMessage: IO.deprecationMessage,
            hostBindings: IO.hostBindings,
            hostListeners: IO.hostListeners,
            propertiesClass: IO.properties,
            methodsClass: IO.methods,
            exampleUrls: this.helper.getComponentExampleUrls(srcFile.getText())
        };
        if (Configuration$1.mainData.disableLifeCycleHooks) {
            directiveDeps.methodsClass = cleanLifecycleHooksFromMethods(directiveDeps.methodsClass);
        }
        if (IO.jsdoctags && IO.jsdoctags.length > 0) {
            directiveDeps.jsdoctags = IO.jsdoctags[0].tags;
        }
        if (IO.extends) {
            directiveDeps.extends = IO.extends;
        }
        if (IO.implements && IO.implements.length > 0) {
            directiveDeps.implements = IO.implements;
        }
        if (IO.constructor && !Configuration$1.mainData.disableConstructors) {
            directiveDeps.constructorObj = IO.constructor;
        }
        if (IO.accessors) {
            directiveDeps.accessors = IO.accessors;
        }
        return directiveDeps;
    };
    return DirectiveDepFactory;
}());

var JsDocHelper = /** @class */ (function () {
    function JsDocHelper() {
    }
    JsDocHelper.prototype.hasJSDocInternalTag = function (filename, sourceFile, node) {
        if (typeof sourceFile.statements !== 'undefined') {
            return this.checkStatements(sourceFile.statements, node);
        }
        return false;
    };
    JsDocHelper.prototype.checkStatements = function (statements, node) {
        var _this = this;
        return statements.some(function (x) { return _this.checkStatement(x, node); });
    };
    JsDocHelper.prototype.checkStatement = function (statement, node) {
        if (statement.pos === node.pos && statement.end === node.end) {
            if (node.jsDoc && node.jsDoc.length > 0) {
                return this.checkJsDocs(node.jsDoc);
            }
        }
        return false;
    };
    JsDocHelper.prototype.checkJsDocs = function (jsDocs) {
        var _this = this;
        return jsDocs
            .filter(function (x) { return x.tags && x.tags.length > 0; })
            .some(function (x) { return _this.checkJsDocTags(x.tags); });
    };
    JsDocHelper.prototype.checkJsDocTags = function (tags) {
        return tags.some(function (x) { return x.tagName && x.tagName.text === 'internal'; });
    };
    return JsDocHelper;
}());

var ModuleHelper = /** @class */ (function () {
    function ModuleHelper(cache, symbolHelper) {
        if (symbolHelper === void 0) { symbolHelper = new SymbolHelper(); }
        this.cache = cache;
        this.symbolHelper = symbolHelper;
    }
    ModuleHelper.prototype.getModuleProviders = function (props, srcFile) {
        var _this = this;
        return this.symbolHelper
            .getSymbolDeps(props, 'providers', srcFile)
            .map(function (providerName) { return _this.symbolHelper.parseDeepIndentifier(providerName, srcFile); });
    };
    ModuleHelper.prototype.getModuleControllers = function (props, srcFile) {
        var _this = this;
        return this.symbolHelper
            .getSymbolDeps(props, 'controllers', srcFile)
            .map(function (providerName) { return _this.symbolHelper.parseDeepIndentifier(providerName, srcFile); });
    };
    ModuleHelper.prototype.getModuleDeclarations = function (props, srcFile) {
        var _this = this;
        return this.symbolHelper.getSymbolDeps(props, 'declarations', srcFile).map(function (name) {
            var component = _this.cache.get(name);
            if (component) {
                return component;
            }
            return _this.symbolHelper.parseDeepIndentifier(name, srcFile);
        });
    };
    ModuleHelper.prototype.getModuleEntryComponents = function (props, srcFile) {
        var _this = this;
        return this.symbolHelper.getSymbolDeps(props, 'entryComponents', srcFile).map(function (name) {
            var component = _this.cache.get(name);
            if (component) {
                return component;
            }
            return _this.symbolHelper.parseDeepIndentifier(name, srcFile);
        });
    };
    ModuleHelper.prototype.cleanImportForRootForChild = function (name) {
        var nsModule = name.split('.');
        if (nsModule.length > 0) {
            name = nsModule[0];
        }
        return name;
    };
    ModuleHelper.prototype.getModuleImports = function (props, srcFile) {
        var _this = this;
        return this.symbolHelper
            .getSymbolDeps(props, 'imports', srcFile)
            .map(function (name) { return _this.cleanImportForRootForChild(name); })
            .map(function (name) { return _this.symbolHelper.parseDeepIndentifier(name); });
    };
    ModuleHelper.prototype.getModuleExports = function (props, srcFile) {
        var _this = this;
        return this.symbolHelper
            .getSymbolDeps(props, 'exports', srcFile)
            .map(function (name) { return _this.symbolHelper.parseDeepIndentifier(name, srcFile); });
    };
    ModuleHelper.prototype.getModuleImportsRaw = function (props, srcFile) {
        return this.symbolHelper.getSymbolDepsRaw(props, 'imports');
    };
    ModuleHelper.prototype.getModuleId = function (props, srcFile) {
        var _id = this.symbolHelper.getSymbolDeps(props, 'id', srcFile), id;
        if (_id.length === 1) {
            id = _id[0];
        }
        return id;
    };
    ModuleHelper.prototype.getModuleSchemas = function (props, srcFile) {
        var schemas = this.symbolHelper.getSymbolDeps(props, 'schemas', srcFile);
        return schemas;
    };
    ModuleHelper.prototype.getModuleBootstrap = function (props, srcFile) {
        var _this = this;
        return this.symbolHelper
            .getSymbolDeps(props, 'bootstrap', srcFile)
            .map(function (name) { return _this.symbolHelper.parseDeepIndentifier(name, srcFile); });
    };
    return ModuleHelper;
}());

var crypto$3 = require('crypto');
var ModuleDepFactory = /** @class */ (function () {
    function ModuleDepFactory(moduleHelper) {
        this.moduleHelper = moduleHelper;
    }
    ModuleDepFactory.prototype.create = function (file, srcFile, name, properties, IO) {
        var sourceCode = srcFile.getText();
        var hash = crypto$3.createHash('sha512').update(sourceCode).digest('hex');
        return {
            name: name,
            id: 'module-' + name + '-' + hash,
            file: file,
            ngid: this.moduleHelper.getModuleId(properties, srcFile),
            providers: this.moduleHelper.getModuleProviders(properties, srcFile),
            declarations: this.moduleHelper.getModuleDeclarations(properties, srcFile),
            controllers: this.moduleHelper.getModuleControllers(properties, srcFile),
            entryComponents: this.moduleHelper.getModuleEntryComponents(properties, srcFile),
            imports: this.moduleHelper.getModuleImports(properties, srcFile),
            exports: this.moduleHelper.getModuleExports(properties, srcFile),
            schemas: this.moduleHelper.getModuleSchemas(properties, srcFile),
            bootstrap: this.moduleHelper.getModuleBootstrap(properties, srcFile),
            type: 'module',
            rawdescription: IO.rawdescription,
            methods: IO.methods,
            description: IO.description,
            sourceCode: srcFile.text,
            deprecated: IO.deprecated,
            deprecationMessage: IO.deprecationMessage
        };
    };
    return ModuleDepFactory;
}());

var crypto$2 = require('crypto');
var EntityDepFactory = /** @class */ (function () {
    function EntityDepFactory() {
    }
    EntityDepFactory.prototype.create = function (file, srcFile, name, properties, IO) {
        var sourceCode = srcFile.getText();
        var hash = crypto$2.createHash('sha512').update(sourceCode).digest('hex');
        var infos = {
            name: name,
            id: 'controller-' + name + '-' + hash,
            file: file,
            type: 'entity',
            description: IO.description,
            rawdescription: IO.rawdescription,
            sourceCode: srcFile.text,
            deprecated: IO.deprecated,
            deprecationMessage: IO.deprecationMessage,
            properties: IO.properties
        };
        return infos;
    };
    return EntityDepFactory;
}());

var crypto$1 = require('crypto');
var project = new tsMorph.Project();
// TypeScript reference : https://github.com/Microsoft/TypeScript/blob/master/lib/typescript.d.ts
var AngularDependencies = /** @class */ (function (_super) {
    __extends(AngularDependencies, _super);
    function AngularDependencies(files, options) {
        var _this = _super.call(this, files, options) || this;
        _this.cache = new ComponentCache();
        _this.moduleHelper = new ModuleHelper(_this.cache);
        _this.jsDocHelper = new JsDocHelper();
        _this.symbolHelper = new SymbolHelper();
        _this.jsdocParserUtil = new JsdocParserUtil();
        return _this;
    }
    AngularDependencies.prototype.getDependencies = function () {
        var _this = this;
        var deps = {
            aliases: {},
            modules: [],
            modulesForGraph: [],
            components: [],
            controllers: [],
            entities: [],
            injectables: [],
            interceptors: [],
            guards: [],
            pipes: [],
            directives: [],
            routes: [],
            classes: [],
            interfaces: [],
            typescriptImports: [],
            miscellaneous: {
                variables: [],
                functions: [],
                typealiases: [],
                enumerations: []
            },
            routesTree: undefined
        };
        var sourceFiles = this.program.getSourceFiles() || [];
        RouterParserUtil$1.scannedFiles = sourceFiles;
        sourceFiles.map(function (file) {
            var filePath = file.fileName;
            if (path__namespace.extname(filePath) === '.ts' || path__namespace.extname(filePath) === '.tsx') {
                if (!Configuration$1.mainData.angularJSProject && path__namespace.extname(filePath) === '.js') {
                    logger.info('parsing', filePath);
                    _this.getSourceFileDecorators(file, deps);
                }
                else {
                    if (filePath.lastIndexOf('.d.ts') === -1 &&
                        filePath.lastIndexOf('spec.ts') === -1) {
                        logger.info('parsing', filePath);
                        _this.getTypescriptExportsAliases(file, deps);
                        _this.getTypescriptImportsAliases(file, deps);
                        _this.getSourceFileDecorators(file, deps);
                    }
                }
            }
            return deps;
        });
        // End of file scanning
        // Try merging inside the same file declarated variables & modules with imports | exports | declarations | providers
        if (deps.miscellaneous.variables.length > 0) {
            deps.miscellaneous.variables.forEach(function (_variable) {
                var newVar = [];
                // link ...VAR to VAR values, recursively
                (function (_var, _newVar) {
                    // getType pr reconstruire....
                    var elementsMatcher = function (variabelToReplace) {
                        if (variabelToReplace.initializer) {
                            if (variabelToReplace.initializer.elements) {
                                if (variabelToReplace.initializer.elements.length > 0) {
                                    variabelToReplace.initializer.elements.forEach(function (element) {
                                        // Direct value -> Kind 79
                                        if (element.text &&
                                            element.kind === tsMorph.SyntaxKind.Identifier) {
                                            newVar.push({
                                                name: element.text,
                                                type: _this.symbolHelper.getType(element.text)
                                            });
                                        }
                                        // if _variable is ArrayLiteralExpression 203
                                        // and has SpreadElements in his elements
                                        // merge them
                                        if (element.kind === tsMorph.SyntaxKind.SpreadElement &&
                                            element.expression) {
                                            var el = deps.miscellaneous.variables.find(function (variable) {
                                                return variable.name === element.expression.text;
                                            });
                                            if (el) {
                                                elementsMatcher(el);
                                            }
                                        }
                                    });
                                }
                            }
                        }
                    };
                    elementsMatcher(_var);
                })(_variable);
                var onLink = function (mod) {
                    var process = function (initialArray, _var) {
                        var indexToClean = 0;
                        var found = false;
                        var findVariableInArray = function (el, index) {
                            if (el.name === _var.name) {
                                indexToClean = index;
                                found = true;
                            }
                        };
                        initialArray.forEach(findVariableInArray);
                        // Clean indexes to replace
                        if (found) {
                            initialArray.splice(indexToClean, 1);
                            // Add variable
                            newVar.forEach(function (newEle) {
                                if (typeof ___namespace.find(initialArray, { name: newEle.name }) ===
                                    'undefined') {
                                    initialArray.push(newEle);
                                }
                            });
                        }
                    };
                    process(mod.imports, _variable);
                    process(mod.exports, _variable);
                    process(mod.controllers, _variable);
                    process(mod.declarations, _variable);
                    process(mod.providers, _variable);
                };
                deps.modules.forEach(onLink);
                deps.modulesForGraph.forEach(onLink);
            });
        }
        /**
         * If one thing extends another, merge them, only for internal sources
         * - classes
         * - components
         * - injectables
         * - directives
         * for
         * - inputs
         * - outputs
         * - properties
         * - methods
         */
        deps = ExtendsMerger$1.merge(deps);
        // RouterParserUtil.printModulesRoutes();
        // RouterParserUtil.printRoutes();
        if (!Configuration$1.mainData.disableRoutesGraph) {
            RouterParserUtil$1.linkModulesAndRoutes();
            RouterParserUtil$1.constructModulesTree();
            deps.routesTree = RouterParserUtil$1.constructRoutesTree();
        }
        return deps;
    };
    AngularDependencies.prototype.processClass = function (node, file, srcFile, outputSymbols, fileBody, astFile) {
        var name = this.getSymboleName(node);
        var IO = this.getClassIO(file, srcFile, node, fileBody, astFile);
        var sourceCode = srcFile.getText();
        var hash = crypto$1.createHash('sha512').update(sourceCode).digest('hex');
        var deps = {
            name: name,
            id: 'class-' + name + '-' + hash,
            file: file,
            deprecated: IO.deprecated,
            deprecationMessage: IO.deprecationMessage,
            type: 'class',
            sourceCode: srcFile.getText()
        };
        var excludeFromClassArray = false;
        if (IO.constructor && !Configuration$1.mainData.disableConstructors) {
            deps.constructorObj = IO.constructor;
        }
        if (IO.inputs) {
            deps.inputsClass = IO.inputs;
        }
        if (IO.outputs) {
            deps.outputsClass = IO.outputs;
        }
        if (IO.properties) {
            deps.properties = IO.properties;
            deps.inputsClass = deps.inputsClass
                ? deps.inputsClass.concat(this.componentHelper.getInputSignals(IO.properties))
                : this.componentHelper.getInputSignals(IO.properties);
            deps.outputsClass = deps.outputsClass
                ? deps.outputsClass.concat(this.componentHelper.getOutputSignals(IO.properties))
                : this.componentHelper.getOutputSignals(IO.properties);
        }
        if (IO.description) {
            deps.description = IO.description;
        }
        if (IO.rawdescription) {
            deps.rawdescription = IO.rawdescription;
        }
        if (IO.methods) {
            deps.methods = IO.methods;
        }
        if (IO.indexSignatures) {
            deps.indexSignatures = IO.indexSignatures;
        }
        if (IO.extends) {
            deps.extends = IO.extends;
        }
        if (IO.jsdoctags && IO.jsdoctags.length > 0) {
            deps.jsdoctags = IO.jsdoctags[0].tags;
        }
        if (IO.accessors) {
            deps.accessors = IO.accessors;
        }
        if (IO.hostBindings) {
            deps.hostBindings = IO.hostBindings;
        }
        if (IO.hostListeners) {
            deps.hostListeners = IO.hostListeners;
        }
        if (Configuration$1.mainData.disableLifeCycleHooks) {
            deps.methods = cleanLifecycleHooksFromMethods(deps.methods);
        }
        if (IO.implements && IO.implements.length > 0) {
            deps.implements = IO.implements;
            if (this.isGuard(IO.implements)) {
                // We don't want the Guard to show up in the Classes menu
                excludeFromClassArray = true;
                deps.type = 'guard';
                outputSymbols.guards.push(deps);
            }
        }
        if (typeof IO.ignore === 'undefined') {
            this.debug(deps);
            if (!excludeFromClassArray) {
                outputSymbols.classes.push(deps);
            }
        }
        else {
            this.ignore(deps);
        }
    };
    AngularDependencies.prototype.getTypescriptImportsAliases = function (initialSrcFile, outputSymbols) {
        var astFile = typeof project.getSourceFile(initialSrcFile.fileName) !== 'undefined'
            ? project.getSourceFile(initialSrcFile.fileName)
            : project.addSourceFileAtPath(initialSrcFile.fileName);
        if (astFile) {
            var importDeclarations = astFile.getImportDeclarations();
            if (importDeclarations && importDeclarations.length > 0) {
                importDeclarations.forEach(function (importDeclaration) {
                    var namedImports = importDeclaration.getNamedImports();
                    if (namedImports && namedImports.length > 0) {
                        namedImports.forEach(function (namedImport) {
                            if (namedImport.getAliasNode()) {
                                if (outputSymbols.aliases.hasOwnProperty(namedImport.getName())) {
                                    outputSymbols.aliases[namedImport.getName()].push(namedImport.getAliasNode().getText());
                                }
                                else {
                                    outputSymbols.aliases[namedImport.getName()] = [
                                        namedImport.getAliasNode().getText()
                                    ];
                                }
                            }
                        });
                    }
                });
            }
        }
    };
    AngularDependencies.prototype.getTypescriptExportsAliases = function (initialSrcFile, outputSymbols) {
        var astFile = typeof project.getSourceFile(initialSrcFile.fileName) !== 'undefined'
            ? project.getSourceFile(initialSrcFile.fileName)
            : project.addSourceFileAtPath(initialSrcFile.fileName);
        if (astFile) {
            var exportDeclarations = astFile.getExportDeclarations();
            if (exportDeclarations && exportDeclarations.length > 0) {
                exportDeclarations.forEach(function (exportDeclaration) {
                    var hasNamedExports = exportDeclaration.hasNamedExports();
                    if (hasNamedExports) {
                        var namedExports = exportDeclaration.getNamedExports();
                        if (namedExports && namedExports.length > 0) {
                            namedExports.forEach(function (namedExport) {
                                if (namedExport.getAliasNode()) {
                                    if (outputSymbols.aliases.hasOwnProperty(namedExport.getName())) {
                                        outputSymbols.aliases[namedExport.getName()].push(namedExport.getAliasNode().getText());
                                    }
                                    else {
                                        outputSymbols.aliases[namedExport.getName()] = [
                                            namedExport.getAliasNode().getText()
                                        ];
                                    }
                                }
                            });
                        }
                    }
                });
            }
        }
    };
    AngularDependencies.prototype.getSourceFileDecorators = function (initialSrcFile, outputSymbols) {
        var _this = this;
        var cleaner = (process.cwd() + path__namespace.sep).replace(/\\/g, '/');
        var fileName = initialSrcFile.fileName.replace(cleaner, '');
        var scannedFile = initialSrcFile;
        // Search in file for variable statement as routes definitions
        var astFile = typeof project.getSourceFile(initialSrcFile.fileName) !== 'undefined'
            ? project.getSourceFile(initialSrcFile.fileName)
            : project.addSourceFileAtPath(initialSrcFile.fileName);
        var variableRoutesStatements = astFile.getVariableStatements();
        var hasRoutesStatements = false;
        if (variableRoutesStatements.length > 0) {
            // Clean file for spread and dynamics inside routes definitions
            variableRoutesStatements.forEach(function (s) {
                var variableDeclarations = s.getDeclarations();
                var len = variableDeclarations.length;
                var i = 0;
                for (i; i < len; i++) {
                    if (variableDeclarations[i].compilerNode.type) {
                        if (variableDeclarations[i].compilerNode.type.typeName &&
                            variableDeclarations[i].compilerNode.type.typeName.text === 'Routes') {
                            hasRoutesStatements = true;
                        }
                    }
                }
            });
        }
        if (hasRoutesStatements && !Configuration$1.mainData.disableRoutesGraph) {
            // Clean file for spread and dynamics inside routes definitions
            logger.info('Analysing routes definitions and clean them if necessary');
            // scannedFile = RouterParserUtil.cleanFileIdentifiers(astFile).compilerNode;
            RouterParserUtil$1.cleanFileSpreads(astFile);
            scannedFile = RouterParserUtil$1.cleanCallExpressions(astFile).compilerNode;
            scannedFile = RouterParserUtil$1.cleanFileDynamics(astFile).compilerNode;
            scannedFile.kind = tsMorph.SyntaxKind.SourceFile;
        }
        tsMorph.ts.forEachChild(scannedFile, function (initialNode) {
            if (_this.jsDocHelper.hasJSDocInternalTag(fileName, scannedFile, initialNode) &&
                Configuration$1.mainData.disableInternal) {
                return;
            }
            var parseNode = function (file, srcFile, node, fileBody, astFile) {
                var sourceCode = srcFile.getText();
                var hash = crypto$1.createHash('sha512').update(sourceCode).digest('hex');
                if (nodeHasDecorator(node)) {
                    var classWithCustomDecorator_1 = false;
                    var nodeDecorators_1 = getNodeDecorators(node);
                    var visitDecorator = function (visitedDecorator, index) {
                        var deps;
                        var name = _this.getSymboleName(node);
                        var props = _this.findProperties(visitedDecorator, srcFile);
                        var IO = _this.componentHelper.getComponentIO(file, srcFile, node, fileBody, astFile);
                        if (_this.isModule(visitedDecorator)) {
                            var moduleDep = new ModuleDepFactory(_this.moduleHelper).create(file, srcFile, name, props, IO);
                            if (RouterParserUtil$1.hasRouterModuleInImports(moduleDep.imports)) {
                                RouterParserUtil$1.addModuleWithRoutes(name, _this.moduleHelper.getModuleImportsRaw(props, srcFile), file);
                            }
                            deps = moduleDep;
                            if (typeof IO.ignore === 'undefined') {
                                RouterParserUtil$1.addModule(name, moduleDep.imports);
                                outputSymbols.modules.push(moduleDep);
                                outputSymbols.modulesForGraph.push(moduleDep);
                            }
                        }
                        else if (_this.isComponent(visitedDecorator)) {
                            if (props.length === 0) {
                                return;
                            }
                            var componentDep = new ComponentDepFactory(_this.componentHelper).create(file, srcFile, name, props, IO);
                            deps = componentDep;
                            if (typeof IO.ignore === 'undefined') {
                                ComponentsTreeEngine$1.addComponent(componentDep);
                                outputSymbols.components.push(componentDep);
                            }
                        }
                        else if (_this.isController(visitedDecorator)) {
                            var controllerDep = new ControllerDepFactory().create(file, srcFile, name, props, IO);
                            deps = controllerDep;
                            if (typeof IO.ignore === 'undefined') {
                                outputSymbols.controllers.push(controllerDep);
                            }
                        }
                        else if (_this.isEntity(visitedDecorator)) {
                            var entityDep = new EntityDepFactory().create(file, srcFile, name, props, IO);
                            deps = entityDep;
                            if (typeof IO.ignore === 'undefined') {
                                outputSymbols.entities.push(entityDep);
                            }
                        }
                        else if (_this.isInjectable(visitedDecorator)) {
                            var injectableDeps = {
                                name: name,
                                id: 'injectable-' + name + '-' + hash,
                                file: file,
                                properties: IO.properties,
                                methods: IO.methods,
                                deprecated: IO.deprecated,
                                deprecationMessage: IO.deprecationMessage,
                                description: IO.description,
                                rawdescription: IO.rawdescription,
                                sourceCode: srcFile.getText(),
                                exampleUrls: _this.componentHelper.getComponentExampleUrls(srcFile.getText())
                            };
                            if (IO.constructor && !Configuration$1.mainData.disableConstructors) {
                                injectableDeps.constructorObj = IO.constructor;
                            }
                            if (IO.jsdoctags && IO.jsdoctags.length > 0) {
                                injectableDeps.jsdoctags = IO.jsdoctags[0].tags;
                            }
                            if (IO.accessors) {
                                injectableDeps.accessors = IO.accessors;
                            }
                            if (IO.extends) {
                                injectableDeps.extends = IO.extends;
                            }
                            if (Configuration$1.mainData.disableLifeCycleHooks) {
                                injectableDeps.methods = cleanLifecycleHooksFromMethods(injectableDeps.methods);
                            }
                            deps = injectableDeps;
                            if (typeof IO.ignore === 'undefined') {
                                if (___namespace.includes(IO.implements, 'HttpInterceptor')) {
                                    injectableDeps.type = 'interceptor';
                                    outputSymbols.interceptors.push(injectableDeps);
                                }
                                else if (_this.isGuard(IO.implements)) {
                                    injectableDeps.type = 'guard';
                                    outputSymbols.guards.push(injectableDeps);
                                }
                                else {
                                    injectableDeps.type = 'injectable';
                                    _this.addNewEntityInStore(injectableDeps, outputSymbols.injectables);
                                }
                            }
                        }
                        else if (_this.isPipe(visitedDecorator)) {
                            var pipeDeps = {
                                name: name,
                                id: 'pipe-' + name + '-' + hash,
                                file: file,
                                type: 'pipe',
                                deprecated: IO.deprecated,
                                deprecationMessage: IO.deprecationMessage,
                                description: IO.description,
                                rawdescription: IO.rawdescription,
                                properties: IO.properties,
                                methods: IO.methods,
                                standalone: _this.componentHelper.getComponentStandalone(props, srcFile)
                                    ? true
                                    : false,
                                pure: _this.componentHelper.getComponentPure(props, srcFile),
                                ngname: _this.componentHelper.getComponentName(props, srcFile),
                                sourceCode: srcFile.getText(),
                                exampleUrls: _this.componentHelper.getComponentExampleUrls(srcFile.getText())
                            };
                            if (Configuration$1.mainData.disableLifeCycleHooks) {
                                pipeDeps.methods = cleanLifecycleHooksFromMethods(pipeDeps.methods);
                            }
                            if (IO.jsdoctags && IO.jsdoctags.length > 0) {
                                pipeDeps.jsdoctags = IO.jsdoctags[0].tags;
                            }
                            deps = pipeDeps;
                            if (typeof IO.ignore === 'undefined') {
                                outputSymbols.pipes.push(pipeDeps);
                            }
                        }
                        else if (_this.isDirective(visitedDecorator)) {
                            var directiveDeps = new DirectiveDepFactory(_this.componentHelper).create(file, srcFile, name, props, IO);
                            deps = directiveDeps;
                            if (typeof IO.ignore === 'undefined') {
                                outputSymbols.directives.push(directiveDeps);
                            }
                        }
                        else {
                            var hasMultipleDecoratorsWithInternalOne = _this.hasInternalDecorator(nodeDecorators_1);
                            // Just a class
                            if (!classWithCustomDecorator_1 &&
                                !hasMultipleDecoratorsWithInternalOne) {
                                classWithCustomDecorator_1 = true;
                                _this.processClass(node, file, srcFile, outputSymbols, fileBody);
                            }
                        }
                        _this.cache.set(name, deps);
                        if (typeof IO.ignore === 'undefined') {
                            _this.debug(deps);
                        }
                        else {
                            _this.ignore(deps);
                        }
                    };
                    var filterByDecorators = function (filteredNode) {
                        if (filteredNode.expression && filteredNode.expression.expression) {
                            var _test = /(NgModule|Component|Injectable|Pipe|Directive)/.test(filteredNode.expression.expression.text);
                            if (!_test && tsMorph.ts.isClassDeclaration(node)) {
                                _test = true;
                            }
                            return _test;
                        }
                        if (tsMorph.ts.isClassDeclaration(node)) {
                            return true;
                        }
                        return false;
                    };
                    nodeDecorators_1.filter(filterByDecorators).forEach(visitDecorator);
                }
                else if (node.symbol) {
                    if (node.symbol.flags === tsMorph.ts.SymbolFlags.Class) {
                        _this.processClass(node, file, srcFile, outputSymbols, fileBody, astFile);
                    }
                    else if (node.symbol.flags === tsMorph.ts.SymbolFlags.Interface) {
                        var name = _this.getSymboleName(node);
                        var IO = _this.getInterfaceIO(file, srcFile, node, fileBody, astFile);
                        var interfaceDeps = {
                            name: name,
                            id: 'interface-' + name + '-' + hash,
                            file: file,
                            deprecated: IO.deprecated,
                            deprecationMessage: IO.deprecationMessage,
                            type: 'interface',
                            sourceCode: srcFile.getText()
                        };
                        if (IO.properties) {
                            interfaceDeps.properties = IO.properties;
                        }
                        if (IO.indexSignatures) {
                            interfaceDeps.indexSignatures = IO.indexSignatures;
                        }
                        if (IO.kind) {
                            interfaceDeps.kind = IO.kind;
                        }
                        if (IO.description) {
                            interfaceDeps.description = IO.description;
                            interfaceDeps.rawdescription = IO.rawdescription;
                        }
                        if (IO.methods) {
                            interfaceDeps.methods = IO.methods;
                        }
                        if (IO.extends) {
                            interfaceDeps.extends = IO.extends;
                        }
                        if (typeof IO.ignore === 'undefined') {
                            _this.debug(interfaceDeps);
                            outputSymbols.interfaces.push(interfaceDeps);
                        }
                        else {
                            _this.ignore(interfaceDeps);
                        }
                    }
                    else if (tsMorph.ts.isFunctionDeclaration(node)) {
                        var infos = _this.visitFunctionDeclaration(node);
                        var name = infos.name;
                        var deprecated = infos.deprecated;
                        var deprecationMessage = infos.deprecationMessage;
                        var functionDep = {
                            name: name,
                            file: file,
                            ctype: 'miscellaneous',
                            subtype: 'function',
                            deprecated: deprecated,
                            deprecationMessage: deprecationMessage,
                            description: _this.visitEnumTypeAliasFunctionDeclarationDescription(node)
                        };
                        if (infos.args) {
                            functionDep.args = infos.args;
                        }
                        if (infos.returnType) {
                            functionDep.returnType = infos.returnType;
                        }
                        if (infos.jsdoctags && infos.jsdoctags.length > 0) {
                            functionDep.jsdoctags = infos.jsdoctags;
                        }
                        if (typeof infos.ignore === 'undefined') {
                            if (!(_this.hasPrivateJSDocTag(functionDep.jsdoctags) &&
                                Configuration$1.mainData.disablePrivate)) {
                                _this.debug(functionDep);
                                outputSymbols.miscellaneous.functions.push(functionDep);
                            }
                        }
                    }
                    else if (tsMorph.ts.isEnumDeclaration(node)) {
                        var infos = _this.visitEnumDeclaration(node);
                        var name = infos.name;
                        var deprecated = infos.deprecated;
                        var deprecationMessage = infos.deprecationMessage;
                        var enumDeps = {
                            name: name,
                            childs: infos.members,
                            ctype: 'miscellaneous',
                            subtype: 'enum',
                            deprecated: deprecated,
                            deprecationMessage: deprecationMessage,
                            description: _this.visitEnumTypeAliasFunctionDeclarationDescription(node),
                            file: file
                        };
                        if (!isIgnore(node)) {
                            _this.debug(enumDeps);
                            outputSymbols.miscellaneous.enumerations.push(enumDeps);
                        }
                    }
                    else if (tsMorph.ts.isTypeAliasDeclaration(node)) {
                        var infos = _this.visitTypeDeclaration(node);
                        var name = infos.name;
                        var deprecated = infos.deprecated;
                        var deprecationMessage = infos.deprecationMessage;
                        var typeAliasDeps = {
                            name: name,
                            ctype: 'miscellaneous',
                            subtype: 'typealias',
                            rawtype: _this.classHelper.visitType(node),
                            file: file,
                            deprecated: deprecated,
                            deprecationMessage: deprecationMessage,
                            description: _this.visitEnumTypeAliasFunctionDeclarationDescription(node)
                        };
                        if (node.type) {
                            typeAliasDeps.kind = node.type.kind;
                            if (typeAliasDeps.rawtype === '') {
                                typeAliasDeps.rawtype = _this.classHelper.visitType(node);
                            }
                        }
                        if (typeAliasDeps.kind &&
                            typeAliasDeps.kind === tsMorph.SyntaxKind.TemplateLiteralType &&
                            node.type) {
                            typeAliasDeps.rawtype = srcFile.text.substring(node.type.pos, node.type.end);
                        }
                        if (!isIgnore(node)) {
                            outputSymbols.miscellaneous.typealiases.push(typeAliasDeps);
                        }
                        if (typeof infos.ignore === 'undefined') {
                            _this.debug(typeAliasDeps);
                        }
                    }
                    else if (tsMorph.ts.isModuleDeclaration(node)) {
                        if (node.body) {
                            if (node.body.statements && node.body.statements.length > 0) {
                                node.body.statements.forEach(function (statement) {
                                    return parseNode(file, srcFile, statement, node.body, astFile);
                                });
                            }
                        }
                    }
                }
                else {
                    var IO = _this.getRouteIO(file, srcFile, node);
                    if (IO.routes) {
                        var newRoutes = void 0;
                        try {
                            newRoutes = RouterParserUtil$1.cleanRawRouteParsed(IO.routes);
                        }
                        catch (e) {
                            // tslint:disable-next-line:max-line-length
                            logger.error('Routes parsing error, maybe a trailing comma or an external variable, trying to fix that later after sources scanning.');
                            newRoutes = IO.routes.replace(/ /gm, '');
                            RouterParserUtil$1.addIncompleteRoute({
                                data: newRoutes,
                                file: file
                            });
                            return true;
                        }
                        outputSymbols.routes = __spreadArray(__spreadArray([], __read(outputSymbols.routes), false), __read(newRoutes), false);
                    }
                    if (tsMorph.ts.isClassDeclaration(node)) {
                        _this.processClass(node, file, srcFile, outputSymbols, fileBody);
                    }
                    if (tsMorph.ts.isExpressionStatement(node) || tsMorph.ts.isIfStatement(node)) {
                        var bootstrapModuleReference = 'bootstrapModule';
                        // Find the root module with bootstrapModule call
                        // 1. find a simple call : platformBrowserDynamic().bootstrapModule(AppModule);
                        // 2. or inside a call :
                        // () => {
                        //     platformBrowserDynamic().bootstrapModule(AppModule);
                        // });
                        // 3. with a catch : platformBrowserDynamic().bootstrapModule(AppModule).catch(error => console.error(error));
                        // 4. with parameters : platformBrowserDynamic().bootstrapModule(AppModule, {}).catch(error => console.error(error));
                        // Find recusively in expression nodes one with name 'bootstrapModule'
                        var rootModule_1;
                        var resultNode = void 0;
                        if (srcFile.text.indexOf(bootstrapModuleReference) !== -1) {
                            if (node.expression) {
                                resultNode = _this.findExpressionByNameInExpressions(node.expression, 'bootstrapModule');
                            }
                            if (typeof node.thenStatement !== 'undefined') {
                                if (node.thenStatement.statements &&
                                    node.thenStatement.statements.length > 0) {
                                    var firstStatement = node.thenStatement.statements[0];
                                    resultNode = _this.findExpressionByNameInExpressions(firstStatement.expression, 'bootstrapModule');
                                }
                            }
                            if (!resultNode) {
                                if (node.expression &&
                                    node.expression.arguments &&
                                    node.expression.arguments.length > 0) {
                                    resultNode = _this.findExpressionByNameInExpressionArguments(node.expression.arguments, 'bootstrapModule');
                                }
                            }
                            if (resultNode) {
                                if (resultNode.arguments.length > 0) {
                                    ___namespace.forEach(resultNode.arguments, function (argument) {
                                        if (argument.text) {
                                            rootModule_1 = argument.text;
                                        }
                                    });
                                }
                                if (rootModule_1) {
                                    RouterParserUtil$1.setRootModule(rootModule_1);
                                }
                            }
                        }
                    }
                    if (tsMorph.ts.isVariableStatement(node) && !RouterParserUtil$1.isVariableRoutes(node)) {
                        var isDestructured = false;
                        // Check for destructuring array
                        var nodeVariableDeclarations = node.declarationList.declarations;
                        if (nodeVariableDeclarations) {
                            if (nodeVariableDeclarations.length > 0) {
                                if (nodeVariableDeclarations[0].name &&
                                    nodeVariableDeclarations[0].name.kind ===
                                        tsMorph.SyntaxKind.ArrayBindingPattern) {
                                    isDestructured = true;
                                }
                            }
                        }
                        var visitVariableNode = function (variableNode) {
                            var infos = _this.visitVariableDeclaration(variableNode);
                            if (infos) {
                                var name = infos.name;
                                var deprecated = infos.deprecated;
                                var deprecationMessage = infos.deprecationMessage;
                                var deps = {
                                    name: name,
                                    ctype: 'miscellaneous',
                                    subtype: 'variable',
                                    file: file,
                                    deprecated: deprecated,
                                    deprecationMessage: deprecationMessage
                                };
                                deps.type = infos.type ? infos.type : '';
                                if (infos.defaultValue) {
                                    deps.defaultValue = infos.defaultValue;
                                }
                                if (infos.initializer) {
                                    deps.initializer = infos.initializer;
                                }
                                if (variableNode.jsDoc &&
                                    variableNode.jsDoc.length > 0 &&
                                    variableNode.jsDoc[0].comment) {
                                    var rawDescription = _this.jsdocParserUtil.parseJSDocNode(variableNode.jsDoc[0]);
                                    deps.rawdescription = rawDescription;
                                    deps.description = markedAcl(rawDescription);
                                }
                                if (isModuleWithProviders(variableNode)) {
                                    var routingInitializer = getModuleWithProviders(variableNode);
                                    RouterParserUtil$1.addModuleWithRoutes(name, [routingInitializer], file);
                                    RouterParserUtil$1.addModule(name, [routingInitializer]);
                                }
                                if (!isIgnore(variableNode)) {
                                    _this.debug(deps);
                                    outputSymbols.miscellaneous.variables.push(deps);
                                }
                            }
                        };
                        if (isDestructured) {
                            if (nodeVariableDeclarations[0].name.elements) {
                                var destructuredVariables = nodeVariableDeclarations[0].name.elements;
                                for (var i = 0; i < destructuredVariables.length; i++) {
                                    var destructuredVariable = destructuredVariables[i];
                                    var name = destructuredVariable.name
                                        ? destructuredVariable.name.escapedText
                                        : '';
                                    var deps = {
                                        name: name,
                                        ctype: 'miscellaneous',
                                        subtype: 'variable',
                                        file: file
                                    };
                                    if (nodeVariableDeclarations[0].initializer) {
                                        if (nodeVariableDeclarations[0].initializer.elements) {
                                            deps.initializer =
                                                nodeVariableDeclarations[0].initializer.elements[i];
                                        }
                                        deps.defaultValue = deps.initializer
                                            ? _this.classHelper.stringifyDefaultValue(deps.initializer)
                                            : undefined;
                                    }
                                    if (!isIgnore(destructuredVariables[i])) {
                                        _this.debug(deps);
                                        outputSymbols.miscellaneous.variables.push(deps);
                                    }
                                }
                            }
                        }
                        else {
                            visitVariableNode(node);
                        }
                    }
                    if (tsMorph.ts.isTypeAliasDeclaration(node)) {
                        var infos = _this.visitTypeDeclaration(node);
                        var name = infos.name;
                        var deprecated = infos.deprecated;
                        var deprecationMessage = infos.deprecationMessage;
                        var deps = {
                            name: name,
                            ctype: 'miscellaneous',
                            subtype: 'typealias',
                            rawtype: _this.classHelper.visitType(node),
                            file: file,
                            deprecated: deprecated,
                            deprecationMessage: deprecationMessage,
                            description: _this.visitEnumTypeAliasFunctionDeclarationDescription(node)
                        };
                        if (node.type) {
                            deps.kind = node.type.kind;
                        }
                        if (deps.kind &&
                            deps.kind === tsMorph.SyntaxKind.TemplateLiteralType &&
                            node.type) {
                            deps.rawtype = srcFile.text.substring(node.type.pos, node.type.end);
                        }
                        if (!isIgnore(node)) {
                            _this.debug(deps);
                            outputSymbols.miscellaneous.typealiases.push(deps);
                        }
                    }
                    if (tsMorph.ts.isFunctionDeclaration(node)) {
                        var infos = _this.visitFunctionDeclaration(node);
                        var name = infos.name;
                        var deprecated = infos.deprecated;
                        var deprecationMessage = infos.deprecationMessage;
                        var functionDep = {
                            name: name,
                            ctype: 'miscellaneous',
                            subtype: 'function',
                            file: file,
                            deprecated: deprecated,
                            deprecationMessage: deprecationMessage,
                            description: _this.visitEnumTypeAliasFunctionDeclarationDescription(node)
                        };
                        if (infos.args) {
                            functionDep.args = infos.args;
                        }
                        if (infos.returnType) {
                            functionDep.returnType = infos.returnType;
                        }
                        if (infos.jsdoctags && infos.jsdoctags.length > 0) {
                            functionDep.jsdoctags = infos.jsdoctags;
                        }
                        if (typeof infos.ignore === 'undefined') {
                            if (!(_this.hasPrivateJSDocTag(functionDep.jsdoctags) &&
                                Configuration$1.mainData.disablePrivate)) {
                                _this.debug(functionDep);
                                outputSymbols.miscellaneous.functions.push(functionDep);
                            }
                        }
                    }
                    if (tsMorph.ts.isEnumDeclaration(node)) {
                        var infos = _this.visitEnumDeclaration(node);
                        var name = infos.name;
                        var deprecated = infos.deprecated;
                        var deprecationMessage = infos.deprecationMessage;
                        var enumDeps = {
                            name: name,
                            childs: infos.members,
                            ctype: 'miscellaneous',
                            subtype: 'enum',
                            deprecated: deprecated,
                            deprecationMessage: deprecationMessage,
                            description: _this.visitEnumTypeAliasFunctionDeclarationDescription(node),
                            file: file
                        };
                        if (!isIgnore(node)) {
                            _this.debug(enumDeps);
                            outputSymbols.miscellaneous.enumerations.push(enumDeps);
                        }
                    }
                }
            };
            parseNode(fileName, scannedFile, initialNode, null, astFile);
        });
    };
    /**
     * Function to in a specific store an entity, and check before is there is not the same one
     * in that store : same name, id and file
     * @param entity Entity to store
     * @param store Store
     */
    AngularDependencies.prototype.addNewEntityInStore = function (entity, store) {
        var findSameEntityInStore = ___namespace.filter(store, {
            name: entity.name,
            id: entity.id,
            file: entity.file
        });
        if (findSameEntityInStore.length === 0) {
            store.push(entity);
        }
    };
    AngularDependencies.prototype.debug = function (deps) {
        if (deps) {
            logger.debug('found', "".concat(deps.name));
        }
        else {
            return;
        }
        ['imports', 'exports', 'declarations', 'providers', 'bootstrap'].forEach(function (symbols) {
            if (deps[symbols] && deps[symbols].length > 0) {
                logger.debug('', "- ".concat(symbols, ":"));
                deps[symbols]
                    .map(function (i) { return i.name; })
                    .forEach(function (d) {
                    logger.debug('', "\t- ".concat(d));
                });
            }
        });
    };
    AngularDependencies.prototype.ignore = function (deps) {
        if (deps) {
            logger.warn('ignore', "".concat(deps.name));
        }
        else {
            return;
        }
    };
    AngularDependencies.prototype.checkForDeprecation = function (tags, result) {
        ___namespace.forEach(tags, function (tag) {
            if (tag.tagName && tag.tagName.text && tag.tagName.text.indexOf('deprecated') > -1) {
                result.deprecated = true;
                result.deprecationMessage = tag.comment || '';
            }
        });
    };
    AngularDependencies.prototype.findExpressionByNameInExpressions = function (entryNode, name) {
        var result;
        var loop = function (node, z) {
            if (node) {
                if (node.expression && !node.expression.name) {
                    loop(node.expression, z);
                }
                if (node.expression && node.expression.name) {
                    if (node.expression.name.text === z) {
                        result = node;
                    }
                    else {
                        loop(node.expression, z);
                    }
                }
            }
        };
        loop(entryNode, name);
        return result;
    };
    AngularDependencies.prototype.findExpressionByNameInExpressionArguments = function (arg, name) {
        var result;
        var that = this;
        var i = 0;
        var len = arg.length;
        var loop = function (node, z) {
            if (node.body) {
                if (node.body.statements && node.body.statements.length > 0) {
                    var j = 0;
                    var leng = node.body.statements.length;
                    for (j; j < leng; j++) {
                        result = that.findExpressionByNameInExpressions(node.body.statements[j], z);
                    }
                }
            }
        };
        for (i; i < len; i++) {
            loop(arg[i], name);
        }
        return result;
    };
    AngularDependencies.prototype.parseDecorators = function (decorators, type) {
        var result = false;
        if (decorators.length > 1) {
            ___namespace.forEach(decorators, function (decorator) {
                if (decorator.expression.expression) {
                    if (decorator.expression.expression.text === type) {
                        result = true;
                    }
                }
            });
        }
        else {
            if (decorators[0].expression.expression) {
                if (decorators[0].expression.expression.text === type) {
                    result = true;
                }
            }
        }
        return result;
    };
    AngularDependencies.prototype.parseDecorator = function (decorator, type) {
        var result = false;
        if (decorator.expression.expression) {
            if (decorator.expression.expression.text === type) {
                result = true;
            }
        }
        return result;
    };
    AngularDependencies.prototype.isController = function (metadata) {
        return this.parseDecorator(metadata, 'Controller');
    };
    AngularDependencies.prototype.isEntity = function (metadata) {
        return this.parseDecorator(metadata, 'Entity');
    };
    AngularDependencies.prototype.isComponent = function (metadata) {
        return this.parseDecorator(metadata, 'Component');
    };
    AngularDependencies.prototype.isPipe = function (metadata) {
        return this.parseDecorator(metadata, 'Pipe');
    };
    AngularDependencies.prototype.isDirective = function (metadata) {
        return this.parseDecorator(metadata, 'Directive');
    };
    AngularDependencies.prototype.isInjectable = function (metadata) {
        return this.parseDecorator(metadata, 'Injectable');
    };
    AngularDependencies.prototype.isModule = function (metadata) {
        return this.parseDecorator(metadata, 'NgModule') || this.parseDecorator(metadata, 'Module');
    };
    AngularDependencies.prototype.hasInternalDecorator = function (metadatas) {
        return (this.parseDecorators(metadatas, 'Controller') ||
            this.parseDecorators(metadatas, 'Component') ||
            this.parseDecorators(metadatas, 'Pipe') ||
            this.parseDecorators(metadatas, 'Directive') ||
            this.parseDecorators(metadatas, 'Injectable') ||
            this.parseDecorators(metadatas, 'NgModule') ||
            this.parseDecorators(metadatas, 'Module'));
    };
    AngularDependencies.prototype.isGuard = function (ioImplements) {
        return (___namespace.includes(ioImplements, 'CanActivate') ||
            ___namespace.includes(ioImplements, 'CanActivateChild') ||
            ___namespace.includes(ioImplements, 'CanDeactivate') ||
            ___namespace.includes(ioImplements, 'Resolve') ||
            ___namespace.includes(ioImplements, 'CanLoad'));
    };
    AngularDependencies.prototype.getSymboleName = function (node) {
        return node.name.text;
    };
    AngularDependencies.prototype.findProperties = function (visitedNode, sourceFile) {
        if (visitedNode.expression &&
            visitedNode.expression.arguments &&
            visitedNode.expression.arguments.length > 0) {
            var pop = visitedNode.expression.arguments[0];
            if (pop && pop.properties && pop.properties.length >= 0) {
                return pop.properties;
            }
            else if (pop && pop.kind && pop.kind === tsMorph.SyntaxKind.StringLiteral) {
                return [pop];
            }
            else {
                logger.warn('Empty metadatas, trying to find it with imports.');
                return ImportsUtil$1.findValueInImportOrLocalVariables(pop.text, sourceFile);
            }
        }
        return [];
    };
    AngularDependencies.prototype.isAngularLifecycleHook = function (methodName) {
        /**
         * Copyright https://github.com/ng-bootstrap/ng-bootstrap
         */
        var ANGULAR_LIFECYCLE_METHODS = [
            'ngOnInit',
            'ngOnChanges',
            'ngDoCheck',
            'ngOnDestroy',
            'ngAfterContentInit',
            'ngAfterContentChecked',
            'ngAfterViewInit',
            'ngAfterViewChecked',
            'writeValue',
            'registerOnChange',
            'registerOnTouched',
            'setDisabledState'
        ];
        return ANGULAR_LIFECYCLE_METHODS.indexOf(methodName) >= 0;
    };
    AngularDependencies.prototype.visitTypeDeclaration = function (node) {
        var result = {
            deprecated: false,
            deprecationMessage: '',
            name: node.name.text,
            kind: node.kind
        };
        var jsdoctags = this.jsdocParserUtil.getJSDocs(node);
        if (jsdoctags && jsdoctags.length >= 1 && jsdoctags[0].tags) {
            this.checkForDeprecation(jsdoctags[0].tags, result);
            result.jsdoctags = markedtags(jsdoctags[0].tags);
        }
        return result;
    };
    AngularDependencies.prototype.visitArgument = function (arg) {
        var _this = this;
        if (arg.name && arg.name.kind == tsMorph.SyntaxKind.ObjectBindingPattern) {
            var results = [];
            var destrucuredGroupId_1 = uuid.v4();
            results = arg.name.elements.map(function (element) { return _this.visitArgument(element); });
            results = results.map(function (result) {
                result.destrucuredGroupId = destrucuredGroupId_1;
                return result;
            });
            if (arg.name.elements && arg.type && arg.type.members) {
                if (arg.name.elements.length === arg.type.members.length) {
                    for (var i = 0; i < arg.name.elements.length; i++) {
                        results[i].type = this.classHelper.visitType(arg.type.members[i]);
                    }
                }
            }
            if (arg.name.elements && arg.type && arg.type.typeName) {
                results[0].type = this.classHelper.visitType(arg.type);
            }
            return results;
        }
        else {
            var result = {
                name: arg.name.text,
                type: this.classHelper.visitType(arg),
                deprecated: false,
                deprecationMessage: ''
            };
            if (arg.dotDotDotToken) {
                result.dotDotDotToken = true;
            }
            if (arg.questionToken) {
                result.optional = true;
            }
            if (arg.initializer) {
                result.defaultValue = arg.initializer
                    ? this.classHelper.stringifyDefaultValue(arg.initializer)
                    : undefined;
            }
            if (arg.type) {
                result.type = this.mapType(arg.type.kind);
                if (arg.type.kind === tsMorph.SyntaxKind.TypeReference) {
                    // try replace TypeReference with typeName
                    if (arg.type.typeName) {
                        result.type = arg.type.typeName.text;
                    }
                }
            }
            var jsdoctags = this.jsdocParserUtil.getJSDocs(arg);
            if (jsdoctags && jsdoctags.length >= 1 && jsdoctags[0].tags) {
                this.checkForDeprecation(jsdoctags[0].tags, result);
            }
            return result;
        }
    };
    AngularDependencies.prototype.mapType = function (type) {
        switch (type) {
            case tsMorph.SyntaxKind.NullKeyword:
                return 'null';
            case tsMorph.SyntaxKind.AnyKeyword:
                return 'any';
            case tsMorph.SyntaxKind.BooleanKeyword:
                return 'boolean';
            case tsMorph.SyntaxKind.NeverKeyword:
                return 'never';
            case tsMorph.SyntaxKind.NumberKeyword:
                return 'number';
            case tsMorph.SyntaxKind.StringKeyword:
                return 'string';
            case tsMorph.SyntaxKind.UndefinedKeyword:
                return 'undefined';
            case tsMorph.SyntaxKind.TypeReference:
                return 'typeReference';
        }
    };
    AngularDependencies.prototype.hasPrivateJSDocTag = function (tags) {
        var result = false;
        if (tags) {
            tags.forEach(function (tag) {
                if (tag.tagName && tag.tagName.text && tag.tagName.text === 'private') {
                    result = true;
                }
            });
        }
        return result;
    };
    AngularDependencies.prototype.visitFunctionDeclaration = function (method) {
        var methodName = method.name ? method.name.text : 'Unnamed function';
        var resultArguments = [];
        var result = {
            deprecated: false,
            deprecationMessage: '',
            name: methodName
        };
        for (var i = 0; i < method.parameters.length; i++) {
            var argument = method.parameters[i];
            if (argument) {
                var argumentParsed = this.visitArgument(argument);
                if (argumentParsed.length > 0) {
                    for (var j = 0; j < argumentParsed.length; j++) {
                        var argumentParsedInside = argumentParsed[j];
                        argumentParsedInside.destructuredParameter = true;
                        resultArguments.push(argumentParsedInside);
                    }
                }
                else {
                    resultArguments.push(argumentParsed);
                }
            }
        }
        result.args = resultArguments;
        var jsdoctags = this.jsdocParserUtil.getJSDocs(method);
        if (typeof method.type !== 'undefined') {
            result.returnType = this.classHelper.visitType(method.type);
        }
        if (method.modifiers) {
            if (method.modifiers.length > 0) {
                var kinds = method.modifiers
                    .map(function (modifier) {
                    return modifier.kind;
                })
                    .reverse();
                if (___namespace.indexOf(kinds, tsMorph.SyntaxKind.PublicKeyword) !== -1 &&
                    ___namespace.indexOf(kinds, tsMorph.SyntaxKind.StaticKeyword) !== -1) {
                    kinds = kinds.filter(function (kind) { return kind !== tsMorph.SyntaxKind.PublicKeyword; });
                }
            }
        }
        if (jsdoctags && jsdoctags.length >= 1 && jsdoctags[0].tags) {
            this.checkForDeprecation(jsdoctags[0].tags, result);
            result.jsdoctags = markedtags(jsdoctags[0].tags);
            ___namespace.forEach(jsdoctags[0].tags, function (tag) {
                if (tag.tagName) {
                    if (tag.tagName.text) {
                        if (tag.tagName.text.indexOf('ignore') > -1) {
                            result.ignore = true;
                        }
                    }
                }
            });
        }
        if (result.jsdoctags && result.jsdoctags.length > 0) {
            result.jsdoctags = mergeTagsAndArgs(result.args, result.jsdoctags);
        }
        else if (result.args.length > 0) {
            result.jsdoctags = mergeTagsAndArgs(result.args);
        }
        return result;
    };
    AngularDependencies.prototype.visitVariableDeclaration = function (node) {
        if (node.declarationList && node.declarationList.declarations) {
            var i = 0;
            var len = node.declarationList.declarations.length;
            for (i; i < len; i++) {
                var result = {
                    name: node.declarationList.declarations[i].name.text,
                    defaultValue: node.declarationList.declarations[i].initializer
                        ? this.classHelper.stringifyDefaultValue(node.declarationList.declarations[i].initializer)
                        : undefined,
                    deprecated: false,
                    deprecationMessage: ''
                };
                if (node.declarationList.declarations[i].initializer) {
                    result.initializer = node.declarationList.declarations[i].initializer;
                }
                if (node.declarationList.declarations[i].type) {
                    result.type = this.classHelper.visitType(node.declarationList.declarations[i].type);
                }
                if (typeof result.type === 'undefined' && result.initializer) {
                    result.type = kindToType(result.initializer.kind);
                }
                var jsdoctags = this.jsdocParserUtil.getJSDocs(node.declarationList.declarations[i]);
                if (jsdoctags && jsdoctags.length >= 1 && jsdoctags[0].tags) {
                    this.checkForDeprecation(jsdoctags[0].tags, result);
                }
                return result;
            }
        }
    };
    AngularDependencies.prototype.visitEnumTypeAliasFunctionDeclarationDescription = function (node) {
        var description = '';
        if (node.jsDoc) {
            if (node.jsDoc.length > 0) {
                if (typeof node.jsDoc[0].comment !== 'undefined') {
                    var rawDescription = this.jsdocParserUtil.parseJSDocNode(node.jsDoc[0]);
                    description = markedAcl(rawDescription);
                }
            }
        }
        return description;
    };
    AngularDependencies.prototype.visitEnumDeclaration = function (node) {
        var result = {
            deprecated: false,
            deprecationMessage: '',
            name: node.name.text,
            members: []
        };
        if (node.members) {
            var i = 0;
            var len = node.members.length;
            var memberjsdoctags = [];
            for (i; i < len; i++) {
                var member = {
                    name: node.members[i].name.text,
                    deprecated: false,
                    deprecationMessage: ''
                };
                if (node.members[i].initializer) {
                    // if the initializer kind is a number do cast to the number type
                    member.value = IsKindType.NUMBER(node.members[i].initializer.kind)
                        ? Number(node.members[i].initializer.text)
                        : node.members[i].initializer.text;
                }
                memberjsdoctags = this.jsdocParserUtil.getJSDocs(node.members[i]);
                if (memberjsdoctags && memberjsdoctags.length >= 1 && memberjsdoctags[0].tags) {
                    this.checkForDeprecation(memberjsdoctags[0].tags, member);
                }
                result.members.push(member);
            }
        }
        var jsdoctags = this.jsdocParserUtil.getJSDocs(node);
        if (jsdoctags && jsdoctags.length >= 1 && jsdoctags[0].tags) {
            this.checkForDeprecation(jsdoctags[0].tags, result);
        }
        return result;
    };
    AngularDependencies.prototype.visitEnumDeclarationForRoutes = function (fileName, node) {
        if (node.declarationList.declarations) {
            var i = 0;
            var len = node.declarationList.declarations.length;
            for (i; i < len; i++) {
                var routesInitializer = node.declarationList.declarations[i].initializer;
                var data = new CodeGenerator().generate(routesInitializer);
                RouterParserUtil$1.addRoute({
                    name: node.declarationList.declarations[i].name.text,
                    data: RouterParserUtil$1.cleanRawRoute(data),
                    filename: fileName
                });
                return [
                    {
                        routes: data
                    }
                ];
            }
        }
        return [];
    };
    AngularDependencies.prototype.getRouteIO = function (filename, sourceFile, node) {
        var _this = this;
        var res;
        if (sourceFile.statements) {
            res = sourceFile.statements.reduce(function (directive, statement) {
                if (RouterParserUtil$1.isVariableRoutes(statement)) {
                    if (statement.pos === node.pos && statement.end === node.end) {
                        return directive.concat(_this.visitEnumDeclarationForRoutes(filename, statement));
                    }
                }
                return directive;
            }, []);
            return res[0] || {};
        }
        else {
            return {};
        }
    };
    AngularDependencies.prototype.getClassIO = function (filename, sourceFile, node, fileBody, astFile) {
        var _this = this;
        /**
         * Copyright https://github.com/ng-bootstrap/ng-bootstrap
         */
        var reducedSource = fileBody ? fileBody.statements : sourceFile.statements;
        var res = reducedSource.reduce(function (directive, statement) {
            if (tsMorph.ts.isClassDeclaration(statement)) {
                if (statement.pos === node.pos && statement.end === node.end) {
                    return directive.concat(_this.classHelper.visitClassDeclaration(filename, statement, sourceFile, astFile));
                }
            }
            return directive;
        }, []);
        return res[0] || {};
    };
    AngularDependencies.prototype.getInterfaceIO = function (filename, sourceFile, node, fileBody, astFile) {
        var _this = this;
        /**
         * Copyright https://github.com/ng-bootstrap/ng-bootstrap
         */
        var reducedSource = fileBody ? fileBody.statements : sourceFile.statements;
        var res = reducedSource.reduce(function (directive, statement) {
            if (tsMorph.ts.isInterfaceDeclaration(statement)) {
                if (statement.pos === node.pos && statement.end === node.end) {
                    return directive.concat(_this.classHelper.visitClassDeclaration(filename, statement, sourceFile, astFile));
                }
            }
            return directive;
        }, []);
        return res[0] || {};
    };
    return AngularDependencies;
}(FrameworkDependencies));

var AngularJSDependencies = /** @class */ (function (_super) {
    __extends(AngularJSDependencies, _super);
    function AngularJSDependencies(files, options) {
        var _this = _super.call(this, files, options) || this;
        _this.cache = new ComponentCache();
        _this.moduleHelper = new ModuleHelper(_this.cache);
        _this.jsDocHelper = new JsDocHelper();
        _this.symbolHelper = new SymbolHelper();
        return _this;
    }
    AngularJSDependencies.prototype.getDependencies = function () {
        var deps = {
            modules: [],
            modulesForGraph: [],
            components: [],
            injectables: [],
            interceptors: [],
            pipes: [],
            directives: [],
            routes: [],
            classes: [],
            interfaces: [],
            miscellaneous: {
                variables: [],
                functions: [],
                typealiases: [],
                enumerations: []
            },
            routesTree: undefined
        };
        return deps;
    };
    return AngularJSDependencies;
}(FrameworkDependencies));

function promiseSequential(promises) {
    if (!Array.isArray(promises)) {
        throw new Error('First argument need to be an array of Promises');
    }
    return new Promise(function (resolve, reject) {
        var count = 0;
        var results = [];
        var iterateeFunc = function (previousPromise, currentPromise) {
            return previousPromise
                .then(function (result) {
                if (count++ !== 0) {
                    results = results.concat(result);
                }
                return currentPromise(result, results, count);
            })
                .catch(function (err) {
                return reject(err);
            });
        };
        promises = promises.concat(function () { return Promise.resolve(); });
        promises.reduce(iterateeFunc, Promise.resolve(false)).then(function (res) {
            resolve(results);
        });
    });
}

var chokidar = require('chokidar');
var traverse = require('neotraverse/legacy');
var crypto = require('crypto');
var babel = require('@babel/core');
var cwd$1 = process.cwd();
var startTime = new Date();
var generationPromiseResolve;
var generationPromiseReject;
var generationPromise = new Promise(function (resolve, reject) {
    generationPromiseResolve = resolve;
    generationPromiseReject = reject;
});
var Application = /** @class */ (function () {
    /**
     * Create a new compodoc application instance.
     *
     * @param options An object containing the options that should be used.
     */
    function Application(options) {
        var _this = this;
        /**
         * Files changed during watch scanning
         */
        this.watchChangedFiles = [];
        /**
         * Boolean for watching status
         * @type {boolean}
         */
        this.isWatching = false;
        /**
         * Store package.json data
         */
        this.packageJsonData = {};
        this.preparePipes = function (somePipes) {
            logger.info('Prepare pipes');
            Configuration$1.mainData.pipes = somePipes ? somePipes : DependenciesEngine$1.getPipes();
            return new Promise(function (resolve, reject) {
                var i = 0;
                var len = Configuration$1.mainData.pipes.length;
                var loop = function () {
                    if (i < len) {
                        var pipe = Configuration$1.mainData.pipes[i];
                        if (MarkdownEngine$1.hasNeighbourReadmeFile(pipe.file)) {
                            logger.info(" ".concat(pipe.name, " has a README file, include it"));
                            var readme = MarkdownEngine$1.readNeighbourReadmeFile(pipe.file);
                            pipe.readme = markedAcl(readme);
                        }
                        var page = {
                            path: 'pipes',
                            name: pipe.name,
                            id: pipe.id,
                            navTabs: _this.getNavTabs(pipe),
                            context: 'pipe',
                            pipe: pipe,
                            depth: 1,
                            pageType: COMPODOC_DEFAULTS.PAGE_TYPES.INTERNAL
                        };
                        if (pipe.isDuplicate) {
                            page.name += '-' + pipe.duplicateId;
                        }
                        Configuration$1.addPage(page);
                        i++;
                        loop();
                    }
                    else {
                        resolve(true);
                    }
                };
                loop();
            });
        };
        this.prepareClasses = function (someClasses) {
            logger.info('Prepare classes');
            Configuration$1.mainData.classes = someClasses
                ? someClasses
                : DependenciesEngine$1.getClasses();
            return new Promise(function (resolve, reject) {
                var i = 0;
                var len = Configuration$1.mainData.classes.length;
                var loop = function () {
                    if (i < len) {
                        var classe = Configuration$1.mainData.classes[i];
                        if (MarkdownEngine$1.hasNeighbourReadmeFile(classe.file)) {
                            logger.info(" ".concat(classe.name, " has a README file, include it"));
                            var readme = MarkdownEngine$1.readNeighbourReadmeFile(classe.file);
                            classe.readme = markedAcl(readme);
                        }
                        var page = {
                            path: 'classes',
                            name: classe.name,
                            id: classe.id,
                            navTabs: _this.getNavTabs(classe),
                            context: 'class',
                            class: classe,
                            depth: 1,
                            pageType: COMPODOC_DEFAULTS.PAGE_TYPES.INTERNAL
                        };
                        if (classe.isDuplicate) {
                            page.name += '-' + classe.duplicateId;
                        }
                        Configuration$1.addPage(page);
                        i++;
                        loop();
                    }
                    else {
                        resolve(true);
                    }
                };
                loop();
            });
        };
        for (var option in options) {
            if (typeof Configuration$1.mainData[option] !== 'undefined') {
                Configuration$1.mainData[option] = options[option];
            }
            // For documentationMainName, process it outside the loop, for handling conflict with pages name
            if (option === 'name') {
                Configuration$1.mainData.documentationMainName = options[option];
            }
            // For documentationMainName, process it outside the loop, for handling conflict with pages name
            if (option === 'silent') {
                logger.silent = false;
            }
        }
    }
    /**
     * Start compodoc process
     */
    Application.prototype.generate = function () {
        var _this = this;
        process.on('unhandledRejection', this.unhandledRejectionListener);
        process.on('uncaughtException', this.uncaughtExceptionListener);
        I18nEngine$1.init(Configuration$1.mainData.language);
        if (Configuration$1.mainData.output.charAt(Configuration$1.mainData.output.length - 1) !== '/') {
            Configuration$1.mainData.output += '/';
        }
        if (Configuration$1.mainData.exportFormat !== COMPODOC_DEFAULTS.exportFormat) {
            this.processPackageJson();
        }
        else {
            HtmlEngine$1.init(Configuration$1.mainData.templates).then(function () { return _this.processPackageJson(); });
        }
        return generationPromise;
    };
    Application.prototype.endCallback = function () {
        process.removeListener('unhandledRejection', this.unhandledRejectionListener);
        process.removeListener('uncaughtException', this.uncaughtExceptionListener);
    };
    Application.prototype.unhandledRejectionListener = function (err, p) {
        console.log('Unhandled Rejection at:', p, 'reason:', err);
        logger.error('Sorry, but there was a problem during parsing or generation of the documentation. Please fill an issue on github. (https://github.com/compodoc/compodoc/issues/new)'); // tslint:disable-line
        process.exit(1);
    };
    Application.prototype.uncaughtExceptionListener = function (err) {
        logger.error(err);
        logger.error('Sorry, but there was a problem during parsing or generation of the documentation. Please fill an issue on github. (https://github.com/compodoc/compodoc/issues/new)'); // tslint:disable-line
        process.exit(1);
    };
    /**
     * Start compodoc documentation coverage
     */
    Application.prototype.testCoverage = function () {
        this.getDependenciesData();
    };
    /**
     * Store files for initial processing
     * @param  {Array<string>} files Files found during source folder and tsconfig scan
     */
    Application.prototype.setFiles = function (files) {
        this.files = files;
    };
    /**
     * Store files for watch processing
     * @param  {Array<string>} files Files found during source folder and tsconfig scan
     */
    Application.prototype.setUpdatedFiles = function (files) {
        this.updatedFiles = files;
    };
    /**
     * Return a boolean indicating presence of one TypeScript file in updatedFiles list
     * @return {boolean} Result of scan
     */
    Application.prototype.hasWatchedFilesTSFiles = function () {
        var result = false;
        ___namespace.forEach(this.updatedFiles, function (file) {
            if (path__namespace.extname(file) === '.ts') {
                result = true;
            }
        });
        return result;
    };
    /**
     * Return a boolean indicating presence of one root markdown files in updatedFiles list
     * @return {boolean} Result of scan
     */
    Application.prototype.hasWatchedFilesRootMarkdownFiles = function () {
        var result = false;
        ___namespace.forEach(this.updatedFiles, function (file) {
            if (path__namespace.extname(file) === '.md' && path__namespace.dirname(file) === cwd$1) {
                result = true;
            }
        });
        return result;
    };
    /**
     * Clear files for watch processing
     */
    Application.prototype.clearUpdatedFiles = function () {
        this.updatedFiles = [];
        this.watchChangedFiles = [];
    };
    Application.prototype.processPackageJson = function () {
        var _this = this;
        logger.info('Searching package.json file');
        FileEngine$1.get(cwd$1 + path__namespace.sep + 'package.json').then(function (packageData) {
            var parsedData = JSON.parse(packageData);
            _this.packageJsonData = parsedData;
            if (typeof parsedData.name !== 'undefined' &&
                Configuration$1.mainData.documentationMainName === COMPODOC_DEFAULTS.title) {
                Configuration$1.mainData.documentationMainName =
                    parsedData.name + ' documentation';
            }
            if (typeof parsedData.description !== 'undefined') {
                Configuration$1.mainData.documentationMainDescription = parsedData.description;
            }
            Configuration$1.mainData.angularVersion =
                AngularVersionUtil$1.getAngularVersionOfProject(parsedData);
            logger.info('package.json file found');
            if (!Configuration$1.mainData.disableDependencies) {
                if (typeof parsedData.dependencies !== 'undefined') {
                    _this.processPackageDependencies(parsedData.dependencies);
                }
                if (typeof parsedData.peerDependencies !== 'undefined') {
                    _this.processPackagePeerDependencies(parsedData.peerDependencies);
                }
            }
            if (!Configuration$1.mainData.disableProperties) {
                var propertiesToCheck = [
                    'version',
                    'description',
                    'keywords',
                    'homepage',
                    'bugs',
                    'license',
                    'repository',
                    'author'
                ];
                var hasOneOfCheckedProperties_1 = false;
                propertiesToCheck.forEach(function (prop) {
                    if (prop in parsedData) {
                        hasOneOfCheckedProperties_1 = true;
                        Configuration$1.mainData.packageProperties[prop] = parsedData[prop];
                    }
                });
                if (hasOneOfCheckedProperties_1) {
                    Configuration$1.addPage({
                        name: 'properties',
                        id: 'packageProperties',
                        context: 'package-properties',
                        depth: 0,
                        pageType: COMPODOC_DEFAULTS.PAGE_TYPES.ROOT
                    });
                }
            }
            _this.processMarkdowns().then(function () {
                _this.getDependenciesData();
            }, function (errorMessage) {
                logger.error(errorMessage);
                process.exit(1);
            });
        }, function (errorMessage) {
            logger.error(errorMessage);
            logger.error('Continuing without package.json file');
            _this.processMarkdowns().then(function () {
                _this.getDependenciesData();
            }, function (errorMessage1) {
                logger.error(errorMessage1);
                process.exit(1);
            });
        });
    };
    Application.prototype.processPackagePeerDependencies = function (dependencies) {
        logger.info('Processing package.json peerDependencies');
        Configuration$1.mainData.packagePeerDependencies = dependencies;
        if (!Configuration$1.hasPage('dependencies')) {
            Configuration$1.addPage({
                name: 'dependencies',
                id: 'packageDependencies',
                context: 'package-dependencies',
                depth: 0,
                pageType: COMPODOC_DEFAULTS.PAGE_TYPES.ROOT
            });
        }
    };
    Application.prototype.processPackageDependencies = function (dependencies) {
        logger.info('Processing package.json dependencies');
        Configuration$1.mainData.packageDependencies = dependencies;
        Configuration$1.addPage({
            name: 'dependencies',
            id: 'packageDependencies',
            context: 'package-dependencies',
            depth: 0,
            pageType: COMPODOC_DEFAULTS.PAGE_TYPES.ROOT
        });
    };
    Application.prototype.processMarkdowns = function () {
        logger.info('Searching README.md, CHANGELOG.md, CONTRIBUTING.md, LICENSE.md, TODO.md files');
        return new Promise(function (resolve, reject) {
            var i = 0;
            var markdowns = ['readme', 'changelog', 'contributing', 'license', 'todo'];
            var numberOfMarkdowns = 5;
            var loop = function () {
                if (i < numberOfMarkdowns) {
                    MarkdownEngine$1.getTraditionalMarkdown(markdowns[i].toUpperCase()).then(function (readmeData) {
                        Configuration$1.addPage({
                            name: markdowns[i] === 'readme' ? 'index' : markdowns[i],
                            context: 'getting-started',
                            id: 'getting-started',
                            markdown: readmeData.markdown,
                            data: readmeData.rawData,
                            depth: 0,
                            pageType: COMPODOC_DEFAULTS.PAGE_TYPES.ROOT
                        });
                        if (markdowns[i] === 'readme') {
                            Configuration$1.mainData.readme = true;
                            Configuration$1.addPage({
                                name: 'overview',
                                id: 'overview',
                                context: 'overview',
                                depth: 0,
                                pageType: COMPODOC_DEFAULTS.PAGE_TYPES.ROOT
                            });
                        }
                        else {
                            Configuration$1.mainData.markdowns.push({
                                name: markdowns[i],
                                uppername: markdowns[i].toUpperCase(),
                                depth: 0,
                                pageType: COMPODOC_DEFAULTS.PAGE_TYPES.ROOT
                            });
                        }
                        logger.info("".concat(markdowns[i].toUpperCase(), ".md file found"));
                        i++;
                        loop();
                    }, function (errorMessage) {
                        logger.warn(errorMessage);
                        logger.warn("Continuing without ".concat(markdowns[i].toUpperCase(), ".md file"));
                        if (markdowns[i] === 'readme') {
                            Configuration$1.addPage({
                                name: 'index',
                                id: 'index',
                                context: 'overview',
                                depth: 0,
                                pageType: COMPODOC_DEFAULTS.PAGE_TYPES.ROOT
                            });
                        }
                        i++;
                        loop();
                    });
                }
                else {
                    resolve(true);
                }
            };
            loop();
        });
    };
    Application.prototype.rebuildRootMarkdowns = function () {
        var _this = this;
        logger.info('Regenerating README.md, CHANGELOG.md, CONTRIBUTING.md, LICENSE.md, TODO.md pages');
        var actions = [];
        Configuration$1.resetRootMarkdownPages();
        actions.push(function () {
            return _this.processMarkdowns();
        });
        promiseSequential(actions)
            .then(function (res) {
            _this.processPages();
            _this.clearUpdatedFiles();
        })
            .catch(function (errorMessage) {
            logger.error(errorMessage);
        });
    };
    /**
     * Get dependency data for small group of updated files during watch process
     */
    Application.prototype.getMicroDependenciesData = function () {
        logger.info('Get diff dependencies data');
        var dependenciesClass = AngularDependencies;
        Configuration$1.mainData.angularProject = true;
        if (this.detectAngularJSProjects()) {
            logger.info('AngularJS project detected');
            Configuration$1.mainData.angularProject = false;
            Configuration$1.mainData.angularJSProject = true;
            dependenciesClass = AngularJSDependencies;
        }
        var crawler = new dependenciesClass(this.updatedFiles, {
            tsconfigDirectory: path__namespace.dirname(Configuration$1.mainData.tsconfig)
        }, Configuration$1, RouterParserUtil$1);
        var dependenciesData = crawler.getDependencies();
        DependenciesEngine$1.update(dependenciesData);
        this.prepareJustAFewThings(dependenciesData);
    };
    /**
     * Rebuild external documentation during watch process
     */
    Application.prototype.rebuildExternalDocumentation = function () {
        var _this = this;
        logger.info('Rebuild external documentation');
        var actions = [];
        Configuration$1.resetAdditionalPages();
        if (Configuration$1.mainData.includes !== '') {
            actions.push(function () {
                return _this.prepareExternalIncludes();
            });
        }
        promiseSequential(actions)
            .then(function (res) {
            _this.processPages();
            _this.clearUpdatedFiles();
        })
            .catch(function (errorMessage) {
            logger.error(errorMessage);
        });
    };
    Application.prototype.detectAngularJSProjects = function () {
        if (typeof this.packageJsonData.dependencies !== 'undefined') {
            if (typeof this.packageJsonData.dependencies.angular !== 'undefined') ;
            else {
                var countJSFiles_1 = 0;
                this.files.forEach(function (file) {
                    if (path__namespace.extname(file) === '.js') {
                        countJSFiles_1 += 1;
                    }
                });
                (countJSFiles_1 * 100) / this.files.length;
            }
        }
        return false;
    };
    Application.prototype.getDependenciesData = function () {
        logger.info('Get dependencies data');
        /**
         * AngularJS detection strategy :
         * - if in package.json
         * - if 75% of scanned files are *.js files
         */
        var dependenciesClass = AngularDependencies;
        Configuration$1.mainData.angularProject = true;
        if (this.detectAngularJSProjects()) {
            logger.info('AngularJS project detected');
            Configuration$1.mainData.angularProject = false;
            Configuration$1.mainData.angularJSProject = true;
            dependenciesClass = AngularJSDependencies;
        }
        var crawler = new dependenciesClass(this.files, {
            tsconfigDirectory: path__namespace.dirname(Configuration$1.mainData.tsconfig)
        }, Configuration$1, RouterParserUtil$1);
        var dependenciesData = crawler.getDependencies();
        DependenciesEngine$1.init(dependenciesData);
        Configuration$1.mainData.routesLength = RouterParserUtil$1.routesLength();
        this.printStatistics();
        this.prepareEverything();
    };
    Application.prototype.prepareJustAFewThings = function (diffCrawledData) {
        var _this = this;
        var actions = [];
        Configuration$1.resetPages();
        if (!Configuration$1.mainData.disableRoutesGraph) {
            actions.push(function () { return _this.prepareRoutes(); });
        }
        if (diffCrawledData.components.length > 0) {
            actions.push(function () { return _this.prepareComponents(); });
        }
        if (diffCrawledData.controllers.length > 0) {
            actions.push(function () { return _this.prepareControllers(); });
        }
        if (diffCrawledData.entities.length > 0) {
            actions.push(function () { return _this.prepareEntities(); });
        }
        if (diffCrawledData.modules.length > 0) {
            actions.push(function () { return _this.prepareModules(); });
        }
        if (diffCrawledData.directives.length > 0) {
            actions.push(function () { return _this.prepareDirectives(); });
        }
        if (diffCrawledData.injectables.length > 0) {
            actions.push(function () { return _this.prepareInjectables(); });
        }
        if (diffCrawledData.interceptors.length > 0) {
            actions.push(function () { return _this.prepareInterceptors(); });
        }
        if (diffCrawledData.guards.length > 0) {
            actions.push(function () { return _this.prepareGuards(); });
        }
        if (diffCrawledData.pipes.length > 0) {
            actions.push(function () { return _this.preparePipes(); });
        }
        if (diffCrawledData.classes.length > 0) {
            actions.push(function () { return _this.prepareClasses(); });
        }
        if (diffCrawledData.interfaces.length > 0) {
            actions.push(function () { return _this.prepareInterfaces(); });
        }
        if (diffCrawledData.miscellaneous.variables.length > 0 ||
            diffCrawledData.miscellaneous.functions.length > 0 ||
            diffCrawledData.miscellaneous.typealiases.length > 0 ||
            diffCrawledData.miscellaneous.enumerations.length > 0) {
            actions.push(function () { return _this.prepareMiscellaneous(); });
        }
        if (!Configuration$1.mainData.disableCoverage) {
            actions.push(function () { return _this.prepareCoverage(); });
        }
        promiseSequential(actions)
            .then(function (res) {
            if (Configuration$1.mainData.exportFormat !== COMPODOC_DEFAULTS.exportFormat) {
                if (COMPODOC_DEFAULTS.exportFormatsSupported.indexOf(Configuration$1.mainData.exportFormat) > -1) {
                    logger.info("Generating documentation in export format ".concat(Configuration$1.mainData.exportFormat));
                    ExportEngine$1.export(Configuration$1.mainData.output, Configuration$1.mainData).then(function () {
                        generationPromiseResolve(true);
                        _this.endCallback();
                        logger.info('Documentation generated in ' +
                            Configuration$1.mainData.output +
                            ' in ' +
                            _this.getElapsedTime() +
                            ' seconds');
                        if (Configuration$1.mainData.serve) {
                            logger.info("Serving documentation from ".concat(Configuration$1.mainData.output, " at http://").concat(Configuration$1.mainData.hostname, ":").concat(Configuration$1.mainData.port));
                            _this.runWebServer(Configuration$1.mainData.output);
                        }
                    });
                }
                else {
                    logger.warn("Exported format not supported");
                }
            }
            else {
                _this.processGraphs();
                _this.clearUpdatedFiles();
            }
        })
            .catch(function (errorMessage) {
            logger.error(errorMessage);
        });
    };
    Application.prototype.printStatistics = function () {
        logger.info('-------------------');
        logger.info('Project statistics ');
        if (DependenciesEngine$1.modules.length > 0) {
            logger.info("- files        : ".concat(this.files.length));
        }
        if (DependenciesEngine$1.modules.length > 0) {
            logger.info("- module       : ".concat(DependenciesEngine$1.modules.length));
        }
        if (DependenciesEngine$1.components.length > 0) {
            logger.info("- component    : ".concat(DependenciesEngine$1.components.length));
        }
        if (DependenciesEngine$1.controllers.length > 0) {
            logger.info("- controller   : ".concat(DependenciesEngine$1.controllers.length));
        }
        if (DependenciesEngine$1.entities.length > 0) {
            logger.info("- entity       : ".concat(DependenciesEngine$1.entities.length));
        }
        if (DependenciesEngine$1.directives.length > 0) {
            logger.info("- directive    : ".concat(DependenciesEngine$1.directives.length));
        }
        if (DependenciesEngine$1.injectables.length > 0) {
            logger.info("- injectable   : ".concat(DependenciesEngine$1.injectables.length));
        }
        if (DependenciesEngine$1.interceptors.length > 0) {
            logger.info("- injector     : ".concat(DependenciesEngine$1.interceptors.length));
        }
        if (DependenciesEngine$1.guards.length > 0) {
            logger.info("- guard        : ".concat(DependenciesEngine$1.guards.length));
        }
        if (DependenciesEngine$1.pipes.length > 0) {
            logger.info("- pipe         : ".concat(DependenciesEngine$1.pipes.length));
        }
        if (DependenciesEngine$1.classes.length > 0) {
            logger.info("- class        : ".concat(DependenciesEngine$1.classes.length));
        }
        if (DependenciesEngine$1.interfaces.length > 0) {
            logger.info("- interface    : ".concat(DependenciesEngine$1.interfaces.length));
        }
        if (Configuration$1.mainData.routesLength > 0) {
            logger.info("- route        : ".concat(Configuration$1.mainData.routesLength));
        }
        if (DependenciesEngine$1.miscellaneous.typealiases.length > 0) {
            logger.info("- type aliases : ".concat(DependenciesEngine$1.miscellaneous.typealiases.length));
        }
        logger.info('-------------------');
    };
    Application.prototype.prepareEverything = function () {
        var _this = this;
        var actions = [];
        actions.push(function () {
            return _this.prepareComponents();
        });
        actions.push(function () {
            return _this.prepareModules();
        });
        if (DependenciesEngine$1.directives.length > 0) {
            actions.push(function () {
                return _this.prepareDirectives();
            });
        }
        if (DependenciesEngine$1.controllers.length > 0) {
            actions.push(function () {
                return _this.prepareControllers();
            });
        }
        if (DependenciesEngine$1.entities.length > 0) {
            actions.push(function () {
                return _this.prepareEntities();
            });
        }
        if (DependenciesEngine$1.injectables.length > 0) {
            actions.push(function () {
                return _this.prepareInjectables();
            });
        }
        if (DependenciesEngine$1.interceptors.length > 0) {
            actions.push(function () {
                return _this.prepareInterceptors();
            });
        }
        if (DependenciesEngine$1.guards.length > 0) {
            actions.push(function () {
                return _this.prepareGuards();
            });
        }
        if (DependenciesEngine$1.routes &&
            DependenciesEngine$1.routes.children.length > 0 &&
            !Configuration$1.mainData.disableRoutesGraph) {
            actions.push(function () {
                return _this.prepareRoutes();
            });
        }
        if (DependenciesEngine$1.pipes.length > 0) {
            actions.push(function () {
                return _this.preparePipes();
            });
        }
        if (DependenciesEngine$1.classes.length > 0) {
            actions.push(function () {
                return _this.prepareClasses();
            });
        }
        if (DependenciesEngine$1.interfaces.length > 0) {
            actions.push(function () {
                return _this.prepareInterfaces();
            });
        }
        if (DependenciesEngine$1.miscellaneous.variables.length > 0 ||
            DependenciesEngine$1.miscellaneous.functions.length > 0 ||
            DependenciesEngine$1.miscellaneous.typealiases.length > 0 ||
            DependenciesEngine$1.miscellaneous.enumerations.length > 0) {
            actions.push(function () {
                return _this.prepareMiscellaneous();
            });
        }
        if (!Configuration$1.mainData.disableCoverage) {
            actions.push(function () {
                return _this.prepareCoverage();
            });
        }
        if (Configuration$1.mainData.unitTestCoverage !== '') {
            actions.push(function () {
                return _this.prepareUnitTestCoverage();
            });
        }
        if (Configuration$1.mainData.includes !== '') {
            actions.push(function () {
                return _this.prepareExternalIncludes();
            });
        }
        promiseSequential(actions)
            .then(function (res) {
            if (Configuration$1.mainData.exportFormat !== COMPODOC_DEFAULTS.exportFormat) {
                if (COMPODOC_DEFAULTS.exportFormatsSupported.indexOf(Configuration$1.mainData.exportFormat) > -1) {
                    logger.info("Generating documentation in export format ".concat(Configuration$1.mainData.exportFormat));
                    ExportEngine$1.export(Configuration$1.mainData.output, Configuration$1.mainData).then(function () {
                        generationPromiseResolve(true);
                        _this.endCallback();
                        logger.info('Documentation generated in ' +
                            Configuration$1.mainData.output +
                            ' in ' +
                            _this.getElapsedTime() +
                            ' seconds');
                        if (Configuration$1.mainData.serve) {
                            logger.info("Serving documentation from ".concat(Configuration$1.mainData.output, " at http://").concat(Configuration$1.mainData.hostname, ":").concat(Configuration$1.mainData.port));
                            _this.runWebServer(Configuration$1.mainData.output);
                        }
                    });
                }
                else {
                    logger.warn("Exported format not supported");
                }
            }
            else {
                _this.processGraphs();
            }
        })
            .catch(function (errorMessage) {
            logger.error(errorMessage);
            process.exit(1);
        });
    };
    Application.prototype.getIncludedPathForFile = function (file) {
        return path__namespace.join(Configuration$1.mainData.includes, file);
    };
    Application.prototype.prepareExternalIncludes = function () {
        var _this = this;
        logger.info('Adding external markdown files');
        // Scan include folder for files detailed in summary.json
        // For each file, add to Configuration.mainData.additionalPages
        // Each file will be converted to html page, inside COMPODOC_DEFAULTS.additionalEntryPath
        return new Promise(function (resolve, reject) {
            FileEngine$1.get(_this.getIncludedPathForFile('summary.json')).then(function (summaryData) {
                logger.info('Additional documentation: summary.json file found');
                var parsedSummaryData = JSON.parse(summaryData);
                var that = _this;
                var lastLevelOnePage = undefined;
                traverse(parsedSummaryData).forEach(function () {
                    // tslint:disable-next-line:no-invalid-this
                    if (this.notRoot && typeof this.node === 'object') {
                        // tslint:disable-next-line:no-invalid-this
                        var rawPath = this.path;
                        // tslint:disable-next-line:no-invalid-this
                        var additionalNode = this.node;
                        var file = additionalNode.file;
                        var title = additionalNode.title;
                        var finalPath_1 = Configuration$1.mainData.includesFolder;
                        var finalDepth = rawPath.filter(function (el) {
                            return !isNaN(parseInt(el, 10));
                        });
                        if (typeof file !== 'undefined' && typeof title !== 'undefined') {
                            var url = cleanNameWithoutSpaceAndToLowerCase(title);
                            /**
                             * Id created with title + file path hash, seems to be hypothetically unique here
                             */
                            var id = crypto
                                .createHash('sha512')
                                .update(title + file)
                                .digest('hex');
                            // tslint:disable-next-line:no-invalid-this
                            this.node.id = id;
                            var lastElementRootTree_1 = undefined;
                            finalDepth.forEach(function (el) {
                                var elementTree = typeof lastElementRootTree_1 === 'undefined'
                                    ? parsedSummaryData
                                    : lastElementRootTree_1;
                                if (typeof elementTree.children !== 'undefined') {
                                    elementTree = elementTree.children[el];
                                }
                                else {
                                    elementTree = elementTree[el];
                                }
                                finalPath_1 +=
                                    '/' +
                                        cleanNameWithoutSpaceAndToLowerCase(elementTree.title);
                                lastElementRootTree_1 = elementTree;
                            });
                            finalPath_1 = finalPath_1.replace('/' + url, '');
                            var markdownFile = MarkdownEngine$1.getTraditionalMarkdownSync(that.getIncludedPathForFile(file));
                            if (finalDepth.length > 5) {
                                logger.error('Only 5 levels of depth are supported');
                            }
                            else {
                                var _page = {
                                    name: title,
                                    id: id,
                                    filename: url,
                                    context: 'additional-page',
                                    path: finalPath_1,
                                    additionalPage: markdownFile,
                                    depth: finalDepth.length,
                                    childrenLength: additionalNode.children
                                        ? additionalNode.children.length
                                        : 0,
                                    children: [],
                                    lastChild: false,
                                    pageType: COMPODOC_DEFAULTS.PAGE_TYPES.INTERNAL
                                };
                                if (finalDepth.length === 1) {
                                    lastLevelOnePage = _page;
                                }
                                if (finalDepth.length > 1) {
                                    // store all child pages of the last root level 1 page inside it
                                    lastLevelOnePage.children.push(_page);
                                }
                                else {
                                    Configuration$1.addAdditionalPage(_page);
                                }
                            }
                        }
                    }
                });
                resolve(true);
            }, function (errorMessage) {
                logger.error(errorMessage);
                reject('Error during Additional documentation generation');
            });
        });
    };
    Application.prototype.prepareModules = function (someModules) {
        var _this = this;
        logger.info('Prepare modules');
        var i = 0;
        var _modules = someModules ? someModules : DependenciesEngine$1.getModules();
        return new Promise(function (resolve, reject) {
            Configuration$1.mainData.modules = _modules.map(function (ngModule) {
                ngModule.compodocLinks = {
                    components: [],
                    controllers: [],
                    directives: [],
                    injectables: [],
                    pipes: []
                };
                ['declarations', 'bootstrap', 'imports', 'exports', 'controllers'].forEach(function (metadataType) {
                    ngModule[metadataType] = ngModule[metadataType].filter(function (metaDataItem) {
                        switch (metaDataItem.type) {
                            case 'directive':
                                return DependenciesEngine$1.getDirectives().some(function (directive) {
                                    var selectedDirective;
                                    if (typeof metaDataItem.id !== 'undefined') {
                                        selectedDirective =
                                            directive.id === metaDataItem.id;
                                    }
                                    else {
                                        selectedDirective =
                                            directive.name === metaDataItem.name;
                                    }
                                    if (selectedDirective &&
                                        !ngModule.compodocLinks.directives.includes(directive)) {
                                        ngModule.compodocLinks.directives.push(directive);
                                    }
                                    return selectedDirective;
                                });
                            case 'component':
                                return DependenciesEngine$1.getComponents().some(function (component) {
                                    var selectedComponent;
                                    if (typeof metaDataItem.id !== 'undefined') {
                                        selectedComponent =
                                            component.id === metaDataItem.id;
                                    }
                                    else {
                                        selectedComponent =
                                            component.name === metaDataItem.name;
                                    }
                                    if (selectedComponent &&
                                        !ngModule.compodocLinks.components.includes(component)) {
                                        if (!component.standalone) {
                                            ngModule.compodocLinks.components.push(component);
                                        }
                                    }
                                    return selectedComponent;
                                });
                            case 'controller':
                                return DependenciesEngine$1.getControllers().some(function (controller) {
                                    var selectedController;
                                    if (typeof metaDataItem.id !== 'undefined') {
                                        selectedController =
                                            controller.id === metaDataItem.id;
                                    }
                                    else {
                                        selectedController =
                                            controller.name === metaDataItem.name;
                                    }
                                    if (selectedController &&
                                        !ngModule.compodocLinks.controllers.includes(controller)) {
                                        ngModule.compodocLinks.controllers.push(controller);
                                    }
                                    return selectedController;
                                });
                            case 'module':
                                return DependenciesEngine$1.getModules().some(function (module) { return module.name === metaDataItem.name; });
                            case 'pipe':
                                return DependenciesEngine$1.getPipes().some(function (pipe) {
                                    var selectedPipe;
                                    if (typeof metaDataItem.id !== 'undefined') {
                                        selectedPipe = pipe.id === metaDataItem.id;
                                    }
                                    else {
                                        selectedPipe = pipe.name === metaDataItem.name;
                                    }
                                    if (selectedPipe &&
                                        !ngModule.compodocLinks.pipes.includes(pipe)) {
                                        ngModule.compodocLinks.pipes.push(pipe);
                                    }
                                    return selectedPipe;
                                });
                            default:
                                return true;
                        }
                    });
                });
                ngModule.providers = ngModule.providers.filter(function (provider) {
                    return (DependenciesEngine$1.getInjectables().some(function (injectable) {
                        var selectedInjectable = injectable.name === provider.name;
                        if (selectedInjectable &&
                            !ngModule.compodocLinks.injectables.includes(injectable)) {
                            ngModule.compodocLinks.injectables.push(injectable);
                        }
                        return selectedInjectable;
                    }) ||
                        DependenciesEngine$1.getInterceptors().some(function (interceptor) { return interceptor.name === provider.name; }));
                });
                // Try fixing type undefined for each providers
                ___namespace.forEach(ngModule.providers, function (provider) {
                    if (DependenciesEngine$1.getInjectables().find(function (injectable) { return injectable.name === provider.name; })) {
                        provider.type = 'injectable';
                    }
                    if (DependenciesEngine$1.getInterceptors().find(function (interceptor) { return interceptor.name === provider.name; })) {
                        provider.type = 'interceptor';
                    }
                });
                // Order things
                ngModule.compodocLinks.components = ___namespace.sortBy(ngModule.compodocLinks.components, [
                    'name'
                ]);
                ngModule.compodocLinks.controllers = ___namespace.sortBy(ngModule.compodocLinks.controllers, [
                    'name'
                ]);
                ngModule.compodocLinks.directives = ___namespace.sortBy(ngModule.compodocLinks.directives, [
                    'name'
                ]);
                ngModule.compodocLinks.injectables = ___namespace.sortBy(ngModule.compodocLinks.injectables, [
                    'name'
                ]);
                ngModule.compodocLinks.pipes = ___namespace.sortBy(ngModule.compodocLinks.pipes, ['name']);
                ngModule.declarations = ___namespace.sortBy(ngModule.declarations, ['name']);
                ngModule.entryComponents = ___namespace.sortBy(ngModule.entryComponents, ['name']);
                ngModule.providers = ___namespace.sortBy(ngModule.providers, ['name']);
                ngModule.imports = ___namespace.sortBy(ngModule.imports, ['name']);
                ngModule.exports = ___namespace.sortBy(ngModule.exports, ['name']);
                return ngModule;
            });
            Configuration$1.addPage({
                name: 'modules',
                id: 'modules',
                context: 'modules',
                depth: 0,
                pageType: COMPODOC_DEFAULTS.PAGE_TYPES.ROOT
            });
            var len = Configuration$1.mainData.modules.length;
            var loop = function () {
                if (i < len) {
                    if (MarkdownEngine$1.hasNeighbourReadmeFile(Configuration$1.mainData.modules[i].file)) {
                        logger.info(" ".concat(Configuration$1.mainData.modules[i].name, " has a README file, include it"));
                        var readme = MarkdownEngine$1.readNeighbourReadmeFile(Configuration$1.mainData.modules[i].file);
                        Configuration$1.mainData.modules[i].readme = markedAcl(readme);
                    }
                    Configuration$1.addPage({
                        path: 'modules',
                        name: Configuration$1.mainData.modules[i].name,
                        id: Configuration$1.mainData.modules[i].id,
                        navTabs: _this.getNavTabs(Configuration$1.mainData.modules[i]),
                        context: 'module',
                        module: Configuration$1.mainData.modules[i],
                        depth: 1,
                        pageType: COMPODOC_DEFAULTS.PAGE_TYPES.INTERNAL
                    });
                    i++;
                    loop();
                }
                else {
                    resolve(true);
                }
            };
            loop();
        });
    };
    Application.prototype.prepareInterfaces = function (someInterfaces) {
        var _this = this;
        logger.info('Prepare interfaces');
        Configuration$1.mainData.interfaces = someInterfaces
            ? someInterfaces
            : DependenciesEngine$1.getInterfaces();
        return new Promise(function (resolve, reject) {
            var i = 0;
            var len = Configuration$1.mainData.interfaces.length;
            var loop = function () {
                if (i < len) {
                    var interf = Configuration$1.mainData.interfaces[i];
                    if (MarkdownEngine$1.hasNeighbourReadmeFile(interf.file)) {
                        logger.info(" ".concat(interf.name, " has a README file, include it"));
                        var readme = MarkdownEngine$1.readNeighbourReadmeFile(interf.file);
                        interf.readme = markedAcl(readme);
                    }
                    var page = {
                        path: 'interfaces',
                        name: interf.name,
                        id: interf.id,
                        navTabs: _this.getNavTabs(interf),
                        context: 'interface',
                        interface: interf,
                        depth: 1,
                        pageType: COMPODOC_DEFAULTS.PAGE_TYPES.INTERNAL
                    };
                    if (interf.isDuplicate) {
                        page.name += '-' + interf.duplicateId;
                    }
                    Configuration$1.addPage(page);
                    i++;
                    loop();
                }
                else {
                    resolve(true);
                }
            };
            loop();
        });
    };
    Application.prototype.prepareMiscellaneous = function (someMisc) {
        logger.info('Prepare miscellaneous');
        Configuration$1.mainData.miscellaneous = someMisc
            ? someMisc
            : DependenciesEngine$1.getMiscellaneous();
        return new Promise(function (resolve, reject) {
            if (Configuration$1.mainData.miscellaneous.functions.length > 0) {
                Configuration$1.addPage({
                    path: 'miscellaneous',
                    name: 'functions',
                    id: 'miscellaneous-functions',
                    context: 'miscellaneous-functions',
                    depth: 1,
                    pageType: COMPODOC_DEFAULTS.PAGE_TYPES.INTERNAL
                });
            }
            if (Configuration$1.mainData.miscellaneous.variables.length > 0) {
                Configuration$1.addPage({
                    path: 'miscellaneous',
                    name: 'variables',
                    id: 'miscellaneous-variables',
                    context: 'miscellaneous-variables',
                    depth: 1,
                    pageType: COMPODOC_DEFAULTS.PAGE_TYPES.INTERNAL
                });
            }
            if (Configuration$1.mainData.miscellaneous.typealiases.length > 0) {
                Configuration$1.addPage({
                    path: 'miscellaneous',
                    name: 'typealiases',
                    id: 'miscellaneous-typealiases',
                    context: 'miscellaneous-typealiases',
                    depth: 1,
                    pageType: COMPODOC_DEFAULTS.PAGE_TYPES.INTERNAL
                });
            }
            if (Configuration$1.mainData.miscellaneous.enumerations.length > 0) {
                Configuration$1.addPage({
                    path: 'miscellaneous',
                    name: 'enumerations',
                    id: 'miscellaneous-enumerations',
                    context: 'miscellaneous-enumerations',
                    depth: 1,
                    pageType: COMPODOC_DEFAULTS.PAGE_TYPES.INTERNAL
                });
            }
            resolve(true);
        });
    };
    Application.prototype.handleTemplateurl = function (component) {
        var dirname = path__namespace.dirname(component.file);
        var templatePath = path__namespace.resolve(dirname + path__namespace.sep + component.templateUrl);
        if (!FileEngine$1.existsSync(templatePath)) {
            var err = "Cannot read template for ".concat(component.name);
            logger.error(err);
            return new Promise(function (resolve, reject) { });
        }
        return FileEngine$1.get(templatePath).then(function (data) { return (component.templateData = data); }, function (err) {
            logger.error(err);
            return Promise.reject('');
        });
    };
    Application.prototype.handleStyles = function (component) {
        var styles = component.styles;
        component.stylesData = '';
        return new Promise(function (resolveStyles, rejectStyles) {
            styles.forEach(function (style) {
                component.stylesData = component.stylesData + style + '\n';
            });
            resolveStyles(true);
        });
    };
    Application.prototype.handleStyleurls = function (component) {
        var dirname = path__namespace.dirname(component.file);
        var styleDataPromise = component.styleUrls.map(function (styleUrl) {
            var stylePath = path__namespace.resolve(dirname + path__namespace.sep + styleUrl);
            if (!FileEngine$1.existsSync(stylePath)) {
                var err = "Cannot read style url ".concat(stylePath, " for ").concat(component.name);
                logger.error(err);
                return new Promise(function (resolve, reject) { });
            }
            return new Promise(function (resolve, reject) {
                FileEngine$1.get(stylePath).then(function (data) {
                    resolve({
                        data: data,
                        styleUrl: styleUrl
                    });
                });
            });
        });
        return Promise.all(styleDataPromise).then(function (data) { return (component.styleUrlsData = data); }, function (err) {
            logger.error(err);
            return Promise.reject('');
        });
    };
    Application.prototype.getNavTabs = function (dependency) {
        var navTabConfig = Configuration$1.mainData.navTabConfig;
        var hasCustomNavTabConfig = navTabConfig.length !== 0;
        navTabConfig =
            navTabConfig.length === 0
                ? ___namespace.cloneDeep(COMPODOC_CONSTANTS.navTabDefinitions)
                : navTabConfig;
        var matchDepType = function (depType) {
            return depType === 'all' || depType === dependency.type;
        };
        var navTabs = [];
        ___namespace.forEach(navTabConfig, function (customTab) {
            var navTab = ___namespace.find(COMPODOC_CONSTANTS.navTabDefinitions, { id: customTab.id });
            if (!navTab) {
                throw new Error("Invalid tab ID '".concat(customTab.id, "' specified in tab configuration"));
            }
            navTab.label = customTab.label;
            if (hasCustomNavTabConfig) {
                navTab.custom = true;
            }
            // is tab applicable to target dependency?
            if (-1 === ___namespace.findIndex(navTab.depTypes, matchDepType)) {
                return;
            }
            // global config
            if (customTab.id === 'tree' && Configuration$1.mainData.disableDomTree) {
                return;
            }
            if (customTab.id === 'source' && Configuration$1.mainData.disableSourceCode) {
                return;
            }
            if (customTab.id === 'templateData' && Configuration$1.mainData.disableTemplateTab) {
                return;
            }
            if (customTab.id === 'styleData' && Configuration$1.mainData.disableStyleTab) {
                return;
            }
            // per dependency config
            if (customTab.id === 'readme' && !dependency.readme) {
                return;
            }
            if (customTab.id === 'example' && !dependency.exampleUrls) {
                return;
            }
            if (customTab.id === 'templateData' &&
                (!dependency.templateUrl || dependency.templateUrl.length === 0)) {
                return;
            }
            if (customTab.id === 'styleData' &&
                (!dependency.styleUrls || dependency.styleUrls.length === 0) &&
                (!dependency.styles || dependency.styles.length === 0)) {
                return;
            }
            navTabs.push(navTab);
        });
        if (navTabs.length === 0) {
            throw new Error("No valid navigation tabs have been defined for dependency type '".concat(dependency.type, "'. Specify at least one config for the 'info' or 'source' tab in --navTabConfig."));
        }
        return navTabs;
    };
    Application.prototype.prepareControllers = function (someControllers) {
        var _this = this;
        logger.info('Prepare controllers');
        Configuration$1.mainData.controllers = someControllers
            ? someControllers
            : DependenciesEngine$1.getControllers();
        return new Promise(function (resolve, reject) {
            var i = 0;
            var len = Configuration$1.mainData.controllers.length;
            var loop = function () {
                if (i < len) {
                    var controller = Configuration$1.mainData.controllers[i];
                    var page = {
                        path: 'controllers',
                        name: controller.name,
                        id: controller.id,
                        navTabs: _this.getNavTabs(controller),
                        context: 'controller',
                        controller: controller,
                        depth: 1,
                        pageType: COMPODOC_DEFAULTS.PAGE_TYPES.INTERNAL
                    };
                    if (controller.isDuplicate) {
                        page.name += '-' + controller.duplicateId;
                    }
                    Configuration$1.addPage(page);
                    i++;
                    loop();
                }
                else {
                    resolve(true);
                }
            };
            loop();
        });
    };
    Application.prototype.prepareEntities = function (someEntities) {
        var _this = this;
        logger.info('Prepare entities');
        Configuration$1.mainData.entities = someEntities
            ? someEntities
            : DependenciesEngine$1.getEntities();
        return new Promise(function (resolve, reject) {
            var i = 0;
            var len = Configuration$1.mainData.entities.length;
            var loop = function () {
                if (i < len) {
                    var entity = Configuration$1.mainData.entities[i];
                    var page = {
                        path: 'entities',
                        name: entity.name,
                        id: entity.id,
                        navTabs: _this.getNavTabs(entity),
                        context: 'entity',
                        entity: entity,
                        depth: 1,
                        pageType: COMPODOC_DEFAULTS.PAGE_TYPES.INTERNAL
                    };
                    if (entity.isDuplicate) {
                        page.name += '-' + entity.duplicateId;
                    }
                    Configuration$1.addPage(page);
                    i++;
                    loop();
                }
                else {
                    resolve(true);
                }
            };
            loop();
        });
    };
    Application.prototype.prepareComponents = function (someComponents) {
        var _this = this;
        logger.info('Prepare components');
        Configuration$1.mainData.components = someComponents
            ? someComponents
            : DependenciesEngine$1.getComponents();
        return new Promise(function (mainPrepareComponentResolve, mainPrepareComponentReject) {
            var i = 0;
            var len = Configuration$1.mainData.components.length;
            var loop = function () {
                if (i <= len - 1) {
                    var component_1 = Configuration$1.mainData.components[i];
                    if (MarkdownEngine$1.hasNeighbourReadmeFile(component_1.file)) {
                        logger.info(" ".concat(component_1.name, " has a README file, include it"));
                        var readmeFile = MarkdownEngine$1.readNeighbourReadmeFile(component_1.file);
                        component_1.readme = markedAcl(readmeFile);
                    }
                    var page = {
                        path: 'components',
                        name: component_1.name,
                        id: component_1.id,
                        navTabs: _this.getNavTabs(component_1),
                        context: 'component',
                        component: component_1,
                        depth: 1,
                        pageType: COMPODOC_DEFAULTS.PAGE_TYPES.INTERNAL
                    };
                    if (component_1.isDuplicate) {
                        page.name += '-' + component_1.duplicateId;
                    }
                    Configuration$1.addPage(page);
                    var componentTemplateUrlPromise = new Promise(function (componentTemplateUrlResolve, componentTemplateUrlReject) {
                        if (component_1.templateUrl.length > 0) {
                            logger.info(" ".concat(component_1.name, " has a templateUrl, include it"));
                            _this.handleTemplateurl(component_1).then(function () {
                                componentTemplateUrlResolve(true);
                            }, function (e) {
                                logger.error(e);
                                componentTemplateUrlReject();
                            });
                        }
                        else {
                            componentTemplateUrlResolve(true);
                        }
                    });
                    var componentStyleUrlsPromise = new Promise(function (componentStyleUrlsResolve, componentStyleUrlsReject) {
                        if (component_1.styleUrls.length > 0) {
                            logger.info(" ".concat(component_1.name, " has styleUrls, include them"));
                            _this.handleStyleurls(component_1).then(function () {
                                componentStyleUrlsResolve(true);
                            }, function (e) {
                                logger.error(e);
                                componentStyleUrlsReject();
                            });
                        }
                        else {
                            componentStyleUrlsResolve(true);
                        }
                    });
                    var componentStylesPromise = new Promise(function (componentStylesResolve, componentStylesReject) {
                        if (component_1.styles.length > 0) {
                            logger.info(" ".concat(component_1.name, " has styles, include them"));
                            _this.handleStyles(component_1).then(function () {
                                componentStylesResolve(true);
                            }, function (e) {
                                logger.error(e);
                                componentStylesReject();
                            });
                        }
                        else {
                            componentStylesResolve(true);
                        }
                    });
                    Promise.all([
                        componentTemplateUrlPromise,
                        componentStyleUrlsPromise,
                        componentStylesPromise
                    ]).then(function () {
                        i++;
                        loop();
                    });
                }
                else {
                    mainPrepareComponentResolve(true);
                }
            };
            loop();
        });
    };
    Application.prototype.prepareDirectives = function (someDirectives) {
        var _this = this;
        logger.info('Prepare directives');
        Configuration$1.mainData.directives = someDirectives
            ? someDirectives
            : DependenciesEngine$1.getDirectives();
        return new Promise(function (resolve, reject) {
            var i = 0;
            var len = Configuration$1.mainData.directives.length;
            var loop = function () {
                if (i < len) {
                    var directive = Configuration$1.mainData.directives[i];
                    if (MarkdownEngine$1.hasNeighbourReadmeFile(directive.file)) {
                        logger.info(" ".concat(directive.name, " has a README file, include it"));
                        var readme = MarkdownEngine$1.readNeighbourReadmeFile(directive.file);
                        directive.readme = markedAcl(readme);
                    }
                    var page = {
                        path: 'directives',
                        name: directive.name,
                        id: directive.id,
                        navTabs: _this.getNavTabs(directive),
                        context: 'directive',
                        directive: directive,
                        depth: 1,
                        pageType: COMPODOC_DEFAULTS.PAGE_TYPES.INTERNAL
                    };
                    if (directive.isDuplicate) {
                        page.name += '-' + directive.duplicateId;
                    }
                    Configuration$1.addPage(page);
                    i++;
                    loop();
                }
                else {
                    resolve(true);
                }
            };
            loop();
        });
    };
    Application.prototype.prepareInjectables = function (someInjectables) {
        var _this = this;
        logger.info('Prepare injectables');
        Configuration$1.mainData.injectables = someInjectables
            ? someInjectables
            : DependenciesEngine$1.getInjectables();
        return new Promise(function (resolve, reject) {
            var i = 0;
            var len = Configuration$1.mainData.injectables.length;
            var loop = function () {
                if (i < len) {
                    var injec = Configuration$1.mainData.injectables[i];
                    if (MarkdownEngine$1.hasNeighbourReadmeFile(injec.file)) {
                        logger.info(" ".concat(injec.name, " has a README file, include it"));
                        var readme = MarkdownEngine$1.readNeighbourReadmeFile(injec.file);
                        injec.readme = markedAcl(readme);
                    }
                    var page = {
                        path: 'injectables',
                        name: injec.name,
                        id: injec.id,
                        navTabs: _this.getNavTabs(injec),
                        context: 'injectable',
                        injectable: injec,
                        depth: 1,
                        pageType: COMPODOC_DEFAULTS.PAGE_TYPES.INTERNAL
                    };
                    if (injec.isDuplicate) {
                        page.name += '-' + injec.duplicateId;
                    }
                    Configuration$1.addPage(page);
                    i++;
                    loop();
                }
                else {
                    resolve();
                }
            };
            loop();
        });
    };
    Application.prototype.prepareInterceptors = function (someInterceptors) {
        var _this = this;
        logger.info('Prepare interceptors');
        Configuration$1.mainData.interceptors = someInterceptors
            ? someInterceptors
            : DependenciesEngine$1.getInterceptors();
        return new Promise(function (resolve, reject) {
            var i = 0;
            var len = Configuration$1.mainData.interceptors.length;
            var loop = function () {
                if (i < len) {
                    var interceptor = Configuration$1.mainData.interceptors[i];
                    if (MarkdownEngine$1.hasNeighbourReadmeFile(interceptor.file)) {
                        logger.info(" ".concat(interceptor.name, " has a README file, include it"));
                        var readme = MarkdownEngine$1.readNeighbourReadmeFile(interceptor.file);
                        interceptor.readme = markedAcl(readme);
                    }
                    var page = {
                        path: 'interceptors',
                        name: interceptor.name,
                        id: interceptor.id,
                        navTabs: _this.getNavTabs(interceptor),
                        context: 'interceptor',
                        injectable: interceptor,
                        depth: 1,
                        pageType: COMPODOC_DEFAULTS.PAGE_TYPES.INTERNAL
                    };
                    if (interceptor.isDuplicate) {
                        page.name += '-' + interceptor.duplicateId;
                    }
                    Configuration$1.addPage(page);
                    i++;
                    loop();
                }
                else {
                    resolve();
                }
            };
            loop();
        });
    };
    Application.prototype.prepareGuards = function (someGuards) {
        var _this = this;
        logger.info('Prepare guards');
        Configuration$1.mainData.guards = someGuards ? someGuards : DependenciesEngine$1.getGuards();
        return new Promise(function (resolve, reject) {
            var i = 0;
            var len = Configuration$1.mainData.guards.length;
            var loop = function () {
                if (i < len) {
                    var guard = Configuration$1.mainData.guards[i];
                    if (MarkdownEngine$1.hasNeighbourReadmeFile(guard.file)) {
                        logger.info(" ".concat(guard.name, " has a README file, include it"));
                        var readme = MarkdownEngine$1.readNeighbourReadmeFile(guard.file);
                        guard.readme = markedAcl(readme);
                    }
                    var page = {
                        path: 'guards',
                        name: guard.name,
                        id: guard.id,
                        navTabs: _this.getNavTabs(guard),
                        context: 'guard',
                        injectable: guard,
                        depth: 1,
                        pageType: COMPODOC_DEFAULTS.PAGE_TYPES.INTERNAL
                    };
                    if (guard.isDuplicate) {
                        page.name += '-' + guard.duplicateId;
                    }
                    Configuration$1.addPage(page);
                    i++;
                    loop();
                }
                else {
                    resolve();
                }
            };
            loop();
        });
    };
    Application.prototype.prepareRoutes = function () {
        logger.info('Process routes');
        Configuration$1.mainData.routes = DependenciesEngine$1.getRoutes();
        return new Promise(function (resolve, reject) {
            Configuration$1.addPage({
                name: 'routes',
                id: 'routes',
                context: 'routes',
                depth: 0,
                pageType: COMPODOC_DEFAULTS.PAGE_TYPES.ROOT
            });
            if (Configuration$1.mainData.exportFormat === COMPODOC_DEFAULTS.exportFormat) {
                RouterParserUtil$1.generateRoutesIndex(Configuration$1.mainData.output, Configuration$1.mainData.routes).then(function () {
                    logger.info(' Routes index generated');
                    resolve();
                }, function (e) {
                    logger.error(e);
                    reject();
                });
            }
            else {
                resolve();
            }
        });
    };
    Application.prototype.prepareCoverage = function () {
        logger.info('Process documentation coverage report');
        return new Promise(function (resolve, reject) {
            /*
             * loop with components, directives, controllers, entities, classes, injectables, interfaces, pipes, guards, misc functions variables
             */
            var files = [];
            var totalProjectStatementDocumented = 0;
            var getStatus = function (percent) {
                var status;
                if (percent <= 25) {
                    status = 'low';
                }
                else if (percent > 25 && percent <= 50) {
                    status = 'medium';
                }
                else if (percent > 50 && percent <= 75) {
                    status = 'good';
                }
                else {
                    status = 'very-good';
                }
                return status;
            };
            var processComponentsAndDirectivesAndControllersAndEntities = function (list) {
                ___namespace.forEach(list, function (el) {
                    var element = Object.assign({}, el);
                    if (!element.propertiesClass) {
                        element.propertiesClass = [];
                    }
                    if (!element.methodsClass) {
                        element.methodsClass = [];
                    }
                    if (!element.hostBindings) {
                        element.hostBindings = [];
                    }
                    if (!element.hostListeners) {
                        element.hostListeners = [];
                    }
                    if (!element.inputsClass) {
                        element.inputsClass = [];
                    }
                    if (!element.outputsClass) {
                        element.outputsClass = [];
                    }
                    var cl = {
                        filePath: element.file,
                        type: element.type,
                        linktype: element.type,
                        name: element.name
                    };
                    var totalStatementDocumented = 0;
                    var totalStatements = element.propertiesClass.length +
                        element.methodsClass.length +
                        element.inputsClass.length +
                        element.hostBindings.length +
                        element.hostListeners.length +
                        element.outputsClass.length +
                        1; // +1 for element decorator comment
                    if (element.constructorObj) {
                        totalStatements += 1;
                        if (element.constructorObj &&
                            element.constructorObj.description &&
                            element.constructorObj.description !== '') {
                            totalStatementDocumented += 1;
                        }
                    }
                    if (element.description && element.description !== '') {
                        totalStatementDocumented += 1;
                    }
                    ___namespace.forEach(element.propertiesClass, function (property) {
                        if (property.modifierKind === tsMorph.SyntaxKind.PrivateKeyword) {
                            // Doesn't handle private for coverage
                            totalStatements -= 1;
                        }
                        if (property.description &&
                            property.description !== '' &&
                            property.modifierKind !== tsMorph.SyntaxKind.PrivateKeyword) {
                            totalStatementDocumented += 1;
                        }
                    });
                    ___namespace.forEach(element.methodsClass, function (method) {
                        if (method.modifierKind === tsMorph.SyntaxKind.PrivateKeyword) {
                            // Doesn't handle private for coverage
                            totalStatements -= 1;
                        }
                        if (method.description &&
                            method.description !== '' &&
                            method.modifierKind !== tsMorph.SyntaxKind.PrivateKeyword) {
                            totalStatementDocumented += 1;
                        }
                    });
                    ___namespace.forEach(element.hostBindings, function (property) {
                        if (property.modifierKind === tsMorph.SyntaxKind.PrivateKeyword) {
                            // Doesn't handle private for coverage
                            totalStatements -= 1;
                        }
                        if (property.description &&
                            property.description !== '' &&
                            property.modifierKind !== tsMorph.SyntaxKind.PrivateKeyword) {
                            totalStatementDocumented += 1;
                        }
                    });
                    ___namespace.forEach(element.hostListeners, function (method) {
                        if (method.modifierKind === tsMorph.SyntaxKind.PrivateKeyword) {
                            // Doesn't handle private for coverage
                            totalStatements -= 1;
                        }
                        if (method.description &&
                            method.description !== '' &&
                            method.modifierKind !== tsMorph.SyntaxKind.PrivateKeyword) {
                            totalStatementDocumented += 1;
                        }
                    });
                    ___namespace.forEach(element.inputsClass, function (input) {
                        if (input.modifierKind === tsMorph.SyntaxKind.PrivateKeyword) {
                            // Doesn't handle private for coverage
                            totalStatements -= 1;
                        }
                        if (input.description &&
                            input.description !== '' &&
                            input.modifierKind !== tsMorph.SyntaxKind.PrivateKeyword) {
                            totalStatementDocumented += 1;
                        }
                    });
                    ___namespace.forEach(element.outputsClass, function (output) {
                        if (output.modifierKind === tsMorph.SyntaxKind.PrivateKeyword) {
                            // Doesn't handle private for coverage
                            totalStatements -= 1;
                        }
                        if (output.description &&
                            output.description !== '' &&
                            output.modifierKind !== tsMorph.SyntaxKind.PrivateKeyword) {
                            totalStatementDocumented += 1;
                        }
                    });
                    cl.coveragePercent = Math.floor((totalStatementDocumented / totalStatements) * 100);
                    if (totalStatements === 0) {
                        cl.coveragePercent = 0;
                    }
                    cl.coverageCount = totalStatementDocumented + '/' + totalStatements;
                    cl.status = getStatus(cl.coveragePercent);
                    totalProjectStatementDocumented += cl.coveragePercent;
                    files.push(cl);
                });
            };
            var processCoveragePerFile = function () {
                logger.info('Process documentation coverage per file');
                logger.info('-------------------');
                var overFiles = files.filter(function (f) {
                    var overTest = f.coveragePercent >= Configuration$1.mainData.coverageMinimumPerFile;
                    if (overTest && !Configuration$1.mainData.coverageTestShowOnlyFailed) {
                        logger.info("".concat(f.coveragePercent, " % for file ").concat(f.filePath, " - ").concat(f.name, " - over minimum per file"));
                    }
                    return overTest;
                });
                var underFiles = files.filter(function (f) {
                    var underTest = f.coveragePercent < Configuration$1.mainData.coverageMinimumPerFile;
                    if (underTest) {
                        logger.error("".concat(f.coveragePercent, " % for file ").concat(f.filePath, " - ").concat(f.name, " - under minimum per file"));
                    }
                    return underTest;
                });
                logger.info('-------------------');
                return {
                    overFiles: overFiles,
                    underFiles: underFiles
                };
            };
            var processFunctionsAndVariables = function (id, type) {
                ___namespace.forEach(id, function (el) {
                    var cl = {
                        filePath: el.file,
                        type: type,
                        linktype: el.type,
                        linksubtype: el.subtype,
                        name: el.name
                    };
                    if (type === 'variable' || type === 'function' || type === 'type alias') {
                        cl.linktype = 'miscellaneous';
                    }
                    var totalStatementDocumented = 0;
                    var totalStatements = 1;
                    if (el.modifierKind === tsMorph.SyntaxKind.PrivateKeyword) {
                        // Doesn't handle private for coverage
                        totalStatements -= 1;
                    }
                    if (el.description &&
                        el.description !== '' &&
                        el.modifierKind !== tsMorph.SyntaxKind.PrivateKeyword) {
                        totalStatementDocumented += 1;
                    }
                    cl.coveragePercent = Math.floor((totalStatementDocumented / totalStatements) * 100);
                    cl.coverageCount = totalStatementDocumented + '/' + totalStatements;
                    cl.status = getStatus(cl.coveragePercent);
                    totalProjectStatementDocumented += cl.coveragePercent;
                    files.push(cl);
                });
            };
            var processClasses = function (list, type, linktype) {
                ___namespace.forEach(list, function (cl) {
                    var element = Object.assign({}, cl);
                    if (!element.properties) {
                        element.properties = [];
                    }
                    if (!element.methods) {
                        element.methods = [];
                    }
                    var cla = {
                        filePath: element.file,
                        type: type,
                        linktype: linktype,
                        name: element.name
                    };
                    var totalStatementDocumented = 0;
                    var totalStatements = element.properties.length + element.methods.length + 1; // +1 for element itself
                    if (element.constructorObj) {
                        totalStatements += 1;
                        if (element.constructorObj &&
                            element.constructorObj.description &&
                            element.constructorObj.description !== '') {
                            totalStatementDocumented += 1;
                        }
                    }
                    if (element.description && element.description !== '') {
                        totalStatementDocumented += 1;
                    }
                    ___namespace.forEach(element.properties, function (property) {
                        if (property.modifierKind === tsMorph.SyntaxKind.PrivateKeyword) {
                            // Doesn't handle private for coverage
                            totalStatements -= 1;
                        }
                        if (property.description &&
                            property.description !== '' &&
                            property.modifierKind !== tsMorph.SyntaxKind.PrivateKeyword) {
                            totalStatementDocumented += 1;
                        }
                    });
                    ___namespace.forEach(element.methods, function (method) {
                        if (method.modifierKind === tsMorph.SyntaxKind.PrivateKeyword) {
                            // Doesn't handle private for coverage
                            totalStatements -= 1;
                        }
                        if (method.description &&
                            method.description !== '' &&
                            method.modifierKind !== tsMorph.SyntaxKind.PrivateKeyword) {
                            totalStatementDocumented += 1;
                        }
                    });
                    cla.coveragePercent = Math.floor((totalStatementDocumented / totalStatements) * 100);
                    if (totalStatements === 0) {
                        cla.coveragePercent = 0;
                    }
                    cla.coverageCount = totalStatementDocumented + '/' + totalStatements;
                    cla.status = getStatus(cla.coveragePercent);
                    totalProjectStatementDocumented += cla.coveragePercent;
                    files.push(cla);
                });
            };
            processComponentsAndDirectivesAndControllersAndEntities(Configuration$1.mainData.components);
            processComponentsAndDirectivesAndControllersAndEntities(Configuration$1.mainData.directives);
            processComponentsAndDirectivesAndControllersAndEntities(Configuration$1.mainData.controllers);
            processComponentsAndDirectivesAndControllersAndEntities(Configuration$1.mainData.entities);
            processClasses(Configuration$1.mainData.classes, 'class', 'classe');
            processClasses(Configuration$1.mainData.injectables, 'injectable', 'injectable');
            processClasses(Configuration$1.mainData.interfaces, 'interface', 'interface');
            processClasses(Configuration$1.mainData.guards, 'guard', 'guard');
            processClasses(Configuration$1.mainData.interceptors, 'interceptor', 'interceptor');
            ___namespace.forEach(Configuration$1.mainData.pipes, function (pipe) {
                var cl = {
                    filePath: pipe.file,
                    type: pipe.type,
                    linktype: pipe.type,
                    name: pipe.name
                };
                var totalStatementDocumented = 0;
                var totalStatements = 1;
                if (pipe.description && pipe.description !== '') {
                    totalStatementDocumented += 1;
                }
                cl.coveragePercent = Math.floor((totalStatementDocumented / totalStatements) * 100);
                cl.coverageCount = totalStatementDocumented + '/' + totalStatements;
                cl.status = getStatus(cl.coveragePercent);
                totalProjectStatementDocumented += cl.coveragePercent;
                files.push(cl);
            });
            processFunctionsAndVariables(Configuration$1.mainData.miscellaneous.functions, 'function');
            processFunctionsAndVariables(Configuration$1.mainData.miscellaneous.variables, 'variable');
            processFunctionsAndVariables(Configuration$1.mainData.miscellaneous.typealiases, 'type alias');
            files = ___namespace.sortBy(files, ['filePath']);
            var coverageData = {
                count: files.length > 0
                    ? Math.floor(totalProjectStatementDocumented / files.length)
                    : 0,
                status: '',
                files: files
            };
            coverageData.status = getStatus(coverageData.count);
            Configuration$1.addPage({
                name: 'coverage',
                id: 'coverage',
                context: 'coverage',
                files: files,
                data: coverageData,
                depth: 0,
                pageType: COMPODOC_DEFAULTS.PAGE_TYPES.ROOT
            });
            coverageData.files = files;
            Configuration$1.mainData.coverageData = coverageData;
            if (Configuration$1.mainData.exportFormat === COMPODOC_DEFAULTS.exportFormat) {
                HtmlEngine$1.generateCoverageBadge(Configuration$1.mainData.output, 'documentation', coverageData);
            }
            files = ___namespace.sortBy(files, ['coveragePercent']);
            var coverageTestPerFileResults;
            if (Configuration$1.mainData.coverageTest &&
                !Configuration$1.mainData.coverageTestPerFile) {
                // Global coverage test and not per file
                if (coverageData.count >= Configuration$1.mainData.coverageTestThreshold) {
                    logger.info("Documentation coverage (".concat(coverageData.count, "%) is over threshold (").concat(Configuration$1.mainData.coverageTestThreshold, "%)"));
                    generationPromiseResolve(true);
                    process.exit(0);
                }
                else {
                    var message = "Documentation coverage (".concat(coverageData.count, "%) is not over threshold (").concat(Configuration$1.mainData.coverageTestThreshold, "%)");
                    generationPromiseReject();
                    if (Configuration$1.mainData.coverageTestThresholdFail) {
                        logger.error(message);
                        process.exit(1);
                    }
                    else {
                        logger.warn(message);
                        process.exit(0);
                    }
                }
            }
            else if (!Configuration$1.mainData.coverageTest &&
                Configuration$1.mainData.coverageTestPerFile) {
                coverageTestPerFileResults = processCoveragePerFile();
                // Per file coverage test and not global
                if (coverageTestPerFileResults.underFiles.length > 0) {
                    var message = "Documentation coverage per file is not over threshold (".concat(Configuration$1.mainData.coverageMinimumPerFile, "%)");
                    generationPromiseReject();
                    if (Configuration$1.mainData.coverageTestThresholdFail) {
                        logger.error(message);
                        process.exit(1);
                    }
                    else {
                        logger.warn(message);
                        process.exit(0);
                    }
                }
                else {
                    logger.info("Documentation coverage per file is over threshold (".concat(Configuration$1.mainData.coverageMinimumPerFile, "%)"));
                    generationPromiseResolve(true);
                    process.exit(0);
                }
            }
            else if (Configuration$1.mainData.coverageTest &&
                Configuration$1.mainData.coverageTestPerFile) {
                // Per file coverage test and global
                coverageTestPerFileResults = processCoveragePerFile();
                if (coverageData.count >= Configuration$1.mainData.coverageTestThreshold &&
                    coverageTestPerFileResults.underFiles.length === 0) {
                    logger.info("Documentation coverage (".concat(coverageData.count, "%) is over threshold (").concat(Configuration$1.mainData.coverageTestThreshold, "%)"));
                    logger.info("Documentation coverage per file is over threshold (".concat(Configuration$1.mainData.coverageMinimumPerFile, "%)"));
                    generationPromiseResolve(true);
                    process.exit(0);
                }
                else if (coverageData.count >= Configuration$1.mainData.coverageTestThreshold &&
                    coverageTestPerFileResults.underFiles.length > 0) {
                    logger.info("Documentation coverage (".concat(coverageData.count, "%) is over threshold (").concat(Configuration$1.mainData.coverageTestThreshold, "%)"));
                    var message = "Documentation coverage per file is not over threshold (".concat(Configuration$1.mainData.coverageMinimumPerFile, "%)");
                    generationPromiseReject();
                    if (Configuration$1.mainData.coverageTestThresholdFail) {
                        logger.error(message);
                        process.exit(1);
                    }
                    else {
                        logger.warn(message);
                        process.exit(0);
                    }
                }
                else if (coverageData.count < Configuration$1.mainData.coverageTestThreshold &&
                    coverageTestPerFileResults.underFiles.length > 0) {
                    var messageGlobal = "Documentation coverage (".concat(coverageData.count, "%) is not over threshold (").concat(Configuration$1.mainData.coverageTestThreshold, "%)"), messagePerFile = "Documentation coverage per file is not over threshold (".concat(Configuration$1.mainData.coverageMinimumPerFile, "%)");
                    generationPromiseReject();
                    if (Configuration$1.mainData.coverageTestThresholdFail) {
                        logger.error(messageGlobal);
                        logger.error(messagePerFile);
                        process.exit(1);
                    }
                    else {
                        logger.warn(messageGlobal);
                        logger.warn(messagePerFile);
                        process.exit(0);
                    }
                }
                else {
                    var message = "Documentation coverage (".concat(coverageData.count, "%) is not over threshold (").concat(Configuration$1.mainData.coverageTestThreshold, "%)"), messagePerFile = "Documentation coverage per file is over threshold (".concat(Configuration$1.mainData.coverageMinimumPerFile, "%)");
                    generationPromiseReject();
                    if (Configuration$1.mainData.coverageTestThresholdFail) {
                        logger.error(message);
                        logger.info(messagePerFile);
                        process.exit(1);
                    }
                    else {
                        logger.warn(message);
                        logger.info(messagePerFile);
                        process.exit(0);
                    }
                }
            }
            else {
                resolve(true);
            }
        });
    };
    Application.prototype.prepareUnitTestCoverage = function () {
        logger.info('Process unit test coverage report');
        return new Promise(function (resolve, reject) {
            var covDat, covFileNames;
            var coverageData = Configuration$1.mainData.coverageData;
            if (!coverageData.files) {
                logger.warn('Missing documentation coverage data');
            }
            else {
                covDat = {};
                covFileNames = ___namespace.map(coverageData.files, function (el) {
                    var fileName = path__namespace.normalize(el.filePath);
                    covDat[fileName] = {
                        type: el.type,
                        linktype: el.linktype,
                        linksubtype: el.linksubtype,
                        name: el.name
                    };
                    return fileName;
                });
            }
            // read coverage summary file and data
            var unitTestSummary = {};
            var fileDat = FileEngine$1.getSync(Configuration$1.mainData.unitTestCoverage);
            if (fileDat) {
                unitTestSummary = JSON.parse(fileDat);
            }
            else {
                return Promise.reject('Error reading unit test coverage file');
            }
            var getCovStatus = function (percent, totalLines) {
                var status;
                if (totalLines === 0) {
                    status = 'uncovered';
                }
                else if (percent <= 25) {
                    status = 'low';
                }
                else if (percent > 25 && percent <= 50) {
                    status = 'medium';
                }
                else if (percent > 50 && percent <= 75) {
                    status = 'good';
                }
                else {
                    status = 'very-good';
                }
                return status;
            };
            var getCoverageData = function (data, fileName) {
                var out = {};
                if (fileName !== 'total') {
                    if (covDat === undefined) {
                        // need a name to include in output but this isn't visible
                        out = { name: fileName, filePath: fileName };
                    }
                    else {
                        var findMatch = ___namespace.filter(covFileNames, function (el) {
                            var normalizedFilename = path__namespace.normalize(fileName).replace(/\\/g, '/');
                            return el.includes(fileName) || normalizedFilename.includes(el);
                        });
                        if (findMatch.length > 0) {
                            out = ___namespace.clone(covDat[findMatch[0]]);
                            out['filePath'] = fileName;
                        }
                    }
                }
                var keysToGet = ['statements', 'branches', 'functions', 'lines'];
                ___namespace.forEach(keysToGet, function (key) {
                    if (data[key]) {
                        var t = data[key];
                        out[key] = {
                            coveragePercent: Math.round(t.pct),
                            coverageCount: '' + t.covered + '/' + t.total,
                            status: getCovStatus(t.pct, t.total)
                        };
                    }
                });
                return out;
            };
            var unitTestData = {};
            var files = [];
            for (var file in unitTestSummary) {
                var dat = getCoverageData(unitTestSummary[file], file);
                if (file === 'total') {
                    unitTestData['total'] = dat;
                }
                else {
                    files.push(dat);
                }
            }
            unitTestData['files'] = files;
            unitTestData['idColumn'] = covDat !== undefined; // should we include the id column
            Configuration$1.mainData.unitTestData = unitTestData;
            Configuration$1.addPage({
                name: 'unit-test',
                id: 'unit-test',
                context: 'unit-test',
                files: files,
                data: unitTestData,
                depth: 0,
                pageType: COMPODOC_DEFAULTS.PAGE_TYPES.ROOT
            });
            if (Configuration$1.mainData.exportFormat === COMPODOC_DEFAULTS.exportFormat) {
                var keysToGet = ['statements', 'branches', 'functions', 'lines'];
                ___namespace.forEach(keysToGet, function (key) {
                    if (unitTestData['total'][key]) {
                        HtmlEngine$1.generateCoverageBadge(Configuration$1.mainData.output, key, {
                            count: unitTestData['total'][key]['coveragePercent'],
                            status: unitTestData['total'][key]['status']
                        });
                    }
                });
            }
            resolve(true);
        });
    };
    Application.prototype.processPage = function (page) {
        logger.info('Process page', page.name);
        var htmlData = HtmlEngine$1.render(Configuration$1.mainData, page);
        var finalPath = Configuration$1.mainData.output;
        if (Configuration$1.mainData.output.lastIndexOf('/') === -1) {
            finalPath += '/';
        }
        if (page.path) {
            finalPath += page.path + '/';
        }
        if (page.filename) {
            finalPath += page.filename + '.html';
        }
        else {
            finalPath += page.name + '.html';
        }
        if (!Configuration$1.mainData.disableSearch) {
            SearchEngine$1.indexPage({
                infos: page,
                rawData: htmlData,
                url: finalPath
            });
        }
        FileEngine$1.writeSync(finalPath, htmlData);
        return Promise.resolve(true);
    };
    Application.prototype.processPages = function () {
        var _this = this;
        var pages = ___namespace.sortBy(Configuration$1.pages, ['name']);
        logger.info('Process pages');
        Promise.all(pages.map(function (page) { return _this.processPage(page); }))
            .then(function () {
            var callbacksAfterGenerateSearchIndexJson = function () {
                if (Configuration$1.mainData.additionalPages.length > 0) {
                    _this.processAdditionalPages();
                }
                else {
                    if (Configuration$1.mainData.assetsFolder !== '') {
                        _this.processAssetsFolder();
                    }
                    _this.processResources();
                }
            };
            if (!Configuration$1.mainData.disableSearch) {
                SearchEngine$1.generateSearchIndexJson(Configuration$1.mainData.output).then(function () {
                    callbacksAfterGenerateSearchIndexJson();
                }, function (e) {
                    logger.error(e);
                });
            }
            else {
                callbacksAfterGenerateSearchIndexJson();
            }
        })
            .then(function () {
            return _this.processMenu(Configuration$1.mainData);
        })
            .catch(function (e) {
            logger.error(e);
        });
    };
    Application.prototype.transpileMenuWCToES5 = function (es6Code) {
        return babel.transformAsync(es6Code, {
            cwd: __dirname,
            filename: 'menu-wc_es5.js',
            presets: [
                [
                    '@babel/preset-env',
                    {
                        targets: {
                            ie: '11'
                        }
                    }
                ]
            ],
            plugins: [
                [
                    '@babel/plugin-transform-private-methods',
                    {
                        loose: false
                    }
                ]
            ]
        });
    };
    Application.prototype.processMenu = function (mainData) {
        var _this = this;
        logger.info('Process menu...');
        return new Promise(function (resolveProcessMenu, rejectProcessMenu) {
            var output = mainData.output.slice();
            var outputLastCharacter = output.lastIndexOf('/');
            if (outputLastCharacter !== -1) {
                output = output.slice(0, -1);
            }
            var finalPathES6 = "".concat(output, "/js/menu-wc.js");
            var finalPathES5 = "".concat(output, "/js/menu-wc_es5.js");
            HtmlEngine$1.renderMenu(Configuration$1.mainData.templates, mainData)
                .then(function (htmlData) {
                FileEngine$1.write(finalPathES6, htmlData)
                    .then(function () {
                    _this.transpileMenuWCToES5(htmlData)
                        .then(function (es5Data) {
                        FileEngine$1.write(finalPathES5, es5Data.code)
                            .then(function () {
                            resolveProcessMenu();
                        })
                            .catch(function (err) {
                            logger.error('Error during ' + finalPathES5 + ' page generation');
                            logger.error(err);
                            return rejectProcessMenu('');
                        });
                    })
                        .catch(function (err) {
                        logger.error('Error during ' + finalPathES5 + ' page generation');
                        logger.error(err);
                        return rejectProcessMenu('');
                    });
                })
                    .catch(function (err) {
                    logger.error('Error during ' + finalPathES6 + ' page generation');
                    logger.error(err);
                    return rejectProcessMenu('');
                });
            })
                .catch(function (err) {
                logger.error('Error during ' + finalPathES6 + ' page generation');
                logger.error(err);
                return rejectProcessMenu('');
            });
        });
    };
    Application.prototype.processAdditionalPages = function () {
        var _this = this;
        logger.info('Process additional pages');
        var pages = Configuration$1.mainData.additionalPages;
        Promise.all(pages.map(function (page) {
            if (page.children.length > 0) {
                return Promise.all(__spreadArray([
                    _this.processPage(page)
                ], __read(page.children.map(function (childPage) { return _this.processPage(childPage); })), false));
            }
            else {
                return _this.processPage(page);
            }
        }))
            .then(function () {
            SearchEngine$1.generateSearchIndexJson(Configuration$1.mainData.output).then(function () {
                if (Configuration$1.mainData.assetsFolder !== '') {
                    _this.processAssetsFolder();
                }
                _this.processResources();
            });
        })
            .catch(function (e) {
            logger.error(e);
            return Promise.reject(e);
        });
    };
    Application.prototype.processAssetsFolder = function () {
        logger.info('Copy assets folder');
        if (!FileEngine$1.existsSync(Configuration$1.mainData.assetsFolder)) {
            logger.error("Provided assets folder ".concat(Configuration$1.mainData.assetsFolder, " did not exist"));
        }
        else {
            var finalOutput = Configuration$1.mainData.output;
            var testOutputDir = Configuration$1.mainData.output.match(cwd$1);
            if (testOutputDir && testOutputDir.length > 0) {
                finalOutput = Configuration$1.mainData.output.replace(cwd$1 + path__namespace.sep, '');
            }
            var destination = path__namespace.join(finalOutput, path__namespace.basename(Configuration$1.mainData.assetsFolder));
            fs__namespace.copy(path__namespace.resolve(Configuration$1.mainData.assetsFolder), path__namespace.resolve(destination), function (err) {
                if (err) {
                    logger.error('Error during resources copy ', err);
                }
            });
        }
    };
    Application.prototype.processResources = function () {
        var _this = this;
        logger.info('Copy main resources');
        var onComplete = function () {
            logger.info('Documentation generated in ' +
                Configuration$1.mainData.output +
                ' in ' +
                _this.getElapsedTime() +
                ' seconds using ' +
                Configuration$1.mainData.theme +
                ' theme');
            if (Configuration$1.mainData.serve) {
                logger.info("Serving documentation from ".concat(Configuration$1.mainData.output, " at http://").concat(Configuration$1.mainData.hostname, ":").concat(Configuration$1.mainData.port));
                _this.runWebServer(Configuration$1.mainData.output);
            }
            else {
                generationPromiseResolve(true);
                _this.endCallback();
            }
        };
        var finalOutput = Configuration$1.mainData.output;
        var testOutputDir = Configuration$1.mainData.output.match(cwd$1);
        if (testOutputDir && testOutputDir.length > 0) {
            finalOutput = Configuration$1.mainData.output.replace(cwd$1 + path__namespace.sep, '');
        }
        fs__namespace.copy(path__namespace.resolve(__dirname + '/../src/resources/'), path__namespace.resolve(finalOutput), function (errorCopy) {
            if (errorCopy) {
                logger.error('Error during resources copy ', errorCopy);
            }
            else {
                var extThemePromise = new Promise(function (extThemeResolve, extThemeReject) {
                    if (Configuration$1.mainData.extTheme) {
                        fs__namespace.copy(path__namespace.resolve(cwd$1 + path__namespace.sep + Configuration$1.mainData.extTheme), path__namespace.resolve(finalOutput + '/styles/'), function (errorCopyTheme) {
                            if (errorCopyTheme) {
                                logger.error('Error during external styling theme copy ', errorCopyTheme);
                                extThemeReject();
                            }
                            else {
                                logger.info('External styling theme copy succeeded');
                                extThemeResolve(true);
                            }
                        });
                    }
                    else {
                        extThemeResolve(true);
                    }
                });
                var customFaviconPromise = new Promise(function (customFaviconResolve, customFaviconReject) {
                    if (Configuration$1.mainData.customFavicon !== '') {
                        logger.info("Custom favicon supplied");
                        fs__namespace.copy(path__namespace.resolve(cwd$1 + path__namespace.sep + Configuration$1.mainData.customFavicon), path__namespace.resolve(finalOutput + '/images/favicon.ico'), function (errorCopyFavicon) {
                            // tslint:disable-line
                            if (errorCopyFavicon) {
                                logger.error('Error during resources copy of favicon', errorCopyFavicon);
                                customFaviconReject();
                            }
                            else {
                                logger.info('External custom favicon copy succeeded');
                                customFaviconResolve(true);
                            }
                        });
                    }
                    else {
                        customFaviconResolve(true);
                    }
                });
                var customLogoPromise = new Promise(function (customLogoResolve, customLogoReject) {
                    if (Configuration$1.mainData.customLogo !== '') {
                        logger.info("Custom logo supplied");
                        fs__namespace.copy(path__namespace.resolve(cwd$1 + path__namespace.sep + Configuration$1.mainData.customLogo), path__namespace.resolve(finalOutput +
                            '/images/' +
                            Configuration$1.mainData.customLogo.split('/').pop()), function (errorCopyLogo) {
                            // tslint:disable-line
                            if (errorCopyLogo) {
                                logger.error('Error during resources copy of logo', errorCopyLogo);
                                customLogoReject();
                            }
                            else {
                                logger.info('External custom logo copy succeeded');
                                customLogoResolve(true);
                            }
                        });
                    }
                    else {
                        customLogoResolve(true);
                    }
                });
                Promise.all([extThemePromise, customFaviconPromise, customLogoPromise]).then(function () {
                    onComplete();
                });
            }
        });
    };
    /**
     * Calculates the elapsed time since the program was started.
     *
     * @returns {number}
     */
    Application.prototype.getElapsedTime = function () {
        return (new Date().valueOf() - startTime.valueOf()) / 1000;
    };
    Application.prototype.processGraphs = function () {
        var _this = this;
        if (Configuration$1.mainData.disableGraph) {
            logger.info('Graph generation disabled');
            this.processPages();
        }
        else {
            logger.info('Process main graph');
            var modules_1 = Configuration$1.mainData.modules;
            var i_1 = 0;
            var len_1 = modules_1.length;
            var loop_1 = function () {
                if (i_1 <= len_1 - 1) {
                    logger.info('Process module graph ', modules_1[i_1].name);
                    var finalPath_2 = Configuration$1.mainData.output;
                    if (Configuration$1.mainData.output.lastIndexOf('/') === -1) {
                        finalPath_2 += '/';
                    }
                    finalPath_2 += 'modules/' + modules_1[i_1].name;
                    var _rawModule = DependenciesEngine$1.getRawModule(modules_1[i_1].name);
                    if (_rawModule.declarations.length > 0 ||
                        _rawModule.bootstrap.length > 0 ||
                        _rawModule.imports.length > 0 ||
                        _rawModule.exports.length > 0 ||
                        _rawModule.providers.length > 0) {
                        NgdEngine$1.renderGraph(modules_1[i_1].file, finalPath_2, 'f', modules_1[i_1].name).then(function () {
                            NgdEngine$1.readGraph(path__namespace.resolve(finalPath_2 + path__namespace.sep + 'dependencies.svg'), modules_1[i_1].name).then(function (data) {
                                modules_1[i_1].graph = data;
                                i_1++;
                                loop_1();
                            }, function (err) {
                                logger.error('Error during graph read: ', err);
                            });
                        }, function (errorMessage) {
                            logger.error(errorMessage);
                        });
                    }
                    else {
                        i_1++;
                        loop_1();
                    }
                }
                else {
                    _this.processPages();
                }
            };
            var finalMainGraphPath_1 = Configuration$1.mainData.output;
            if (finalMainGraphPath_1.lastIndexOf('/') === -1) {
                finalMainGraphPath_1 += '/';
            }
            finalMainGraphPath_1 += 'graph';
            NgdEngine$1.init(path__namespace.resolve(finalMainGraphPath_1));
            NgdEngine$1.renderGraph(Configuration$1.mainData.tsconfig, path__namespace.resolve(finalMainGraphPath_1), 'p').then(function () {
                NgdEngine$1.readGraph(path__namespace.resolve(finalMainGraphPath_1 + path__namespace.sep + 'dependencies.svg'), 'Main graph').then(function (data) {
                    Configuration$1.mainData.mainGraph = data;
                    loop_1();
                }, function (err) {
                    logger.error('Error during main graph reading : ', err);
                    Configuration$1.mainData.disableMainGraph = true;
                    loop_1();
                });
            }, function (err) {
                logger.error('Ooops error during main graph generation, moving on next part with main graph disabled : ', err);
                Configuration$1.mainData.disableMainGraph = true;
                loop_1();
            });
        }
    };
    Application.prototype.runWebServer = function (folder) {
        if (!this.isWatching) {
            var liveServerConfiguration = {
                root: folder,
                open: Configuration$1.mainData.open,
                quiet: true,
                logLevel: 0,
                wait: 1000,
                port: Configuration$1.mainData.port
            };
            if (Configuration$1.mainData.host !== '') {
                liveServerConfiguration.host = Configuration$1.mainData.host;
            }
            LiveServer__namespace.start(liveServerConfiguration);
        }
        if (Configuration$1.mainData.watch && !this.isWatching) {
            if (typeof this.files === 'undefined') {
                logger.error('No sources files available, please use -p flag');
                generationPromiseReject();
                process.exit(1);
            }
            else {
                this.runWatch();
            }
        }
        else if (Configuration$1.mainData.watch && this.isWatching) {
            var srcFolder = findMainSourceFolder(this.files);
            logger.info("Already watching sources in ".concat(srcFolder, " folder"));
        }
    };
    Application.prototype.runWatch = function () {
        var _this = this;
        var sources = [findMainSourceFolder(this.files)];
        var watcherReady = false;
        this.isWatching = true;
        logger.info("Watching sources in ".concat(findMainSourceFolder(this.files), " folder"));
        if (MarkdownEngine$1.hasRootMarkdowns()) {
            sources = sources.concat(MarkdownEngine$1.listRootMarkdowns());
        }
        if (Configuration$1.mainData.includes !== '') {
            sources = sources.concat(Configuration$1.mainData.includes);
        }
        // Check all elements of sources list exist
        sources = cleanSourcesForWatch(sources);
        var watcher = chokidar.watch(sources, {
            awaitWriteFinish: true,
            ignoreInitial: true,
            ignored: /(spec|\.d)\.ts/
        });
        var timerAddAndRemoveRef;
        var timerChangeRef;
        var runnerAddAndRemove = function () {
            startTime = new Date();
            _this.generate();
        };
        var waiterAddAndRemove = function () {
            clearTimeout(timerAddAndRemoveRef);
            timerAddAndRemoveRef = setTimeout(runnerAddAndRemove, 1000);
        };
        var runnerChange = function () {
            startTime = new Date();
            _this.setUpdatedFiles(_this.watchChangedFiles);
            if (_this.hasWatchedFilesTSFiles()) {
                _this.getMicroDependenciesData();
            }
            else if (_this.hasWatchedFilesRootMarkdownFiles()) {
                _this.rebuildRootMarkdowns();
            }
            else {
                _this.rebuildExternalDocumentation();
            }
        };
        var waiterChange = function () {
            clearTimeout(timerChangeRef);
            timerChangeRef = setTimeout(runnerChange, 1000);
        };
        watcher.on('ready', function () {
            if (!watcherReady) {
                watcherReady = true;
                watcher
                    .on('add', function (file) {
                    logger.debug("File ".concat(file, " has been added"));
                    // Test extension, if ts
                    // rescan everything
                    if (path__namespace.extname(file) === '.ts') {
                        waiterAddAndRemove();
                    }
                })
                    .on('change', function (file) {
                    logger.debug("File ".concat(file, " has been changed"));
                    // Test extension, if ts
                    // rescan only file
                    if (path__namespace.extname(file) === '.ts' ||
                        path__namespace.extname(file) === '.md' ||
                        path__namespace.extname(file) === '.json') {
                        _this.watchChangedFiles.push(path__namespace.join(cwd$1 + path__namespace.sep + file));
                        waiterChange();
                    }
                })
                    .on('unlink', function (file) {
                    logger.debug("File ".concat(file, " has been removed"));
                    // Test extension, if ts
                    // rescan everything
                    if (path__namespace.extname(file) === '.ts') {
                        waiterAddAndRemove();
                    }
                });
            }
        });
    };
    Object.defineProperty(Application.prototype, "application", {
        /**
         * Return the application / root component instance.
         */
        get: function () {
            return this;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Application.prototype, "isCLI", {
        get: function () {
            return false;
        },
        enumerable: false,
        configurable: true
    });
    return Application;
}());

var fg = require('fast-glob');
var os = require('os');
var osName = require('os-name');
var pkg = require('../package.json');
var program = require('commander').program;
var cosmiconfigModuleName = 'compodoc';
var scannedFiles = [];
var excludeFiles = EXCLUDE_PATTERNS;
var includeFiles = [];
var cwd = process.cwd();
process.setMaxListeners(0);
var CliApplication = /** @class */ (function (_super) {
    __extends(CliApplication, _super);
    function CliApplication() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Run compodoc from the command line.
     */
    CliApplication.prototype.start = function () {
        var _this = this;
        function list(val) {
            return val.split(',');
        }
        program
            .version(pkg.version)
            .usage('<src> [options]')
            .option('-c, --config [config]', 'A configuration file : .compodocrc, .compodocrc.json, .compodocrc.yaml or compodoc property in package.json')
            .option('-p, --tsconfig [config]', 'A tsconfig.json file')
            .option('-d, --output [folder]', 'Where to store the generated documentation', COMPODOC_DEFAULTS.folder)
            .option('-y, --extTheme [file]', 'External styling theme file')
            .option('-n, --name [name]', 'Title documentation', COMPODOC_DEFAULTS.title)
            .option('-a, --assetsFolder [folder]', 'External assets folder to copy in generated documentation folder')
            .option('-o, --open [value]', 'Open the generated documentation')
            .option('-t, --silent', "In silent mode, log messages aren't logged in the console", false)
            .option('-s, --serve', 'Serve generated documentation (default http://localhost:8080/)', false)
            .option('--host [host]', 'Change default host address')
            .option('-r, --port [port]', 'Change default serving port', COMPODOC_DEFAULTS.port)
            .option('-w, --watch', 'Watch source files after serve and force documentation rebuild', false)
            .option('-e, --exportFormat [format]', 'Export in specified format (json, html)', COMPODOC_DEFAULTS.exportFormat)
            .option('--files [files]', 'Files provided by external tool, used for coverage test')
            .option('--language [language]', 'Language used for the generated documentation (bg-BG, de-DE, en-US, es-ES, fr-FR, hu-HU, it-IT, ja-JP, ka-GE, ko-KR, nl-NL, pl-PL, pt-BR, ru-RU, sk-SK, zh-CN, zh-TW)', COMPODOC_DEFAULTS.language)
            .option('--theme [theme]', "Choose one of available themes, default is 'gitbook' (laravel, original, material, postmark, readthedocs, stripe, vagrant)")
            .option('--hideGenerator', 'Do not print the Compodoc link at the bottom of the page', false)
            .option('--hideDarkModeToggle', 'Do not show dark mode toggle button at the top right position of the page', false)
            .option('--toggleMenuItems <items>', "Close by default items in the menu values : ['all'] or one of these ['modules','components','directives','controllers','entities','classes','injectables','guards','interfaces','interceptors','pipes','miscellaneous','additionalPages']", list, COMPODOC_DEFAULTS.toggleMenuItems)
            .option('--navTabConfig <tab configs>', "List navigation tab objects in the desired order with two string properties (\"id\" and \"label\"). Double-quotes must be escaped with '\\'. Available tab IDs are \"info\", \"readme\", \"source\", \"templateData\", \"styleData\", \"tree\", and \"example\". Note: Certain tabs will only be shown if applicable to a given dependency", list, JSON.stringify(COMPODOC_DEFAULTS.navTabConfig))
            .option('--templates [folder]', 'Path to directory of Handlebars templates to override built-in templates')
            .option('--includes [path]', 'Path of external markdown files to include')
            .option('--includesName [name]', 'Name of item menu of externals markdown files', COMPODOC_DEFAULTS.additionalEntryName)
            .option('--coverageTest [threshold]', 'Test command of documentation coverage with a threshold (default 70)')
            .option('--coverageMinimumPerFile [minimum]', 'Test command of documentation coverage per file with a minimum (default 0)')
            .option('--coverageTestThresholdFail [true|false]', 'Test command of documentation coverage (global or per file) will fail with error or just warn user (true: error, false: warn)', COMPODOC_DEFAULTS.coverageTestThresholdFail)
            .option('--coverageTestShowOnlyFailed', 'Display only failed files for a coverage test')
            .option('--unitTestCoverage [json-summary]', 'To include unit test coverage, specify istanbul JSON coverage summary file')
            .option('--disableSourceCode', 'Do not add source code tab and links to source code', false)
            .option('--disableDomTree', 'Do not add dom tree tab', false)
            .option('--disableTemplateTab', 'Do not add template tab', false)
            .option('--disableStyleTab', 'Do not add style tab', false)
            .option('--disableGraph', 'Do not add the dependency graph', false)
            .option('--disableCoverage', 'Do not add the documentation coverage report', false)
            .option('--disablePrivate', 'Do not show private in generated documentation', false)
            .option('--disableProtected', 'Do not show protected in generated documentation', false)
            .option('--disableInternal', 'Do not show @internal in generated documentation', false)
            .option('--disableLifeCycleHooks', 'Do not show Angular lifecycle hooks in generated documentation', false)
            .option('--disableConstructors', 'Do not show constructors in generated documentation', false)
            .option('--disableRoutesGraph', 'Do not add the routes graph', COMPODOC_DEFAULTS.disableRoutesGraph)
            .option('--disableSearch', 'Do not add the search input', false)
            .option('--disableDependencies', 'Do not add the dependencies list', COMPODOC_DEFAULTS.disableDependencies)
            .option('--disableProperties', 'Do not add the properties list', COMPODOC_DEFAULTS.disableProperties)
            .option('--minimal', 'Minimal mode with only documentation. No search, no graph, no coverage.', false)
            .option('--customFavicon [path]', 'Use a custom favicon')
            .option('--customLogo [path]', 'Use a custom logo')
            .option('--gaID [id]', 'Google Analytics tracking ID')
            .option('--gaSite [site]', 'Google Analytics site name', COMPODOC_DEFAULTS.gaSite)
            .option('--maxSearchResults [maxSearchResults]', 'Max search results on the results page. To show all results, set to 0', COMPODOC_DEFAULTS.maxSearchResults)
            .parse(process.argv);
        var outputHelp = function () {
            program.outputHelp();
            process.exit(1);
        };
        var configExplorer = cosmiconfig.cosmiconfigSync(cosmiconfigModuleName);
        var configExplorerResult;
        var configFile = {};
        var programOptions = program.opts();
        if (programOptions.config) {
            var configFilePath = programOptions.config;
            var testConfigFilePath = configFilePath.match(process.cwd());
            if (testConfigFilePath && testConfigFilePath.length > 0) {
                configFilePath = configFilePath.replace(process.cwd() + path__namespace.sep, '');
            }
            configExplorerResult = configExplorer.load(path__namespace.resolve(configFilePath));
        }
        else {
            configExplorerResult = configExplorer.search();
        }
        if (configExplorerResult) {
            if (typeof configExplorerResult.config !== 'undefined') {
                configFile = configExplorerResult.config;
            }
        }
        if (configFile.output) {
            Configuration$1.mainData.output = configFile.output;
        }
        if (programOptions.output && programOptions.output !== COMPODOC_DEFAULTS.folder) {
            Configuration$1.mainData.output = programOptions.output;
        }
        if (configFile.extTheme) {
            Configuration$1.mainData.extTheme = configFile.extTheme;
        }
        if (programOptions.extTheme) {
            Configuration$1.mainData.extTheme = programOptions.extTheme;
        }
        if (configFile.language) {
            Configuration$1.mainData.language = configFile.language;
        }
        if (programOptions.language) {
            Configuration$1.mainData.language = programOptions.language;
        }
        if (configFile.theme) {
            Configuration$1.mainData.theme = configFile.theme;
        }
        if (programOptions.theme) {
            Configuration$1.mainData.theme = programOptions.theme;
        }
        if (configFile.name) {
            Configuration$1.mainData.documentationMainName = configFile.name;
        }
        if (programOptions.name && programOptions.name !== COMPODOC_DEFAULTS.title) {
            Configuration$1.mainData.documentationMainName = programOptions.name;
        }
        if (configFile.assetsFolder) {
            Configuration$1.mainData.assetsFolder = configFile.assetsFolder;
        }
        if (programOptions.assetsFolder) {
            Configuration$1.mainData.assetsFolder = programOptions.assetsFolder;
        }
        if (configFile.open) {
            Configuration$1.mainData.open = configFile.open;
        }
        if (programOptions.open) {
            Configuration$1.mainData.open = programOptions.open;
        }
        if (configFile.toggleMenuItems) {
            Configuration$1.mainData.toggleMenuItems = configFile.toggleMenuItems;
        }
        if (programOptions.toggleMenuItems &&
            programOptions.toggleMenuItems !== COMPODOC_DEFAULTS.toggleMenuItems) {
            Configuration$1.mainData.toggleMenuItems = programOptions.toggleMenuItems;
        }
        if (configFile.templates) {
            Configuration$1.mainData.templates = configFile.templates;
        }
        if (programOptions.templates) {
            Configuration$1.mainData.templates = programOptions.templates;
        }
        if (configFile.navTabConfig) {
            Configuration$1.mainData.navTabConfig = configFile.navTabConfig;
        }
        if (programOptions.navTabConfig &&
            JSON.parse(programOptions.navTabConfig).length !== COMPODOC_DEFAULTS.navTabConfig.length) {
            Configuration$1.mainData.navTabConfig = JSON.parse(programOptions.navTabConfig);
        }
        if (configFile.includes) {
            Configuration$1.mainData.includes = configFile.includes;
        }
        if (programOptions.includes) {
            Configuration$1.mainData.includes = programOptions.includes;
        }
        if (configFile.includesName) {
            Configuration$1.mainData.includesName = configFile.includesName;
        }
        if (programOptions.includesName &&
            programOptions.includesName !== COMPODOC_DEFAULTS.additionalEntryName) {
            Configuration$1.mainData.includesName = programOptions.includesName;
        }
        if (configFile.silent) {
            logger.silent = false;
        }
        if (programOptions.silent) {
            logger.silent = false;
        }
        if (configFile.serve) {
            Configuration$1.mainData.serve = configFile.serve;
        }
        if (programOptions.serve) {
            Configuration$1.mainData.serve = programOptions.serve;
        }
        if (configFile.host) {
            Configuration$1.mainData.host = configFile.host;
            Configuration$1.mainData.hostname = configFile.host;
        }
        if (programOptions.host) {
            Configuration$1.mainData.host = programOptions.host;
            Configuration$1.mainData.hostname = programOptions.host;
        }
        if (configFile.port) {
            Configuration$1.mainData.port = configFile.port;
        }
        if (programOptions.port && programOptions.port !== COMPODOC_DEFAULTS.port) {
            Configuration$1.mainData.port = programOptions.port;
        }
        if (configFile.watch) {
            Configuration$1.mainData.watch = configFile.watch;
        }
        if (programOptions.watch) {
            Configuration$1.mainData.watch = programOptions.watch;
        }
        if (configFile.exportFormat) {
            Configuration$1.mainData.exportFormat = configFile.exportFormat;
        }
        if (programOptions.exportFormat &&
            programOptions.exportFormat !== COMPODOC_DEFAULTS.exportFormat) {
            Configuration$1.mainData.exportFormat = programOptions.exportFormat;
        }
        if (configFile.hideGenerator) {
            Configuration$1.mainData.hideGenerator = configFile.hideGenerator;
        }
        if (programOptions.hideGenerator) {
            Configuration$1.mainData.hideGenerator = programOptions.hideGenerator;
        }
        if (configFile.hideDarkModeToggle) {
            Configuration$1.mainData.hideDarkModeToggle = configFile.hideDarkModeToggle;
        }
        if (programOptions.hideDarkModeToggle) {
            Configuration$1.mainData.hideDarkModeToggle = programOptions.hideDarkModeToggle;
        }
        if (configFile.coverageTest) {
            Configuration$1.mainData.coverageTest = true;
            Configuration$1.mainData.coverageTestThreshold =
                typeof configFile.coverageTest === 'string'
                    ? parseInt(configFile.coverageTest, 10)
                    : COMPODOC_DEFAULTS.defaultCoverageThreshold;
        }
        if (programOptions.coverageTest) {
            Configuration$1.mainData.coverageTest = true;
            Configuration$1.mainData.coverageTestThreshold =
                typeof programOptions.coverageTest === 'string'
                    ? parseInt(programOptions.coverageTest, 10)
                    : COMPODOC_DEFAULTS.defaultCoverageThreshold;
        }
        if (configFile.coverageMinimumPerFile) {
            Configuration$1.mainData.coverageTestPerFile = true;
            Configuration$1.mainData.coverageMinimumPerFile =
                typeof configFile.coverageMinimumPerFile === 'string'
                    ? parseInt(configFile.coverageMinimumPerFile, 10)
                    : COMPODOC_DEFAULTS.defaultCoverageMinimumPerFile;
        }
        if (programOptions.coverageMinimumPerFile) {
            Configuration$1.mainData.coverageTestPerFile = true;
            Configuration$1.mainData.coverageMinimumPerFile =
                typeof programOptions.coverageMinimumPerFile === 'string'
                    ? parseInt(programOptions.coverageMinimumPerFile, 10)
                    : COMPODOC_DEFAULTS.defaultCoverageMinimumPerFile;
        }
        if (configFile.coverageTestThresholdFail) {
            Configuration$1.mainData.coverageTestThresholdFail =
                configFile.coverageTestThresholdFail === 'false' ? false : true;
        }
        if (programOptions.coverageTestThresholdFail) {
            Configuration$1.mainData.coverageTestThresholdFail =
                programOptions.coverageTestThresholdFail === 'false' ? false : true;
        }
        if (configFile.coverageTestShowOnlyFailed) {
            Configuration$1.mainData.coverageTestShowOnlyFailed =
                configFile.coverageTestShowOnlyFailed;
        }
        if (programOptions.coverageTestShowOnlyFailed) {
            Configuration$1.mainData.coverageTestShowOnlyFailed =
                programOptions.coverageTestShowOnlyFailed;
        }
        if (configFile.unitTestCoverage) {
            Configuration$1.mainData.unitTestCoverage = configFile.unitTestCoverage;
        }
        if (programOptions.unitTestCoverage) {
            Configuration$1.mainData.unitTestCoverage = programOptions.unitTestCoverage;
        }
        if (configFile.disableSourceCode) {
            Configuration$1.mainData.disableSourceCode = configFile.disableSourceCode;
        }
        if (programOptions.disableSourceCode) {
            Configuration$1.mainData.disableSourceCode = programOptions.disableSourceCode;
        }
        if (configFile.disableDomTree) {
            Configuration$1.mainData.disableDomTree = configFile.disableDomTree;
        }
        if (programOptions.disableDomTree) {
            Configuration$1.mainData.disableDomTree = programOptions.disableDomTree;
        }
        if (configFile.disableTemplateTab) {
            Configuration$1.mainData.disableTemplateTab = configFile.disableTemplateTab;
        }
        if (programOptions.disableTemplateTab) {
            Configuration$1.mainData.disableTemplateTab = programOptions.disableTemplateTab;
        }
        if (configFile.disableStyleTab) {
            Configuration$1.mainData.disableStyleTab = configFile.disableStyleTab;
        }
        if (programOptions.disableStyleTab) {
            Configuration$1.mainData.disableStyleTab = programOptions.disableStyleTab;
        }
        if (configFile.disableGraph) {
            Configuration$1.mainData.disableGraph = configFile.disableGraph;
        }
        if (programOptions.disableGraph) {
            Configuration$1.mainData.disableGraph = programOptions.disableGraph;
        }
        if (configFile.disableCoverage) {
            Configuration$1.mainData.disableCoverage = configFile.disableCoverage;
        }
        if (programOptions.disableCoverage) {
            Configuration$1.mainData.disableCoverage = programOptions.disableCoverage;
        }
        if (configFile.disablePrivate) {
            Configuration$1.mainData.disablePrivate = configFile.disablePrivate;
        }
        if (programOptions.disablePrivate) {
            Configuration$1.mainData.disablePrivate = programOptions.disablePrivate;
        }
        if (configFile.disableProtected) {
            Configuration$1.mainData.disableProtected = configFile.disableProtected;
        }
        if (programOptions.disableProtected) {
            Configuration$1.mainData.disableProtected = programOptions.disableProtected;
        }
        if (configFile.disableInternal) {
            Configuration$1.mainData.disableInternal = configFile.disableInternal;
        }
        if (programOptions.disableInternal) {
            Configuration$1.mainData.disableInternal = programOptions.disableInternal;
        }
        if (configFile.disableLifeCycleHooks) {
            Configuration$1.mainData.disableLifeCycleHooks = configFile.disableLifeCycleHooks;
        }
        if (programOptions.disableLifeCycleHooks) {
            Configuration$1.mainData.disableLifeCycleHooks = programOptions.disableLifeCycleHooks;
        }
        if (configFile.disableConstructors) {
            Configuration$1.mainData.disableConstructors = configFile.disableConstructors;
        }
        if (programOptions.disableConstructors) {
            Configuration$1.mainData.disableConstructors = programOptions.disableConstructors;
        }
        if (configFile.disableRoutesGraph) {
            Configuration$1.mainData.disableRoutesGraph = configFile.disableRoutesGraph;
        }
        if (programOptions.disableRoutesGraph) {
            Configuration$1.mainData.disableRoutesGraph = programOptions.disableRoutesGraph;
        }
        if (configFile.disableSearch) {
            Configuration$1.mainData.disableSearch = configFile.disableSearch;
        }
        if (programOptions.disableSearch) {
            Configuration$1.mainData.disableSearch = programOptions.disableSearch;
        }
        if (configFile.disableDependencies) {
            Configuration$1.mainData.disableDependencies = configFile.disableDependencies;
        }
        if (programOptions.disableDependencies) {
            Configuration$1.mainData.disableDependencies = programOptions.disableDependencies;
        }
        if (configFile.disableProperties) {
            Configuration$1.mainData.disableProperties = configFile.disableProperties;
        }
        if (programOptions.disableProperties) {
            Configuration$1.mainData.disableProperties = programOptions.disableProperties;
        }
        if (configFile.minimal) {
            Configuration$1.mainData.disableSearch = true;
            Configuration$1.mainData.disableRoutesGraph = true;
            Configuration$1.mainData.disableGraph = true;
            Configuration$1.mainData.disableCoverage = true;
        }
        if (programOptions.minimal) {
            Configuration$1.mainData.disableSearch = true;
            Configuration$1.mainData.disableRoutesGraph = true;
            Configuration$1.mainData.disableGraph = true;
            Configuration$1.mainData.disableCoverage = true;
        }
        if (configFile.customFavicon) {
            Configuration$1.mainData.customFavicon = configFile.customFavicon;
        }
        if (programOptions.customFavicon) {
            Configuration$1.mainData.customFavicon = programOptions.customFavicon;
        }
        if (configFile.customLogo) {
            Configuration$1.mainData.customLogo = configFile.customLogo;
        }
        if (programOptions.customLogo) {
            Configuration$1.mainData.customLogo = programOptions.customLogo;
        }
        if (configFile.gaID) {
            Configuration$1.mainData.gaID = configFile.gaID;
        }
        if (programOptions.gaID) {
            Configuration$1.mainData.gaID = programOptions.gaID;
        }
        if (configFile.gaSite) {
            Configuration$1.mainData.gaSite = configFile.gaSite;
        }
        if (programOptions.gaSite && programOptions.gaSite !== COMPODOC_DEFAULTS.gaSite) {
            Configuration$1.mainData.gaSite = programOptions.gaSite;
        }
        if (!this.isWatching) {
            if (!logger.silent) {
                console.log("Compodoc v".concat(pkg.version));
            }
            else {
                console.log(fs__namespace.readFileSync(path__namespace.join(__dirname, '../src/banner')).toString());
                console.log(pkg.version);
                console.log('');
                console.log("TypeScript version used by Compodoc : ".concat(tsMorph.ts.version));
                console.log('');
                if (FileEngine$1.existsSync(cwd + path__namespace.sep + 'package.json')) {
                    var packageData = FileEngine$1.getSync(cwd + path__namespace.sep + 'package.json');
                    if (packageData) {
                        var parsedData = JSON.parse(packageData);
                        var projectDevDependencies = parsedData.devDependencies;
                        if (projectDevDependencies && projectDevDependencies.typescript) {
                            var tsProjectVersion = AngularVersionUtil$1.cleanVersion(projectDevDependencies.typescript);
                            console.log("TypeScript version of current project : ".concat(tsProjectVersion));
                            console.log('');
                        }
                    }
                }
                console.log("Node.js version : ".concat(process.version));
                console.log('');
                console.log("Operating system : ".concat(osName(os.platform(), os.release())));
                console.log('');
            }
        }
        if (configExplorerResult) {
            if (typeof configExplorerResult.config !== 'undefined') {
                logger.info("Using configuration file : ".concat(configExplorerResult.filepath));
            }
        }
        if (!configExplorerResult) {
            logger.warn("No configuration file found, switching to CLI flags.");
        }
        if (programOptions.language && !I18nEngine$1.supportLanguage(programOptions.language)) {
            logger.warn("The language ".concat(programOptions.language, " is not available, falling back to ").concat(I18nEngine$1.fallbackLanguage));
        }
        if (programOptions.tsconfig && typeof programOptions.tsconfig === 'boolean') {
            logger.error("Please provide a tsconfig file.");
            process.exit(1);
        }
        if (configFile.tsconfig) {
            Configuration$1.mainData.tsconfig = configFile.tsconfig;
        }
        if (programOptions.tsconfig) {
            Configuration$1.mainData.tsconfig = programOptions.tsconfig;
        }
        if (programOptions.maxSearchResults) {
            Configuration$1.mainData.maxSearchResults = programOptions.maxSearchResults;
        }
        if (configFile.files) {
            scannedFiles = configFile.files;
        }
        if (configFile.exclude) {
            excludeFiles = configFile.exclude;
        }
        if (configFile.include) {
            includeFiles = configFile.include;
        }
        /**
         * Check --files argument call
         */
        var argv = require('minimist')(process.argv.slice(2));
        if (argv && argv.files) {
            Configuration$1.mainData.hasFilesToCoverage = true;
            if (typeof argv.files === 'string') {
                _super.prototype.setFiles.call(this, [argv.files]);
            }
            else {
                _super.prototype.setFiles.call(this, argv.files);
            }
        }
        if (programOptions.serve && !Configuration$1.mainData.tsconfig && programOptions.output) {
            // if -s & -d, serve it
            if (!FileEngine$1.existsSync(Configuration$1.mainData.output)) {
                logger.error("".concat(Configuration$1.mainData.output, " folder doesn't exist"));
                process.exit(1);
            }
            else {
                logger.info("Serving documentation from ".concat(Configuration$1.mainData.output, " at http://").concat(Configuration$1.mainData.hostname, ":").concat(programOptions.port));
                _super.prototype.runWebServer.call(this, Configuration$1.mainData.output);
            }
        }
        else if (programOptions.serve &&
            !Configuration$1.mainData.tsconfig &&
            !programOptions.output) {
            // if only -s find ./documentation, if ok serve, else error provide -d
            if (!FileEngine$1.existsSync(Configuration$1.mainData.output)) {
                logger.error('Provide output generated folder with -d flag');
                process.exit(1);
            }
            else {
                logger.info("Serving documentation from ".concat(Configuration$1.mainData.output, " at http://").concat(Configuration$1.mainData.hostname, ":").concat(programOptions.port));
                _super.prototype.runWebServer.call(this, Configuration$1.mainData.output);
            }
        }
        else if (Configuration$1.mainData.hasFilesToCoverage) {
            if (programOptions.coverageMinimumPerFile) {
                logger.info('Run documentation coverage test for files');
                _super.prototype.testCoverage.call(this);
            }
            else {
                logger.error('Missing coverage configuration');
            }
        }
        else {
            if (programOptions.hideGenerator) {
                Configuration$1.mainData.hideGenerator = true;
            }
            if (Configuration$1.mainData.tsconfig) {
                /**
                 * tsconfig file provided only
                 */
                var testTsConfigPath = Configuration$1.mainData.tsconfig.indexOf(process.cwd());
                if (testTsConfigPath !== -1) {
                    Configuration$1.mainData.tsconfig = Configuration$1.mainData.tsconfig.replace(process.cwd() + path__namespace.sep, '');
                }
                var sourceFolder = void 0;
                if (program.args.length > 0) {
                    /**
                     * tsconfig file provided with source folder in arg
                     */
                    var testTsConfigPath_1 = Configuration$1.mainData.tsconfig.indexOf(process.cwd());
                    if (testTsConfigPath_1 !== -1) {
                        Configuration$1.mainData.tsconfig = Configuration$1.mainData.tsconfig.replace(process.cwd() + path__namespace.sep, '');
                    }
                    sourceFolder = program.args[0];
                    if (!FileEngine$1.existsSync(sourceFolder)) {
                        logger.error("Provided source folder ".concat(sourceFolder, " was not found in the current directory"));
                        process.exit(1);
                    }
                    else {
                        logger.info('Using provided source folder');
                    }
                }
                if (!FileEngine$1.existsSync(Configuration$1.mainData.tsconfig)) {
                    logger.error("\"".concat(Configuration$1.mainData.tsconfig, "\" file was not found in the current directory"));
                    process.exit(1);
                }
                else {
                    var _file = path__namespace.join(path__namespace.join(process.cwd(), path__namespace.dirname(Configuration$1.mainData.tsconfig)), path__namespace.basename(Configuration$1.mainData.tsconfig));
                    // use the current directory of tsconfig.json as a working directory
                    cwd = _file.split(path__namespace.sep).slice(0, -1).join(path__namespace.sep);
                    logger.info('Using tsconfig file ', _file);
                    var tsConfigFile = readConfig(_file);
                    if (tsConfigFile.files) {
                        scannedFiles = tsConfigFile.files;
                        // Normalize path of these files
                        scannedFiles = scannedFiles.map(function (scannedFile) {
                            return cwd + path__namespace.sep + scannedFile;
                        });
                    }
                    // even if files are supplied with "files" attributes, enhance the array with includes
                    excludeFiles = __spreadArray(__spreadArray([], __read(excludeFiles), false), __read((tsConfigFile.exclude || [])), false);
                    includeFiles = __spreadArray(__spreadArray([], __read(includeFiles), false), __read((tsConfigFile.include || [])), false);
                    if (scannedFiles.length > 0) {
                        includeFiles = __spreadArray(__spreadArray([], __read(includeFiles), false), __read(scannedFiles), false);
                    }
                    if (!includeFiles.length) {
                        includeFiles = INCLUDE_PATTERNS;
                    }
                    var stream = fg.stream(includeFiles, {
                        cwd: sourceFolder || cwd,
                        ignore: excludeFiles,
                        absolute: true
                    });
                    stream.on('data', function (file) {
                        if (path__namespace.extname(file) === '.ts' || path__namespace.extname(file) === '.tsx') {
                            logger.debug('Including', file);
                            scannedFiles.push(file);
                        }
                        else {
                            logger.warn('Excluding', file);
                        }
                    });
                    stream.on('end', function () {
                        _super.prototype.setFiles.call(_this, scannedFiles);
                        if (programOptions.coverageTest || programOptions.coverageTestPerFile) {
                            logger.info('Run documentation coverage test');
                            _super.prototype.testCoverage.call(_this);
                        }
                        else {
                            _super.prototype.generate.call(_this);
                        }
                    });
                }
            }
            else {
                logger.error('tsconfig.json file was not found, please use -p flag');
                outputHelp();
            }
        }
    };
    return CliApplication;
}(Application));

exports.Application = Application;
exports.CliApplication = CliApplication;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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