"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const utility_service_1 = require("../../services/utility.service");
const sms_service_1 = require("../../services/sms/sms.service");
const sms_dto_1 = require("../../dtos/sms.dto");
const jwt_auth_guard_1 = require("../authentication/guards/jwt-auth.guard");
const short_code_service_1 = require("../../services/short-code/short-code.service");
const short_code_dto_1 = require("../../dtos/short-code.dto");
const sms_enum_1 = require("../../enums/sms/sms.enum");
const client_service_1 = require("../../services/partner/client.service");
const partner_dto_1 = require("../../dtos/partner.dto");
const sms_view_service_1 = require("../../services/sms/sms.view.service");
const webhook_dto_1 = require("../../dtos/webhook.dto");
const webhook_service_1 = require("../../services/webhook/webhook.service");
const smsBase = 'sms';
const shortcodeBase = 'shortcode';
const clientBase = 'client';
let ClientController = class ClientController {
    constructor(smsService, shortCodeService, clientService, smsViewsService, webhookService) {
        this.smsService = smsService;
        this.shortCodeService = shortCodeService;
        this.clientService = clientService;
        this.smsViewsService = smsViewsService;
        this.webhookService = webhookService;
    }
    async errorCodes() {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: utility_service_1.UtilityClass.returnEnum(sms_enum_1.ESMSResponseCode),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async send(body, auth) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.smsService.send(body, auth),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async sendBulk(body, auth) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.smsService.sendBulk(body, auth),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async searchSMS(query, auth) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.smsViewsService.searchTransactions({ ...query }, auth),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async getWallet(auth) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: (await this.clientService.getOrCreateWallet(auth.id)).map(({ wallet, type }) => ({
                    grossBalance: wallet.grossBalance,
                    netBalance: wallet.netBalance,
                    grossTotalCredit: wallet.grossTotalCredit,
                    grossTotalDebit: wallet.grossTotalDebit,
                    netTotalCredit: wallet.netTotalCredit,
                    netTotalDebit: wallet.netTotalDebit,
                    walletType: type,
                })),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async shortCodeAnalysis(auth) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.shortCodeService.shortCodeAnalysis(auth),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async searchShortCodes(query, auth) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.shortCodeService.search({ ...query, orgID: auth.id }, auth),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async requestShortcode(body, auth) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.shortCodeService.requestShortcodeWhitelist(body, auth),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async requestShortcodeDrop(body, auth) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.shortCodeService.requestShortcodeDrop(body, auth),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async getLogs(query, auth) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.webhookService.search(query, auth),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
};
exports.ClientController = ClientController;
__decorate([
    (0, common_1.Get)(smsBase + '/errorCodes'),
    (0, la_nest_library_1.SDKPublicAuth)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ClientController.prototype, "errorCodes", null);
__decorate([
    (0, common_1.Post)(smsBase + '/send'),
    (0, swagger_1.ApiResponse)({ type: [sms_dto_1.SendSMSResponseDto] }),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [sms_dto_1.SendSMSDto, Object]),
    __metadata("design:returntype", Promise)
], ClientController.prototype, "send", null);
__decorate([
    (0, common_1.Post)(smsBase + '/send/bulk'),
    (0, swagger_1.ApiResponse)({ type: [sms_dto_1.SendSMSResponseDto] }),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [sms_dto_1.SendBulkSMSDto, Object]),
    __metadata("design:returntype", Promise)
], ClientController.prototype, "sendBulk", null);
__decorate([
    (0, common_1.Get)(smsBase + `/search`),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [sms_dto_1.SearchSMSClientDTO, Object]),
    __metadata("design:returntype", Promise)
], ClientController.prototype, "searchSMS", null);
__decorate([
    (0, common_1.Get)(`wallets`),
    (0, swagger_1.ApiResponse)({ type: [partner_dto_1.GetClientWalletDto] }),
    __param(0, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], ClientController.prototype, "getWallet", null);
__decorate([
    (0, common_1.Get)(`${shortcodeBase}/analysis`),
    (0, swagger_1.ApiResponse)({ type: short_code_dto_1.ShortCodeAnalysisDto }),
    __param(0, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], ClientController.prototype, "shortCodeAnalysis", null);
__decorate([
    (0, common_1.Get)(`${shortcodeBase}/search`),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [short_code_dto_1.SearchShortCodeClientDTO, Object]),
    __metadata("design:returntype", Promise)
], ClientController.prototype, "searchShortCodes", null);
__decorate([
    (0, common_1.Post)(`${shortcodeBase}/request`),
    (0, swagger_1.ApiResponse)({ type: short_code_dto_1.ShortCodeAnalysisDto }),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [short_code_dto_1.RequestShortCodesClientDTO, Object]),
    __metadata("design:returntype", Promise)
], ClientController.prototype, "requestShortcode", null);
__decorate([
    (0, common_1.Post)(`${shortcodeBase}/drop`),
    (0, swagger_1.ApiResponse)({ type: short_code_dto_1.ShortCodeAnalysisDto }),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [short_code_dto_1.RequestShortCodesClientDTO, Object]),
    __metadata("design:returntype", Promise)
], ClientController.prototype, "requestShortcodeDrop", null);
__decorate([
    (0, common_1.Get)('webhook/search'),
    (0, swagger_1.ApiResponse)({ type: webhook_dto_1.SearchWebhookResponse }),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [webhook_dto_1.SearchWebhookPublicDto, Object]),
    __metadata("design:returntype", Promise)
], ClientController.prototype, "getLogs", null);
exports.ClientController = ClientController = __decorate([
    (0, jwt_auth_guard_1.AllowClientKey)(),
    (0, swagger_1.ApiTags)('CLIENT'),
    (0, common_1.Controller)('client'),
    (0, swagger_1.ApiBearerAuth)(),
    __metadata("design:paramtypes", [sms_service_1.SMSService,
        short_code_service_1.ShortCodeService,
        client_service_1.ClientService,
        sms_view_service_1.SMSViewsService,
        webhook_service_1.WebhookService])
], ClientController);
//# sourceMappingURL=client.controller.js.map