import { IAuthParam } from 'src/modules/authentication/interfaces/authentication.interface';
import { SMSService } from '../../services/sms/sms.service';
import { SearchSMSClientDTO, SendBulkSMSDto, SendSMSDto, SendSMSResponseDto } from '../../dtos/sms.dto';
import { ShortCodeService } from '../../services/short-code/short-code.service';
import { RequestShortCodesClientDTO, SearchShortCodeClientDTO, ShortCodeAnalysisDto } from '../../dtos/short-code.dto';
import { ClientService } from '../../services/partner/client.service';
import { GetClientWalletDto } from '../../dtos/partner.dto';
import { SMSViewsService } from '../../services/sms/sms.view.service';
import { SearchWebhookPublicDto } from '../../dtos/webhook.dto';
import { WebhookService } from '../../services/webhook/webhook.service';
export declare class ClientController {
    protected smsService: SMSService;
    protected shortCodeService: ShortCodeService;
    protected clientService: ClientService;
    smsViewsService: SMSViewsService;
    private readonly webhookService;
    constructor(smsService: SMSService, shortCodeService: ShortCodeService, clientService: ClientService, smsViewsService: SMSViewsService, webhookService: WebhookService);
    errorCodes(): Promise<string | import("@serene-dev/la-nest-library").ValueLabelDto<any>[]>;
    send(body: SendSMSDto, auth: IAuthParam): Promise<string | SendSMSResponseDto[]>;
    sendBulk(body: SendBulkSMSDto, auth: IAuthParam): Promise<string | SendSMSResponseDto[]>;
    searchSMS(query: SearchSMSClientDTO, auth?: IAuthParam): Promise<string | import("@serene-dev/la-nest-library").ISearchResponse<import("../../entities/sms/sms-transaction.entity").SMSTransactionEntity>>;
    getWallet(auth: IAuthParam): Promise<string | GetClientWalletDto[]>;
    shortCodeAnalysis(auth: IAuthParam): Promise<string | ShortCodeAnalysisDto>;
    searchShortCodes(query: SearchShortCodeClientDTO, auth?: IAuthParam): Promise<string | import("@serene-dev/la-nest-library").ISearchResponse<import("../../entities/short-code/short-code.entity").ShortCodeEntity>>;
    requestShortcode(body: RequestShortCodesClientDTO, auth: IAuthParam): Promise<string | ShortCodeAnalysisDto>;
    requestShortcodeDrop(body: RequestShortCodesClientDTO, auth: IAuthParam): Promise<string | ShortCodeAnalysisDto>;
    getLogs(query: SearchWebhookPublicDto, auth: IAuthParam): Promise<string | import("@serene-dev/la-nest-library").ISearchResponse<import("../../entities/webhook.entity").WebhookEntity>>;
}
