"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UsersService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
const base_service_1 = require("../../../services/base.service");
const base_enum_1 = require("../../../enums/base.enum");
const user_detail_entity_1 = require("../entities/user-detail.entity");
const authentication_service_1 = require("./authentication.service");
const authentication_enum_1 = require("../enums/authentication.enum");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const typeorm_2 = require("@nestjs/typeorm");
const utility_service_1 = require("../../../services/utility.service");
const user_view_service_1 = require("./user.view.service");
let UsersService = class UsersService extends base_service_1.BaseService {
    constructor(repo, authService, walletService, userViewService) {
        super(repo, base_enum_1.ETableName.userDetail);
        this.repo = repo;
        this.authService = authService;
        this.walletService = walletService;
        this.userViewService = userViewService;
        this.skipCreator = true;
        this.createConfig = {};
        this.searchV2 = (query, auth) => this.userViewService.searchUserView({ ...query, type: this.type }, auth);
        this.loginFunc = (req, res) => {
            return Promise.resolve(res);
        };
        this.queryStruct = [
            {
                field: 'auth',
                condition: la_nest_library_1.ESearchCondition.leftJoin,
                tableAlias: base_enum_1.ETableName.authentication,
            },
            {
                field: 'type',
                tableAlias: base_enum_1.ETableName.authentication,
            },
        ];
        this.formatSearchQuery = async (res) => {
            res.type = this.type;
            return res;
        };
        this.formatSearchResults = async (res) => {
            res.data?.forEach((x) => {
                delete x.auth?.password;
            });
            return res;
        };
    }
    async getByIDV2(id, auth) {
        return this.userViewService.getSingle({ type: this.type, id }, auth);
    }
    async login(body) {
        body.type = this.type;
        const auth = await this.loginFunc(body, await this.authService.login(body));
        const res = await this.userViewService.getSingle({
            auth_id: auth.id,
        });
        delete auth.password;
        return { ...auth, ...res };
    }
    async getSingle(where, auth) {
        return this.repo.findOne({
            where,
            relations: { auth: true, wallet: true },
        });
    }
    async getById(id) {
        return this.getSingle({
            id,
            auth: { type: this.type },
        });
    }
    async getByAuthId(id) {
        return this.getSingle({
            auth: { id, type: this.type },
        });
    }
    async createUser(body, auth) {
        body.type = this.type;
        const authDetail = await this.authService.register(this.createConfig.pre ? await this.createConfig.pre(body) : body);
        const detail = Object.assign(new user_detail_entity_1.UserDetailEntity(), body);
        detail.manager = !(await this.repo.findOne({
            where: { manager: true, auth: { type: body.type } },
            select: { id: true },
        }));
        detail.auth = authDetail;
        const res = await this.getById((await this.repo.save(detail)).id);
        await this.walletService._create({
            allowOverdraft: false,
            overdraftLimit: 0,
            userID: res.id,
            name: utility_service_1.UtilityClass.strConcatenator(authDetail.firstname, authDetail.lastname, ' '),
            type: authentication_enum_1.EAuthType.public,
        });
        delete res.auth.password;
        return this.createConfig.post ? this.createConfig.post(res) : res;
    }
    async toggleStatus(id, data) {
        const detail = await this.getById(id);
        if (!detail)
            utility_service_1.UtilityClass.throwError({ message: `ID is invalid` });
        await this.authService.toggleStatus(detail.auth.id, data);
        await this.toggleActive(id, data);
        return this.getByIDV2(id);
    }
    async forceLogout(data) {
        return this.authService.forceLogout(data);
    }
    async logout(data) {
        return this.authService.logout(data);
    }
};
exports.UsersService = UsersService;
UsersService.path = `user`;
exports.UsersService = UsersService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_2.InjectRepository)(user_detail_entity_1.UserDetailEntity)),
    __metadata("design:paramtypes", [typeorm_1.Repository,
        authentication_service_1.AuthService,
        la_nest_library_1.SDKWalletService,
        user_view_service_1.UserViewService])
], UsersService);
//# sourceMappingURL=users.service.js.map