import { FindOptionsWhere, Repository } from 'typeorm';
import { BaseService } from 'src/services/base.service';
import { AuthEntity } from '../entities/authentication.entity';
import { UserDetailEntity } from '../entities/user-detail.entity';
import { AuthService } from './authentication.service';
import { LoginDto, CreateUserDTO, UserSearchQueryDTO } from '../dtos/authentication.dto';
import { EAuthType } from '../enums/authentication.enum';
import { SDKLogoutDTO, SDKSystemLogoutDTO, SDKWalletService } from '@serene-dev/la-nest-library';
import { ToggleActiveDTO } from 'src/dtos/base.dto';
import { UserViewService } from './user.view.service';
import { IAuthParam } from '../interfaces/authentication.interface';
export declare abstract class UsersService extends BaseService<UserDetailEntity, UserSearchQueryDTO> {
    readonly repo: Repository<UserDetailEntity>;
    protected authService: AuthService;
    walletService: SDKWalletService;
    userViewService: UserViewService;
    static path: string;
    type: EAuthType;
    skipCreator: boolean;
    createConfig: {
        pre?: (req: CreateUserDTO) => Promise<CreateUserDTO>;
        post?: (res: UserDetailEntity) => Promise<UserDetailEntity>;
    };
    constructor(repo: Repository<UserDetailEntity>, authService: AuthService, walletService: SDKWalletService, userViewService: UserViewService);
    searchV2: (query: UserSearchQueryDTO, auth: IAuthParam) => Promise<import("@serene-dev/la-nest-library").ISearchResponse<import("../entities/user.view.entity").UserView>>;
    getByIDV2(id: string, auth?: IAuthParam): Promise<import("../entities/user.view.entity").UserView>;
    loginFunc: (req: LoginDto, res: AuthEntity) => Promise<any>;
    login(body: LoginDto): Promise<any>;
    getSingle(where: FindOptionsWhere<UserDetailEntity>, auth?: IAuthParam): Promise<UserDetailEntity>;
    getById(id: string): Promise<UserDetailEntity>;
    getByAuthId(id: string): Promise<UserDetailEntity>;
    createUser(body: CreateUserDTO, auth?: IAuthParam): Promise<UserDetailEntity>;
    toggleStatus(id: string, data: ToggleActiveDTO): Promise<import("../entities/user.view.entity").UserView>;
    forceLogout(data: SDKSystemLogoutDTO): Promise<boolean>;
    logout(data: SDKLogoutDTO): Promise<boolean>;
}
