"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserViewService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
const user_view_entity_1 = require("../entities/user.view.entity");
const typeorm_2 = require("@nestjs/typeorm");
const utility_service_1 = require("../../../services/utility.service");
const authentication_enum_1 = require("../enums/authentication.enum");
const authentication_repository_1 = require("./authentication.repository");
let UserViewService = class UserViewService {
    constructor(repoUserView, authRepo) {
        this.repoUserView = repoUserView;
        this.authRepo = authRepo;
        this.searchUserView = async ({ type, firstname, lastname, orgID, ...query }, auth) => {
            return utility_service_1.UtilityClass.searchView(this.repoUserView, query, {
                baseWhere: {
                    firstname: utility_service_1.UtilityClass.likeFormatter(firstname),
                    lastname: utility_service_1.UtilityClass.likeFormatter(lastname),
                    type: auth.isAdmin ? type : authentication_enum_1.EAuthType.public,
                    orgID: auth.isAdmin
                        ? orgID
                        : await this.authRepo.getOrgIDByAuthID(auth.id),
                },
            });
        };
    }
    async getSingle(query, auth) {
        return this.repoUserView.findOneBy({
            ...query,
            orgID: auth && !auth?.isAdmin
                ? await this.authRepo.getOrgIDByAuthID(auth.id)
                : query.orgID,
        });
    }
};
exports.UserViewService = UserViewService;
exports.UserViewService = UserViewService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_2.InjectRepository)(user_view_entity_1.UserView)),
    __metadata("design:paramtypes", [typeorm_1.Repository,
        authentication_repository_1.AuthRepository])
], UserViewService);
//# sourceMappingURL=user.view.service.js.map