import { FindOptionsWhere, Repository } from 'typeorm';
import { UserView } from '../entities/user.view.entity';
import { UserSearchQueryDTO } from '../dtos/authentication.dto';
import { IAuthParam } from '../interfaces/authentication.interface';
import { AuthRepository } from './authentication.repository';
export declare class UserViewService {
    repoUserView: Repository<UserView>;
    authRepo: AuthRepository;
    constructor(repoUserView: Repository<UserView>, authRepo: AuthRepository);
    searchUserView: ({ type, firstname, lastname, orgID, ...query }: UserSearchQueryDTO, auth: IAuthParam) => Promise<import("@serene-dev/la-nest-library").ISearchResponse<UserView>>;
    getSingle(query: FindOptionsWhere<UserView>, auth?: IAuthParam): Promise<UserView>;
}
