import { UsersService } from './users.service';
import { EAuthType } from '../enums/authentication.enum';
import { SDKWalletEntity } from '@serene-dev/la-nest-library';
import { UserDetailEntity } from '../entities/user-detail.entity';
import { IAuthParam } from '../interfaces/authentication.interface';
import { ICreateConfig } from '../../../interfaces/index.interface';
import { CreateUserDTO } from '../dtos/authentication.dto';
export declare class PublicUsersService extends UsersService {
    static path: string;
    type: EAuthType;
    getOrCreateWallet(authID: string, config?: ICreateConfig): Promise<SDKWalletEntity>;
    createMissingWallets(auth: IAuthParam): Promise<void>;
    _updateByID(id: string, data: Partial<UserDetailEntity>, config?: ICreateConfig): Promise<UserDetailEntity>;
    createUser(body: CreateUserDTO, auth?: IAuthParam): Promise<UserDetailEntity>;
}
