"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthService = exports.AuthenticationSessionService = void 0;
const common_1 = require("@nestjs/common");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const typeorm_1 = require("typeorm");
const typeorm_2 = require("@nestjs/typeorm");
const authentication_entity_1 = require("../entities/authentication.entity");
const token_service_1 = require("../../../services/token.service");
const utility_service_1 = require("../../../services/utility.service");
const authentication_session_entity_1 = require("../entities/authentication-session.entity");
const authentication_enum_1 = require("../enums/authentication.enum");
const environment_service_1 = require("../../../services/environment.service");
let AuthenticationSessionService = class AuthenticationSessionService extends la_nest_library_1.SDKAuthenticationSessionService {
    constructor(repository) {
        super(repository);
        this.repository = repository;
    }
};
exports.AuthenticationSessionService = AuthenticationSessionService;
exports.AuthenticationSessionService = AuthenticationSessionService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_2.InjectRepository)(authentication_session_entity_1.AuthSessionEntity)),
    __metadata("design:paramtypes", [typeorm_1.Repository])
], AuthenticationSessionService);
let AuthService = class AuthService extends la_nest_library_1.SDKAuthenticationService {
    constructor(repo, tokenService, authenticationSessionService, tokenSessionService) {
        super(repo, tokenService, authenticationSessionService, tokenSessionService);
        this.repo = repo;
        this.tokenService = tokenService;
        this.authenticationSessionService = authenticationSessionService;
        this.tokenSessionService = tokenSessionService;
    }
    async getWhere(where) {
        return (await this.repo.findBy(where));
    }
    async register(body) {
        return (await super.register(body));
    }
    generateToken(auth) {
        return this.tokenService.generateToken({
            id: auth.id,
            isPublic: auth.type == authentication_enum_1.EAuthType.public,
            isAdmin: auth.type == authentication_enum_1.EAuthType.admin,
            orgId: auth.orgID,
        });
    }
    async login(body) {
        const res = (await super.login(body));
        if (environment_service_1.evt.isDev)
            res['tokenOnly'] = res.token?.replace('Bearer ', '');
        const msg = `You just logged in at ${utility_service_1.UtilityClass.currentLocalDateTime}`;
        la_nest_library_1.MailService.sendMail({
            to: body.email,
            text: msg,
            html: await utility_service_1.UtilityClass.emailTemplater(`New Log In`, msg),
            subject: `Log In Notification`,
            _senderName: 'Account Manager',
        });
        return res;
    }
};
exports.AuthService = AuthService;
exports.AuthService = AuthService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_2.InjectRepository)(authentication_entity_1.AuthEntity)),
    __metadata("design:paramtypes", [typeorm_1.Repository,
        token_service_1.TokenService,
        AuthenticationSessionService,
        token_service_1.TokenSessionService])
], AuthService);
//# sourceMappingURL=authentication.service.js.map