"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AdminUsersService = void 0;
const common_1 = require("@nestjs/common");
const users_service_1 = require("./users.service");
const authentication_enum_1 = require("../enums/authentication.enum");
const authentication_interface_1 = require("../interfaces/authentication.interface");
let AdminUsersService = class AdminUsersService extends users_service_1.UsersService {
    constructor() {
        super(...arguments);
        this.type = authentication_enum_1.EAuthType.admin;
        this.defaultEmail = `ahmeddapo0110@outlook.com`;
    }
    async setupDefaultAdminUser() {
        const exists = await this.authService.count({
            email: this.defaultEmail,
        });
        if (!exists) {
            const password = `password`;
            await this.createUser({
                dob: new Date().toISOString(),
                firstname: 'Super',
                lastname: 'Admin',
                login: false,
                type: authentication_enum_1.EAuthType.admin,
                email: this.defaultEmail,
                username: this.defaultEmail,
                password,
                gender: authentication_interface_1.EGender.male,
                phoneNumber: '',
            });
            console.log(`Default admin has been created for ${this.defaultEmail}. Check your mailbox`);
        }
    }
};
exports.AdminUsersService = AdminUsersService;
AdminUsersService.path = `user_${authentication_enum_1.EAuthType.admin}`;
exports.AdminUsersService = AdminUsersService = __decorate([
    (0, common_1.Injectable)()
], AdminUsersService);
//# sourceMappingURL=admin-users.service.js.map