"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var JwtAuthGuard_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Role = exports.JwtAuthGuard = exports.AllowClientKey = void 0;
const common_1 = require("@nestjs/common");
const core_1 = require("@nestjs/core");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const token_service_1 = require("../../../services/token.service");
const authentication_service_1 = require("../services/authentication.service");
const authentication_enum_1 = require("../enums/authentication.enum");
const ALLOW_CLIENT_KEY = 'ALLOW_CLIENT_KEY';
const AllowClientKey = () => (0, common_1.SetMetadata)(ALLOW_CLIENT_KEY, true);
exports.AllowClientKey = AllowClientKey;
let JwtAuthGuard = JwtAuthGuard_1 = class JwtAuthGuard extends la_nest_library_1.SDKAuthenticationGuard {
    constructor(tokenService, authS, reflector, tokenSessionService) {
        super(tokenService, authS, reflector);
        this.tokenService = tokenService;
        this.authS = authS;
        this.reflector = reflector;
        this.tokenSessionService = tokenSessionService;
        this.skipEnvironment = 'dev';
    }
    async verifyAuthToken(context, payload) {
        const role = this.reflector.get(exports.Role, context.getHandler());
        if (role == authentication_enum_1.EAuthType.admin && payload.isAdmin !== true)
            throw new common_1.UnauthorizedException();
        if (payload.isClient &&
            this.reflector.getAllAndOverride(ALLOW_CLIENT_KEY, [
                context.getHandler(),
                context.getClass(),
            ]))
            await this.tokenSessionService.checkIfExistsBy({
                token: payload.token,
                active: true,
            });
        else
            return super.verifyAuthToken(context, payload);
    }
    canActivate(context) {
        return super.canActivate(context);
    }
    static provideGuard() {
        return {
            provide: core_1.APP_GUARD,
            useClass: JwtAuthGuard_1,
        };
    }
};
exports.JwtAuthGuard = JwtAuthGuard;
exports.JwtAuthGuard = JwtAuthGuard = JwtAuthGuard_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [token_service_1.TokenService,
        authentication_service_1.AuthService,
        core_1.Reflector,
        token_service_1.TokenSessionService])
], JwtAuthGuard);
exports.Role = core_1.Reflector.createDecorator();
//# sourceMappingURL=jwt-auth.guard.js.map