import { CanActivate, ExecutionContext } from '@nestjs/common';
import { Reflector } from '@nestjs/core';
import { SDKAuthenticationGuard } from '@serene-dev/la-nest-library';
import { TokenService, TokenSessionService } from 'src/services/token.service';
import { AuthService } from '../services/authentication.service';
import { AuthEntity } from '../entities/authentication.entity';
import { IAuthParam } from '../interfaces/authentication.interface';
import { EAuthType } from '../enums/authentication.enum';
export declare const AllowClientKey: () => import("@nestjs/common").CustomDecorator<string>;
export declare class JwtAuthGuard extends SDKAuthenticationGuard<AuthEntity> implements CanActivate {
    protected tokenService: TokenService;
    protected authS: AuthService;
    protected reflector: Reflector;
    protected tokenSessionService: TokenSessionService;
    constructor(tokenService: TokenService, authS: AuthService, reflector: Reflector, tokenSessionService: TokenSessionService);
    verifyAuthToken(context: ExecutionContext, payload: IAuthParam): Promise<void>;
    canActivate(context: ExecutionContext): Promise<boolean>;
    static provideGuard(): {
        provide: string;
        useClass: any;
    };
}
export declare const Role: import("@nestjs/core").ReflectableDecorator<EAuthType, EAuthType>;
