"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserSearchQueryDTO = exports.UpdateUserDTO = exports.CreateUserDTO = exports.RegisterUserDTO = exports.SaveUserBankAccountDto = exports.LoginDto = void 0;
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const authentication_interface_1 = require("../interfaces/authentication.interface");
const class_validator_1 = require("class-validator");
const swagger_1 = require("@nestjs/swagger");
const base_sample_1 = require("../../../samples/base.sample");
const class_transformer_1 = require("class-transformer");
class LoginDto extends la_nest_library_1.SDKLoginDTO {
}
exports.LoginDto = LoginDto;
class SaveUserBankAccountDto {
}
exports.SaveUserBankAccountDto = SaveUserBankAccountDto;
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], SaveUserBankAccountDto.prototype, "number", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], SaveUserBankAccountDto.prototype, "name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], SaveUserBankAccountDto.prototype, "bankName", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ required: false }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], SaveUserBankAccountDto.prototype, "bankSortCode", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], SaveUserBankAccountDto.prototype, "bankCode", void 0);
class RegisterUserDTO extends la_nest_library_1.SDKRegisterDTO {
}
exports.RegisterUserDTO = RegisterUserDTO;
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'string', default: base_sample_1.Sample.phoneNumber }),
    (0, class_validator_1.IsPhoneNumber)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], RegisterUserDTO.prototype, "phoneNumber", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], RegisterUserDTO.prototype, "username", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ enum: authentication_interface_1.EGender }),
    (0, class_validator_1.IsEnum)(authentication_interface_1.EGender),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], RegisterUserDTO.prototype, "gender", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: Date }),
    (0, class_validator_1.IsDateString)(),
    __metadata("design:type", String)
], RegisterUserDTO.prototype, "dob", void 0);
__decorate([
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => SaveUserBankAccountDto),
    (0, swagger_1.ApiPropertyOptional)({ type: SaveUserBankAccountDto }),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", SaveUserBankAccountDto)
], RegisterUserDTO.prototype, "bankAccount", void 0);
class CreateUserDTO extends RegisterUserDTO {
}
exports.CreateUserDTO = CreateUserDTO;
__decorate([
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateUserDTO.prototype, "password", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsUUID)(),
    __metadata("design:type", String)
], CreateUserDTO.prototype, "orgID", void 0);
class UpdateUserDTO extends (0, swagger_1.PartialType)(CreateUserDTO) {
}
exports.UpdateUserDTO = UpdateUserDTO;
class UserSearchQueryDTO extends la_nest_library_1.SearchQueryDto {
}
exports.UserSearchQueryDTO = UserSearchQueryDTO;
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsBooleanString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Boolean)
], UserSearchQueryDTO.prototype, "lite", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], UserSearchQueryDTO.prototype, "name", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], UserSearchQueryDTO.prototype, "firstname", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], UserSearchQueryDTO.prototype, "lastname", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsEmail)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], UserSearchQueryDTO.prototype, "email", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], UserSearchQueryDTO.prototype, "username", void 0);
//# sourceMappingURL=authentication.dto.js.map