import { SDKLoginDTO, SDKRegisterDTO, SearchQueryDto } from '@serene-dev/la-nest-library';
import { AuthEntity, UserBankAccount } from '../entities/authentication.entity';
import { UserDetailEntity } from '../entities/user-detail.entity';
import { EGender } from '../interfaces/authentication.interface';
import { EAuthType } from '../enums/authentication.enum';
export declare class LoginDto extends SDKLoginDTO {
}
export declare class SaveUserBankAccountDto implements UserBankAccount {
    number: string;
    name: string;
    bankName: string;
    bankSortCode?: string;
    bankCode: string;
}
export declare class RegisterUserDTO extends SDKRegisterDTO implements Partial<UserDetailEntity> {
    phoneNumber: string;
    username: string;
    gender: EGender;
    dob: string;
    type: EAuthType;
    bankAccount?: SaveUserBankAccountDto;
}
export declare class CreateUserDTO extends RegisterUserDTO {
    password?: string;
    orgID?: string;
}
declare const UpdateUserDTO_base: import("@nestjs/common").Type<Partial<CreateUserDTO>>;
export declare class UpdateUserDTO extends UpdateUserDTO_base {
}
export declare class UserSearchQueryDTO extends SearchQueryDto<UserDetailEntity> implements Partial<UserDetailEntity>, Partial<AuthEntity> {
    type: any;
    auth?: any;
    lite?: boolean;
    name?: string;
    firstname?: string;
    lastname?: string;
    email?: string;
    username?: string;
}
export {};
