"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UsersController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const authentication_service_1 = require("../services/authentication.service");
const authentication_dto_1 = require("../dtos/authentication.dto");
const utility_service_1 = require("../../../services/utility.service");
const users_service_1 = require("../services/users.service");
const base_controller_1 = require("../../../controllers/base.controller");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const base_dto_1 = require("../../../dtos/base.dto");
const authentication_dto_2 = require("@serene-dev/la-nest-library/dist/libs/la-library/src/modules/authentication/authentication.dto");
const authentication_interface_1 = require("../interfaces/authentication.interface");
const jwt_auth_guard_1 = require("../guards/jwt-auth.guard");
const authentication_enum_1 = require("../enums/authentication.enum");
let UsersController = class UsersController extends base_controller_1.BaseController {
    constructor(service, authService) {
        super(service);
        this.service = service;
        this.authService = authService;
        this.subject = `User`;
        this.loginFunc = (req, res) => {
            return Promise.resolve(res);
        };
        this.createFunc = (req, res) => Promise.resolve(res);
    }
    async search(query, auth) {
        return super.search(query, auth, this.service.searchV2);
    }
    async getByID(params, auth) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.getByIDV2(params.id, auth),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async login(data) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: this.loginFunc(data, await this.service.login(data)),
                message: `${this.subject} logged in`,
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async create(data, auth) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: this.createFunc(data, await this.service.createUser(data, auth)),
                message: `${this.subject} created`,
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async forceLogout(body) {
        try {
            return this.service.forceLogout(body);
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async logout(param) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.logout(param),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async update(data, param, auth) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: this.createFunc(data, await this.service._updateByID(param.id, data, { auth })),
                message: `${this.subject} updated`,
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async toggleStatus(data, param) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.toggleStatus(param.id, data),
                message: `${this.subject} updated`,
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async requestPasswordReset(body) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.authService.requestPasswordReset(body),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async verifyResetPasswordToken(body) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.authService.verifyResetPasswordToken(body),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async resetPassword(body) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.authService.resetPassword(body),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async genders() {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: utility_service_1.UtilityClass.returnEnum(authentication_interface_1.EGender),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
};
exports.UsersController = UsersController;
__decorate([
    (0, common_1.Get)('search'),
    (0, la_nest_library_1.SDKPublicAuth)(),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [authentication_dto_1.UserSearchQueryDTO, Object]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "search", null);
__decorate([
    (0, common_1.Get)('getByID/:id'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "getByID", null);
__decorate([
    (0, la_nest_library_1.SDKPublicAuth)(),
    (0, common_1.Post)('login'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [authentication_dto_1.LoginDto]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "login", null);
__decorate([
    (0, common_1.Post)('create'),
    (0, jwt_auth_guard_1.Role)(authentication_enum_1.EAuthType.admin),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [authentication_dto_1.CreateUserDTO, Object]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "create", null);
__decorate([
    (0, common_1.Post)('logout/force'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [la_nest_library_1.SDKSystemLogoutDTO]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "forceLogout", null);
__decorate([
    (0, common_1.Post)('logout'),
    __param(0, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "logout", null);
__decorate([
    (0, common_1.Put)('update/:id'),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Param)()),
    __param(2, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [authentication_dto_1.UpdateUserDTO,
        la_nest_library_1.IDDto, Object]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "update", null);
__decorate([
    (0, common_1.Put)('toggle/:id'),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [base_dto_1.ToggleActiveDTO, la_nest_library_1.IDDto]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "toggleStatus", null);
__decorate([
    (0, common_1.Post)('reset/request'),
    (0, la_nest_library_1.SDKPublicAuth)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [la_nest_library_1.SDKRequestPasswordResetDTO]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "requestPasswordReset", null);
__decorate([
    (0, common_1.Post)('reset/verify'),
    (0, la_nest_library_1.SDKPublicAuth)(),
    (0, swagger_1.ApiResponse)({ type: authentication_dto_2.VerifyResetPasswordTokenResponseDTO }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [la_nest_library_1.SDKVerifyResetPasswordTokenDTO]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "verifyResetPasswordToken", null);
__decorate([
    (0, common_1.Post)('reset'),
    (0, la_nest_library_1.SDKPublicAuth)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [la_nest_library_1.SDKResetPasswordDTO]),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "resetPassword", null);
__decorate([
    (0, common_1.Get)('genders'),
    (0, la_nest_library_1.SDKPublicAuth)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], UsersController.prototype, "genders", null);
exports.UsersController = UsersController = __decorate([
    (0, swagger_1.ApiTags)(users_service_1.UsersService.tag),
    (0, common_1.Controller)(users_service_1.UsersService.path),
    __metadata("design:paramtypes", [users_service_1.UsersService,
        authentication_service_1.AuthService])
], UsersController);
//# sourceMappingURL=users.controller.js.map