"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PublicUsersController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const users_controller_1 = require("./users.controller");
const public_users_service_1 = require("../services/public-users.service");
const authentication_enum_1 = require("../enums/authentication.enum");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const utility_service_1 = require("@serene-dev/la-nest-library/dist/libs/la-library/src/services/utility.service");
const authentication_dto_1 = require("../dtos/authentication.dto");
const authentication_service_1 = require("../services/authentication.service");
let PublicUsersController = class PublicUsersController extends users_controller_1.UsersController {
    constructor(service, authService) {
        super(service, authService);
        this.service = service;
        this.authService = authService;
        this.subject = `${authentication_enum_1.EAuthType.public} User`;
    }
    async register(data) {
        try {
            const login = data.login == true;
            data.login = false;
            const res = await this.createFunc(data, await this.service.createUser(data));
            return utility_service_1.UtilityClass.handleSuccess({
                data: login
                    ? await this.service.login({
                        email: data.email,
                        orgID: data.orgID,
                        password: data.password,
                    })
                    : res,
                message: `${this.subject} signed up`,
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
};
exports.PublicUsersController = PublicUsersController;
__decorate([
    (0, la_nest_library_1.SDKPublicAuth)(),
    (0, common_1.Post)('register'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [authentication_dto_1.RegisterUserDTO]),
    __metadata("design:returntype", Promise)
], PublicUsersController.prototype, "register", null);
exports.PublicUsersController = PublicUsersController = __decorate([
    (0, swagger_1.ApiTags)(public_users_service_1.PublicUsersService.tag),
    (0, common_1.Controller)(public_users_service_1.PublicUsersService.path),
    __metadata("design:paramtypes", [public_users_service_1.PublicUsersService,
        authentication_service_1.AuthService])
], PublicUsersController);
//# sourceMappingURL=public-users.controller.js.map