import { AuthService, AuthenticationSessionService } from './services/authentication.service';
import { BaseModule, SDKAuthEntity } from '@serene-dev/la-nest-library';
import { UserDetailEntity } from './entities/user-detail.entity';
import { JwtAuthGuard } from './guards/jwt-auth.guard';
import { AdminUsersService } from './services/admin-users.service';
import { TokenSessionService } from 'src/services/token.service';
import { TokenSessionEntity } from 'src/entities/token.entity';
import { PublicUsersService } from './services/public-users.service';
import { AuthRepository } from './services/authentication.repository';
import { UserViewService } from './services/user.view.service';
export declare class AuthenticationModule extends BaseModule {
    static entities: (typeof SDKAuthEntity | typeof UserDetailEntity | typeof TokenSessionEntity)[];
    static services: (typeof TokenSessionService | typeof AuthenticationSessionService | typeof AuthService | typeof AuthRepository | typeof UserViewService | typeof PublicUsersService | typeof JwtAuthGuard | typeof AdminUsersService)[];
}
