"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@nestjs/core");
const app_module_1 = require("./app.module");
const index_config_1 = require("./configs/index.config");
const helmet_1 = require("helmet");
const environment_service_1 = require("./services/environment.service");
const utility_service_1 = require("./services/utility.service");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const dotenv = require("dotenv");
const fs = require("fs");
const path = require("path");
const validation_pipe_1 = require("./validations/validation.pipe");
const client_module_1 = require("./modules/client/client.module");
function getPath(path) {
    const p = __dirname + path;
    return p;
}
let parsedEnv = dotenv.config();
if (parsedEnv.error)
    parsedEnv = dotenv.config({ path: getPath('/.env') });
const _evt = parsedEnv.parsed;
async function bootstrap() {
    console.log('logs loc', path.join(__dirname, _evt.LOGS_DEST));
    (0, la_nest_library_1.initLogger)(path.join(__dirname, _evt.LOGS_DEST));
    const app = await core_1.NestFactory.create(app_module_1.AppModule, {
        logger: ['error', 'warn'],
        httpsOptions: _evt.ENVIRONMENT === 'dev'
            ? undefined
            : {
                key: fs.readFileSync(getPath(_evt.SSL_KEY)),
                cert: fs.readFileSync(getPath(_evt.SSL_CERT)),
                ca: fs.readFileSync(getPath(_evt.SSL_CA)),
            },
    });
    app.enableCors();
    app.use((0, helmet_1.default)({
        crossOriginResourcePolicy: { policy: 'cross-origin' },
    }));
    app.useBodyParser('json', { limit: '10mb' });
    app.useGlobalPipes(new validation_pipe_1.CustomValidationPipe({
        whitelist: true,
    }));
    try {
        console.log(`Loading Full swagger`);
        utility_service_1.UtilityClass.enableSwagger(app, {
            appName: index_config_1.Config.appName,
            path: `solo-docs`,
            docExpansion: 'none',
        });
        utility_service_1.UtilityClass.enableSwagger(app, {
            appName: index_config_1.Config.appName,
            path: `client-docs`,
            docExpansion: 'none',
            modules: [client_module_1.ClientModule],
        });
        console.log(`Loaded Full swagger`);
        console.log('Timezone difference in mins', utility_service_1.UtilityClass.calculateTimeZoneDifferenceMins());
        _evt.timestampDifferenceFromGMT =
            utility_service_1.UtilityClass.calculateTimeZoneDifferenceMilliSec();
        await app.listen(+_evt.SERVER_PORT);
        environment_service_1.evt.SERVER_URL = _evt.SERVER_URL || (await app.getUrl());
        console.log(`Application is running on: ${environment_service_1.evt.SERVER_URL}`);
        la_nest_library_1.MailService.loadConfigFromEnvironment(_evt);
        console.log(`Loaded SMTP credentials`);
        console.log(`Good to go 💪🏻💪🏻💪🏻`);
    }
    catch (error) {
        debugger;
        la_nest_library_1.MailService.sendCrashNotification(error);
        console.error(error);
    }
}
bootstrap();
//# sourceMappingURL=main.js.map