"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebhookEntity = void 0;
const typeorm_1 = require("typeorm");
const base_entity_1 = require("./base.entity");
const base_enum_1 = require("../enums/base.enum");
const partner_entity_1 = require("./partner.entity");
const sms_transaction_entity_1 = require("./sms/sms-transaction.entity");
const webhook_enum_1 = require("../enums/webhook.enum");
const webhook_dto_1 = require("../dtos/webhook.dto");
let WebhookEntity = class WebhookEntity extends base_entity_1.BaseEntity {
};
exports.WebhookEntity = WebhookEntity;
__decorate([
    (0, typeorm_1.ManyToOne)(() => partner_entity_1.PartnerEntity, (i) => i.webhooks),
    __metadata("design:type", Object)
], WebhookEntity.prototype, "partner", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], WebhookEntity.prototype, "partnerId", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => sms_transaction_entity_1.SMSTransactionEntity, (i) => i.webhooks),
    __metadata("design:type", Object)
], WebhookEntity.prototype, "smsTransaction", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], WebhookEntity.prototype, "smsTransactionId", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "text" }),
    __metadata("design:type", String)
], WebhookEntity.prototype, "url", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "json" }),
    __metadata("design:type", webhook_dto_1.WebhookPayloadDto)
], WebhookEntity.prototype, "payload", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "int", nullable: true }),
    __metadata("design:type", Number)
], WebhookEntity.prototype, "responseStatus", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "text", nullable: true }),
    __metadata("design:type", String)
], WebhookEntity.prototype, "responseBody", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "enum", enum: webhook_enum_1.EWebhookStatus, default: webhook_enum_1.EWebhookStatus.pending }),
    __metadata("design:type", String)
], WebhookEntity.prototype, "status", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "enum", enum: webhook_enum_1.EWebhookEventType }),
    __metadata("design:type", String)
], WebhookEntity.prototype, "event", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "int", default: 0 }),
    __metadata("design:type", Number)
], WebhookEntity.prototype, "retryCount", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "text", nullable: true }),
    __metadata("design:type", String)
], WebhookEntity.prototype, "errorMessage", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "double", nullable: true }),
    __metadata("design:type", Number)
], WebhookEntity.prototype, "deliveredAt", void 0);
exports.WebhookEntity = WebhookEntity = __decorate([
    (0, typeorm_1.Entity)(base_enum_1.ETableName.webhook)
], WebhookEntity);
//# sourceMappingURL=webhook.entity.js.map