import { Relation } from "typeorm";
import { BaseEntity } from "./base.entity";
import { PartnerEntity } from "./partner.entity";
import { SMSTransactionEntity } from "./sms/sms-transaction.entity";
import { EWebhookEventType, EWebhookStatus } from "../enums/webhook.enum";
import { WebhookPayloadDto } from "../dtos/webhook.dto";
export declare class WebhookEntity extends BaseEntity<WebhookEntity> {
    partner?: Relation<PartnerEntity>;
    partnerId?: string;
    smsTransaction?: Relation<SMSTransactionEntity>;
    smsTransactionId?: string;
    url: string;
    payload: WebhookPayloadDto;
    responseStatus?: number;
    responseBody?: string;
    status: EWebhookStatus;
    event: EWebhookEventType;
    retryCount: number;
    errorMessage?: string;
    deliveredAt?: number;
}
