"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SMSTransactionAdminView = exports.SMSTransactionView = void 0;
const typeorm_1 = require("typeorm");
const base_enum_1 = require("../../enums/base.enum");
const sms_enum_1 = require("../../enums/sms/sms.enum");
let SMSTransactionView = class SMSTransactionView {
};
exports.SMSTransactionView = SMSTransactionView;
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", Boolean)
], SMSTransactionView.prototype, "active", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", Number)
], SMSTransactionView.prototype, "amount", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], SMSTransactionView.prototype, "clientId", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], SMSTransactionView.prototype, "createdAt", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], SMSTransactionView.prototype, "creatorId", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", Number)
], SMSTransactionView.prototype, "dateTimeDelivered", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", Number)
], SMSTransactionView.prototype, "dateTimeFailed", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", Number)
], SMSTransactionView.prototype, "dateTimeSent", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", Date)
], SMSTransactionView.prototype, "deletedAt", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], SMSTransactionView.prototype, "error", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], SMSTransactionView.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], SMSTransactionView.prototype, "lastUpdateID", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], SMSTransactionView.prototype, "message", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", Object)
], SMSTransactionView.prototype, "meta", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], SMSTransactionView.prototype, "name", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], SMSTransactionView.prototype, "orgID", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], SMSTransactionView.prototype, "pErrorCode", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], SMSTransactionView.prototype, "pErrorMessage", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], SMSTransactionView.prototype, "pMessageID", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], SMSTransactionView.prototype, "productId", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], SMSTransactionView.prototype, "productMainVolume", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], SMSTransactionView.prototype, "productMaxVolume", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], SMSTransactionView.prototype, "recipient", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], SMSTransactionView.prototype, "recipientId", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", Boolean)
], SMSTransactionView.prototype, "resolvedFeedback", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], SMSTransactionView.prototype, "shortCode", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], SMSTransactionView.prototype, "shortCodeId", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], SMSTransactionView.prototype, "clientName", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], SMSTransactionView.prototype, "smsId", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], SMSTransactionView.prototype, "status", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], SMSTransactionView.prototype, "type", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], SMSTransactionView.prototype, "updatedAt", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], SMSTransactionView.prototype, "updaterId", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], SMSTransactionView.prototype, "walletTransactionId", void 0);
exports.SMSTransactionView = SMSTransactionView = __decorate([
    (0, typeorm_1.ViewEntity)({
        expression: `SELECT
    sr.smsId,
    sr.recipient,
    s.message,
    s.productId,
    s.type,
    s.clientId,
    p.name AS clientName,
    s.shortCodeId,
    sc.code AS shortCode,
    prod.minVolume AS productMainVolume,
    prod.maxVolume AS productMaxVolume,
    p.name,
    st.*
FROM
    ${base_enum_1.ETableName.smsTransactions} AS st
LEFT JOIN ${base_enum_1.ETableName.smsRecipients} AS sr
ON
    sr.id = st.recipientId
LEFT JOIN ${base_enum_1.ETableName.sms} AS s
ON
    s.id = sr.smsId
LEFT JOIN ${base_enum_1.ETableName.shortCodes} AS sc
ON
    sc.id = s.shortCodeId
LEFT JOIN ${base_enum_1.ETableName.products} AS prod
ON
    prod.id = s.productId
LEFT JOIN ${base_enum_1.ETableName.partner} AS p
ON
    p.id = s.clientId;`,
        name: base_enum_1.ETableName.sms_transaction_view,
    })
], SMSTransactionView);
let SMSTransactionAdminView = class SMSTransactionAdminView extends SMSTransactionView {
};
exports.SMSTransactionAdminView = SMSTransactionAdminView;
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], SMSTransactionAdminView.prototype, "providerId", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], SMSTransactionAdminView.prototype, "providerName", void 0);
exports.SMSTransactionAdminView = SMSTransactionAdminView = __decorate([
    (0, typeorm_1.ViewEntity)({
        expression: `SELECT 
    provider.name AS providerName,  
    stv.*
FROM
    ${base_enum_1.ETableName.sms_transaction_view} AS stv 
LEFT JOIN ${base_enum_1.ETableName.partner} AS provider
ON
    provider.id = stv.providerId;`,
        name: base_enum_1.ETableName.sms_transaction_admin_view,
        dependsOn: [SMSTransactionView],
    })
], SMSTransactionAdminView);
//# sourceMappingURL=sms.view.entity.js.map