"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SMSTransactionEntity = void 0;
const typeorm_1 = require("typeorm");
const base_entity_1 = require("../base.entity");
const base_enum_1 = require("../../enums/base.enum");
const sms_enum_1 = require("../../enums/sms/sms.enum");
const partner_entity_1 = require("../partner.entity");
const sms_recipient_entity_1 = require("./sms-recipient.entity");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const webhook_entity_1 = require("../webhook.entity");
let SMSTransactionEntity = class SMSTransactionEntity extends base_entity_1.BaseEntity {
};
exports.SMSTransactionEntity = SMSTransactionEntity;
__decorate([
    (0, typeorm_1.OneToOne)(() => sms_recipient_entity_1.SMSRecipientEntity, (i) => i.transaction),
    (0, typeorm_1.JoinColumn)(),
    __metadata("design:type", Object)
], SMSTransactionEntity.prototype, "recipient", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], SMSTransactionEntity.prototype, "recipientId", void 0);
__decorate([
    (0, typeorm_1.OneToOne)(() => la_nest_library_1.SDKWalletTransaction),
    (0, typeorm_1.JoinColumn)({ referencedColumnName: "id" }),
    __metadata("design:type", Object)
], SMSTransactionEntity.prototype, "walletTransaction", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], SMSTransactionEntity.prototype, "walletTransactionId", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "double" }),
    __metadata("design:type", Number)
], SMSTransactionEntity.prototype, "amount", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "enum", enum: sms_enum_1.ESMSStatus, default: sms_enum_1.ESMSStatus.pending }),
    __metadata("design:type", String)
], SMSTransactionEntity.prototype, "status", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "enum", enum: sms_enum_1.ESMSResponseCode, nullable: true }),
    __metadata("design:type", String)
], SMSTransactionEntity.prototype, "error", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "double", nullable: true }),
    __metadata("design:type", Number)
], SMSTransactionEntity.prototype, "dateTimeDelivered", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "double", nullable: true }),
    __metadata("design:type", Number)
], SMSTransactionEntity.prototype, "dateTimeFailed", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "double", nullable: true }),
    __metadata("design:type", Number)
], SMSTransactionEntity.prototype, "dateTimeSent", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "text", nullable: true }),
    __metadata("design:type", String)
], SMSTransactionEntity.prototype, "pMessageID", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "text", nullable: true }),
    __metadata("design:type", String)
], SMSTransactionEntity.prototype, "pErrorCode", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "text", nullable: true }),
    __metadata("design:type", String)
], SMSTransactionEntity.prototype, "pErrorMessage", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "boolean", default: false }),
    __metadata("design:type", Boolean)
], SMSTransactionEntity.prototype, "resolvedFeedback", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => partner_entity_1.PartnerEntity, (i) => i.messages),
    __metadata("design:type", Object)
], SMSTransactionEntity.prototype, "provider", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], SMSTransactionEntity.prototype, "providerId", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => webhook_entity_1.WebhookEntity, (i) => i.smsTransaction),
    __metadata("design:type", Object)
], SMSTransactionEntity.prototype, "webhooks", void 0);
exports.SMSTransactionEntity = SMSTransactionEntity = __decorate([
    (0, typeorm_1.Entity)(base_enum_1.ETableName.smsTransactions)
], SMSTransactionEntity);
//# sourceMappingURL=sms-transaction.entity.js.map