import { Relation } from "typeorm";
import { BaseEntity } from "../base.entity";
import { ESMSResponseCode, ESMSStatus } from "../../enums/sms/sms.enum";
import { PartnerEntity } from "../partner.entity";
import { SMSRecipientEntity } from "./sms-recipient.entity";
import { SDKWalletTransaction } from "@serene-dev/la-nest-library";
import { WebhookEntity } from "../webhook.entity";
export declare class SMSTransactionEntity extends BaseEntity<SMSTransactionEntity> {
    recipient: Relation<SMSRecipientEntity>;
    recipientId?: string;
    walletTransaction: Relation<SDKWalletTransaction>;
    walletTransactionId?: string;
    amount: number;
    status: ESMSStatus;
    error?: ESMSResponseCode;
    dateTimeDelivered?: number;
    dateTimeFailed?: number;
    dateTimeSent?: number;
    pMessageID?: string;
    pErrorCode?: string;
    pErrorMessage?: string;
    resolvedFeedback: boolean;
    provider: Relation<PartnerEntity>;
    providerId?: string;
    webhooks?: Relation<WebhookEntity[]>;
}
