"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReportEntity = exports.EReportType = exports.EReportStatus = void 0;
const typeorm_1 = require("typeorm");
const base_entity_1 = require("./base.entity");
const base_enum_1 = require("../enums/base.enum");
var EReportStatus;
(function (EReportStatus) {
    EReportStatus["pending"] = "PENDING";
    EReportStatus["processing"] = "PROCESSING";
    EReportStatus["completed"] = "COMPLETED";
    EReportStatus["failed"] = "FAILED";
})(EReportStatus || (exports.EReportStatus = EReportStatus = {}));
var EReportType;
(function (EReportType) {
    EReportType["smsLogsForAdmin"] = "SMS_LOGS_FOR_ADMIN";
})(EReportType || (exports.EReportType = EReportType = {}));
let ReportEntity = class ReportEntity extends base_entity_1.BaseEntity {
};
exports.ReportEntity = ReportEntity;
__decorate([
    (0, typeorm_1.Column)({ type: "enum", enum: EReportStatus, default: EReportStatus.pending }),
    __metadata("design:type", String)
], ReportEntity.prototype, "status", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "text", nullable: true }),
    __metadata("design:type", String)
], ReportEntity.prototype, "filePath", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "int", nullable: true }),
    __metadata("design:type", Number)
], ReportEntity.prototype, "totalRecords", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "int", default: 0 }),
    __metadata("design:type", Number)
], ReportEntity.prototype, "processedRecords", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "int", default: 0 }),
    __metadata("design:type", Number)
], ReportEntity.prototype, "processedChunks", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "text", nullable: true }),
    __metadata("design:type", String)
], ReportEntity.prototype, "errorMessage", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], ReportEntity.prototype, "requestedBy", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "text" }),
    __metadata("design:type", String)
], ReportEntity.prototype, "reportType", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "nvarchar", length: 50, unique: true }),
    __metadata("design:type", String)
], ReportEntity.prototype, "reportNumber", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "text", nullable: true }),
    __metadata("design:type", String)
], ReportEntity.prototype, "query", void 0);
exports.ReportEntity = ReportEntity = __decorate([
    (0, typeorm_1.Entity)(base_enum_1.ETableName.report)
], ReportEntity);
//# sourceMappingURL=report.entity.js.map